/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.google.common.cache;

import app.simplecloud.relocate.google.common.annotations.GwtCompatible;
import app.simplecloud.relocate.google.common.base.Supplier;
import app.simplecloud.relocate.google.common.cache.ElementTypesAreNonnullByDefault;
import app.simplecloud.relocate.google.common.cache.LongAddable;
import app.simplecloud.relocate.google.common.cache.LongAdder;
import java.util.concurrent.atomic.AtomicLong;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
final class LongAddables {
    private static final Supplier<LongAddable> SUPPLIER;

    LongAddables() {
    }

    public static LongAddable create() {
        return SUPPLIER.get();
    }

    static {
        Supplier<LongAddable> supplier;
        try {
            LongAdder unused = new LongAdder();
            supplier = new Supplier<LongAddable>(){

                @Override
                public LongAddable get() {
                    return new LongAdder();
                }
            };
        }
        catch (Throwable t2) {
            supplier = new Supplier<LongAddable>(){

                @Override
                public LongAddable get() {
                    return new PureJavaLongAddable();
                }
            };
        }
        SUPPLIER = supplier;
    }

    private static final class PureJavaLongAddable
    extends AtomicLong
    implements LongAddable {
        private PureJavaLongAddable() {
        }

        @Override
        public void increment() {
            this.getAndIncrement();
        }

        @Override
        public void add(long x) {
            this.getAndAdd(x);
        }

        @Override
        public long sum() {
            return this.get();
        }
    }
}

