/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.google.common.collect;

import app.simplecloud.relocate.google.common.annotations.GwtCompatible;
import app.simplecloud.relocate.google.common.annotations.GwtIncompatible;
import app.simplecloud.relocate.google.common.annotations.J2ktIncompatible;
import app.simplecloud.relocate.google.common.base.Preconditions;
import app.simplecloud.relocate.google.common.collect.ElementTypesAreNonnullByDefault;
import app.simplecloud.relocate.google.common.collect.ImmutableCollection;
import app.simplecloud.relocate.google.common.collect.ImmutableList;
import app.simplecloud.relocate.google.common.collect.ImmutableMap;
import app.simplecloud.relocate.google.common.collect.ImmutableMapEntry;
import app.simplecloud.relocate.google.common.collect.ImmutableMapEntrySet;
import app.simplecloud.relocate.google.common.collect.ImmutableMapKeySet;
import app.simplecloud.relocate.google.common.collect.ImmutableMapValues;
import app.simplecloud.relocate.google.common.collect.ImmutableSet;
import app.simplecloud.relocate.google.common.collect.Maps;
import app.simplecloud.relocate.google.common.collect.RegularImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
final class JdkBackedImmutableMap<K, V>
extends ImmutableMap<K, V> {
    private final transient Map<K, V> delegateMap;
    private final transient ImmutableList<Map.Entry<K, V>> entries;

    static <K, V> ImmutableMap<K, V> create(int n, @Nullable Map.Entry<K, V>[] entryArray, boolean throwIfDuplicateKeys) {
        HashMap<K, V> delegateMap = Maps.newHashMapWithExpectedSize(n);
        HashMap<K, Object> duplicates = null;
        int dupCount = 0;
        for (int i2 = 0; i2 < n; ++i2) {
            V value;
            entryArray[i2] = RegularImmutableMap.makeImmutable(Objects.requireNonNull(entryArray[i2]));
            K key2 = entryArray[i2].getKey();
            V oldValue = delegateMap.put(key2, value = entryArray[i2].getValue());
            if (oldValue == null) continue;
            if (throwIfDuplicateKeys) {
                throw JdkBackedImmutableMap.conflictException("key", entryArray[i2], entryArray[i2].getKey() + "=" + oldValue);
            }
            if (duplicates == null) {
                duplicates = new HashMap<K, Object>();
            }
            duplicates.put(key2, value);
            ++dupCount;
        }
        if (duplicates != null) {
            Map.Entry[] newEntryArray = new Map.Entry[n - dupCount];
            int outI = 0;
            for (int inI = 0; inI < n; ++inI) {
                Map.Entry<K, V> entry = Objects.requireNonNull(entryArray[inI]);
                K key3 = entry.getKey();
                if (duplicates.containsKey(key3)) {
                    Object value = duplicates.get(key3);
                    if (value == null) continue;
                    entry = new ImmutableMapEntry(key3, value);
                    duplicates.put(key3, null);
                }
                newEntryArray[outI++] = entry;
            }
            entryArray = newEntryArray;
        }
        return new JdkBackedImmutableMap(delegateMap, ImmutableList.asImmutableList(entryArray, n));
    }

    JdkBackedImmutableMap(Map<K, V> delegateMap, ImmutableList<Map.Entry<K, V>> entries2) {
        this.delegateMap = delegateMap;
        this.entries = entries2;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    @CheckForNull
    public V get(@CheckForNull Object key2) {
        return this.delegateMap.get(key2);
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return new ImmutableMapEntrySet.RegularEntrySet<K, V>(this, this.entries);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        Preconditions.checkNotNull(action);
        this.entries.forEach((Consumer<Map.Entry<K, V>>)((Consumer<Map.Entry>)e -> action.accept((Object)e.getKey(), (Object)e.getValue())));
    }

    @Override
    ImmutableSet<K> createKeySet() {
        return new ImmutableMapKeySet(this);
    }

    @Override
    ImmutableCollection<V> createValues() {
        return new ImmutableMapValues(this);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    @J2ktIncompatible
    @GwtIncompatible
    Object writeReplace() {
        return super.writeReplace();
    }
}

