/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.io.grpc.internal;

import app.simplecloud.relocate.google.common.annotations.VisibleForTesting;
import app.simplecloud.relocate.google.common.base.Preconditions;
import app.simplecloud.relocate.io.grpc.CallbackMetricInstrument;
import app.simplecloud.relocate.io.grpc.DoubleCounterMetricInstrument;
import app.simplecloud.relocate.io.grpc.DoubleHistogramMetricInstrument;
import app.simplecloud.relocate.io.grpc.LongCounterMetricInstrument;
import app.simplecloud.relocate.io.grpc.LongGaugeMetricInstrument;
import app.simplecloud.relocate.io.grpc.LongHistogramMetricInstrument;
import app.simplecloud.relocate.io.grpc.MetricInstrumentRegistry;
import app.simplecloud.relocate.io.grpc.MetricRecorder;
import app.simplecloud.relocate.io.grpc.MetricSink;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

final class MetricRecorderImpl
implements MetricRecorder {
    private final List<MetricSink> metricSinks;
    private final MetricInstrumentRegistry registry;

    @VisibleForTesting
    MetricRecorderImpl(List<MetricSink> metricSinks, MetricInstrumentRegistry registry) {
        this.metricSinks = metricSinks;
        this.registry = registry;
    }

    @Override
    public void addDoubleCounter(DoubleCounterMetricInstrument metricInstrument, double value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
        MetricRecorder.super.addDoubleCounter(metricInstrument, value, requiredLabelValues, optionalLabelValues);
        for (MetricSink sink : this.metricSinks) {
            int measuresSize = sink.getMeasuresSize();
            if (measuresSize <= metricInstrument.getIndex()) {
                sink.updateMeasures(this.registry.getMetricInstruments());
            }
            sink.addDoubleCounter(metricInstrument, value, requiredLabelValues, optionalLabelValues);
        }
    }

    @Override
    public void addLongCounter(LongCounterMetricInstrument metricInstrument, long value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
        MetricRecorder.super.addLongCounter(metricInstrument, value, requiredLabelValues, optionalLabelValues);
        for (MetricSink sink : this.metricSinks) {
            int measuresSize = sink.getMeasuresSize();
            if (measuresSize <= metricInstrument.getIndex()) {
                sink.updateMeasures(this.registry.getMetricInstruments());
            }
            sink.addLongCounter(metricInstrument, value, requiredLabelValues, optionalLabelValues);
        }
    }

    @Override
    public void recordDoubleHistogram(DoubleHistogramMetricInstrument metricInstrument, double value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
        MetricRecorder.super.recordDoubleHistogram(metricInstrument, value, requiredLabelValues, optionalLabelValues);
        for (MetricSink sink : this.metricSinks) {
            int measuresSize = sink.getMeasuresSize();
            if (measuresSize <= metricInstrument.getIndex()) {
                sink.updateMeasures(this.registry.getMetricInstruments());
            }
            sink.recordDoubleHistogram(metricInstrument, value, requiredLabelValues, optionalLabelValues);
        }
    }

    @Override
    public void recordLongHistogram(LongHistogramMetricInstrument metricInstrument, long value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
        MetricRecorder.super.recordLongHistogram(metricInstrument, value, requiredLabelValues, optionalLabelValues);
        for (MetricSink sink : this.metricSinks) {
            int measuresSize = sink.getMeasuresSize();
            if (measuresSize <= metricInstrument.getIndex()) {
                sink.updateMeasures(this.registry.getMetricInstruments());
            }
            sink.recordLongHistogram(metricInstrument, value, requiredLabelValues, optionalLabelValues);
        }
    }

    @Override
    public MetricRecorder.Registration registerBatchCallback(MetricRecorder.BatchCallback callback, CallbackMetricInstrument ... metricInstruments) {
        long largestMetricInstrumentIndex = -1L;
        BitSet allowedInstruments = new BitSet();
        for (CallbackMetricInstrument metricInstrument : metricInstruments) {
            largestMetricInstrumentIndex = Math.max(largestMetricInstrumentIndex, (long)metricInstrument.getIndex());
            allowedInstruments.set(metricInstrument.getIndex());
        }
        ArrayList<MetricSink.Registration> registrations = new ArrayList<MetricSink.Registration>();
        for (MetricSink sink : this.metricSinks) {
            int measuresSize = sink.getMeasuresSize();
            if ((long)measuresSize <= largestMetricInstrumentIndex) {
                sink.updateMeasures(this.registry.getMetricInstruments());
            }
            BatchRecorderImpl singleSinkRecorder = new BatchRecorderImpl(sink, allowedInstruments);
            registrations.add(sink.registerBatchCallback(() -> callback.accept(singleSinkRecorder), metricInstruments));
        }
        return () -> {
            for (MetricSink.Registration registration : registrations) {
                registration.close();
            }
        };
    }

    static class BatchRecorderImpl
    implements MetricRecorder.BatchRecorder {
        private final MetricSink sink;
        private final BitSet allowedInstruments;

        BatchRecorderImpl(MetricSink sink, BitSet allowedInstruments) {
            this.sink = Preconditions.checkNotNull(sink, "sink");
            this.allowedInstruments = Preconditions.checkNotNull(allowedInstruments, "allowedInstruments");
        }

        @Override
        public void recordLongGauge(LongGaugeMetricInstrument metricInstrument, long value, List<String> requiredLabelValues, List<String> optionalLabelValues) {
            MetricRecorder.BatchRecorder.super.recordLongGauge(metricInstrument, value, requiredLabelValues, optionalLabelValues);
            Preconditions.checkArgument(this.allowedInstruments.get(metricInstrument.getIndex()), "Instrument was not listed when registering callback: %s", (Object)metricInstrument);
            this.sink.recordLongGauge(metricInstrument, value, requiredLabelValues, optionalLabelValues);
        }
    }
}

