/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.auth.jwt;

import com.auth0.jwk.JwkProvider;
import com.auth0.jwk.JwkProviderBuilder;
import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.Verification;
import io.ktor.http.auth.HttpAuthHeader;
import io.ktor.server.application.ApplicationCall;
import io.ktor.server.auth.AuthenticationContext;
import io.ktor.server.auth.AuthenticationFailedCause;
import io.ktor.server.auth.AuthenticationProvider;
import io.ktor.server.auth.UnauthorizedResponse;
import io.ktor.server.auth.jwt.JWTAuthKt;
import io.ktor.server.auth.jwt.JWTAuthSchemes;
import io.ktor.server.auth.jwt.JWTAuthenticationProvider;
import io.ktor.server.auth.jwt.JWTChallengeContext;
import io.ktor.server.auth.jwt.JWTCredential;
import io.ktor.server.auth.jwt.JWTUtilsKt;
import io.ktor.util.reflect.TypeInfo;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001)B\u0011\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0096@\u00a2\u0006\u0004\b\t\u0010\nR\u0014\u0010\f\u001a\u00020\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\"\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\"\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0015RV\u0010!\u001aD\b\u0001\u0012\u0004\u0012\u00020\u0012\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001d\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u0018j\b\u0012\u0004\u0012\u00020\u0019`\u001f\u00a2\u0006\u0002\b 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"Rc\u0010'\u001aQ\b\u0001\u0012\u0004\u0012\u00020$\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(%\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u001d\u0012\u0006\u0012\u0004\u0018\u00010\u001e0#j\u0002`&\u00a2\u0006\u0002\b 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010(\u00a8\u0006*"}, d2={"Lio/ktor/server/auth/jwt/JWTAuthenticationProvider;", "Lio/ktor/server/auth/AuthenticationProvider;", "Lio/ktor/server/auth/jwt/JWTAuthenticationProvider$Config;", "config", "<init>", "(Lio/ktor/server/auth/jwt/JWTAuthenticationProvider$Config;)V", "Lio/ktor/server/auth/AuthenticationContext;", "context", "", "onAuthenticate", "(Lio/ktor/server/auth/AuthenticationContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "realm", "Ljava/lang/String;", "Lio/ktor/server/auth/jwt/JWTAuthSchemes;", "schemes", "Lio/ktor/server/auth/jwt/JWTAuthSchemes;", "Lkotlin/Function1;", "Lio/ktor/server/application/ApplicationCall;", "Lio/ktor/http/auth/HttpAuthHeader;", "authHeader", "Lkotlin/jvm/functions/Function1;", "Lcom/auth0/jwt/interfaces/JWTVerifier;", "verifier", "Lkotlin/Function3;", "Lio/ktor/server/auth/jwt/JWTCredential;", "Lkotlin/ParameterName;", "name", "credentials", "Lkotlin/coroutines/Continuation;", "", "Lio/ktor/server/auth/AuthenticationFunction;", "Lkotlin/ExtensionFunctionType;", "authenticationFunction", "Lkotlin/jvm/functions/Function3;", "Lkotlin/Function4;", "Lio/ktor/server/auth/jwt/JWTChallengeContext;", "defaultScheme", "Lio/ktor/server/auth/jwt/JWTAuthChallengeFunction;", "challengeFunction", "Lkotlin/jvm/functions/Function4;", "Config", "ktor-server-auth-jwt"})
public final class JWTAuthenticationProvider
extends AuthenticationProvider {
    @NotNull
    private final String realm;
    @NotNull
    private final JWTAuthSchemes schemes;
    @NotNull
    private final Function1<ApplicationCall, HttpAuthHeader> authHeader;
    @NotNull
    private final Function1<HttpAuthHeader, com.auth0.jwt.interfaces.JWTVerifier> verifier;
    @NotNull
    private final Function3<ApplicationCall, JWTCredential, Continuation<Object>, Object> authenticationFunction;
    @NotNull
    private final Function4<JWTChallengeContext, String, String, Continuation<? super Unit>, Object> challengeFunction;

    public JWTAuthenticationProvider(@NotNull Config config2) {
        Intrinsics.checkNotNullParameter(config2, "config");
        super(config2);
        this.realm = config2.getRealm();
        this.schemes = config2.getSchemes$ktor_server_auth_jwt();
        this.authHeader = config2.getAuthHeader$ktor_server_auth_jwt();
        this.verifier = config2.getVerifier$ktor_server_auth_jwt();
        this.authenticationFunction = config2.getAuthenticationFunction$ktor_server_auth_jwt();
        this.challengeFunction = config2.getChallenge$ktor_server_auth_jwt();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object onAuthenticate(@NotNull AuthenticationContext var1_1, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof onAuthenticate.1)) ** GOTO lbl-1000
        var8_3 = $completion;
        if ((var8_3.label & -2147483648) != 0) {
            var8_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ JWTAuthenticationProvider this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.onAuthenticate(null, this);
                }
            };
        }
        $result = $continuation.result;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                call = context.getCall();
                token = this.authHeader.invoke(call);
                if (token == null) {
                    JWTAuthKt.getJWTLogger().debug("JWT authentication failed: No credentials provided");
                    JWTUtilsKt.bearerChallenge(context, AuthenticationFailedCause.NoCredentials.INSTANCE, this.realm, this.schemes, this.challengeFunction);
                    return Unit.INSTANCE;
                }
                jwtVerifier = this.verifier.invoke(token);
                if (jwtVerifier == null) {
                    JWTAuthKt.getJWTLogger().debug("JWT authentication failed: Unable to create JWT verifier");
                    JWTUtilsKt.bearerChallenge(context, AuthenticationFailedCause.InvalidCredentials.INSTANCE, this.realm, this.schemes, this.challengeFunction);
                    return Unit.INSTANCE;
                }
                $continuation.L$0 = this;
                $continuation.L$1 = context;
                $continuation.label = 1;
                v0 = JWTUtilsKt.verifyAndValidate(call, jwtVerifier, token, this.schemes, this.authenticationFunction, $continuation);
                ** if (v0 != var9_5) goto lbl31
lbl30:
                // 1 sources

                return var9_5;
lbl31:
                // 1 sources

                ** GOTO lbl39
            }
            case 1: {
                context = (AuthenticationContext)$continuation.L$1;
                this = (JWTAuthenticationProvider)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure($result);
                    v0 = $result;
lbl39:
                    // 2 sources

                    if ((principal = v0) != null) {
                        context.principal(this.getName(), principal);
                        return Unit.INSTANCE;
                    }
                    JWTAuthKt.getJWTLogger().debug("JWT authentication failed: Invalid credentials");
                    JWTUtilsKt.bearerChallenge(context, AuthenticationFailedCause.InvalidCredentials.INSTANCE, this.realm, this.schemes, this.challengeFunction);
                }
                catch (Throwable cause) {
                    v1 = cause.getMessage();
                    if (v1 == null) {
                        v1 = cause.getClass().getSimpleName();
                    }
                    message = v1;
                    JWTAuthKt.getJWTLogger().debug("JWT authentication failed: " + message, cause);
                    v2 = JWTAuthKt.getJWTAuthKey();
                    Intrinsics.checkNotNull(message);
                    context.error(v2, new AuthenticationFailedCause.Error(message));
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0015\u0018\u00002\u00020\u0001B\u0013\b\u0000\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J#\u0010\u000b\u001a\u00020\n2\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006\u00a2\u0006\u0004\b\u000b\u0010\fJ+\u0010\u0010\u001a\u00020\n2\b\b\u0002\u0010\r\u001a\u00020\u00022\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u000e\"\u00020\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J#\u0010\u0013\u001a\u00020\n2\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0006\u00a2\u0006\u0004\b\u0013\u0010\fJ<\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00022\u001d\b\u0002\u0010\u001b\u001a\u0017\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\n0\u0006j\u0002`\u0019\u00a2\u0006\u0002\b\u001a\u00a2\u0006\u0004\b\u0013\u0010\u001cJ4\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00152\u001d\b\u0002\u0010\u001b\u001a\u0017\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\n0\u0006j\u0002`\u0019\u00a2\u0006\u0002\b\u001a\u00a2\u0006\u0004\b\u0013\u0010\u001dJ@\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\u001f2\u0019\b\u0002\u0010\t\u001a\u0013\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\n0\u0006\u00a2\u0006\u0002\b\u001a\u00a2\u0006\u0004\b\u0013\u0010!J4\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00022\u001d\b\u0002\u0010\t\u001a\u0017\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\n0\u0006j\u0002`\u0019\u00a2\u0006\u0002\b\u001a\u00a2\u0006\u0004\b\u0013\u0010\"J>\u0010'\u001a\u00020\n2/\u0010'\u001a+\b\u0001\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020$\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010&0%\u0012\u0006\u0012\u0004\u0018\u00010&0#\u00a2\u0006\u0002\b\u001a\u00a2\u0006\u0004\b'\u0010(Jd\u0010.\u001a\u00020\n2U\u0010\t\u001aQ\b\u0001\u0012\u0004\u0012\u00020*\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b+\u0012\b\b\u0003\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b+\u0012\b\b\u0003\u0012\u0004\b\b(,\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0%\u0012\u0006\u0012\u0004\u0018\u00010&0)j\u0002`-\u00a2\u0006\u0002\b\u001a\u00a2\u0006\u0004\b.\u0010/J\u000f\u00103\u001a\u000200H\u0000\u00a2\u0006\u0004\b1\u00102Rd\u00106\u001aD\b\u0001\u0012\u0004\u0012\u00020\u0007\u0012\u0013\u0012\u00110$\u00a2\u0006\f\b+\u0012\b\b\u0003\u0012\u0004\b\b(4\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010&0%\u0012\u0006\u0012\u0004\u0018\u00010&0#j\b\u0012\u0004\u0012\u00020$`5\u00a2\u0006\u0002\b\u001a8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b6\u00107\u001a\u0004\b8\u00109\"\u0004\b:\u0010(R\"\u0010<\u001a\u00020;8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b<\u0010=\u001a\u0004\b>\u0010?\"\u0004\b@\u0010AR0\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00068\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b\u000b\u0010B\u001a\u0004\bC\u0010D\"\u0004\bE\u0010\fR0\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00068\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b\u0013\u0010B\u001a\u0004\bF\u0010D\"\u0004\bG\u0010\fRq\u0010.\u001aQ\b\u0001\u0012\u0004\u0012\u00020*\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b+\u0012\b\b\u0003\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b+\u0012\b\b\u0003\u0012\u0004\b\b(,\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0%\u0012\u0006\u0012\u0004\u0018\u00010&0)j\u0002`-\u00a2\u0006\u0002\b\u001a8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b.\u0010H\u001a\u0004\bI\u0010J\"\u0004\bK\u0010/R\"\u0010,\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b,\u0010L\u001a\u0004\bM\u0010N\"\u0004\bO\u0010\u0005\u00a8\u0006P"}, d2={"Lio/ktor/server/auth/jwt/JWTAuthenticationProvider$Config;", "Lio/ktor/server/auth/AuthenticationProvider$Config;", "", "name", "<init>", "(Ljava/lang/String;)V", "Lkotlin/Function1;", "Lio/ktor/server/application/ApplicationCall;", "Lio/ktor/http/auth/HttpAuthHeader;", "block", "", "authHeader", "(Lkotlin/jvm/functions/Function1;)V", "defaultScheme", "", "additionalSchemes", "authSchemes", "(Ljava/lang/String;[Ljava/lang/String;)V", "Lcom/auth0/jwt/interfaces/JWTVerifier;", "verifier", "(Lcom/auth0/jwt/interfaces/JWTVerifier;)V", "Lcom/auth0/jwk/JwkProvider;", "jwkProvider", "issuer", "Lcom/auth0/jwt/interfaces/Verification;", "Lio/ktor/server/auth/jwt/JWTConfigureFunction;", "Lkotlin/ExtensionFunctionType;", "configure", "(Lcom/auth0/jwk/JwkProvider;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "(Lcom/auth0/jwk/JwkProvider;Lkotlin/jvm/functions/Function1;)V", "audience", "Lcom/auth0/jwt/algorithms/Algorithm;", "algorithm", "(Ljava/lang/String;Ljava/lang/String;Lcom/auth0/jwt/algorithms/Algorithm;Lkotlin/jvm/functions/Function1;)V", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "Lkotlin/Function3;", "Lio/ktor/server/auth/jwt/JWTCredential;", "Lkotlin/coroutines/Continuation;", "", "validate", "(Lkotlin/jvm/functions/Function3;)V", "Lkotlin/Function4;", "Lio/ktor/server/auth/jwt/JWTChallengeContext;", "Lkotlin/ParameterName;", "realm", "Lio/ktor/server/auth/jwt/JWTAuthChallengeFunction;", "challenge", "(Lkotlin/jvm/functions/Function4;)V", "Lio/ktor/server/auth/jwt/JWTAuthenticationProvider;", "build$ktor_server_auth_jwt", "()Lio/ktor/server/auth/jwt/JWTAuthenticationProvider;", "build", "credentials", "Lio/ktor/server/auth/AuthenticationFunction;", "authenticationFunction", "Lkotlin/jvm/functions/Function3;", "getAuthenticationFunction$ktor_server_auth_jwt", "()Lkotlin/jvm/functions/Function3;", "setAuthenticationFunction$ktor_server_auth_jwt", "Lio/ktor/server/auth/jwt/JWTAuthSchemes;", "schemes", "Lio/ktor/server/auth/jwt/JWTAuthSchemes;", "getSchemes$ktor_server_auth_jwt", "()Lio/ktor/server/auth/jwt/JWTAuthSchemes;", "setSchemes$ktor_server_auth_jwt", "(Lio/ktor/server/auth/jwt/JWTAuthSchemes;)V", "Lkotlin/jvm/functions/Function1;", "getAuthHeader$ktor_server_auth_jwt", "()Lkotlin/jvm/functions/Function1;", "setAuthHeader$ktor_server_auth_jwt", "getVerifier$ktor_server_auth_jwt", "setVerifier$ktor_server_auth_jwt", "Lkotlin/jvm/functions/Function4;", "getChallenge$ktor_server_auth_jwt", "()Lkotlin/jvm/functions/Function4;", "setChallenge$ktor_server_auth_jwt", "Ljava/lang/String;", "getRealm", "()Ljava/lang/String;", "setRealm", "ktor-server-auth-jwt"})
    public static final class Config
    extends AuthenticationProvider.Config {
        @NotNull
        private Function3<? super ApplicationCall, ? super JWTCredential, ? super Continuation<Object>, ? extends Object> authenticationFunction = new Function3<ApplicationCall, JWTCredential, Continuation<?>, Object>(null){
            int label;

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        throw new NotImplementedError("JWT auth validate function is not specified. Use jwt { validate { ... } } to fix.");
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(ApplicationCall p1, JWTCredential p2, Continuation<?> p3) {
                return new /* invalid duplicate definition of identical inner class */.invokeSuspend(Unit.INSTANCE);
            }
        };
        @NotNull
        private JWTAuthSchemes schemes = new JWTAuthSchemes("Bearer", new String[0]);
        @NotNull
        private Function1<? super ApplicationCall, ? extends HttpAuthHeader> authHeader = Config::authHeader$lambda$0;
        @NotNull
        private Function1<? super HttpAuthHeader, ? extends com.auth0.jwt.interfaces.JWTVerifier> verifier = verifier.1.INSTANCE;
        @NotNull
        private Function4<? super JWTChallengeContext, ? super String, ? super String, ? super Continuation<? super Unit>, ? extends Object> challenge = new Function4<JWTChallengeContext, String, String, Continuation<? super Unit>, Object>(null){
            int label;
            private /* synthetic */ Object L$0;
            /* synthetic */ Object L$1;
            /* synthetic */ Object L$2;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        KType kType;
                        void var3_4;
                        ResultKt.throwOnFailure(object);
                        JWTChallengeContext jWTChallengeContext = (JWTChallengeContext)this.L$0;
                        String scheme = (String)this.L$1;
                        String realm = (String)this.L$2;
                        ApplicationCall $this$respond$iv = jWTChallengeContext.getCall();
                        HttpAuthHeader[] httpAuthHeaderArray = new HttpAuthHeader[]{new HttpAuthHeader.Parameterized((String)var3_4, MapsKt.mapOf(TuplesKt.to("realm", realm)), null, 4, null)};
                        UnauthorizedResponse message$iv = new UnauthorizedResponse(httpAuthHeaderArray);
                        boolean $i$f$respond = false;
                        UnauthorizedResponse unauthorizedResponse = message$iv;
                        ApplicationCall applicationCall = $this$respond$iv;
                        boolean $i$f$typeInfo = false;
                        KClass kClass = Reflection.getOrCreateKotlinClass(UnauthorizedResponse.class);
                        boolean $i$f$typeOfOrNull = false;
                        try {
                            kType = Reflection.typeOf(UnauthorizedResponse.class);
                        }
                        catch (Throwable throwable) {
                            kType = null;
                        }
                        KType kType2 = kType;
                        KClass kClass2 = kClass;
                        TypeInfo typeInfo = new TypeInfo(kClass2, kType2);
                        this.L$0 = null;
                        this.L$1 = null;
                        this.label = 1;
                        Object object3 = applicationCall.respond(unauthorizedResponse, typeInfo, this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        boolean $i$f$respond = false;
                        ResultKt.throwOnFailure($result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(JWTChallengeContext p1, String p2, String p3, Continuation<? super Unit> p4) {
                Function4<JWTChallengeContext, String, String, Continuation<? super Unit>, Object> function4 = new /* invalid duplicate definition of identical inner class */;
                function4.L$0 = p1;
                function4.L$1 = p2;
                function4.L$2 = p3;
                return function4.invokeSuspend(Unit.INSTANCE);
            }
        };
        @NotNull
        private String realm = "Ktor Server";

        public Config(@Nullable String name) {
            super(name);
        }

        @NotNull
        public final Function3<ApplicationCall, JWTCredential, Continuation<Object>, Object> getAuthenticationFunction$ktor_server_auth_jwt() {
            return this.authenticationFunction;
        }

        public final void setAuthenticationFunction$ktor_server_auth_jwt(@NotNull Function3<? super ApplicationCall, ? super JWTCredential, ? super Continuation<Object>, ? extends Object> function3) {
            Intrinsics.checkNotNullParameter(function3, "<set-?>");
            this.authenticationFunction = function3;
        }

        @NotNull
        public final JWTAuthSchemes getSchemes$ktor_server_auth_jwt() {
            return this.schemes;
        }

        public final void setSchemes$ktor_server_auth_jwt(@NotNull JWTAuthSchemes jWTAuthSchemes) {
            Intrinsics.checkNotNullParameter(jWTAuthSchemes, "<set-?>");
            this.schemes = jWTAuthSchemes;
        }

        @NotNull
        public final Function1<ApplicationCall, HttpAuthHeader> getAuthHeader$ktor_server_auth_jwt() {
            return this.authHeader;
        }

        public final void setAuthHeader$ktor_server_auth_jwt(@NotNull Function1<? super ApplicationCall, ? extends HttpAuthHeader> function1) {
            Intrinsics.checkNotNullParameter(function1, "<set-?>");
            this.authHeader = function1;
        }

        @NotNull
        public final Function1<HttpAuthHeader, com.auth0.jwt.interfaces.JWTVerifier> getVerifier$ktor_server_auth_jwt() {
            return this.verifier;
        }

        public final void setVerifier$ktor_server_auth_jwt(@NotNull Function1<? super HttpAuthHeader, ? extends com.auth0.jwt.interfaces.JWTVerifier> function1) {
            Intrinsics.checkNotNullParameter(function1, "<set-?>");
            this.verifier = function1;
        }

        @NotNull
        public final Function4<JWTChallengeContext, String, String, Continuation<? super Unit>, Object> getChallenge$ktor_server_auth_jwt() {
            return this.challenge;
        }

        public final void setChallenge$ktor_server_auth_jwt(@NotNull Function4<? super JWTChallengeContext, ? super String, ? super String, ? super Continuation<? super Unit>, ? extends Object> function4) {
            Intrinsics.checkNotNullParameter(function4, "<set-?>");
            this.challenge = function4;
        }

        @NotNull
        public final String getRealm() {
            return this.realm;
        }

        public final void setRealm(@NotNull String string) {
            Intrinsics.checkNotNullParameter(string, "<set-?>");
            this.realm = string;
        }

        public final void authHeader(@NotNull Function1<? super ApplicationCall, ? extends HttpAuthHeader> block) {
            Intrinsics.checkNotNullParameter(block, "block");
            this.authHeader = block;
        }

        public final void authSchemes(@NotNull String defaultScheme, String ... additionalSchemes) {
            Intrinsics.checkNotNullParameter(defaultScheme, "defaultScheme");
            Intrinsics.checkNotNullParameter(additionalSchemes, "additionalSchemes");
            this.schemes = new JWTAuthSchemes(defaultScheme, Arrays.copyOf(additionalSchemes, additionalSchemes.length));
        }

        public static /* synthetic */ void authSchemes$default(Config config2, String string, String[] stringArray, int n, Object object) {
            if ((n & 1) != 0) {
                string = "Bearer";
            }
            config2.authSchemes(string, stringArray);
        }

        public final void verifier(@NotNull com.auth0.jwt.interfaces.JWTVerifier verifier2) {
            Intrinsics.checkNotNullParameter(verifier2, "verifier");
            this.verifier = arg_0 -> Config.verifier$lambda$1(verifier2, arg_0);
        }

        public final void verifier(@NotNull Function1<? super HttpAuthHeader, ? extends com.auth0.jwt.interfaces.JWTVerifier> verifier2) {
            Intrinsics.checkNotNullParameter(verifier2, "verifier");
            this.verifier = verifier2;
        }

        public final void verifier(@NotNull JwkProvider jwkProvider, @NotNull String issuer, @NotNull Function1<? super Verification, Unit> configure) {
            Intrinsics.checkNotNullParameter(jwkProvider, "jwkProvider");
            Intrinsics.checkNotNullParameter(issuer, "issuer");
            Intrinsics.checkNotNullParameter(configure, "configure");
            this.verifier = arg_0 -> Config.verifier$lambda$3(jwkProvider, issuer, this, configure, arg_0);
        }

        public static /* synthetic */ void verifier$default(Config config2, JwkProvider jwkProvider, String string, Function1 function1, int n, Object object) {
            if ((n & 4) != 0) {
                function1 = Config::verifier$lambda$2;
            }
            config2.verifier(jwkProvider, string, function1);
        }

        public final void verifier(@NotNull JwkProvider jwkProvider, @NotNull Function1<? super Verification, Unit> configure) {
            Intrinsics.checkNotNullParameter(jwkProvider, "jwkProvider");
            Intrinsics.checkNotNullParameter(configure, "configure");
            this.verifier = arg_0 -> Config.verifier$lambda$5(jwkProvider, this, configure, arg_0);
        }

        public static /* synthetic */ void verifier$default(Config config2, JwkProvider jwkProvider, Function1 function1, int n, Object object) {
            if ((n & 2) != 0) {
                function1 = Config::verifier$lambda$4;
            }
            config2.verifier(jwkProvider, function1);
        }

        public final void verifier(@NotNull String issuer, @NotNull String audience, @NotNull Algorithm algorithm, @NotNull Function1<? super Verification, Unit> block) {
            Verification verification;
            Intrinsics.checkNotNullParameter(issuer, "issuer");
            Intrinsics.checkNotNullParameter(audience, "audience");
            Intrinsics.checkNotNullParameter(algorithm, "algorithm");
            Intrinsics.checkNotNullParameter(block, "block");
            String[] stringArray = new String[]{audience};
            Verification verification2 = JWT.require(algorithm).withAudience(stringArray).withIssuer(issuer);
            Intrinsics.checkNotNullExpressionValue(verification2, "withIssuer(...)");
            Verification verification3 = verification = verification2;
            block.invoke(verification3);
            JWTVerifier jWTVerifier = verification.build();
            Intrinsics.checkNotNullExpressionValue(jWTVerifier, "build(...)");
            this.verifier(jWTVerifier);
        }

        public static /* synthetic */ void verifier$default(Config config2, String string, String string2, Algorithm algorithm, Function1 function1, int n, Object object) {
            if ((n & 8) != 0) {
                function1 = Config::verifier$lambda$6;
            }
            config2.verifier(string, string2, algorithm, function1);
        }

        public final void verifier(@NotNull String issuer, @NotNull Function1<? super Verification, Unit> block) {
            Intrinsics.checkNotNullParameter(issuer, "issuer");
            Intrinsics.checkNotNullParameter(block, "block");
            JwkProvider provider = new JwkProviderBuilder(issuer).build();
            this.verifier = arg_0 -> Config.verifier$lambda$8(provider, this, block, arg_0);
        }

        public static /* synthetic */ void verifier$default(Config config2, String string, Function1 function1, int n, Object object) {
            if ((n & 2) != 0) {
                function1 = Config::verifier$lambda$7;
            }
            config2.verifier(string, function1);
        }

        public final void validate(@NotNull Function3<? super ApplicationCall, ? super JWTCredential, ? super Continuation<Object>, ? extends Object> validate2) {
            Intrinsics.checkNotNullParameter(validate2, "validate");
            this.authenticationFunction = validate2;
        }

        public final void challenge(@NotNull Function4<? super JWTChallengeContext, ? super String, ? super String, ? super Continuation<? super Unit>, ? extends Object> block) {
            Intrinsics.checkNotNullParameter(block, "block");
            this.challenge = block;
        }

        @NotNull
        public final JWTAuthenticationProvider build$ktor_server_auth_jwt() {
            return new JWTAuthenticationProvider(this);
        }

        private static final HttpAuthHeader authHeader$lambda$0(ApplicationCall call) {
            Intrinsics.checkNotNullParameter(call, "call");
            return JWTUtilsKt.parseAuthorizationHeaderOrNull(call.getRequest());
        }

        private static final com.auth0.jwt.interfaces.JWTVerifier verifier$lambda$1(com.auth0.jwt.interfaces.JWTVerifier $verifier, HttpAuthHeader it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return $verifier;
        }

        private static final Unit verifier$lambda$2(Verification verification) {
            Intrinsics.checkNotNullParameter(verification, "<this>");
            return Unit.INSTANCE;
        }

        private static final com.auth0.jwt.interfaces.JWTVerifier verifier$lambda$3(JwkProvider $jwkProvider, String $issuer, Config this$0, Function1 $configure, HttpAuthHeader token) {
            Intrinsics.checkNotNullParameter(token, "token");
            return JWTUtilsKt.getVerifier($jwkProvider, $issuer, token, this$0.schemes, $configure);
        }

        private static final Unit verifier$lambda$4(Verification verification) {
            Intrinsics.checkNotNullParameter(verification, "<this>");
            return Unit.INSTANCE;
        }

        private static final com.auth0.jwt.interfaces.JWTVerifier verifier$lambda$5(JwkProvider $jwkProvider, Config this$0, Function1 $configure, HttpAuthHeader token) {
            Intrinsics.checkNotNullParameter(token, "token");
            return JWTUtilsKt.getVerifier($jwkProvider, token, this$0.schemes, $configure);
        }

        private static final Unit verifier$lambda$6(Verification verification) {
            Intrinsics.checkNotNullParameter(verification, "<this>");
            return Unit.INSTANCE;
        }

        private static final Unit verifier$lambda$7(Verification verification) {
            Intrinsics.checkNotNullParameter(verification, "<this>");
            return Unit.INSTANCE;
        }

        private static final com.auth0.jwt.interfaces.JWTVerifier verifier$lambda$8(JwkProvider $provider, Config this$0, Function1 $block, HttpAuthHeader token) {
            Intrinsics.checkNotNullParameter(token, "token");
            Intrinsics.checkNotNull($provider);
            return JWTUtilsKt.getVerifier($provider, token, this$0.schemes, $block);
        }
    }
}

