/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io.core.internal;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.Buffer;
import kotlinx.io.Segment;
import kotlinx.io.SegmentKt;
import kotlinx.io.unsafe.UnsafeBufferOperations;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\u001a-\u0010\u0007\u001a\u00020\u0005*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0007\u0010\b\u001a%\u0010\t\u001a\u00020\u0005*\u00020\u00002\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lkotlinx/io/Buffer;", "", "min", "Lkotlin/Function1;", "Ljava/nio/ByteBuffer;", "", "block", "writeDirect", "(Lkotlinx/io/Buffer;ILkotlin/jvm/functions/Function1;)V", "readDirect", "(Lkotlinx/io/Buffer;Lkotlin/jvm/functions/Function1;)V", "ktor-io"})
@SourceDebugExtension(value={"SMAP\nChunkBufferJvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChunkBufferJvm.kt\nio/ktor/utils/io/core/internal/ChunkBufferJvmKt\n+ 2 UnsafeBufferOperations.kt\nkotlinx/io/unsafe/UnsafeBufferOperations\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,31:1\n195#2,28:32\n99#2:60\n100#2,8:62\n1#3:61\n*S KotlinDebug\n*F\n+ 1 ChunkBufferJvm.kt\nio/ktor/utils/io/core/internal/ChunkBufferJvmKt\n*L\n14#1:32,28\n23#1:60\n23#1:62,8\n23#1:61\n*E\n"})
public final class ChunkBufferJvmKt {
    /*
     * WARNING - void declaration
     */
    public static final void writeDirect(@NotNull Buffer $this$writeDirect, int min2, @NotNull Function1<? super ByteBuffer, Unit> block) {
        void endIndex;
        void startIndex;
        Intrinsics.checkNotNullParameter($this$writeDirect, "<this>");
        Intrinsics.checkNotNullParameter(block, "block");
        UnsafeBufferOperations unsafeBufferOperations = UnsafeBufferOperations.INSTANCE;
        Buffer buffer$iv = $this$writeDirect.getBuffer();
        boolean $i$f$writeToTail = false;
        Segment tail$iv = buffer$iv.writableSegment(min2);
        byte[] data$iv = tail$iv.dataAsByteArray(false);
        int n = data$iv.length;
        int n2 = tail$iv.getLimit();
        byte[] array = data$iv;
        boolean bl = false;
        ByteBuffer buffer = ByteBuffer.wrap(array, (int)startIndex, (int)(endIndex - startIndex));
        Intrinsics.checkNotNull(buffer);
        block.invoke(buffer);
        int bytesWritten$iv = buffer.position() - startIndex;
        if (bytesWritten$iv == min2) {
            tail$iv.writeBackData(data$iv, bytesWritten$iv);
            tail$iv.setLimit(tail$iv.getLimit() + bytesWritten$iv);
            buffer$iv.setSizeMut(buffer$iv.getSizeMut() + (long)bytesWritten$iv);
        } else {
            if (!(0 <= bytesWritten$iv ? bytesWritten$iv <= tail$iv.getRemainingCapacity() : false)) {
                boolean bl2 = false;
                String string = "Invalid number of bytes written: " + bytesWritten$iv + ". Should be in 0.." + tail$iv.getRemainingCapacity();
                throw new IllegalStateException(string.toString());
            }
            if (bytesWritten$iv != 0) {
                tail$iv.writeBackData(data$iv, bytesWritten$iv);
                tail$iv.setLimit(tail$iv.getLimit() + bytesWritten$iv);
                buffer$iv.setSizeMut(buffer$iv.getSizeMut() + (long)bytesWritten$iv);
            } else if (SegmentKt.isEmpty((Segment)tail$iv)) {
                buffer$iv.recycleTail();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void readDirect(@NotNull Buffer $this$readDirect, @NotNull Function1<? super ByteBuffer, Unit> block) {
        int consumed;
        void endExclusive;
        void start2;
        Intrinsics.checkNotNullParameter($this$readDirect, "<this>");
        Intrinsics.checkNotNullParameter(block, "block");
        UnsafeBufferOperations unsafeBufferOperations = UnsafeBufferOperations.INSTANCE;
        Buffer buffer$iv = $this$readDirect.getBuffer();
        boolean $i$f$readFromHead = false;
        if (!(!buffer$iv.exhausted())) {
            boolean $i$a$-require-UnsafeBufferOperations$readFromHead$1$iv22 = false;
            String $i$a$-require-UnsafeBufferOperations$readFromHead$1$iv22 = "Buffer is empty";
            throw new IllegalArgumentException($i$a$-require-UnsafeBufferOperations$readFromHead$1$iv22.toString());
        }
        Segment segment = buffer$iv.getHead();
        Intrinsics.checkNotNull(segment);
        Segment head$iv = segment;
        int n = head$iv.getLimit();
        int n2 = head$iv.getPos();
        byte[] array = head$iv.dataAsByteArray(true);
        boolean bl = false;
        ByteBuffer wrap = ByteBuffer.wrap(array, (int)start2, (int)(endExclusive - start2));
        Intrinsics.checkNotNull(wrap);
        block.invoke(wrap);
        int bytesRead$iv = consumed = wrap.position() - start2;
        if (bytesRead$iv != 0) {
            if (bytesRead$iv < 0) {
                throw new IllegalStateException("Returned negative read bytes count");
            }
            if (bytesRead$iv > head$iv.getSize()) {
                throw new IllegalStateException("Returned too many bytes");
            }
            buffer$iv.skip((long)bytesRead$iv);
        }
    }
}

