/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.configurate.reference;

import io.leangen.geantyref.TypeToken;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.NodePath;
import org.spongepowered.configurate.ScopedConfigurationNode;
import org.spongepowered.configurate.loader.ConfigurationLoader;
import org.spongepowered.configurate.reactive.Publisher;
import org.spongepowered.configurate.reference.ManualConfigurationReference;
import org.spongepowered.configurate.reference.ValueReference;
import org.spongepowered.configurate.reference.WatchServiceListener;
import org.spongepowered.configurate.reference.WatchingConfigurationReference;
import org.spongepowered.configurate.serialize.SerializationException;

public interface ConfigurationReference<N extends ConfigurationNode>
extends AutoCloseable {
    public static <N extends ScopedConfigurationNode<N>> ConfigurationReference<N> fixed(ConfigurationLoader<? extends N> loader) throws ConfigurateException {
        ManualConfigurationReference<N> ret2 = new ManualConfigurationReference<N>(loader, ForkJoinPool.commonPool());
        ret2.load();
        return ret2;
    }

    public static <T extends ScopedConfigurationNode<T>> ConfigurationReference<T> watching(Function<Path, ConfigurationLoader<? extends T>> loaderCreator, Path file2, WatchServiceListener listener) throws ConfigurateException {
        WatchingConfigurationReference<T> ret2 = new WatchingConfigurationReference<T>(loaderCreator.apply(file2), listener.taskExecutor);
        ret2.load();
        ret2.disposable(listener.listenToFile(file2, ret2));
        return ret2;
    }

    public void load() throws ConfigurateException;

    public void save() throws ConfigurateException;

    public void save(ConfigurationNode var1) throws ConfigurateException;

    public Publisher<N> saveAsync();

    public Publisher<N> updateAsync(Function<N, ? extends N> var1);

    public N node();

    public ConfigurationLoader<? extends N> loader();

    public N get(Object ... var1);

    public N get(Iterable<?> var1);

    default public void set(Object[] path2, @Nullable Object value) throws SerializationException {
        this.node().node(path2).set(value);
    }

    default public <T> void set(Object[] path2, Class<T> type, @Nullable T value) throws SerializationException {
        this.node().node(path2).set(type, value);
    }

    default public <T> void set(Object[] path2, TypeToken<T> type, @Nullable T value) throws SerializationException {
        this.node().node(path2).set(type, value);
    }

    default public void set(NodePath path2, @Nullable Object value) throws SerializationException {
        this.node().node(path2).set(value);
    }

    default public <T> void set(NodePath path2, Class<T> type, @Nullable T value) throws SerializationException {
        this.node().node(path2).set(type, value);
    }

    default public <T> void set(NodePath path2, TypeToken<T> type, @Nullable T value) throws SerializationException {
        this.node().node(path2).set(type, value);
    }

    default public <T> ValueReference<T, N> referenceTo(TypeToken<T> type, Object ... path2) throws SerializationException {
        return this.referenceTo(type, NodePath.of(path2));
    }

    default public <T> ValueReference<T, N> referenceTo(Class<T> type, Object ... path2) throws SerializationException {
        return this.referenceTo(type, NodePath.of(path2));
    }

    default public <T> ValueReference<T, N> referenceTo(TypeToken<T> type, NodePath path2) throws SerializationException {
        return this.referenceTo(type, path2, null);
    }

    default public <T> ValueReference<T, N> referenceTo(Class<T> type, NodePath path2) throws SerializationException {
        return this.referenceTo(type, path2, null);
    }

    public <T> ValueReference<T, N> referenceTo(TypeToken<T> var1, NodePath var2, @Nullable T var3) throws SerializationException;

    public <T> ValueReference<T, N> referenceTo(Class<T> var1, NodePath var2, @Nullable T var3) throws SerializationException;

    public Publisher<N> updates();

    public Publisher<Map.Entry<ErrorPhase, Throwable>> errors();

    @Override
    public void close();

    public static enum ErrorPhase {
        LOADING,
        SAVING,
        UNKNOWN,
        VALUE;

    }
}

