/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.api.platform.velocity;

import app.simplecloud.api.platform.shared.PlayerSynchronizer;
import app.simplecloud.api.platform.velocity.PlayerConnectionListener;
import app.simplecloud.controller.api.ControllerApi;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.proxy.ProxyServer;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0011H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lapp/simplecloud/api/platform/velocity/VelocityApiProvider;", "", "logger", "Lorg/slf4j/Logger;", "proxyServer", "Lcom/velocitypowered/api/proxy/ProxyServer;", "<init>", "(Lorg/slf4j/Logger;Lcom/velocitypowered/api/proxy/ProxyServer;)V", "controllerApi", "Lapp/simplecloud/controller/api/ControllerApi$Coroutine;", "playerSynchronizer", "Lapp/simplecloud/api/platform/shared/PlayerSynchronizer;", "onProxyInitialize", "", "event", "Lcom/velocitypowered/api/event/proxy/ProxyInitializeEvent;", "onProxyShutdown", "Lcom/velocitypowered/api/event/proxy/ProxyShutdownEvent;", "cloud-api"})
public final class VelocityApiProvider {
    @NotNull
    private final Logger logger;
    @NotNull
    private final ProxyServer proxyServer;
    @NotNull
    private final ControllerApi.Coroutine controllerApi;
    @NotNull
    private final PlayerSynchronizer playerSynchronizer;

    @Inject
    public VelocityApiProvider(@NotNull Logger logger, @NotNull ProxyServer proxyServer) {
        Intrinsics.checkNotNullParameter(logger, "logger");
        Intrinsics.checkNotNullParameter(proxyServer, "proxyServer");
        this.logger = logger;
        this.proxyServer = proxyServer;
        this.controllerApi = ControllerApi.Companion.createCoroutineApi();
        this.playerSynchronizer = new PlayerSynchronizer(this.controllerApi, () -> VelocityApiProvider.playerSynchronizer$lambda$0(this));
    }

    @Subscribe
    public final void onProxyInitialize(@NotNull ProxyInitializeEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.logger.info("SimpleCloud v3 API provider initialized!");
        this.proxyServer.getEventManager().register((Object)this, (Object)new PlayerConnectionListener(this.playerSynchronizer));
        this.playerSynchronizer.start();
    }

    @Subscribe
    public final void onProxyShutdown(@NotNull ProxyShutdownEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.logger.info("SimpleCloud v3 API provider uninitialized!");
        this.playerSynchronizer.stop();
    }

    private static final long playerSynchronizer$lambda$0(VelocityApiProvider this$0) {
        return this$0.proxyServer.getPlayerCount();
    }
}

