/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.google.common.collect;

import app.simplecloud.relocate.google.common.annotations.GwtCompatible;
import app.simplecloud.relocate.google.common.annotations.GwtIncompatible;
import app.simplecloud.relocate.google.common.annotations.J2ktIncompatible;
import app.simplecloud.relocate.google.common.base.Preconditions;
import app.simplecloud.relocate.google.common.collect.CollectSpliterators;
import app.simplecloud.relocate.google.common.collect.ElementTypesAreNonnullByDefault;
import app.simplecloud.relocate.google.common.collect.ImmutableAsList;
import app.simplecloud.relocate.google.common.collect.ImmutableCollection;
import app.simplecloud.relocate.google.common.collect.ImmutableList;
import app.simplecloud.relocate.google.common.collect.ImmutableMap;
import app.simplecloud.relocate.google.common.collect.ImmutableSet;
import app.simplecloud.relocate.google.common.collect.Iterators;
import app.simplecloud.relocate.google.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
final class ImmutableMapValues<K, V>
extends ImmutableCollection<V> {
    private final ImmutableMap<K, V> map;

    ImmutableMapValues(ImmutableMap<K, V> map2) {
        this.map = map2;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public UnmodifiableIterator<V> iterator() {
        return new UnmodifiableIterator<V>(){
            final UnmodifiableIterator<Map.Entry<K, V>> entryItr;
            {
                this.entryItr = ((ImmutableSet)ImmutableMapValues.this.map.entrySet()).iterator();
            }

            @Override
            public boolean hasNext() {
                return this.entryItr.hasNext();
            }

            @Override
            public V next() {
                return ((Map.Entry)this.entryItr.next()).getValue();
            }
        };
    }

    @Override
    public Spliterator<V> spliterator() {
        return CollectSpliterators.map(((ImmutableCollection)((Object)this.map.entrySet())).spliterator(), Map.Entry::getValue);
    }

    @Override
    public boolean contains(@CheckForNull Object object) {
        return object != null && Iterators.contains(this.iterator(), object);
    }

    @Override
    boolean isPartialView() {
        return true;
    }

    @Override
    public ImmutableList<V> asList() {
        final ImmutableList entryList = ((ImmutableCollection)((Object)this.map.entrySet())).asList();
        return new ImmutableAsList<V>(this){
            final /* synthetic */ ImmutableMapValues this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public V get(int index) {
                return ((Map.Entry)entryList.get(index)).getValue();
            }

            @Override
            ImmutableCollection<V> delegateCollection() {
                return this.this$0;
            }

            @Override
            @J2ktIncompatible
            @GwtIncompatible
            Object writeReplace() {
                return super.writeReplace();
            }
        };
    }

    @Override
    @GwtIncompatible
    public void forEach(Consumer<? super V> action) {
        Preconditions.checkNotNull(action);
        this.map.forEach((? super K k, ? super V v) -> action.accept((Object)v));
    }

    @Override
    @J2ktIncompatible
    @GwtIncompatible
    Object writeReplace() {
        return super.writeReplace();
    }

    @GwtIncompatible
    @J2ktIncompatible
    private static class SerializedForm<V>
    implements Serializable {
        final ImmutableMap<?, V> map;
        private static final long serialVersionUID = 0L;

        SerializedForm(ImmutableMap<?, V> map2) {
            this.map = map2;
        }

        Object readResolve() {
            return this.map.values();
        }
    }
}

