/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.google.protobuf;

import app.simplecloud.relocate.google.protobuf.CanIgnoreReturnValue;
import app.simplecloud.relocate.google.protobuf.CheckReturnValue;
import app.simplecloud.relocate.google.protobuf.ExtensionRegistryLite;
import app.simplecloud.relocate.google.protobuf.Internal;
import app.simplecloud.relocate.google.protobuf.ManifestSchemaFactory;
import app.simplecloud.relocate.google.protobuf.MessageSchema;
import app.simplecloud.relocate.google.protobuf.Reader;
import app.simplecloud.relocate.google.protobuf.Schema;
import app.simplecloud.relocate.google.protobuf.SchemaFactory;
import app.simplecloud.relocate.google.protobuf.Writer;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@CheckReturnValue
final class Protobuf {
    private static final Protobuf INSTANCE = new Protobuf();
    static boolean assumeLiteRuntime = false;
    private final SchemaFactory schemaFactory;
    private final ConcurrentMap<Class<?>, Schema<?>> schemaCache = new ConcurrentHashMap();

    public static Protobuf getInstance() {
        return INSTANCE;
    }

    public <T> void writeTo(T message, Writer writer2) throws IOException {
        this.schemaFor(message).writeTo(message, writer2);
    }

    public <T> void mergeFrom(T message, Reader reader2) throws IOException {
        this.mergeFrom(message, reader2, ExtensionRegistryLite.getEmptyRegistry());
    }

    public <T> void mergeFrom(T message, Reader reader2, ExtensionRegistryLite extensionRegistry) throws IOException {
        this.schemaFor(message).mergeFrom(message, reader2, extensionRegistry);
    }

    public <T> void makeImmutable(T message) {
        this.schemaFor(message).makeImmutable(message);
    }

    <T> boolean isInitialized(T message) {
        return this.schemaFor(message).isInitialized(message);
    }

    public <T> Schema<T> schemaFor(Class<T> messageType) {
        Schema<?> previous;
        Internal.checkNotNull(messageType, "messageType");
        Schema<Object> schema = (Schema<T>)this.schemaCache.get(messageType);
        if (schema == null && (previous = this.registerSchema(messageType, schema = this.schemaFactory.createSchema(messageType))) != null) {
            schema = previous;
        }
        return schema;
    }

    public <T> Schema<T> schemaFor(T message) {
        return this.schemaFor((T)message.getClass());
    }

    public Schema<?> registerSchema(Class<?> messageType, Schema<?> schema) {
        Internal.checkNotNull(messageType, "messageType");
        Internal.checkNotNull(schema, "schema");
        return this.schemaCache.putIfAbsent(messageType, schema);
    }

    @CanIgnoreReturnValue
    public Schema<?> registerSchemaOverride(Class<?> messageType, Schema<?> schema) {
        Internal.checkNotNull(messageType, "messageType");
        Internal.checkNotNull(schema, "schema");
        return this.schemaCache.put(messageType, schema);
    }

    private Protobuf() {
        this.schemaFactory = new ManifestSchemaFactory();
    }

    int getTotalSchemaSize() {
        int result2 = 0;
        for (Schema schema : this.schemaCache.values()) {
            if (!(schema instanceof MessageSchema)) continue;
            result2 += ((MessageSchema)schema).getSchemaSize();
        }
        return result2;
    }
}

