/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.google.protobuf;

import app.simplecloud.relocate.google.protobuf.ByteString;
import app.simplecloud.relocate.google.protobuf.CanIgnoreReturnValue;
import app.simplecloud.relocate.google.protobuf.CodedInputStream;
import app.simplecloud.relocate.google.protobuf.CodedOutputStream;
import app.simplecloud.relocate.google.protobuf.InvalidProtocolBufferException;
import app.simplecloud.relocate.google.protobuf.MessageLiteToString;
import app.simplecloud.relocate.google.protobuf.WireFormat;
import app.simplecloud.relocate.google.protobuf.Writer;
import java.io.IOException;
import java.util.Arrays;

public final class UnknownFieldSetLite {
    private static final int MIN_CAPACITY = 8;
    private static final UnknownFieldSetLite DEFAULT_INSTANCE = new UnknownFieldSetLite(0, new int[0], new Object[0], false);
    private int count;
    private int[] tags;
    private Object[] objects;
    private int memoizedSerializedSize = -1;
    private boolean isMutable;

    public static UnknownFieldSetLite getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    static UnknownFieldSetLite newInstance() {
        return new UnknownFieldSetLite();
    }

    static UnknownFieldSetLite mutableCopyOf(UnknownFieldSetLite first2, UnknownFieldSetLite second2) {
        int count2 = first2.count + second2.count;
        int[] tags = Arrays.copyOf(first2.tags, count2);
        System.arraycopy(second2.tags, 0, tags, first2.count, second2.count);
        Object[] objects = Arrays.copyOf(first2.objects, count2);
        System.arraycopy(second2.objects, 0, objects, first2.count, second2.count);
        return new UnknownFieldSetLite(count2, tags, objects, true);
    }

    private UnknownFieldSetLite() {
        this(0, new int[8], new Object[8], true);
    }

    private UnknownFieldSetLite(int count2, int[] tags, Object[] objects, boolean isMutable) {
        this.count = count2;
        this.tags = tags;
        this.objects = objects;
        this.isMutable = isMutable;
    }

    public void makeImmutable() {
        if (this.isMutable) {
            this.isMutable = false;
        }
    }

    void checkMutable() {
        if (!this.isMutable) {
            throw new UnsupportedOperationException();
        }
    }

    public void writeTo(CodedOutputStream output2) throws IOException {
        block7: for (int i2 = 0; i2 < this.count; ++i2) {
            int tag = this.tags[i2];
            int fieldNumber = WireFormat.getTagFieldNumber(tag);
            switch (WireFormat.getTagWireType(tag)) {
                case 0: {
                    output2.writeUInt64(fieldNumber, (Long)this.objects[i2]);
                    continue block7;
                }
                case 5: {
                    output2.writeFixed32(fieldNumber, (Integer)this.objects[i2]);
                    continue block7;
                }
                case 1: {
                    output2.writeFixed64(fieldNumber, (Long)this.objects[i2]);
                    continue block7;
                }
                case 2: {
                    output2.writeBytes(fieldNumber, (ByteString)this.objects[i2]);
                    continue block7;
                }
                case 3: {
                    output2.writeTag(fieldNumber, 3);
                    ((UnknownFieldSetLite)this.objects[i2]).writeTo(output2);
                    output2.writeTag(fieldNumber, 4);
                    continue block7;
                }
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
            }
        }
    }

    public void writeAsMessageSetTo(CodedOutputStream output2) throws IOException {
        for (int i2 = 0; i2 < this.count; ++i2) {
            int fieldNumber = WireFormat.getTagFieldNumber(this.tags[i2]);
            output2.writeRawMessageSetExtension(fieldNumber, (ByteString)this.objects[i2]);
        }
    }

    void writeAsMessageSetTo(Writer writer2) throws IOException {
        if (writer2.fieldOrder() == Writer.FieldOrder.DESCENDING) {
            for (int i2 = this.count - 1; i2 >= 0; --i2) {
                int fieldNumber = WireFormat.getTagFieldNumber(this.tags[i2]);
                writer2.writeMessageSetItem(fieldNumber, this.objects[i2]);
            }
        } else {
            for (int i3 = 0; i3 < this.count; ++i3) {
                int fieldNumber = WireFormat.getTagFieldNumber(this.tags[i3]);
                writer2.writeMessageSetItem(fieldNumber, this.objects[i3]);
            }
        }
    }

    public void writeTo(Writer writer2) throws IOException {
        if (this.count == 0) {
            return;
        }
        if (writer2.fieldOrder() == Writer.FieldOrder.ASCENDING) {
            for (int i2 = 0; i2 < this.count; ++i2) {
                UnknownFieldSetLite.writeField(this.tags[i2], this.objects[i2], writer2);
            }
        } else {
            for (int i3 = this.count - 1; i3 >= 0; --i3) {
                UnknownFieldSetLite.writeField(this.tags[i3], this.objects[i3], writer2);
            }
        }
    }

    private static void writeField(int tag, Object object, Writer writer2) throws IOException {
        int fieldNumber = WireFormat.getTagFieldNumber(tag);
        switch (WireFormat.getTagWireType(tag)) {
            case 0: {
                writer2.writeInt64(fieldNumber, (Long)object);
                break;
            }
            case 5: {
                writer2.writeFixed32(fieldNumber, (Integer)object);
                break;
            }
            case 1: {
                writer2.writeFixed64(fieldNumber, (Long)object);
                break;
            }
            case 2: {
                writer2.writeBytes(fieldNumber, (ByteString)object);
                break;
            }
            case 3: {
                if (writer2.fieldOrder() == Writer.FieldOrder.ASCENDING) {
                    writer2.writeStartGroup(fieldNumber);
                    ((UnknownFieldSetLite)object).writeTo(writer2);
                    writer2.writeEndGroup(fieldNumber);
                    break;
                }
                writer2.writeEndGroup(fieldNumber);
                ((UnknownFieldSetLite)object).writeTo(writer2);
                writer2.writeStartGroup(fieldNumber);
                break;
            }
            default: {
                throw new RuntimeException(InvalidProtocolBufferException.invalidWireType());
            }
        }
    }

    public int getSerializedSizeAsMessageSet() {
        int size = this.memoizedSerializedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        for (int i2 = 0; i2 < this.count; ++i2) {
            int tag = this.tags[i2];
            int fieldNumber = WireFormat.getTagFieldNumber(tag);
            size += CodedOutputStream.computeRawMessageSetExtensionSize(fieldNumber, (ByteString)this.objects[i2]);
        }
        this.memoizedSerializedSize = size;
        return size;
    }

    public int getSerializedSize() {
        int size = this.memoizedSerializedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        block7: for (int i2 = 0; i2 < this.count; ++i2) {
            int tag = this.tags[i2];
            int fieldNumber = WireFormat.getTagFieldNumber(tag);
            switch (WireFormat.getTagWireType(tag)) {
                case 0: {
                    size += CodedOutputStream.computeUInt64Size(fieldNumber, (Long)this.objects[i2]);
                    continue block7;
                }
                case 5: {
                    size += CodedOutputStream.computeFixed32Size(fieldNumber, (Integer)this.objects[i2]);
                    continue block7;
                }
                case 1: {
                    size += CodedOutputStream.computeFixed64Size(fieldNumber, (Long)this.objects[i2]);
                    continue block7;
                }
                case 2: {
                    size += CodedOutputStream.computeBytesSize(fieldNumber, (ByteString)this.objects[i2]);
                    continue block7;
                }
                case 3: {
                    size += CodedOutputStream.computeTagSize(fieldNumber) * 2 + ((UnknownFieldSetLite)this.objects[i2]).getSerializedSize();
                    continue block7;
                }
                default: {
                    throw new IllegalStateException(InvalidProtocolBufferException.invalidWireType());
                }
            }
        }
        this.memoizedSerializedSize = size;
        return size;
    }

    private static boolean tagsEquals(int[] tags1, int[] tags2, int count2) {
        for (int i2 = 0; i2 < count2; ++i2) {
            if (tags1[i2] == tags2[i2]) continue;
            return false;
        }
        return true;
    }

    private static boolean objectsEquals(Object[] objects1, Object[] objects2, int count2) {
        for (int i2 = 0; i2 < count2; ++i2) {
            if (objects1[i2].equals(objects2[i2])) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnknownFieldSetLite)) {
            return false;
        }
        UnknownFieldSetLite other = (UnknownFieldSetLite)obj;
        return this.count == other.count && UnknownFieldSetLite.tagsEquals(this.tags, other.tags, this.count) && UnknownFieldSetLite.objectsEquals(this.objects, other.objects, this.count);
    }

    private static int hashCode(int[] tags, int count2) {
        int hashCode = 17;
        for (int i2 = 0; i2 < count2; ++i2) {
            hashCode = 31 * hashCode + tags[i2];
        }
        return hashCode;
    }

    private static int hashCode(Object[] objects, int count2) {
        int hashCode = 17;
        for (int i2 = 0; i2 < count2; ++i2) {
            hashCode = 31 * hashCode + objects[i2].hashCode();
        }
        return hashCode;
    }

    public int hashCode() {
        int hashCode = 17;
        hashCode = 31 * hashCode + this.count;
        hashCode = 31 * hashCode + UnknownFieldSetLite.hashCode(this.tags, this.count);
        hashCode = 31 * hashCode + UnknownFieldSetLite.hashCode(this.objects, this.count);
        return hashCode;
    }

    final void printWithIndent(StringBuilder buffer, int indent) {
        for (int i2 = 0; i2 < this.count; ++i2) {
            int fieldNumber = WireFormat.getTagFieldNumber(this.tags[i2]);
            MessageLiteToString.printField(buffer, indent, String.valueOf(fieldNumber), this.objects[i2]);
        }
    }

    void storeField(int tag, Object value) {
        this.checkMutable();
        this.ensureCapacity(this.count + 1);
        this.tags[this.count] = tag;
        this.objects[this.count] = value;
        ++this.count;
    }

    private void ensureCapacity(int minCapacity) {
        if (minCapacity > this.tags.length) {
            int newCapacity = this.count + this.count / 2;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            if (newCapacity < 8) {
                newCapacity = 8;
            }
            this.tags = Arrays.copyOf(this.tags, newCapacity);
            this.objects = Arrays.copyOf(this.objects, newCapacity);
        }
    }

    boolean mergeFieldFrom(int tag, CodedInputStream input2) throws IOException {
        this.checkMutable();
        int fieldNumber = WireFormat.getTagFieldNumber(tag);
        switch (WireFormat.getTagWireType(tag)) {
            case 0: {
                this.storeField(tag, input2.readInt64());
                return true;
            }
            case 5: {
                this.storeField(tag, input2.readFixed32());
                return true;
            }
            case 1: {
                this.storeField(tag, input2.readFixed64());
                return true;
            }
            case 2: {
                this.storeField(tag, input2.readBytes());
                return true;
            }
            case 3: {
                UnknownFieldSetLite subFieldSet = new UnknownFieldSetLite();
                subFieldSet.mergeFrom(input2);
                input2.checkLastTagWas(WireFormat.makeTag(fieldNumber, 4));
                this.storeField(tag, subFieldSet);
                return true;
            }
            case 4: {
                input2.checkValidEndTag();
                return false;
            }
        }
        throw InvalidProtocolBufferException.invalidWireType();
    }

    UnknownFieldSetLite mergeVarintField(int fieldNumber, int value) {
        this.checkMutable();
        if (fieldNumber == 0) {
            throw new IllegalArgumentException("Zero is not a valid field number.");
        }
        this.storeField(WireFormat.makeTag(fieldNumber, 0), value);
        return this;
    }

    UnknownFieldSetLite mergeLengthDelimitedField(int fieldNumber, ByteString value) {
        this.checkMutable();
        if (fieldNumber == 0) {
            throw new IllegalArgumentException("Zero is not a valid field number.");
        }
        this.storeField(WireFormat.makeTag(fieldNumber, 2), value);
        return this;
    }

    private UnknownFieldSetLite mergeFrom(CodedInputStream input2) throws IOException {
        int tag;
        while ((tag = input2.readTag()) != 0 && this.mergeFieldFrom(tag, input2)) {
        }
        return this;
    }

    @CanIgnoreReturnValue
    UnknownFieldSetLite mergeFrom(UnknownFieldSetLite other) {
        if (other.equals(UnknownFieldSetLite.getDefaultInstance())) {
            return this;
        }
        this.checkMutable();
        int newCount = this.count + other.count;
        this.ensureCapacity(newCount);
        System.arraycopy(other.tags, 0, this.tags, this.count, other.count);
        System.arraycopy(other.objects, 0, this.objects, this.count, other.count);
        this.count = newCount;
        return this;
    }
}

