/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.io.grpc;

import app.simplecloud.relocate.google.common.base.Preconditions;
import app.simplecloud.relocate.io.grpc.ExperimentalApi;
import app.simplecloud.relocate.io.grpc.TimeUtils;
import java.time.Duration;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class SynchronizationContext
implements Executor {
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private final Queue<Runnable> queue = new ConcurrentLinkedQueue<Runnable>();
    private final AtomicReference<Thread> drainingThread = new AtomicReference();

    public SynchronizationContext(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = Preconditions.checkNotNull(uncaughtExceptionHandler, "uncaughtExceptionHandler");
    }

    public final void drain() {
        do {
            if (!this.drainingThread.compareAndSet(null, Thread.currentThread())) {
                return;
            }
            try {
                Runnable runnable;
                while ((runnable = this.queue.poll()) != null) {
                    try {
                        runnable.run();
                    }
                    catch (Throwable t2) {
                        this.uncaughtExceptionHandler.uncaughtException(Thread.currentThread(), t2);
                    }
                }
            }
            finally {
                this.drainingThread.set(null);
            }
        } while (!this.queue.isEmpty());
    }

    public final void executeLater(Runnable runnable) {
        this.queue.add(Preconditions.checkNotNull(runnable, "runnable is null"));
    }

    @Override
    public final void execute(Runnable task2) {
        this.executeLater(task2);
        this.drain();
    }

    public void throwIfNotInThisSynchronizationContext() {
        Preconditions.checkState(Thread.currentThread() == this.drainingThread.get(), "Not called from the SynchronizationContext");
    }

    public final ScheduledHandle schedule(final Runnable task2, long delay2, TimeUnit unit, ScheduledExecutorService timerService) {
        final ManagedRunnable runnable = new ManagedRunnable(task2);
        ScheduledFuture<?> future = timerService.schedule(new Runnable(){

            @Override
            public void run() {
                SynchronizationContext.this.execute(runnable);
            }

            public String toString() {
                return task2.toString() + "(scheduled in SynchronizationContext)";
            }
        }, delay2, unit);
        return new ScheduledHandle(runnable, future);
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/11657")
    public final ScheduledHandle schedule(Runnable task2, Duration delay2, ScheduledExecutorService timerService) {
        return this.schedule(task2, TimeUtils.convertToNanos(delay2), TimeUnit.NANOSECONDS, timerService);
    }

    public final ScheduledHandle scheduleWithFixedDelay(final Runnable task2, long initialDelay, final long delay2, TimeUnit unit, ScheduledExecutorService timerService) {
        final ManagedRunnable runnable = new ManagedRunnable(task2);
        ScheduledFuture<?> future = timerService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                SynchronizationContext.this.execute(runnable);
            }

            public String toString() {
                return task2.toString() + "(scheduled in SynchronizationContext with delay of " + delay2 + ")";
            }
        }, initialDelay, delay2, unit);
        return new ScheduledHandle(runnable, future);
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/11657")
    public final ScheduledHandle scheduleWithFixedDelay(Runnable task2, Duration initialDelay, Duration delay2, ScheduledExecutorService timerService) {
        return this.scheduleWithFixedDelay(task2, TimeUtils.convertToNanos(initialDelay), TimeUtils.convertToNanos(delay2), TimeUnit.NANOSECONDS, timerService);
    }

    public static final class ScheduledHandle {
        private final ManagedRunnable runnable;
        private final ScheduledFuture<?> future;

        private ScheduledHandle(ManagedRunnable runnable, ScheduledFuture<?> future) {
            this.runnable = Preconditions.checkNotNull(runnable, "runnable");
            this.future = Preconditions.checkNotNull(future, "future");
        }

        public void cancel() {
            this.runnable.isCancelled = true;
            this.future.cancel(false);
        }

        public boolean isPending() {
            return !this.runnable.hasStarted && !this.runnable.isCancelled;
        }
    }

    private static class ManagedRunnable
    implements Runnable {
        final Runnable task;
        boolean isCancelled;
        boolean hasStarted;

        ManagedRunnable(Runnable task2) {
            this.task = Preconditions.checkNotNull(task2, "task");
        }

        @Override
        public void run() {
            if (!this.isCancelled) {
                this.hasStarted = true;
                this.task.run();
            }
        }
    }
}

