/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.io.grpc.stub;

import app.simplecloud.relocate.google.common.base.Preconditions;
import app.simplecloud.relocate.io.grpc.ExperimentalApi;
import app.simplecloud.relocate.io.grpc.stub.CallStreamObserver;
import app.simplecloud.relocate.io.grpc.stub.StreamObserver;
import java.util.Iterator;

public final class StreamObservers {
    private StreamObservers() {
    }

    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/10957")
    public static <T> void nextAndComplete(StreamObserver<T> responseObserver, T response2) {
        responseObserver.onNext(response2);
        responseObserver.onCompleted();
    }

    @Deprecated
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4694")
    public static <V> void copyWithFlowControl(final Iterator<V> source, final CallStreamObserver<V> target) {
        Preconditions.checkNotNull(source, "source");
        Preconditions.checkNotNull(target, "target");
        final class FlowControllingOnReadyHandler
        implements Runnable {
            private boolean completed;

            FlowControllingOnReadyHandler() {
            }

            @Override
            public void run() {
                if (this.completed) {
                    return;
                }
                while (target.isReady() && source.hasNext()) {
                    target.onNext(source.next());
                }
                if (!source.hasNext()) {
                    this.completed = true;
                    target.onCompleted();
                }
            }
        }
        target.setOnReadyHandler(new FlowControllingOnReadyHandler());
    }

    @Deprecated
    @ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4694")
    public static <V> void copyWithFlowControl(Iterable<V> source, CallStreamObserver<V> target) {
        Preconditions.checkNotNull(source, "source");
        StreamObservers.copyWithFlowControl(source.iterator(), target);
    }
}

