/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.auth;

import io.ktor.http.Headers;
import io.ktor.http.HeadersKt;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpStatusCode;
import io.ktor.http.auth.HttpAuthHeader;
import io.ktor.http.content.OutgoingContent;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0002\"\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0013\b\u0016\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\bR\u001f\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\t\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u000f\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0013\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lio/ktor/server/auth/ForbiddenResponse;", "Lio/ktor/http/content/OutgoingContent$NoContent;", "", "Lio/ktor/http/auth/HttpAuthHeader;", "challenges", "<init>", "([Lio/ktor/http/auth/HttpAuthHeader;)V", "challenge", "(Lio/ktor/http/auth/HttpAuthHeader;)V", "[Lio/ktor/http/auth/HttpAuthHeader;", "getChallenges", "()[Lio/ktor/http/auth/HttpAuthHeader;", "Lio/ktor/http/HttpStatusCode;", "getStatus", "()Lio/ktor/http/HttpStatusCode;", "status", "Lio/ktor/http/Headers;", "getHeaders", "()Lio/ktor/http/Headers;", "headers", "ktor-server-auth"})
public final class ForbiddenResponse
extends OutgoingContent.NoContent {
    @NotNull
    private final HttpAuthHeader[] challenges;

    public ForbiddenResponse(HttpAuthHeader ... challenges) {
        Intrinsics.checkNotNullParameter(challenges, "challenges");
        this.challenges = challenges;
    }

    @NotNull
    public final HttpAuthHeader[] getChallenges() {
        return this.challenges;
    }

    public ForbiddenResponse(@Nullable HttpAuthHeader challenge2) {
        HttpAuthHeader[] httpAuthHeaderArray;
        if (challenge2 == null) {
            httpAuthHeaderArray = new HttpAuthHeader[]{};
        } else {
            HttpAuthHeader[] httpAuthHeaderArray2 = new HttpAuthHeader[]{challenge2};
            httpAuthHeaderArray = httpAuthHeaderArray2;
        }
        HttpAuthHeader[] httpAuthHeaderArray3 = httpAuthHeaderArray;
        this(Arrays.copyOf(httpAuthHeaderArray3, httpAuthHeaderArray3.length));
    }

    @Override
    @NotNull
    public HttpStatusCode getStatus() {
        return HttpStatusCode.Companion.getForbidden();
    }

    @Override
    @NotNull
    public Headers getHeaders() {
        return !(this.challenges.length == 0) ? HeadersKt.headersOf(HttpHeaders.INSTANCE.getWWWAuthenticate(), ArraysKt.joinToString$default(this.challenges, (CharSequence)", ", null, null, 0, null, ForbiddenResponse::_get_headers_$lambda$0, 30, null)) : Headers.Companion.getEmpty();
    }

    private static final CharSequence _get_headers_$lambda$0(HttpAuthHeader it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.render();
    }
}

