/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io;

import java.io.IOException;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlinx.coroutines.CopyableThrowable;
import kotlinx.coroutines.ExceptionsKt;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0003\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007R\u0013\u0010\n\u001a\u0004\u0018\u00010\u00028F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000b"}, d2={"Lio/ktor/utils/io/CloseToken;", "", "", "origin", "<init>", "(Ljava/lang/Throwable;)V", "closedException", "Ljava/lang/Throwable;", "getCause", "()Ljava/lang/Throwable;", "cause", "ktor-io"})
public final class CloseToken {
    @Nullable
    private final Throwable closedException;

    public CloseToken(@Nullable Throwable origin) {
        Throwable throwable;
        if (origin == null) {
            throwable = null;
        } else if (origin instanceof CancellationException) {
            if (origin instanceof CopyableThrowable) {
                throwable = (Throwable)((CopyableThrowable)((Object)origin)).createCopy();
            } else {
                String string = ((CancellationException)origin).getMessage();
                if (string == null) {
                    string = "Channel was cancelled";
                }
                throwable = ExceptionsKt.CancellationException(string, origin);
            }
        } else if (origin instanceof IOException && origin instanceof CopyableThrowable) {
            throwable = (Throwable)((CopyableThrowable)((Object)origin)).createCopy();
        } else {
            String string = origin.getMessage();
            if (string == null) {
                string = "Channel was closed";
            }
            throwable = new IOException(string, origin);
        }
        this.closedException = throwable;
    }

    @Nullable
    public final Throwable getCause() {
        Throwable throwable;
        if (this.closedException == null) {
            throwable = null;
        } else if (this.closedException instanceof IOException) {
            throwable = this.closedException instanceof CopyableThrowable ? (Throwable)((CopyableThrowable)((Object)this.closedException)).createCopy() : (Throwable)new IOException(((IOException)this.closedException).getMessage(), this.closedException);
        } else if (this.closedException instanceof CopyableThrowable) {
            Object t2 = ((CopyableThrowable)((Object)this.closedException)).createCopy();
            throwable = (Throwable)t2;
            if (t2 == null) {
                throwable = ExceptionsKt.CancellationException(this.closedException.getMessage(), this.closedException);
            }
        } else {
            throwable = ExceptionsKt.CancellationException(this.closedException.getMessage(), this.closedException);
        }
        return throwable;
    }
}

