/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.configurate.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.spongepowered.configurate.util.NamingScheme;

public enum NamingSchemes implements NamingScheme
{
    PASSTHROUGH{

        @Override
        public String coerce(String input2) {
            return input2;
        }
    }
    ,
    CAMEL_CASE{

        @Override
        public String coerce(String input2) {
            Matcher match = DASH_UNDERSCORE.matcher(input2);
            if (!match.find()) {
                return input2;
            }
            StringBuffer ret2 = new StringBuffer(input2.length());
            do {
                match.appendReplacement(ret2, "");
                ret2.appendCodePoint(input2.codePointAt(match.start()));
                ret2.appendCodePoint(Character.toUpperCase(input2.codePointBefore(match.end())));
            } while (match.find());
            match.appendTail(ret2);
            return ret2.toString();
        }
    }
    ,
    SNAKE_CASE{

        @Override
        public String coerce(String input2) {
            return NamingSchemes.enforceLowerCaseSeparatorChar(input2, '_', '-');
        }
    }
    ,
    LOWER_CASE_DASHED{

        @Override
        public String coerce(String input2) {
            return NamingSchemes.enforceLowerCaseSeparatorChar(input2, '-', '_');
        }
    };

    private static final Pattern DASH_UNDERSCORE;
    private static final char UNDERSCORE = '_';
    private static final char DASH = '-';

    private static String enforceLowerCaseSeparatorChar(String input2, char preferredDelimiter, char convertDelimiter) {
        StringBuilder build = new StringBuilder(input2);
        for (int i2 = 0; i2 < build.length(); ++i2) {
            int ch = build.codePointAt(i2);
            if (ch == convertDelimiter) {
                if (i2 == 0 || i2 == build.length() - 1) continue;
                build.setCharAt(i2, preferredDelimiter);
                continue;
            }
            if (!Character.isUpperCase(ch)) continue;
            build.insert(i2++, preferredDelimiter);
            int lower = Character.toLowerCase(ch);
            if (Character.isBmpCodePoint(lower)) {
                build.setCharAt(i2, (char)lower);
                continue;
            }
            build.setCharAt(i2++, Character.highSurrogate(lower));
            build.setCharAt(i2, Character.lowSurrogate(lower));
        }
        return build.toString();
    }

    static {
        DASH_UNDERSCORE = Pattern.compile(".[-_].");
    }
}

