/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.droplet.player.api.impl;

import app.simplecloud.droplet.api.auth.AuthCallCredentials;
import app.simplecloud.droplet.api.future.ListenableFutureExtensionKt;
import app.simplecloud.droplet.player.api.CloudPlayer;
import app.simplecloud.droplet.player.api.OfflineCloudPlayer;
import app.simplecloud.droplet.player.api.PlayerApi;
import app.simplecloud.droplet.player.api.impl.CloudPlayerImpl;
import app.simplecloud.droplet.player.api.impl.OfflineCloudPlayerImpl;
import app.simplecloud.pubsub.PubSubClient;
import app.simplecloud.relocate.google.common.util.concurrent.ListenableFuture;
import app.simplecloud.relocate.io.grpc.ManagedChannel;
import app.simplecloud.relocate.io.grpc.ManagedChannelBuilder;
import build.buf.gen.simplecloud.droplet.player.v1.CloudPlayerConfiguration;
import build.buf.gen.simplecloud.droplet.player.v1.CloudPlayerConnectResult;
import build.buf.gen.simplecloud.droplet.player.v1.ConnectCloudPlayerRequest;
import build.buf.gen.simplecloud.droplet.player.v1.ConnectCloudPlayerResponse;
import build.buf.gen.simplecloud.droplet.player.v1.GetCloudPlayerByNameRequest;
import build.buf.gen.simplecloud.droplet.player.v1.GetCloudPlayerByUniqueIdRequest;
import build.buf.gen.simplecloud.droplet.player.v1.GetCloudPlayerResponse;
import build.buf.gen.simplecloud.droplet.player.v1.GetOfflineCloudPlayerResponse;
import build.buf.gen.simplecloud.droplet.player.v1.GetOnlineCloudPlayerCountRequest;
import build.buf.gen.simplecloud.droplet.player.v1.GetOnlineCloudPlayerCountResponse;
import build.buf.gen.simplecloud.droplet.player.v1.GetOnlineCloudPlayersRequest;
import build.buf.gen.simplecloud.droplet.player.v1.GetOnlineCloudPlayersResponse;
import build.buf.gen.simplecloud.droplet.player.v1.GetOnlineStatusRequest;
import build.buf.gen.simplecloud.droplet.player.v1.GetOnlineStatusResponse;
import build.buf.gen.simplecloud.droplet.player.v1.OfflineCloudPlayerConfiguration;
import build.buf.gen.simplecloud.droplet.player.v1.PlayerAdventureServiceGrpc;
import build.buf.gen.simplecloud.droplet.player.v1.PlayerServiceGrpc;
import build.buf.gen.simplecloud.droplet.player.v1.UpdateCloudPlayerServerRequest;
import build.buf.gen.simplecloud.droplet.player.v1.UpdateCloudPlayerServerResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00152\u0006\u0010\u0017\u001a\u00020\u0003H\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0014\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001d0\u0015H\u0016J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0015H\u0016J\u001e\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u0003H\u0016J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001e\u0010%\u001a\b\u0012\u0004\u0012\u00020$0\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u0003H\u0016J\b\u0010&\u001a\u00020\u0013H\u0016J\b\u0010'\u001a\u00020\tH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lapp/simplecloud/droplet/player/api/impl/PlayerApiFutureImpl;", "Lapp/simplecloud/droplet/player/api/PlayerApi$Future;", "authSecret", "", "<init>", "(Ljava/lang/String;)V", "authCallCredentials", "Lapp/simplecloud/droplet/api/auth/AuthCallCredentials;", "managedChannel", "Lapp/simplecloud/relocate/io/grpc/ManagedChannel;", "playerServiceStub", "Lbuild/buf/gen/simplecloud/droplet/player/v1/PlayerServiceGrpc$PlayerServiceFutureStub;", "getPlayerServiceStub", "()Lbuild/buf/gen/simplecloud/droplet/player/v1/PlayerServiceGrpc$PlayerServiceFutureStub;", "playerServiceAdventureStub", "Lbuild/buf/gen/simplecloud/droplet/player/v1/PlayerAdventureServiceGrpc$PlayerAdventureServiceFutureStub;", "getPlayerServiceAdventureStub", "()Lbuild/buf/gen/simplecloud/droplet/player/v1/PlayerAdventureServiceGrpc$PlayerAdventureServiceFutureStub;", "pubSubClient", "Lapp/simplecloud/pubsub/PubSubClient;", "getOfflinePlayer", "Ljava/util/concurrent/CompletableFuture;", "Lapp/simplecloud/droplet/player/api/OfflineCloudPlayer;", "name", "uniqueId", "Ljava/util/UUID;", "getOnlinePlayer", "Lapp/simplecloud/droplet/player/api/CloudPlayer;", "getOnlinePlayers", "", "getOnlinePlayerCount", "", "connectPlayer", "Lbuild/buf/gen/simplecloud/droplet/player/v1/CloudPlayerConnectResult;", "serverName", "isOnline", "", "updateServer", "getPubSubClient", "createManagedChannelFromEnv", "player-api"})
@SourceDebugExtension(value={"SMAP\nPlayerApiFutureImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerApiFutureImpl.kt\napp/simplecloud/droplet/player/api/impl/PlayerApiFutureImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,122:1\n1557#2:123\n1628#2,3:124\n*S KotlinDebug\n*F\n+ 1 PlayerApiFutureImpl.kt\napp/simplecloud/droplet/player/api/impl/PlayerApiFutureImpl\n*L\n77#1:123\n77#1:124,3\n*E\n"})
public class PlayerApiFutureImpl
implements PlayerApi.Future {
    @NotNull
    private final AuthCallCredentials authCallCredentials;
    @NotNull
    private final ManagedChannel managedChannel;
    @NotNull
    private final PlayerServiceGrpc.PlayerServiceFutureStub playerServiceStub;
    @NotNull
    private final PlayerAdventureServiceGrpc.PlayerAdventureServiceFutureStub playerServiceAdventureStub;
    @NotNull
    private final PubSubClient pubSubClient;

    public PlayerApiFutureImpl(@NotNull String authSecret) {
        Intrinsics.checkNotNullParameter(authSecret, "authSecret");
        this.authCallCredentials = new AuthCallCredentials(authSecret);
        this.managedChannel = this.createManagedChannelFromEnv();
        Object s2 = PlayerServiceGrpc.newFutureStub(this.managedChannel).withCallCredentials(this.authCallCredentials);
        Intrinsics.checkNotNullExpressionValue(s2, "withCallCredentials(...)");
        this.playerServiceStub = (PlayerServiceGrpc.PlayerServiceFutureStub)s2;
        Object s3 = PlayerAdventureServiceGrpc.newFutureStub(this.managedChannel).withCallCredentials(this.authCallCredentials);
        Intrinsics.checkNotNullExpressionValue(s3, "withCallCredentials(...)");
        this.playerServiceAdventureStub = (PlayerAdventureServiceGrpc.PlayerAdventureServiceFutureStub)s3;
        String string = System.getenv("PLAYER_DROPLET_PUBSUB_HOST");
        if (string == null) {
            string = "localhost";
        }
        String string2 = System.getenv("PLAYER_DROPLET_PUBSUB_PORT");
        this.pubSubClient = new PubSubClient(string, string2 != null ? Integer.parseInt(string2) : 5827, this.authCallCredentials);
    }

    @NotNull
    public final PlayerServiceGrpc.PlayerServiceFutureStub getPlayerServiceStub() {
        return this.playerServiceStub;
    }

    @NotNull
    public final PlayerAdventureServiceGrpc.PlayerAdventureServiceFutureStub getPlayerServiceAdventureStub() {
        return this.playerServiceAdventureStub;
    }

    @Override
    @NotNull
    public CompletableFuture<OfflineCloudPlayer> getOfflinePlayer(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        ListenableFuture<GetOfflineCloudPlayerResponse> listenableFuture = this.playerServiceStub.getOfflineCloudPlayerByName(GetCloudPlayerByNameRequest.newBuilder().setName(name).build());
        Intrinsics.checkNotNullExpressionValue(listenableFuture, "getOfflineCloudPlayerByName(...)");
        CompletionStage completionStage = ListenableFutureExtensionKt.toCompletable(listenableFuture).thenApply(arg_0 -> PlayerApiFutureImpl.getOfflinePlayer$lambda$1(PlayerApiFutureImpl::getOfflinePlayer$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue(completionStage, "thenApply(...)");
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<OfflineCloudPlayer> getOfflinePlayer(@NotNull UUID uniqueId) {
        Intrinsics.checkNotNullParameter(uniqueId, "uniqueId");
        ListenableFuture<GetOfflineCloudPlayerResponse> listenableFuture = this.playerServiceStub.getOfflineCloudPlayerByUniqueId(GetCloudPlayerByUniqueIdRequest.newBuilder().setUniqueId(uniqueId.toString()).build());
        Intrinsics.checkNotNullExpressionValue(listenableFuture, "getOfflineCloudPlayerByUniqueId(...)");
        CompletionStage completionStage = ListenableFutureExtensionKt.toCompletable(listenableFuture).thenApply(arg_0 -> PlayerApiFutureImpl.getOfflinePlayer$lambda$3(PlayerApiFutureImpl::getOfflinePlayer$lambda$2, arg_0));
        Intrinsics.checkNotNullExpressionValue(completionStage, "thenApply(...)");
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<CloudPlayer> getOnlinePlayer(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        ListenableFuture<GetCloudPlayerResponse> listenableFuture = this.playerServiceStub.getCloudPlayerByName(GetCloudPlayerByNameRequest.newBuilder().setName(name).build());
        Intrinsics.checkNotNullExpressionValue(listenableFuture, "getCloudPlayerByName(...)");
        CompletionStage completionStage = ListenableFutureExtensionKt.toCompletable(listenableFuture).thenApply(arg_0 -> PlayerApiFutureImpl.getOnlinePlayer$lambda$5(arg_0 -> PlayerApiFutureImpl.getOnlinePlayer$lambda$4(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue(completionStage, "thenApply(...)");
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<CloudPlayer> getOnlinePlayer(@NotNull UUID uniqueId) {
        Intrinsics.checkNotNullParameter(uniqueId, "uniqueId");
        ListenableFuture<GetCloudPlayerResponse> listenableFuture = this.playerServiceStub.getCloudPlayerByUniqueId(GetCloudPlayerByUniqueIdRequest.newBuilder().setUniqueId(uniqueId.toString()).build());
        Intrinsics.checkNotNullExpressionValue(listenableFuture, "getCloudPlayerByUniqueId(...)");
        CompletionStage completionStage = ListenableFutureExtensionKt.toCompletable(listenableFuture).thenApply(arg_0 -> PlayerApiFutureImpl.getOnlinePlayer$lambda$7(arg_0 -> PlayerApiFutureImpl.getOnlinePlayer$lambda$6(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue(completionStage, "thenApply(...)");
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<List<CloudPlayer>> getOnlinePlayers() {
        ListenableFuture<GetOnlineCloudPlayersResponse> listenableFuture = this.playerServiceStub.getOnlineCloudPlayers(GetOnlineCloudPlayersRequest.getDefaultInstance());
        Intrinsics.checkNotNullExpressionValue(listenableFuture, "getOnlineCloudPlayers(...)");
        CompletionStage completionStage = ListenableFutureExtensionKt.toCompletable(listenableFuture).thenApply(arg_0 -> PlayerApiFutureImpl.getOnlinePlayers$lambda$10(arg_0 -> PlayerApiFutureImpl.getOnlinePlayers$lambda$9(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue(completionStage, "thenApply(...)");
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<Integer> getOnlinePlayerCount() {
        ListenableFuture<GetOnlineCloudPlayerCountResponse> listenableFuture = this.playerServiceStub.getOnlineCloudPlayerCount(GetOnlineCloudPlayerCountRequest.getDefaultInstance());
        Intrinsics.checkNotNullExpressionValue(listenableFuture, "getOnlineCloudPlayerCount(...)");
        CompletionStage completionStage = ListenableFutureExtensionKt.toCompletable(listenableFuture).thenApply(arg_0 -> PlayerApiFutureImpl.getOnlinePlayerCount$lambda$12(PlayerApiFutureImpl::getOnlinePlayerCount$lambda$11, arg_0));
        Intrinsics.checkNotNullExpressionValue(completionStage, "thenApply(...)");
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<CloudPlayerConnectResult> connectPlayer(@NotNull UUID uniqueId, @NotNull String serverName) {
        Intrinsics.checkNotNullParameter(uniqueId, "uniqueId");
        Intrinsics.checkNotNullParameter(serverName, "serverName");
        ListenableFuture<ConnectCloudPlayerResponse> listenableFuture = this.playerServiceStub.connectCloudPlayerToServer(ConnectCloudPlayerRequest.newBuilder().setUniqueId(uniqueId.toString()).setServerName(serverName).build());
        Intrinsics.checkNotNullExpressionValue(listenableFuture, "connectCloudPlayerToServer(...)");
        CompletionStage completionStage = ListenableFutureExtensionKt.toCompletable(listenableFuture).thenApply(arg_0 -> PlayerApiFutureImpl.connectPlayer$lambda$14(PlayerApiFutureImpl::connectPlayer$lambda$13, arg_0));
        Intrinsics.checkNotNullExpressionValue(completionStage, "thenApply(...)");
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> isOnline(@NotNull UUID uniqueId) {
        Intrinsics.checkNotNullParameter(uniqueId, "uniqueId");
        ListenableFuture<GetOnlineStatusResponse> listenableFuture = this.playerServiceStub.getOnlineStatus(GetOnlineStatusRequest.newBuilder().setUniqueId(uniqueId.toString()).build());
        Intrinsics.checkNotNullExpressionValue(listenableFuture, "getOnlineStatus(...)");
        CompletionStage completionStage = ListenableFutureExtensionKt.toCompletable(listenableFuture).thenApply(arg_0 -> PlayerApiFutureImpl.isOnline$lambda$16(PlayerApiFutureImpl::isOnline$lambda$15, arg_0));
        Intrinsics.checkNotNullExpressionValue(completionStage, "thenApply(...)");
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> updateServer(@NotNull UUID uniqueId, @NotNull String serverName) {
        Intrinsics.checkNotNullParameter(uniqueId, "uniqueId");
        Intrinsics.checkNotNullParameter(serverName, "serverName");
        ListenableFuture<UpdateCloudPlayerServerResponse> listenableFuture = this.playerServiceStub.updateCloudPlayerServer(UpdateCloudPlayerServerRequest.newBuilder().setUniqueId(uniqueId.toString()).setServerName(serverName).build());
        Intrinsics.checkNotNullExpressionValue(listenableFuture, "updateCloudPlayerServer(...)");
        CompletionStage completionStage = ListenableFutureExtensionKt.toCompletable(listenableFuture).thenApply(arg_0 -> PlayerApiFutureImpl.updateServer$lambda$18(PlayerApiFutureImpl::updateServer$lambda$17, arg_0));
        Intrinsics.checkNotNullExpressionValue(completionStage, "thenApply(...)");
        return completionStage;
    }

    @Override
    @NotNull
    public PubSubClient getPubSubClient() {
        return this.pubSubClient;
    }

    private final ManagedChannel createManagedChannelFromEnv() {
        String string = System.getenv("PLAYER_DROPLET_HOST");
        if (string == null) {
            string = "127.0.0.1";
        }
        String host = string;
        String string2 = System.getenv("PLAYER_DROPLET_PORT");
        int port = string2 != null ? Integer.parseInt(string2) : 5826;
        ManagedChannel managedChannel = ((ManagedChannelBuilder)ManagedChannelBuilder.forAddress(host, port).usePlaintext()).build();
        Intrinsics.checkNotNullExpressionValue(managedChannel, "build(...)");
        return managedChannel;
    }

    private static final OfflineCloudPlayer getOfflinePlayer$lambda$0(GetOfflineCloudPlayerResponse it) {
        OfflineCloudPlayerConfiguration offlineCloudPlayerConfiguration = it.getOfflineCloudPlayer();
        Intrinsics.checkNotNullExpressionValue(offlineCloudPlayerConfiguration, "getOfflineCloudPlayer(...)");
        return new OfflineCloudPlayerImpl(offlineCloudPlayerConfiguration);
    }

    private static final OfflineCloudPlayer getOfflinePlayer$lambda$1(Function1 $tmp0, Object p0) {
        return (OfflineCloudPlayer)$tmp0.invoke(p0);
    }

    private static final OfflineCloudPlayer getOfflinePlayer$lambda$2(GetOfflineCloudPlayerResponse it) {
        OfflineCloudPlayerConfiguration offlineCloudPlayerConfiguration = it.getOfflineCloudPlayer();
        Intrinsics.checkNotNullExpressionValue(offlineCloudPlayerConfiguration, "getOfflineCloudPlayer(...)");
        return new OfflineCloudPlayerImpl(offlineCloudPlayerConfiguration);
    }

    private static final OfflineCloudPlayer getOfflinePlayer$lambda$3(Function1 $tmp0, Object p0) {
        return (OfflineCloudPlayer)$tmp0.invoke(p0);
    }

    private static final CloudPlayer getOnlinePlayer$lambda$4(PlayerApiFutureImpl this$0, GetCloudPlayerResponse it) {
        PlayerServiceGrpc.PlayerServiceFutureStub playerServiceFutureStub = this$0.playerServiceStub;
        PlayerAdventureServiceGrpc.PlayerAdventureServiceFutureStub playerAdventureServiceFutureStub = this$0.playerServiceAdventureStub;
        CloudPlayerConfiguration cloudPlayerConfiguration = it.getCloudPlayer();
        Intrinsics.checkNotNullExpressionValue(cloudPlayerConfiguration, "getCloudPlayer(...)");
        return new CloudPlayerImpl(playerServiceFutureStub, playerAdventureServiceFutureStub, cloudPlayerConfiguration, null, 8, null);
    }

    private static final CloudPlayer getOnlinePlayer$lambda$5(Function1 $tmp0, Object p0) {
        return (CloudPlayer)$tmp0.invoke(p0);
    }

    private static final CloudPlayer getOnlinePlayer$lambda$6(PlayerApiFutureImpl this$0, GetCloudPlayerResponse it) {
        PlayerServiceGrpc.PlayerServiceFutureStub playerServiceFutureStub = this$0.playerServiceStub;
        PlayerAdventureServiceGrpc.PlayerAdventureServiceFutureStub playerAdventureServiceFutureStub = this$0.playerServiceAdventureStub;
        CloudPlayerConfiguration cloudPlayerConfiguration = it.getCloudPlayer();
        Intrinsics.checkNotNullExpressionValue(cloudPlayerConfiguration, "getCloudPlayer(...)");
        return new CloudPlayerImpl(playerServiceFutureStub, playerAdventureServiceFutureStub, cloudPlayerConfiguration, null, 8, null);
    }

    private static final CloudPlayer getOnlinePlayer$lambda$7(Function1 $tmp0, Object p0) {
        return (CloudPlayer)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final List getOnlinePlayers$lambda$9(PlayerApiFutureImpl this$0, GetOnlineCloudPlayersResponse response2) {
        void $this$mapTo$iv$iv;
        List<CloudPlayerConfiguration> list = response2.getOnlineCloudPlayersList();
        Intrinsics.checkNotNullExpressionValue(list, "getOnlineCloudPlayersList(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void cloudPlayer;
            CloudPlayerConfiguration cloudPlayerConfiguration = (CloudPlayerConfiguration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PlayerServiceGrpc.PlayerServiceFutureStub playerServiceFutureStub = this$0.playerServiceStub;
            PlayerAdventureServiceGrpc.PlayerAdventureServiceFutureStub playerAdventureServiceFutureStub = this$0.playerServiceAdventureStub;
            Intrinsics.checkNotNull(cloudPlayer);
            collection.add(new CloudPlayerImpl(playerServiceFutureStub, playerAdventureServiceFutureStub, (CloudPlayerConfiguration)cloudPlayer, null, 8, null));
        }
        return (List)destination$iv$iv;
    }

    private static final List getOnlinePlayers$lambda$10(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final Integer getOnlinePlayerCount$lambda$11(GetOnlineCloudPlayerCountResponse it) {
        return it.getCount();
    }

    private static final Integer getOnlinePlayerCount$lambda$12(Function1 $tmp0, Object p0) {
        return (Integer)$tmp0.invoke(p0);
    }

    private static final CloudPlayerConnectResult connectPlayer$lambda$13(ConnectCloudPlayerResponse it) {
        return it.getResult();
    }

    private static final CloudPlayerConnectResult connectPlayer$lambda$14(Function1 $tmp0, Object p0) {
        return (CloudPlayerConnectResult)$tmp0.invoke(p0);
    }

    private static final Boolean isOnline$lambda$15(GetOnlineStatusResponse it) {
        return it.getOnline();
    }

    private static final Boolean isOnline$lambda$16(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Boolean updateServer$lambda$17(UpdateCloudPlayerServerResponse it) {
        return it.getSuccess();
    }

    private static final Boolean updateServer$lambda$18(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

