/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx;

import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import app.simplecloud.relocate.io.grpc.netty.shaded.io.netty.util.CharsetUtil;

public class TextWebSocketFrame
extends WebSocketFrame {
    public TextWebSocketFrame() {
        super(Unpooled.buffer(0));
    }

    public TextWebSocketFrame(String text2) {
        super(TextWebSocketFrame.fromText(text2));
    }

    public TextWebSocketFrame(ByteBuf binaryData) {
        super(binaryData);
    }

    public TextWebSocketFrame(boolean finalFragment, int rsv, String text2) {
        super(finalFragment, rsv, TextWebSocketFrame.fromText(text2));
    }

    private static ByteBuf fromText(String text2) {
        if (text2 == null || text2.isEmpty()) {
            return Unpooled.EMPTY_BUFFER;
        }
        return Unpooled.copiedBuffer(text2, CharsetUtil.UTF_8);
    }

    public TextWebSocketFrame(boolean finalFragment, int rsv, ByteBuf binaryData) {
        super(finalFragment, rsv, binaryData);
    }

    public String text() {
        return this.content().toString(CharsetUtil.UTF_8);
    }

    @Override
    public TextWebSocketFrame copy() {
        return (TextWebSocketFrame)super.copy();
    }

    @Override
    public TextWebSocketFrame duplicate() {
        return (TextWebSocketFrame)super.duplicate();
    }

    @Override
    public TextWebSocketFrame retainedDuplicate() {
        return (TextWebSocketFrame)super.retainedDuplicate();
    }

    @Override
    public TextWebSocketFrame replace(ByteBuf content2) {
        return new TextWebSocketFrame(this.isFinalFragment(), this.rsv(), content2);
    }

    @Override
    public TextWebSocketFrame retain() {
        super.retain();
        return this;
    }

    @Override
    public TextWebSocketFrame retain(int increment) {
        super.retain(increment);
        return this;
    }

    @Override
    public TextWebSocketFrame touch() {
        super.touch();
        return this;
    }

    @Override
    public TextWebSocketFrame touch(Object hint) {
        super.touch(hint);
        return this;
    }
}

