/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.auth.jwt;

import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.interfaces.Payload;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\n\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0086\u0002\u00a2\u0006\u0004\b\b\u0010\tJ/\u0010\r\u001a\u0004\u0018\u00018\u0000\"\b\b\u0000\u0010\n*\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ3\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u000f\"\b\b\u0000\u0010\n*\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0017\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0013\u0010 \u001a\u0004\u0018\u00010\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0013\u0010\"\u001a\u0004\u0018\u00010\u001d8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001fR\u0013\u0010$\u001a\u0004\u0018\u00010\u001d8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u001fR\u0013\u0010&\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0016\u00a8\u0006'"}, d2={"Lio/ktor/server/auth/jwt/JWTPayloadHolder;", "", "Lcom/auth0/jwt/interfaces/Payload;", "payload", "<init>", "(Lcom/auth0/jwt/interfaces/Payload;)V", "", "name", "get", "(Ljava/lang/String;)Ljava/lang/String;", "T", "Lkotlin/reflect/KClass;", "clazz", "getClaim", "(Ljava/lang/String;Lkotlin/reflect/KClass;)Ljava/lang/Object;", "", "getListClaim", "(Ljava/lang/String;Lkotlin/reflect/KClass;)Ljava/util/List;", "Lcom/auth0/jwt/interfaces/Payload;", "getPayload", "()Lcom/auth0/jwt/interfaces/Payload;", "getIssuer", "()Ljava/lang/String;", "issuer", "getSubject", "subject", "getAudience", "()Ljava/util/List;", "audience", "Ljava/util/Date;", "getExpiresAt", "()Ljava/util/Date;", "expiresAt", "getNotBefore", "notBefore", "getIssuedAt", "issuedAt", "getJwtId", "jwtId", "ktor-server-auth-jwt"})
public abstract class JWTPayloadHolder {
    @NotNull
    private final Payload payload;

    public JWTPayloadHolder(@NotNull Payload payload) {
        Intrinsics.checkNotNullParameter(payload, "payload");
        this.payload = payload;
    }

    @NotNull
    public final Payload getPayload() {
        return this.payload;
    }

    @Nullable
    public final String getIssuer() {
        return this.payload.getIssuer();
    }

    @Nullable
    public final String getSubject() {
        return this.payload.getSubject();
    }

    @NotNull
    public final List<String> getAudience() {
        List<String> list = this.payload.getAudience();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Nullable
    public final Date getExpiresAt() {
        return this.payload.getExpiresAt();
    }

    @Nullable
    public final Date getNotBefore() {
        return this.payload.getNotBefore();
    }

    @Nullable
    public final Date getIssuedAt() {
        return this.payload.getIssuedAt();
    }

    @Nullable
    public final String getJwtId() {
        return this.payload.getId();
    }

    @Nullable
    public final String get(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return this.payload.getClaim(name).asString();
    }

    @Nullable
    public final <T> T getClaim(@NotNull String name, @NotNull KClass<T> clazz) {
        T t2;
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        try {
            t2 = this.payload.getClaim(name).as(JvmClassMappingKt.getJavaObjectType(clazz));
        }
        catch (JWTDecodeException ex) {
            t2 = null;
        }
        return t2;
    }

    @NotNull
    public final <T> List<T> getListClaim(@NotNull String name, @NotNull KClass<T> clazz) {
        List list;
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        try {
            List<T> list2 = this.payload.getClaim(name).asList(JvmClassMappingKt.getJavaObjectType(clazz));
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            list = list2;
        }
        catch (JWTDecodeException ex) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

