/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.google.protobuf;

import app.simplecloud.relocate.google.protobuf.BooleanArrayList;
import app.simplecloud.relocate.google.protobuf.ByteString;
import app.simplecloud.relocate.google.protobuf.CheckReturnValue;
import app.simplecloud.relocate.google.protobuf.CodedOutputStream;
import app.simplecloud.relocate.google.protobuf.DoubleArrayList;
import app.simplecloud.relocate.google.protobuf.FloatArrayList;
import app.simplecloud.relocate.google.protobuf.IntArrayList;
import app.simplecloud.relocate.google.protobuf.Internal;
import app.simplecloud.relocate.google.protobuf.LazyStringList;
import app.simplecloud.relocate.google.protobuf.LongArrayList;
import app.simplecloud.relocate.google.protobuf.MapEntryLite;
import app.simplecloud.relocate.google.protobuf.MessageLite;
import app.simplecloud.relocate.google.protobuf.Schema;
import app.simplecloud.relocate.google.protobuf.Writer;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@CheckReturnValue
final class CodedOutputStreamWriter
implements Writer {
    private final CodedOutputStream output;

    public static CodedOutputStreamWriter forCodedOutput(CodedOutputStream output2) {
        if (output2.wrapper != null) {
            return output2.wrapper;
        }
        return new CodedOutputStreamWriter(output2);
    }

    private CodedOutputStreamWriter(CodedOutputStream output2) {
        this.output = Internal.checkNotNull(output2, "output");
        this.output.wrapper = this;
    }

    @Override
    public Writer.FieldOrder fieldOrder() {
        return Writer.FieldOrder.ASCENDING;
    }

    public int getTotalBytesWritten() {
        return this.output.getTotalBytesWritten();
    }

    @Override
    public void writeSFixed32(int fieldNumber, int value) throws IOException {
        this.output.writeSFixed32(fieldNumber, value);
    }

    @Override
    public void writeInt64(int fieldNumber, long value) throws IOException {
        this.output.writeInt64(fieldNumber, value);
    }

    @Override
    public void writeSFixed64(int fieldNumber, long value) throws IOException {
        this.output.writeSFixed64(fieldNumber, value);
    }

    @Override
    public void writeFloat(int fieldNumber, float value) throws IOException {
        this.output.writeFloat(fieldNumber, value);
    }

    @Override
    public void writeDouble(int fieldNumber, double value) throws IOException {
        this.output.writeDouble(fieldNumber, value);
    }

    @Override
    public void writeEnum(int fieldNumber, int value) throws IOException {
        this.output.writeEnum(fieldNumber, value);
    }

    @Override
    public void writeUInt64(int fieldNumber, long value) throws IOException {
        this.output.writeUInt64(fieldNumber, value);
    }

    @Override
    public void writeInt32(int fieldNumber, int value) throws IOException {
        this.output.writeInt32(fieldNumber, value);
    }

    @Override
    public void writeFixed64(int fieldNumber, long value) throws IOException {
        this.output.writeFixed64(fieldNumber, value);
    }

    @Override
    public void writeFixed32(int fieldNumber, int value) throws IOException {
        this.output.writeFixed32(fieldNumber, value);
    }

    @Override
    public void writeBool(int fieldNumber, boolean value) throws IOException {
        this.output.writeBool(fieldNumber, value);
    }

    @Override
    public void writeString(int fieldNumber, String value) throws IOException {
        this.output.writeString(fieldNumber, value);
    }

    @Override
    public void writeBytes(int fieldNumber, ByteString value) throws IOException {
        this.output.writeBytes(fieldNumber, value);
    }

    @Override
    public void writeUInt32(int fieldNumber, int value) throws IOException {
        this.output.writeUInt32(fieldNumber, value);
    }

    @Override
    public void writeSInt32(int fieldNumber, int value) throws IOException {
        this.output.writeSInt32(fieldNumber, value);
    }

    @Override
    public void writeSInt64(int fieldNumber, long value) throws IOException {
        this.output.writeSInt64(fieldNumber, value);
    }

    @Override
    public void writeMessage(int fieldNumber, Object value) throws IOException {
        this.output.writeMessage(fieldNumber, (MessageLite)value);
    }

    @Override
    public void writeMessage(int fieldNumber, Object value, Schema schema) throws IOException {
        this.output.writeMessage(fieldNumber, (MessageLite)value, schema);
    }

    @Override
    @Deprecated
    public void writeGroup(int fieldNumber, Object value) throws IOException {
        this.output.writeGroup(fieldNumber, (MessageLite)value);
    }

    @Override
    public void writeGroup(int fieldNumber, Object value, Schema schema) throws IOException {
        this.output.writeGroup(fieldNumber, (MessageLite)value, schema);
    }

    @Override
    @Deprecated
    public void writeStartGroup(int fieldNumber) throws IOException {
        this.output.writeTag(fieldNumber, 3);
    }

    @Override
    @Deprecated
    public void writeEndGroup(int fieldNumber) throws IOException {
        this.output.writeTag(fieldNumber, 4);
    }

    @Override
    public final void writeMessageSetItem(int fieldNumber, Object value) throws IOException {
        if (value instanceof ByteString) {
            this.output.writeRawMessageSetExtension(fieldNumber, (ByteString)value);
        } else {
            this.output.writeMessageSetExtension(fieldNumber, (MessageLite)value);
        }
    }

    @Override
    public void writeInt32List(int fieldNumber, List<Integer> value, boolean packed) throws IOException {
        if (value instanceof IntArrayList) {
            this.writeInt32ListInternal(fieldNumber, (IntArrayList)value, packed);
        } else {
            this.writeInt32ListInternal(fieldNumber, value, packed);
        }
    }

    private void writeInt32ListInternal(int fieldNumber, IntArrayList value, boolean packed) throws IOException {
        if (packed) {
            int i2;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i2 = 0; i2 < value.size(); ++i2) {
                dataSize += CodedOutputStream.computeInt32SizeNoTag(value.getInt(i2));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i2 = 0; i2 < value.size(); ++i2) {
                this.output.writeInt32NoTag(value.getInt(i2));
            }
        } else {
            for (int i3 = 0; i3 < value.size(); ++i3) {
                this.output.writeInt32(fieldNumber, value.getInt(i3));
            }
        }
    }

    private void writeInt32ListInternal(int fieldNumber, List<Integer> value, boolean packed) throws IOException {
        if (packed) {
            int i2;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i2 = 0; i2 < value.size(); ++i2) {
                dataSize += CodedOutputStream.computeInt32SizeNoTag(value.get(i2));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i2 = 0; i2 < value.size(); ++i2) {
                this.output.writeInt32NoTag(value.get(i2));
            }
        } else {
            for (int i3 = 0; i3 < value.size(); ++i3) {
                this.output.writeInt32(fieldNumber, value.get(i3));
            }
        }
    }

    @Override
    public void writeFixed32List(int fieldNumber, List<Integer> value, boolean packed) throws IOException {
        if (value instanceof IntArrayList) {
            this.writeFixed32ListInternal(fieldNumber, (IntArrayList)value, packed);
        } else {
            this.writeFixed32ListInternal(fieldNumber, value, packed);
        }
    }

    private void writeFixed32ListInternal(int fieldNumber, IntArrayList value, boolean packed) throws IOException {
        if (packed) {
            int i2;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i2 = 0; i2 < value.size(); ++i2) {
                dataSize += CodedOutputStream.computeFixed32SizeNoTag(value.getInt(i2));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i2 = 0; i2 < value.size(); ++i2) {
                this.output.writeFixed32NoTag(value.getInt(i2));
            }
        } else {
            for (int i3 = 0; i3 < value.size(); ++i3) {
                this.output.writeFixed32(fieldNumber, value.getInt(i3));
            }
        }
    }

    private void writeFixed32ListInternal(int fieldNumber, List<Integer> value, boolean packed) throws IOException {
        if (packed) {
            int i2;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i2 = 0; i2 < value.size(); ++i2) {
                dataSize += CodedOutputStream.computeFixed32SizeNoTag(value.get(i2));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i2 = 0; i2 < value.size(); ++i2) {
                this.output.writeFixed32NoTag(value.get(i2));
            }
        } else {
            for (int i3 = 0; i3 < value.size(); ++i3) {
                this.output.writeFixed32(fieldNumber, value.get(i3));
            }
        }
    }

    @Override
    public void writeInt64List(int fieldNumber, List<Long> value, boolean packed) throws IOException {
        if (value instanceof LongArrayList) {
            this.writeInt64ListInternal(fieldNumber, (LongArrayList)value, packed);
        } else {
            this.writeInt64ListInternal(fieldNumber, value, packed);
        }
    }

    private void writeInt64ListInternal(int fieldNumber, LongArrayList value, boolean packed) throws IOException {
        if (packed) {
            int i2;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i2 = 0; i2 < value.size(); ++i2) {
                dataSize += CodedOutputStream.computeInt64SizeNoTag(value.getLong(i2));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i2 = 0; i2 < value.size(); ++i2) {
                this.output.writeInt64NoTag(value.getLong(i2));
            }
        } else {
            for (int i3 = 0; i3 < value.size(); ++i3) {
                this.output.writeInt64(fieldNumber, value.getLong(i3));
            }
        }
    }

    private void writeInt64ListInternal(int fieldNumber, List<Long> value, boolean packed) throws IOException {
        if (packed) {
            int i2;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i2 = 0; i2 < value.size(); ++i2) {
                dataSize += CodedOutputStream.computeInt64SizeNoTag(value.get(i2));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i2 = 0; i2 < value.size(); ++i2) {
                this.output.writeInt64NoTag(value.get(i2));
            }
        } else {
            for (int i3 = 0; i3 < value.size(); ++i3) {
                this.output.writeInt64(fieldNumber, value.get(i3));
            }
        }
    }

    @Override
    public void writeUInt64List(int fieldNumber, List<Long> value, boolean packed) throws IOException {
        if (value instanceof LongArrayList) {
            this.writeUInt64ListInternal(fieldNumber, (LongArrayList)value, packed);
        } else {
            this.writeUInt64ListInternal(fieldNumber, value, packed);
        }
    }

    private void writeUInt64ListInternal(int fieldNumber, LongArrayList value, boolean packed) throws IOException {
        if (packed) {
            int i2;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i2 = 0; i2 < value.size(); ++i2) {
                dataSize += CodedOutputStream.computeUInt64SizeNoTag(value.getLong(i2));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i2 = 0; i2 < value.size(); ++i2) {
                this.output.writeUInt64NoTag(value.getLong(i2));
            }
        } else {
            for (int i3 = 0; i3 < value.size(); ++i3) {
                this.output.writeUInt64(fieldNumber, value.getLong(i3));
            }
        }
    }

    private void writeUInt64ListInternal(int fieldNumber, List<Long> value, boolean packed) throws IOException {
        if (packed) {
            int i2;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i2 = 0; i2 < value.size(); ++i2) {
                dataSize += CodedOutputStream.computeUInt64SizeNoTag(value.get(i2));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i2 = 0; i2 < value.size(); ++i2) {
                this.output.writeUInt64NoTag(value.get(i2));
            }
        } else {
            for (int i3 = 0; i3 < value.size(); ++i3) {
                this.output.writeUInt64(fieldNumber, value.get(i3));
            }
        }
    }

    @Override
    public void writeFixed64List(int fieldNumber, List<Long> value, boolean packed) throws IOException {
        if (value instanceof LongArrayList) {
            this.writeFixed64ListInternal(fieldNumber, (LongArrayList)value, packed);
        } else {
            this.writeFixed64ListInternal(fieldNumber, value, packed);
        }
    }

    private void writeFixed64ListInternal(int fieldNumber, LongArrayList value, boolean packed) throws IOException {
        if (packed) {
            int i2;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i2 = 0; i2 < value.size(); ++i2) {
                dataSize += CodedOutputStream.computeFixed64SizeNoTag(value.getLong(i2));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i2 = 0; i2 < value.size(); ++i2) {
                this.output.writeFixed64NoTag(value.getLong(i2));
            }
        } else {
            for (int i3 = 0; i3 < value.size(); ++i3) {
                this.output.writeFixed64(fieldNumber, value.getLong(i3));
            }
        }
    }

    private void writeFixed64ListInternal(int fieldNumber, List<Long> value, boolean packed) throws IOException {
        if (packed) {
            int i2;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i2 = 0; i2 < value.size(); ++i2) {
                dataSize += CodedOutputStream.computeFixed64SizeNoTag(value.get(i2));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i2 = 0; i2 < value.size(); ++i2) {
                this.output.writeFixed64NoTag(value.get(i2));
            }
        } else {
            for (int i3 = 0; i3 < value.size(); ++i3) {
                this.output.writeFixed64(fieldNumber, value.get(i3));
            }
        }
    }

    @Override
    public void writeFloatList(int fieldNumber, List<Float> value, boolean packed) throws IOException {
        if (value instanceof FloatArrayList) {
            this.writeFloatListInternal(fieldNumber, (FloatArrayList)value, packed);
        } else {
            this.writeFloatListInternal(fieldNumber, value, packed);
        }
    }

    private void writeFloatListInternal(int fieldNumber, FloatArrayList value, boolean packed) throws IOException {
        if (packed) {
            int i2;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i2 = 0; i2 < value.size(); ++i2) {
                dataSize += CodedOutputStream.computeFloatSizeNoTag(value.getFloat(i2));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i2 = 0; i2 < value.size(); ++i2) {
                this.output.writeFloatNoTag(value.getFloat(i2));
            }
        } else {
            for (int i3 = 0; i3 < value.size(); ++i3) {
                this.output.writeFloat(fieldNumber, value.getFloat(i3));
            }
        }
    }

    private void writeFloatListInternal(int fieldNumber, List<Float> value, boolean packed) throws IOException {
        if (packed) {
            int i2;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i2 = 0; i2 < value.size(); ++i2) {
                dataSize += CodedOutputStream.computeFloatSizeNoTag(value.get(i2).floatValue());
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i2 = 0; i2 < value.size(); ++i2) {
                this.output.writeFloatNoTag(value.get(i2).floatValue());
            }
        } else {
            for (int i3 = 0; i3 < value.size(); ++i3) {
                this.output.writeFloat(fieldNumber, value.get(i3).floatValue());
            }
        }
    }

    @Override
    public void writeDoubleList(int fieldNumber, List<Double> value, boolean packed) throws IOException {
        if (value instanceof DoubleArrayList) {
            this.writeDoubleListInternal(fieldNumber, (DoubleArrayList)value, packed);
        } else {
            this.writeDoubleListInternal(fieldNumber, value, packed);
        }
    }

    private void writeDoubleListInternal(int fieldNumber, DoubleArrayList value, boolean packed) throws IOException {
        if (packed) {
            int i2;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i2 = 0; i2 < value.size(); ++i2) {
                dataSize += CodedOutputStream.computeDoubleSizeNoTag(value.getDouble(i2));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i2 = 0; i2 < value.size(); ++i2) {
                this.output.writeDoubleNoTag(value.getDouble(i2));
            }
        } else {
            for (int i3 = 0; i3 < value.size(); ++i3) {
                this.output.writeDouble(fieldNumber, value.getDouble(i3));
            }
        }
    }

    private void writeDoubleListInternal(int fieldNumber, List<Double> value, boolean packed) throws IOException {
        if (packed) {
            int i2;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i2 = 0; i2 < value.size(); ++i2) {
                dataSize += CodedOutputStream.computeDoubleSizeNoTag(value.get(i2));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i2 = 0; i2 < value.size(); ++i2) {
                this.output.writeDoubleNoTag(value.get(i2));
            }
        } else {
            for (int i3 = 0; i3 < value.size(); ++i3) {
                this.output.writeDouble(fieldNumber, value.get(i3));
            }
        }
    }

    @Override
    public void writeEnumList(int fieldNumber, List<Integer> value, boolean packed) throws IOException {
        if (value instanceof IntArrayList) {
            this.writeEnumListInternal(fieldNumber, (IntArrayList)value, packed);
        } else {
            this.writeEnumListInternal(fieldNumber, value, packed);
        }
    }

    private void writeEnumListInternal(int fieldNumber, IntArrayList value, boolean packed) throws IOException {
        if (packed) {
            int i2;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i2 = 0; i2 < value.size(); ++i2) {
                dataSize += CodedOutputStream.computeEnumSizeNoTag(value.getInt(i2));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i2 = 0; i2 < value.size(); ++i2) {
                this.output.writeEnumNoTag(value.getInt(i2));
            }
        } else {
            for (int i3 = 0; i3 < value.size(); ++i3) {
                this.output.writeEnum(fieldNumber, value.getInt(i3));
            }
        }
    }

    private void writeEnumListInternal(int fieldNumber, List<Integer> value, boolean packed) throws IOException {
        if (packed) {
            int i2;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i2 = 0; i2 < value.size(); ++i2) {
                dataSize += CodedOutputStream.computeEnumSizeNoTag(value.get(i2));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i2 = 0; i2 < value.size(); ++i2) {
                this.output.writeEnumNoTag(value.get(i2));
            }
        } else {
            for (int i3 = 0; i3 < value.size(); ++i3) {
                this.output.writeEnum(fieldNumber, value.get(i3));
            }
        }
    }

    @Override
    public void writeBoolList(int fieldNumber, List<Boolean> value, boolean packed) throws IOException {
        if (value instanceof BooleanArrayList) {
            this.writeBoolListInternal(fieldNumber, (BooleanArrayList)value, packed);
        } else {
            this.writeBoolListInternal(fieldNumber, value, packed);
        }
    }

    private void writeBoolListInternal(int fieldNumber, BooleanArrayList value, boolean packed) throws IOException {
        if (packed) {
            int i2;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i2 = 0; i2 < value.size(); ++i2) {
                dataSize += CodedOutputStream.computeBoolSizeNoTag(value.getBoolean(i2));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i2 = 0; i2 < value.size(); ++i2) {
                this.output.writeBoolNoTag(value.getBoolean(i2));
            }
        } else {
            for (int i3 = 0; i3 < value.size(); ++i3) {
                this.output.writeBool(fieldNumber, value.getBoolean(i3));
            }
        }
    }

    private void writeBoolListInternal(int fieldNumber, List<Boolean> value, boolean packed) throws IOException {
        if (packed) {
            int i2;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i2 = 0; i2 < value.size(); ++i2) {
                dataSize += CodedOutputStream.computeBoolSizeNoTag(value.get(i2));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i2 = 0; i2 < value.size(); ++i2) {
                this.output.writeBoolNoTag(value.get(i2));
            }
        } else {
            for (int i3 = 0; i3 < value.size(); ++i3) {
                this.output.writeBool(fieldNumber, value.get(i3));
            }
        }
    }

    @Override
    public void writeStringList(int fieldNumber, List<String> value) throws IOException {
        if (value instanceof LazyStringList) {
            LazyStringList lazyList = (LazyStringList)value;
            for (int i2 = 0; i2 < value.size(); ++i2) {
                this.writeLazyString(fieldNumber, lazyList.getRaw(i2));
            }
        } else {
            for (int i3 = 0; i3 < value.size(); ++i3) {
                this.output.writeString(fieldNumber, value.get(i3));
            }
        }
    }

    private void writeLazyString(int fieldNumber, Object value) throws IOException {
        if (value instanceof String) {
            this.output.writeString(fieldNumber, (String)value);
        } else {
            this.output.writeBytes(fieldNumber, (ByteString)value);
        }
    }

    @Override
    public void writeBytesList(int fieldNumber, List<ByteString> value) throws IOException {
        for (int i2 = 0; i2 < value.size(); ++i2) {
            this.output.writeBytes(fieldNumber, value.get(i2));
        }
    }

    @Override
    public void writeUInt32List(int fieldNumber, List<Integer> value, boolean packed) throws IOException {
        if (value instanceof IntArrayList) {
            this.writeUInt32ListInternal(fieldNumber, (IntArrayList)value, packed);
        } else {
            this.writeUInt32ListInternal(fieldNumber, value, packed);
        }
    }

    private void writeUInt32ListInternal(int fieldNumber, IntArrayList value, boolean packed) throws IOException {
        if (packed) {
            int i2;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i2 = 0; i2 < value.size(); ++i2) {
                dataSize += CodedOutputStream.computeUInt32SizeNoTag(value.getInt(i2));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i2 = 0; i2 < value.size(); ++i2) {
                this.output.writeUInt32NoTag(value.getInt(i2));
            }
        } else {
            for (int i3 = 0; i3 < value.size(); ++i3) {
                this.output.writeUInt32(fieldNumber, value.getInt(i3));
            }
        }
    }

    public void writeUInt32ListInternal(int fieldNumber, List<Integer> value, boolean packed) throws IOException {
        if (packed) {
            int i2;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i2 = 0; i2 < value.size(); ++i2) {
                dataSize += CodedOutputStream.computeUInt32SizeNoTag(value.get(i2));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i2 = 0; i2 < value.size(); ++i2) {
                this.output.writeUInt32NoTag(value.get(i2));
            }
        } else {
            for (int i3 = 0; i3 < value.size(); ++i3) {
                this.output.writeUInt32(fieldNumber, value.get(i3));
            }
        }
    }

    @Override
    public void writeSFixed32List(int fieldNumber, List<Integer> value, boolean packed) throws IOException {
        if (value instanceof IntArrayList) {
            this.writeSFixed32ListInternal(fieldNumber, (IntArrayList)value, packed);
        } else {
            this.writeSFixed32ListInternal(fieldNumber, value, packed);
        }
    }

    private void writeSFixed32ListInternal(int fieldNumber, IntArrayList value, boolean packed) throws IOException {
        if (packed) {
            int i2;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i2 = 0; i2 < value.size(); ++i2) {
                dataSize += CodedOutputStream.computeSFixed32SizeNoTag(value.getInt(i2));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i2 = 0; i2 < value.size(); ++i2) {
                this.output.writeSFixed32NoTag(value.getInt(i2));
            }
        } else {
            for (int i3 = 0; i3 < value.size(); ++i3) {
                this.output.writeSFixed32(fieldNumber, value.getInt(i3));
            }
        }
    }

    private void writeSFixed32ListInternal(int fieldNumber, List<Integer> value, boolean packed) throws IOException {
        if (packed) {
            int i2;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i2 = 0; i2 < value.size(); ++i2) {
                dataSize += CodedOutputStream.computeSFixed32SizeNoTag(value.get(i2));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i2 = 0; i2 < value.size(); ++i2) {
                this.output.writeSFixed32NoTag(value.get(i2));
            }
        } else {
            for (int i3 = 0; i3 < value.size(); ++i3) {
                this.output.writeSFixed32(fieldNumber, value.get(i3));
            }
        }
    }

    @Override
    public void writeSFixed64List(int fieldNumber, List<Long> value, boolean packed) throws IOException {
        if (value instanceof LongArrayList) {
            this.writeSFixed64ListInternal(fieldNumber, (LongArrayList)value, packed);
        } else {
            this.writeSFixed64ListInternal(fieldNumber, value, packed);
        }
    }

    private void writeSFixed64ListInternal(int fieldNumber, LongArrayList value, boolean packed) throws IOException {
        if (packed) {
            int i2;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i2 = 0; i2 < value.size(); ++i2) {
                dataSize += CodedOutputStream.computeSFixed64SizeNoTag(value.getLong(i2));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i2 = 0; i2 < value.size(); ++i2) {
                this.output.writeSFixed64NoTag(value.getLong(i2));
            }
        } else {
            for (int i3 = 0; i3 < value.size(); ++i3) {
                this.output.writeSFixed64(fieldNumber, value.getLong(i3));
            }
        }
    }

    private void writeSFixed64ListInternal(int fieldNumber, List<Long> value, boolean packed) throws IOException {
        if (packed) {
            int i2;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i2 = 0; i2 < value.size(); ++i2) {
                dataSize += CodedOutputStream.computeSFixed64SizeNoTag(value.get(i2));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i2 = 0; i2 < value.size(); ++i2) {
                this.output.writeSFixed64NoTag(value.get(i2));
            }
        } else {
            for (int i3 = 0; i3 < value.size(); ++i3) {
                this.output.writeSFixed64(fieldNumber, value.get(i3));
            }
        }
    }

    @Override
    public void writeSInt32List(int fieldNumber, List<Integer> value, boolean packed) throws IOException {
        if (value instanceof IntArrayList) {
            this.writeSInt32ListInternal(fieldNumber, (IntArrayList)value, packed);
        } else {
            this.writeSInt32ListInternal(fieldNumber, value, packed);
        }
    }

    private void writeSInt32ListInternal(int fieldNumber, IntArrayList value, boolean packed) throws IOException {
        if (packed) {
            int i2;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i2 = 0; i2 < value.size(); ++i2) {
                dataSize += CodedOutputStream.computeSInt32SizeNoTag(value.getInt(i2));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i2 = 0; i2 < value.size(); ++i2) {
                this.output.writeSInt32NoTag(value.getInt(i2));
            }
        } else {
            for (int i3 = 0; i3 < value.size(); ++i3) {
                this.output.writeSInt32(fieldNumber, value.getInt(i3));
            }
        }
    }

    public void writeSInt32ListInternal(int fieldNumber, List<Integer> value, boolean packed) throws IOException {
        if (packed) {
            int i2;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i2 = 0; i2 < value.size(); ++i2) {
                dataSize += CodedOutputStream.computeSInt32SizeNoTag(value.get(i2));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i2 = 0; i2 < value.size(); ++i2) {
                this.output.writeSInt32NoTag(value.get(i2));
            }
        } else {
            for (int i3 = 0; i3 < value.size(); ++i3) {
                this.output.writeSInt32(fieldNumber, value.get(i3));
            }
        }
    }

    @Override
    public void writeSInt64List(int fieldNumber, List<Long> value, boolean packed) throws IOException {
        if (value instanceof LongArrayList) {
            this.writeSInt64ListInternal(fieldNumber, (LongArrayList)value, packed);
        } else {
            this.writeSInt64ListInternal(fieldNumber, value, packed);
        }
    }

    private void writeSInt64ListInternal(int fieldNumber, LongArrayList value, boolean packed) throws IOException {
        if (packed) {
            int i2;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i2 = 0; i2 < value.size(); ++i2) {
                dataSize += CodedOutputStream.computeSInt64SizeNoTag(value.getLong(i2));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i2 = 0; i2 < value.size(); ++i2) {
                this.output.writeSInt64NoTag(value.getLong(i2));
            }
        } else {
            for (int i3 = 0; i3 < value.size(); ++i3) {
                this.output.writeSInt64(fieldNumber, value.getLong(i3));
            }
        }
    }

    private void writeSInt64ListInternal(int fieldNumber, List<Long> value, boolean packed) throws IOException {
        if (packed) {
            int i2;
            this.output.writeTag(fieldNumber, 2);
            int dataSize = 0;
            for (i2 = 0; i2 < value.size(); ++i2) {
                dataSize += CodedOutputStream.computeSInt64SizeNoTag(value.get(i2));
            }
            this.output.writeUInt32NoTag(dataSize);
            for (i2 = 0; i2 < value.size(); ++i2) {
                this.output.writeSInt64NoTag(value.get(i2));
            }
        } else {
            for (int i3 = 0; i3 < value.size(); ++i3) {
                this.output.writeSInt64(fieldNumber, value.get(i3));
            }
        }
    }

    @Override
    public void writeMessageList(int fieldNumber, List<?> value) throws IOException {
        for (int i2 = 0; i2 < value.size(); ++i2) {
            this.writeMessage(fieldNumber, value.get(i2));
        }
    }

    @Override
    public void writeMessageList(int fieldNumber, List<?> value, Schema schema) throws IOException {
        for (int i2 = 0; i2 < value.size(); ++i2) {
            this.writeMessage(fieldNumber, value.get(i2), schema);
        }
    }

    @Override
    @Deprecated
    public void writeGroupList(int fieldNumber, List<?> value) throws IOException {
        for (int i2 = 0; i2 < value.size(); ++i2) {
            this.writeGroup(fieldNumber, value.get(i2));
        }
    }

    @Override
    public void writeGroupList(int fieldNumber, List<?> value, Schema schema) throws IOException {
        for (int i2 = 0; i2 < value.size(); ++i2) {
            this.writeGroup(fieldNumber, value.get(i2), schema);
        }
    }

    @Override
    public <K, V> void writeMap(int fieldNumber, MapEntryLite.Metadata<K, V> metadata, Map<K, V> map2) throws IOException {
        if (this.output.isSerializationDeterministic()) {
            this.writeDeterministicMap(fieldNumber, metadata, map2);
            return;
        }
        for (Map.Entry<K, V> entry : map2.entrySet()) {
            this.output.writeTag(fieldNumber, 2);
            this.output.writeUInt32NoTag(MapEntryLite.computeSerializedSize(metadata, entry.getKey(), entry.getValue()));
            MapEntryLite.writeTo(this.output, metadata, entry.getKey(), entry.getValue());
        }
    }

    private <K, V> void writeDeterministicMap(int fieldNumber, MapEntryLite.Metadata<K, V> metadata, Map<K, V> map2) throws IOException {
        switch (metadata.keyType) {
            case BOOL: {
                V value = map2.get(Boolean.FALSE);
                if (value != null) {
                    this.writeDeterministicBooleanMapEntry(fieldNumber, false, value, metadata);
                }
                if ((value = map2.get(Boolean.TRUE)) == null) break;
                this.writeDeterministicBooleanMapEntry(fieldNumber, true, value, metadata);
                break;
            }
            case FIXED32: 
            case INT32: 
            case SFIXED32: 
            case SINT32: 
            case UINT32: {
                this.writeDeterministicIntegerMap(fieldNumber, metadata, map2);
                break;
            }
            case FIXED64: 
            case INT64: 
            case SFIXED64: 
            case SINT64: 
            case UINT64: {
                this.writeDeterministicLongMap(fieldNumber, metadata, map2);
                break;
            }
            case STRING: {
                this.writeDeterministicStringMap(fieldNumber, metadata, map2);
                break;
            }
            default: {
                throw new IllegalArgumentException("does not support key type: " + (Object)((Object)metadata.keyType));
            }
        }
    }

    private <V> void writeDeterministicBooleanMapEntry(int fieldNumber, boolean key2, V value, MapEntryLite.Metadata<Boolean, V> metadata) throws IOException {
        this.output.writeTag(fieldNumber, 2);
        this.output.writeUInt32NoTag(MapEntryLite.computeSerializedSize(metadata, key2, value));
        MapEntryLite.writeTo(this.output, metadata, key2, value);
    }

    private <V> void writeDeterministicIntegerMap(int fieldNumber, MapEntryLite.Metadata<Integer, V> metadata, Map<Integer, V> map2) throws IOException {
        int[] keys2 = new int[map2.size()];
        int index = 0;
        Iterator<Integer> iterator2 = map2.keySet().iterator();
        while (iterator2.hasNext()) {
            int k = iterator2.next();
            keys2[index++] = k;
        }
        Arrays.sort(keys2);
        for (Object key2 : (Iterator<Integer>)keys2) {
            V value = map2.get((int)key2);
            this.output.writeTag(fieldNumber, 2);
            this.output.writeUInt32NoTag(MapEntryLite.computeSerializedSize(metadata, (int)key2, value));
            MapEntryLite.writeTo(this.output, metadata, (int)key2, value);
        }
    }

    private <V> void writeDeterministicLongMap(int fieldNumber, MapEntryLite.Metadata<Long, V> metadata, Map<Long, V> map2) throws IOException {
        long[] keys2 = new long[map2.size()];
        int index = 0;
        Iterator<Long> iterator2 = map2.keySet().iterator();
        while (iterator2.hasNext()) {
            long k = iterator2.next();
            keys2[index++] = k;
        }
        Arrays.sort(keys2);
        for (Object key2 : (Iterator<Long>)keys2) {
            V value = map2.get((long)key2);
            this.output.writeTag(fieldNumber, 2);
            this.output.writeUInt32NoTag(MapEntryLite.computeSerializedSize(metadata, (long)key2, value));
            MapEntryLite.writeTo(this.output, metadata, (long)key2, value);
        }
    }

    private <V> void writeDeterministicStringMap(int fieldNumber, MapEntryLite.Metadata<String, V> metadata, Map<String, V> map2) throws IOException {
        Object[] keys2 = new String[map2.size()];
        int index = 0;
        for (String k : map2.keySet()) {
            keys2[index++] = k;
        }
        Arrays.sort(keys2);
        for (Object key2 : keys2) {
            V value = map2.get(key2);
            this.output.writeTag(fieldNumber, 2);
            this.output.writeUInt32NoTag(MapEntryLite.computeSerializedSize(metadata, key2, value));
            MapEntryLite.writeTo(this.output, metadata, key2, value);
        }
    }
}

