/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.configurate.loader;

import com.google.errorprone.annotations.ForOverride;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.spongepowered.configurate.ConfigurateException;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.ConfigurationOptions;
import org.spongepowered.configurate.ScopedConfigurationNode;
import org.spongepowered.configurate.loader.AtomicFiles;
import org.spongepowered.configurate.loader.CommentHandler;
import org.spongepowered.configurate.loader.CommentHandlers;
import org.spongepowered.configurate.loader.ConfigurationLoader;
import org.spongepowered.configurate.loader.HeaderMode;
import org.spongepowered.configurate.loader.ParsingException;
import org.spongepowered.configurate.reference.ConfigurationReference;
import org.spongepowered.configurate.util.UnmodifiableCollections;

public abstract class AbstractConfigurationLoader<N extends ScopedConfigurationNode<N>>
implements ConfigurationLoader<N> {
    public static final String CONFIGURATE_LINE_SEPARATOR = "\n";
    public static final Pattern CONFIGURATE_LINE_PATTERN = Pattern.compile("\n");
    protected static final String SYSTEM_LINE_SEPARATOR = System.lineSeparator();
    protected final @Nullable Callable<BufferedReader> source;
    protected final @Nullable Callable<BufferedWriter> sink;
    private final List<CommentHandler> commentHandlers;
    private final HeaderMode headerMode;
    private final ConfigurationOptions defaultOptions;

    protected AbstractConfigurationLoader(Builder<?, ?> builder2, CommentHandler[] commentHandlers) {
        this.source = builder2.source();
        this.sink = builder2.sink();
        this.headerMode = builder2.headerMode();
        this.commentHandlers = UnmodifiableCollections.toList(commentHandlers);
        this.defaultOptions = builder2.defaultOptions();
    }

    public CommentHandler defaultCommentHandler() {
        return this.commentHandlers.get(0);
    }

    @Override
    public ConfigurationReference<N> loadToReference() throws ConfigurateException {
        return ConfigurationReference.fixed(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public N load(ConfigurationOptions options2) throws ParsingException {
        if (this.source == null) {
            throw new ParsingException(-1, -1, "", "No source present to read from!", null);
        }
        try (BufferedReader reader2 = this.source.call();){
            String comment;
            if ((this.headerMode == HeaderMode.PRESERVE || this.headerMode == HeaderMode.NONE) && (comment = CommentHandlers.extractComment(reader2, this.commentHandlers)) != null && comment.length() > 0) {
                options2 = options2.header(comment);
            }
            ScopedConfigurationNode node = (ScopedConfigurationNode)this.createNode(options2);
            this.loadInternal(node, reader2);
            ScopedConfigurationNode scopedConfigurationNode = node;
            return (N)scopedConfigurationNode;
        }
        catch (ParsingException ex) {
            throw ex;
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            return (N)((ScopedConfigurationNode)this.createNode(options2));
        }
        catch (IOException e) {
            throw new ParsingException(-1, -1, options2.header(), null, e);
        }
        catch (Exception e) {
            throw new ParsingException(-1, -1, options2.header(), "Unknown error occurred while loading", e);
        }
    }

    @ForOverride
    protected abstract void loadInternal(N var1, BufferedReader var2) throws ParsingException;

    @Override
    public void save(ConfigurationNode node) throws ConfigurateException {
        if (this.sink == null) {
            throw new ConfigurateException(node, "No sink present to write to!");
        }
        this.checkCanWrite(node);
        try (Writer writer2 = this.sink.call();){
            String header;
            this.writeHeaderInternal(writer2);
            if (this.headerMode != HeaderMode.NONE && (header = node.options().header()) != null && !header.isEmpty()) {
                Iterator lines = this.defaultCommentHandler().toComment(CONFIGURATE_LINE_PATTERN.splitAsStream(header)).iterator();
                while (lines.hasNext()) {
                    writer2.write((String)lines.next());
                    writer2.write(SYSTEM_LINE_SEPARATOR);
                }
                writer2.write(SYSTEM_LINE_SEPARATOR);
            }
            this.saveInternal(node, writer2);
        }
        catch (ConfigurateException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ConfigurateException(node, (Throwable)ex);
        }
    }

    @ForOverride
    protected void checkCanWrite(ConfigurationNode node) throws ConfigurateException {
    }

    @ForOverride
    protected void writeHeaderInternal(Writer writer2) throws IOException {
    }

    @ForOverride
    protected abstract void saveInternal(ConfigurationNode var1, Writer var2) throws ConfigurateException;

    @Override
    public ConfigurationOptions defaultOptions() {
        return this.defaultOptions;
    }

    @Override
    public final boolean canLoad() {
        return this.source != null;
    }

    @Override
    public final boolean canSave() {
        return this.sink != null;
    }

    public static abstract class Builder<T extends Builder<T, L>, L extends AbstractConfigurationLoader<?>> {
        protected HeaderMode headerMode = HeaderMode.PRESERVE;
        protected @Nullable Callable<BufferedReader> source;
        protected @Nullable Callable<BufferedWriter> sink;
        protected ConfigurationOptions defaultOptions = ConfigurationOptions.defaults();

        protected Builder() {
        }

        private T self() {
            return (T)this;
        }

        public T file(File file2) {
            return this.path(Objects.requireNonNull(file2, "file").toPath());
        }

        public T path(Path path2) {
            Path absPath = Objects.requireNonNull(path2, "path").toAbsolutePath();
            this.source = () -> Files.newBufferedReader(absPath, StandardCharsets.UTF_8);
            this.sink = AtomicFiles.atomicWriterFactory(absPath, StandardCharsets.UTF_8);
            return this.self();
        }

        public T url(URL url2) {
            Objects.requireNonNull(url2, "url");
            this.source = () -> new BufferedReader(new InputStreamReader(url2.openConnection().getInputStream(), StandardCharsets.UTF_8));
            return this.self();
        }

        public T source(@Nullable Callable<BufferedReader> source) {
            this.source = source;
            return this.self();
        }

        public @Nullable Callable<BufferedReader> source() {
            return this.source;
        }

        public T sink(@Nullable Callable<BufferedWriter> sink) {
            this.sink = sink;
            return this.self();
        }

        public @Nullable Callable<BufferedWriter> sink() {
            return this.sink;
        }

        public T headerMode(HeaderMode mode) {
            this.headerMode = Objects.requireNonNull(mode, "mode");
            return this.self();
        }

        public HeaderMode headerMode() {
            return this.headerMode;
        }

        public T defaultOptions(ConfigurationOptions defaultOptions) {
            this.defaultOptions = Objects.requireNonNull(defaultOptions, "defaultOptions");
            return this.self();
        }

        public T defaultOptions(UnaryOperator<ConfigurationOptions> defaultOptions) {
            this.defaultOptions = Objects.requireNonNull((ConfigurationOptions)defaultOptions.apply(this.defaultOptions), "defaultOptions (updated)");
            return this.self();
        }

        public ConfigurationOptions defaultOptions() {
            return this.defaultOptions;
        }

        public abstract L build();

        public ConfigurationNode buildAndLoadString(String input2) throws ConfigurateException {
            return ((Builder)this.source(() -> new BufferedReader(new StringReader(input2)))).build().load();
        }

        public String buildAndSaveString(ConfigurationNode output2) throws ConfigurateException {
            Objects.requireNonNull(output2, "output");
            StringWriter writer2 = new StringWriter();
            ((AbstractConfigurationLoader)((Builder)this.sink(() -> new BufferedWriter(writer2))).build()).save(output2);
            return writer2.toString();
        }
    }
}

