/*
 * Decompiled with CFR 0.152.
 */
package app.simplecloud.relocate.google.common.collect;

import app.simplecloud.relocate.google.common.annotations.GwtCompatible;
import app.simplecloud.relocate.google.common.base.Function;
import app.simplecloud.relocate.google.common.base.Preconditions;
import app.simplecloud.relocate.google.common.base.Predicate;
import app.simplecloud.relocate.google.common.base.Predicates;
import app.simplecloud.relocate.google.common.base.Supplier;
import app.simplecloud.relocate.google.common.collect.AbstractIterator;
import app.simplecloud.relocate.google.common.collect.AbstractMapEntry;
import app.simplecloud.relocate.google.common.collect.AbstractTable;
import app.simplecloud.relocate.google.common.collect.CollectSpliterators;
import app.simplecloud.relocate.google.common.collect.Collections2;
import app.simplecloud.relocate.google.common.collect.ElementTypesAreNonnullByDefault;
import app.simplecloud.relocate.google.common.collect.ForwardingMapEntry;
import app.simplecloud.relocate.google.common.collect.GwtTransient;
import app.simplecloud.relocate.google.common.collect.Iterators;
import app.simplecloud.relocate.google.common.collect.Lists;
import app.simplecloud.relocate.google.common.collect.Maps;
import app.simplecloud.relocate.google.common.collect.NullnessCasts;
import app.simplecloud.relocate.google.common.collect.Sets;
import app.simplecloud.relocate.google.common.collect.Table;
import app.simplecloud.relocate.google.common.collect.Tables;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible
class StandardTable<R, C, V>
extends AbstractTable<R, C, V>
implements Serializable {
    @GwtTransient
    final Map<R, Map<C, V>> backingMap;
    @GwtTransient
    final Supplier<? extends Map<C, V>> factory;
    @LazyInit
    @CheckForNull
    private transient Set<C> columnKeySet;
    @LazyInit
    @CheckForNull
    private transient Map<R, Map<C, V>> rowMap;
    @LazyInit
    @CheckForNull
    private transient ColumnMap columnMap;
    private static final long serialVersionUID = 0L;

    StandardTable(Map<R, Map<C, V>> backingMap, Supplier<? extends Map<C, V>> factory) {
        this.backingMap = backingMap;
        this.factory = factory;
    }

    @Override
    public boolean contains(@CheckForNull Object rowKey, @CheckForNull Object columnKey) {
        return rowKey != null && columnKey != null && super.contains(rowKey, columnKey);
    }

    @Override
    public boolean containsColumn(@CheckForNull Object columnKey) {
        if (columnKey == null) {
            return false;
        }
        for (Map<C, V> map2 : this.backingMap.values()) {
            if (!Maps.safeContainsKey(map2, columnKey)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsRow(@CheckForNull Object rowKey) {
        return rowKey != null && Maps.safeContainsKey(this.backingMap, rowKey);
    }

    @Override
    public boolean containsValue(@CheckForNull Object value) {
        return value != null && super.containsValue(value);
    }

    @Override
    @CheckForNull
    public V get(@CheckForNull Object rowKey, @CheckForNull Object columnKey) {
        return rowKey == null || columnKey == null ? null : (V)super.get(rowKey, columnKey);
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public int size() {
        int size = 0;
        for (Map<C, V> map2 : this.backingMap.values()) {
            size += map2.size();
        }
        return size;
    }

    @Override
    public void clear() {
        this.backingMap.clear();
    }

    private Map<C, V> getOrCreate(R rowKey) {
        Map<C, V> map2 = this.backingMap.get(rowKey);
        if (map2 == null) {
            map2 = this.factory.get();
            this.backingMap.put(rowKey, map2);
        }
        return map2;
    }

    @Override
    @CheckForNull
    @CanIgnoreReturnValue
    public V put(R rowKey, C columnKey, V value) {
        Preconditions.checkNotNull(rowKey);
        Preconditions.checkNotNull(columnKey);
        Preconditions.checkNotNull(value);
        return this.getOrCreate(rowKey).put(columnKey, value);
    }

    @Override
    @CheckForNull
    @CanIgnoreReturnValue
    public V remove(@CheckForNull Object rowKey, @CheckForNull Object columnKey) {
        if (rowKey == null || columnKey == null) {
            return null;
        }
        Map<C, V> map2 = Maps.safeGet(this.backingMap, rowKey);
        if (map2 == null) {
            return null;
        }
        V value = map2.remove(columnKey);
        if (map2.isEmpty()) {
            this.backingMap.remove(rowKey);
        }
        return value;
    }

    @CanIgnoreReturnValue
    private Map<R, V> removeColumn(@CheckForNull Object column) {
        LinkedHashMap<R, V> output2 = new LinkedHashMap<R, V>();
        Iterator<Map.Entry<R, Map<C, V>>> iterator2 = this.backingMap.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<R, Map<C, V>> entry = iterator2.next();
            V value = entry.getValue().remove(column);
            if (value == null) continue;
            output2.put(entry.getKey(), value);
            if (!entry.getValue().isEmpty()) continue;
            iterator2.remove();
        }
        return output2;
    }

    private boolean containsMapping(@CheckForNull Object rowKey, @CheckForNull Object columnKey, @CheckForNull Object value) {
        return value != null && value.equals(this.get(rowKey, columnKey));
    }

    private boolean removeMapping(@CheckForNull Object rowKey, @CheckForNull Object columnKey, @CheckForNull Object value) {
        if (this.containsMapping(rowKey, columnKey, value)) {
            this.remove(rowKey, columnKey);
            return true;
        }
        return false;
    }

    @Override
    public Set<Table.Cell<R, C, V>> cellSet() {
        return super.cellSet();
    }

    @Override
    Iterator<Table.Cell<R, C, V>> cellIterator() {
        return new CellIterator();
    }

    @Override
    Spliterator<Table.Cell<R, C, V>> cellSpliterator() {
        return CollectSpliterators.flatMap(this.backingMap.entrySet().spliterator(), rowEntry -> CollectSpliterators.map(((Map)rowEntry.getValue()).entrySet().spliterator(), columnEntry -> Tables.immutableCell(rowEntry.getKey(), columnEntry.getKey(), columnEntry.getValue())), 65, this.size());
    }

    @Override
    public Map<C, V> row(R rowKey) {
        return new Row(rowKey);
    }

    @Override
    public Map<R, V> column(C columnKey) {
        return new Column(columnKey);
    }

    @Override
    public Set<R> rowKeySet() {
        return this.rowMap().keySet();
    }

    @Override
    public Set<C> columnKeySet() {
        ColumnKeySet result2 = this.columnKeySet;
        return result2 == null ? (this.columnKeySet = new ColumnKeySet()) : result2;
    }

    Iterator<C> createColumnKeyIterator() {
        return new ColumnKeyIterator();
    }

    @Override
    public Collection<V> values() {
        return super.values();
    }

    @Override
    public Map<R, Map<C, V>> rowMap() {
        Map<R, Map<C, Map<C, V>>> result2 = this.rowMap;
        return result2 == null ? (this.rowMap = this.createRowMap()) : result2;
    }

    Map<R, Map<C, V>> createRowMap() {
        return new RowMap();
    }

    @Override
    public Map<C, Map<R, V>> columnMap() {
        ColumnMap result2 = this.columnMap;
        return result2 == null ? (this.columnMap = new ColumnMap()) : result2;
    }

    private class CellIterator
    implements Iterator<Table.Cell<R, C, V>> {
        final Iterator<Map.Entry<R, Map<C, V>>> rowIterator;
        @CheckForNull
        Map.Entry<R, Map<C, V>> rowEntry;
        Iterator<Map.Entry<C, V>> columnIterator;

        private CellIterator() {
            this.rowIterator = StandardTable.this.backingMap.entrySet().iterator();
            this.columnIterator = Iterators.emptyModifiableIterator();
        }

        @Override
        public boolean hasNext() {
            return this.rowIterator.hasNext() || this.columnIterator.hasNext();
        }

        @Override
        public Table.Cell<R, C, V> next() {
            if (!this.columnIterator.hasNext()) {
                this.rowEntry = this.rowIterator.next();
                this.columnIterator = this.rowEntry.getValue().entrySet().iterator();
            }
            Objects.requireNonNull(this.rowEntry);
            Map.Entry columnEntry = this.columnIterator.next();
            return Tables.immutableCell(this.rowEntry.getKey(), columnEntry.getKey(), columnEntry.getValue());
        }

        @Override
        public void remove() {
            this.columnIterator.remove();
            if (Objects.requireNonNull(this.rowEntry).getValue().isEmpty()) {
                this.rowIterator.remove();
                this.rowEntry = null;
            }
        }
    }

    class Row
    extends Maps.IteratorBasedAbstractMap<C, V> {
        final R rowKey;
        @CheckForNull
        Map<C, V> backingRowMap;

        Row(R rowKey) {
            this.rowKey = Preconditions.checkNotNull(rowKey);
        }

        final void updateBackingRowMapField() {
            if (this.backingRowMap == null || this.backingRowMap.isEmpty() && StandardTable.this.backingMap.containsKey(this.rowKey)) {
                this.backingRowMap = this.computeBackingRowMap();
            }
        }

        @CheckForNull
        Map<C, V> computeBackingRowMap() {
            return StandardTable.this.backingMap.get(this.rowKey);
        }

        void maintainEmptyInvariant() {
            this.updateBackingRowMapField();
            if (this.backingRowMap != null && this.backingRowMap.isEmpty()) {
                StandardTable.this.backingMap.remove(this.rowKey);
                this.backingRowMap = null;
            }
        }

        @Override
        public boolean containsKey(@CheckForNull Object key2) {
            this.updateBackingRowMapField();
            return key2 != null && this.backingRowMap != null && Maps.safeContainsKey(this.backingRowMap, key2);
        }

        @Override
        @CheckForNull
        public V get(@CheckForNull Object key2) {
            this.updateBackingRowMapField();
            return key2 != null && this.backingRowMap != null ? (Object)Maps.safeGet(this.backingRowMap, key2) : null;
        }

        @Override
        @CheckForNull
        public V put(C key2, V value) {
            Preconditions.checkNotNull(key2);
            Preconditions.checkNotNull(value);
            if (this.backingRowMap != null && !this.backingRowMap.isEmpty()) {
                return this.backingRowMap.put(key2, value);
            }
            return StandardTable.this.put(this.rowKey, key2, value);
        }

        @Override
        @CheckForNull
        public V remove(@CheckForNull Object key2) {
            this.updateBackingRowMapField();
            if (this.backingRowMap == null) {
                return null;
            }
            Object result2 = Maps.safeRemove(this.backingRowMap, key2);
            this.maintainEmptyInvariant();
            return result2;
        }

        @Override
        public void clear() {
            this.updateBackingRowMapField();
            if (this.backingRowMap != null) {
                this.backingRowMap.clear();
            }
            this.maintainEmptyInvariant();
        }

        @Override
        public int size() {
            this.updateBackingRowMapField();
            return this.backingRowMap == null ? 0 : this.backingRowMap.size();
        }

        @Override
        Iterator<Map.Entry<C, V>> entryIterator() {
            this.updateBackingRowMapField();
            if (this.backingRowMap == null) {
                return Iterators.emptyModifiableIterator();
            }
            final Iterator iterator2 = this.backingRowMap.entrySet().iterator();
            return new Iterator<Map.Entry<C, V>>(){
                final /* synthetic */ Row this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public boolean hasNext() {
                    return iterator2.hasNext();
                }

                @Override
                public Map.Entry<C, V> next() {
                    return this.this$1.wrapEntry((Map.Entry)iterator2.next());
                }

                @Override
                public void remove() {
                    iterator2.remove();
                    this.this$1.maintainEmptyInvariant();
                }
            };
        }

        @Override
        Spliterator<Map.Entry<C, V>> entrySpliterator() {
            this.updateBackingRowMapField();
            if (this.backingRowMap == null) {
                return Spliterators.emptySpliterator();
            }
            return CollectSpliterators.map(this.backingRowMap.entrySet().spliterator(), this::wrapEntry);
        }

        Map.Entry<C, V> wrapEntry(final Map.Entry<C, V> entry) {
            return new ForwardingMapEntry<C, V>(this){
                final /* synthetic */ Row this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                protected Map.Entry<C, V> delegate() {
                    return entry;
                }

                @Override
                public V setValue(V value) {
                    return super.setValue(Preconditions.checkNotNull(value));
                }

                @Override
                public boolean equals(@CheckForNull Object object) {
                    return this.standardEquals(object);
                }
            };
        }
    }

    private class Column
    extends Maps.ViewCachingAbstractMap<R, V> {
        final C columnKey;

        Column(C columnKey) {
            this.columnKey = Preconditions.checkNotNull(columnKey);
        }

        @Override
        @CheckForNull
        public V put(R key2, V value) {
            return StandardTable.this.put(key2, this.columnKey, value);
        }

        @Override
        @CheckForNull
        public V get(@CheckForNull Object key2) {
            return StandardTable.this.get(key2, this.columnKey);
        }

        @Override
        public boolean containsKey(@CheckForNull Object key2) {
            return StandardTable.this.contains(key2, this.columnKey);
        }

        @Override
        @CheckForNull
        public V remove(@CheckForNull Object key2) {
            return StandardTable.this.remove(key2, this.columnKey);
        }

        @CanIgnoreReturnValue
        boolean removeFromColumnIf(Predicate<? super Map.Entry<R, V>> predicate) {
            boolean changed = false;
            Iterator iterator2 = StandardTable.this.backingMap.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry = iterator2.next();
                Map map2 = entry.getValue();
                Object value = map2.get(this.columnKey);
                if (value == null || !predicate.apply(Maps.immutableEntry(entry.getKey(), value))) continue;
                map2.remove(this.columnKey);
                changed = true;
                if (!map2.isEmpty()) continue;
                iterator2.remove();
            }
            return changed;
        }

        @Override
        Set<Map.Entry<R, V>> createEntrySet() {
            return new EntrySet();
        }

        @Override
        Set<R> createKeySet() {
            return new KeySet();
        }

        @Override
        Collection<V> createValues() {
            return new Values();
        }

        private class EntrySet
        extends Sets.ImprovedAbstractSet<Map.Entry<R, V>> {
            private EntrySet() {
            }

            @Override
            public Iterator<Map.Entry<R, V>> iterator() {
                return new EntrySetIterator();
            }

            @Override
            public int size() {
                int size = 0;
                for (Map map2 : StandardTable.this.backingMap.values()) {
                    if (!map2.containsKey(Column.this.columnKey)) continue;
                    ++size;
                }
                return size;
            }

            @Override
            public boolean isEmpty() {
                return !StandardTable.this.containsColumn(Column.this.columnKey);
            }

            @Override
            public void clear() {
                Column.this.removeFromColumnIf(Predicates.alwaysTrue());
            }

            @Override
            public boolean contains(@CheckForNull Object o) {
                if (o instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)o;
                    return StandardTable.this.containsMapping(entry.getKey(), Column.this.columnKey, entry.getValue());
                }
                return false;
            }

            @Override
            public boolean remove(@CheckForNull Object obj) {
                if (obj instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)obj;
                    return StandardTable.this.removeMapping(entry.getKey(), Column.this.columnKey, entry.getValue());
                }
                return false;
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                return Column.this.removeFromColumnIf(Predicates.not(Predicates.in(c)));
            }
        }

        private class KeySet
        extends Maps.KeySet<R, V> {
            KeySet() {
                super(Column.this);
            }

            @Override
            public boolean contains(@CheckForNull Object obj) {
                return StandardTable.this.contains(obj, Column.this.columnKey);
            }

            @Override
            public boolean remove(@CheckForNull Object obj) {
                return StandardTable.this.remove(obj, Column.this.columnKey) != null;
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                return Column.this.removeFromColumnIf(Maps.keyPredicateOnEntries(Predicates.not(Predicates.in(c))));
            }
        }

        private class Values
        extends Maps.Values<R, V> {
            Values() {
                super(Column.this);
            }

            @Override
            public boolean remove(@CheckForNull Object obj) {
                return obj != null && Column.this.removeFromColumnIf(Maps.valuePredicateOnEntries(Predicates.equalTo(obj)));
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                return Column.this.removeFromColumnIf(Maps.valuePredicateOnEntries(Predicates.in(c)));
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                return Column.this.removeFromColumnIf(Maps.valuePredicateOnEntries(Predicates.not(Predicates.in(c))));
            }
        }

        private class EntrySetIterator
        extends AbstractIterator<Map.Entry<R, V>> {
            final Iterator<Map.Entry<R, Map<C, V>>> iterator;

            private EntrySetIterator() {
                this.iterator = StandardTable.this.backingMap.entrySet().iterator();
            }

            @Override
            @CheckForNull
            protected Map.Entry<R, V> computeNext() {
                while (this.iterator.hasNext()) {
                    final Map.Entry entry = this.iterator.next();
                    if (!entry.getValue().containsKey(Column.this.columnKey)) continue;
                    class EntryImpl
                    extends AbstractMapEntry<R, V> {
                        final /* synthetic */ EntrySetIterator this$2;

                        EntryImpl() {
                            this.this$2 = this$2;
                        }

                        @Override
                        public R getKey() {
                            return entry.getKey();
                        }

                        @Override
                        public V getValue() {
                            return ((Map)entry.getValue()).get(this.this$2.Column.this.columnKey);
                        }

                        @Override
                        public V setValue(V value) {
                            return NullnessCasts.uncheckedCastNullableTToT(((Map)entry.getValue()).put(this.this$2.Column.this.columnKey, Preconditions.checkNotNull(value)));
                        }
                    }
                    return new EntryImpl();
                }
                return (Map.Entry)this.endOfData();
            }
        }
    }

    private class ColumnKeySet
    extends TableSet<C> {
        private ColumnKeySet() {
        }

        @Override
        public Iterator<C> iterator() {
            return StandardTable.this.createColumnKeyIterator();
        }

        @Override
        public int size() {
            return Iterators.size(this.iterator());
        }

        @Override
        public boolean remove(@CheckForNull Object obj) {
            if (obj == null) {
                return false;
            }
            boolean changed = false;
            Iterator iterator2 = StandardTable.this.backingMap.values().iterator();
            while (iterator2.hasNext()) {
                Map map2 = iterator2.next();
                if (!map2.keySet().remove(obj)) continue;
                changed = true;
                if (!map2.isEmpty()) continue;
                iterator2.remove();
            }
            return changed;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            Preconditions.checkNotNull(c);
            boolean changed = false;
            Iterator iterator2 = StandardTable.this.backingMap.values().iterator();
            while (iterator2.hasNext()) {
                Map map2 = iterator2.next();
                if (!Iterators.removeAll(map2.keySet().iterator(), c)) continue;
                changed = true;
                if (!map2.isEmpty()) continue;
                iterator2.remove();
            }
            return changed;
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            Preconditions.checkNotNull(c);
            boolean changed = false;
            Iterator iterator2 = StandardTable.this.backingMap.values().iterator();
            while (iterator2.hasNext()) {
                Map map2 = iterator2.next();
                if (!map2.keySet().retainAll(c)) continue;
                changed = true;
                if (!map2.isEmpty()) continue;
                iterator2.remove();
            }
            return changed;
        }

        @Override
        public boolean contains(@CheckForNull Object obj) {
            return StandardTable.this.containsColumn(obj);
        }
    }

    private class ColumnKeyIterator
    extends AbstractIterator<C> {
        final Map<C, V> seen;
        final Iterator<Map<C, V>> mapIterator;
        Iterator<Map.Entry<C, V>> entryIterator;

        private ColumnKeyIterator() {
            this.seen = StandardTable.this.factory.get();
            this.mapIterator = StandardTable.this.backingMap.values().iterator();
            this.entryIterator = Iterators.emptyIterator();
        }

        @Override
        @CheckForNull
        protected C computeNext() {
            while (true) {
                if (this.entryIterator.hasNext()) {
                    Map.Entry entry = this.entryIterator.next();
                    if (this.seen.containsKey(entry.getKey())) continue;
                    this.seen.put(entry.getKey(), entry.getValue());
                    return entry.getKey();
                }
                if (!this.mapIterator.hasNext()) break;
                this.entryIterator = this.mapIterator.next().entrySet().iterator();
            }
            return this.endOfData();
        }
    }

    class RowMap
    extends Maps.ViewCachingAbstractMap<R, Map<C, V>> {
        RowMap() {
        }

        @Override
        public boolean containsKey(@CheckForNull Object key2) {
            return StandardTable.this.containsRow(key2);
        }

        @Override
        @CheckForNull
        public Map<C, V> get(@CheckForNull Object key2) {
            return StandardTable.this.containsRow(key2) ? StandardTable.this.row(Objects.requireNonNull(key2)) : null;
        }

        @Override
        @CheckForNull
        public Map<C, V> remove(@CheckForNull Object key2) {
            return key2 == null ? null : StandardTable.this.backingMap.remove(key2);
        }

        @Override
        protected Set<Map.Entry<R, Map<C, V>>> createEntrySet() {
            return new EntrySet();
        }

        private final class EntrySet
        extends TableSet<Map.Entry<R, Map<C, V>>> {
            private EntrySet() {
            }

            @Override
            public Iterator<Map.Entry<R, Map<C, V>>> iterator() {
                return Maps.asMapEntryIterator(StandardTable.this.backingMap.keySet(), new Function<R, Map<C, V>>(){

                    @Override
                    public Map<C, V> apply(R rowKey) {
                        return StandardTable.this.row(rowKey);
                    }
                });
            }

            @Override
            public int size() {
                return StandardTable.this.backingMap.size();
            }

            @Override
            public boolean contains(@CheckForNull Object obj) {
                if (obj instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)obj;
                    return entry.getKey() != null && entry.getValue() instanceof Map && Collections2.safeContains(StandardTable.this.backingMap.entrySet(), entry);
                }
                return false;
            }

            @Override
            public boolean remove(@CheckForNull Object obj) {
                if (obj instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)obj;
                    return entry.getKey() != null && entry.getValue() instanceof Map && StandardTable.this.backingMap.entrySet().remove(entry);
                }
                return false;
            }
        }
    }

    private class ColumnMap
    extends Maps.ViewCachingAbstractMap<C, Map<R, V>> {
        private ColumnMap() {
        }

        @Override
        @CheckForNull
        public Map<R, V> get(@CheckForNull Object key2) {
            return StandardTable.this.containsColumn(key2) ? StandardTable.this.column(Objects.requireNonNull(key2)) : null;
        }

        @Override
        public boolean containsKey(@CheckForNull Object key2) {
            return StandardTable.this.containsColumn(key2);
        }

        @Override
        @CheckForNull
        public Map<R, V> remove(@CheckForNull Object key2) {
            return StandardTable.this.containsColumn(key2) ? StandardTable.this.removeColumn(key2) : null;
        }

        @Override
        public Set<Map.Entry<C, Map<R, V>>> createEntrySet() {
            return new ColumnMapEntrySet();
        }

        @Override
        public Set<C> keySet() {
            return StandardTable.this.columnKeySet();
        }

        @Override
        Collection<Map<R, V>> createValues() {
            return new ColumnMapValues();
        }

        private final class ColumnMapEntrySet
        extends TableSet<Map.Entry<C, Map<R, V>>> {
            private ColumnMapEntrySet() {
            }

            @Override
            public Iterator<Map.Entry<C, Map<R, V>>> iterator() {
                return Maps.asMapEntryIterator(StandardTable.this.columnKeySet(), new Function<C, Map<R, V>>(){

                    @Override
                    public Map<R, V> apply(C columnKey) {
                        return StandardTable.this.column(columnKey);
                    }
                });
            }

            @Override
            public int size() {
                return StandardTable.this.columnKeySet().size();
            }

            @Override
            public boolean contains(@CheckForNull Object obj) {
                Map.Entry entry;
                if (obj instanceof Map.Entry && StandardTable.this.containsColumn((entry = (Map.Entry)obj).getKey())) {
                    return ((Map)Objects.requireNonNull(ColumnMap.this.get(entry.getKey()))).equals(entry.getValue());
                }
                return false;
            }

            @Override
            public boolean remove(@CheckForNull Object obj) {
                if (this.contains(obj) && obj instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)obj;
                    StandardTable.this.removeColumn(entry.getKey());
                    return true;
                }
                return false;
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                Preconditions.checkNotNull(c);
                return Sets.removeAllImpl(this, c.iterator());
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                Preconditions.checkNotNull(c);
                boolean changed = false;
                for (Object columnKey : Lists.newArrayList(StandardTable.this.columnKeySet().iterator())) {
                    if (c.contains(Maps.immutableEntry(columnKey, StandardTable.this.column(columnKey)))) continue;
                    StandardTable.this.removeColumn(columnKey);
                    changed = true;
                }
                return changed;
            }
        }

        private class ColumnMapValues
        extends Maps.Values<C, Map<R, V>> {
            ColumnMapValues() {
                super(ColumnMap.this);
            }

            @Override
            public boolean remove(@CheckForNull Object obj) {
                for (Map.Entry entry : ColumnMap.this.entrySet()) {
                    if (!((Map)entry.getValue()).equals(obj)) continue;
                    StandardTable.this.removeColumn(entry.getKey());
                    return true;
                }
                return false;
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                Preconditions.checkNotNull(c);
                boolean changed = false;
                for (Object columnKey : Lists.newArrayList(StandardTable.this.columnKeySet().iterator())) {
                    if (!c.contains(StandardTable.this.column(columnKey))) continue;
                    StandardTable.this.removeColumn(columnKey);
                    changed = true;
                }
                return changed;
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                Preconditions.checkNotNull(c);
                boolean changed = false;
                for (Object columnKey : Lists.newArrayList(StandardTable.this.columnKeySet().iterator())) {
                    if (c.contains(StandardTable.this.column(columnKey))) continue;
                    StandardTable.this.removeColumn(columnKey);
                    changed = true;
                }
                return changed;
            }
        }
    }

    private abstract class TableSet<T>
    extends Sets.ImprovedAbstractSet<T> {
        private TableSet() {
        }

        @Override
        public boolean isEmpty() {
            return StandardTable.this.backingMap.isEmpty();
        }

        @Override
        public void clear() {
            StandardTable.this.backingMap.clear();
        }
    }
}

