/*
 * Decompiled with CFR 0.152.
 */
package MCplugin.powerTrims.Logic;

import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ArmorMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.trim.ArmorTrim;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.persistence.PersistentDataType;

public class ArmourChecking {
    public static boolean hasFullTrimmedArmor(Player player, TrimPattern pattern) {
        ItemStack[] armor;
        for (ItemStack piece : armor = player.getInventory().getArmorContents()) {
            if (piece == null || piece.getType() == Material.AIR) {
                return false;
            }
            ItemMeta itemMeta = piece.getItemMeta();
            if (!(itemMeta instanceof ArmorMeta)) {
                return false;
            }
            ArmorMeta armorMeta = (ArmorMeta)itemMeta;
            ArmorTrim trim = armorMeta.getTrim();
            if (trim != null && trim.getPattern() == pattern) continue;
            return false;
        }
        return true;
    }

    public static boolean hasFullUpgradedArmor(Player player, TrimPattern pattern, NamespacedKey upgradeKey) {
        ItemStack[] armor;
        for (ItemStack piece : armor = player.getInventory().getArmorContents()) {
            if (piece == null || piece.getType() == Material.AIR) {
                return false;
            }
            ItemMeta itemMeta = piece.getItemMeta();
            if (!(itemMeta instanceof ArmorMeta)) {
                return false;
            }
            ArmorMeta armorMeta = (ArmorMeta)itemMeta;
            if (!armorMeta.getPersistentDataContainer().has(upgradeKey, PersistentDataType.BYTE)) {
                return false;
            }
            ArmorTrim trim = armorMeta.getTrim();
            if (trim != null && trim.getPattern() == pattern) continue;
            return false;
        }
        return true;
    }

    public static TrimPattern getEquippedTrim(Player player) {
        ItemStack[] armor = player.getInventory().getArmorContents();
        TrimPattern equippedTrim = null;
        for (ItemStack piece : armor) {
            if (piece == null || piece.getType() == Material.AIR) {
                return null;
            }
            ItemMeta itemMeta = piece.getItemMeta();
            if (!(itemMeta instanceof ArmorMeta)) {
                return null;
            }
            ArmorMeta armorMeta = (ArmorMeta)itemMeta;
            ArmorTrim trim = armorMeta.getTrim();
            if (trim == null) {
                return null;
            }
            if (equippedTrim == null) {
                equippedTrim = trim.getPattern();
                continue;
            }
            if (equippedTrim == trim.getPattern()) continue;
            return null;
        }
        return equippedTrim;
    }
}

