/*
 * Decompiled with CFR 0.152.
 */
package MCplugin.powerTrims.Logic;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.plugin.java.JavaPlugin;

public class DataManager {
    private final JavaPlugin plugin;
    private final File cooldownFile;
    private FileConfiguration cooldownConfig;
    private final Map<UUID, Map<String, Long>> cooldownCache;

    public DataManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.cooldownFile = new File(plugin.getDataFolder(), "cooldowns.yml");
        this.cooldownCache = new HashMap<UUID, Map<String, Long>>();
        this.loadConfigs();
    }

    private void loadConfigs() {
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdirs();
        }
        if (!this.cooldownFile.exists()) {
            try {
                this.cooldownFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not create cooldowns.yml!");
                e.printStackTrace();
            }
        }
        this.cooldownConfig = YamlConfiguration.loadConfiguration((File)this.cooldownFile);
        this.loadData();
    }

    private void loadData() {
        for (String uuidStr : this.cooldownConfig.getKeys(false)) {
            UUID uuid = UUID.fromString(uuidStr);
            HashMap<String, Long> playerCooldowns = new HashMap<String, Long>();
            if (this.cooldownConfig.getConfigurationSection(uuidStr) != null) {
                for (String trimName : this.cooldownConfig.getConfigurationSection(uuidStr).getKeys(false)) {
                    long cooldown = this.cooldownConfig.getLong(uuidStr + "." + trimName);
                    playerCooldowns.put(trimName, cooldown);
                }
            }
            this.cooldownCache.put(uuid, playerCooldowns);
        }
    }

    public void saveData() {
        for (Map.Entry<UUID, Map<String, Long>> entry : this.cooldownCache.entrySet()) {
            String uuidStr = entry.getKey().toString();
            for (Map.Entry<String, Long> cooldownEntry : entry.getValue().entrySet()) {
                this.cooldownConfig.set(uuidStr + "." + cooldownEntry.getKey(), (Object)cooldownEntry.getValue());
            }
        }
        try {
            this.cooldownConfig.save(this.cooldownFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save data files!");
            e.printStackTrace();
        }
    }

    public void setCooldown(Player player, TrimPattern pattern, long cooldown) {
        String trimName = this.getTrimName(pattern);
        this.cooldownCache.computeIfAbsent(player.getUniqueId(), k -> new HashMap()).put(trimName, cooldown);
    }

    public long getCooldown(Player player, TrimPattern pattern) {
        String trimName = this.getTrimName(pattern);
        return ((Map)this.cooldownCache.getOrDefault(player.getUniqueId(), new HashMap())).getOrDefault(trimName, 0L);
    }

    private String getTrimName(TrimPattern pattern) {
        if (pattern == TrimPattern.SILENCE) {
            return "SILENCE";
        }
        if (pattern == TrimPattern.SPIRE) {
            return "SPIRE";
        }
        if (pattern == TrimPattern.SENTRY) {
            return "SENTRY";
        }
        if (pattern == TrimPattern.WILD) {
            return "WILD";
        }
        if (pattern == TrimPattern.WARD) {
            return "WARD";
        }
        if (pattern == TrimPattern.EYE) {
            return "EYE";
        }
        if (pattern == TrimPattern.VEX) {
            return "VEX";
        }
        if (pattern == TrimPattern.DUNE) {
            return "DUNE";
        }
        if (pattern == TrimPattern.WAYFINDER) {
            return "WAYFINDER";
        }
        if (pattern == TrimPattern.FLOW) {
            return "FLOW";
        }
        if (pattern == TrimPattern.RIB) {
            return "RIB";
        }
        if (pattern == TrimPattern.TIDE) {
            return "TIDE";
        }
        if (pattern == TrimPattern.COAST) {
            return "COAST";
        }
        if (pattern == TrimPattern.HOST) {
            return "HOST";
        }
        if (pattern == TrimPattern.RAISER) {
            return "RAISER";
        }
        if (pattern == TrimPattern.SNOUT) {
            return "SNOUT";
        }
        return pattern.toString();
    }
}

