/*
 * Decompiled with CFR 0.152.
 */
package MCplugin.powerTrims.Logic;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class PersistentTrustManager {
    private final JavaPlugin plugin;
    private final File trustFile;
    private FileConfiguration trustConfig;
    private final Map<UUID, Set<UUID>> trustedPlayers = new HashMap<UUID, Set<UUID>>();

    public PersistentTrustManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.trustFile = new File(plugin.getDataFolder(), "trusted_players.yml");
        this.loadTrusts();
    }

    private void loadTrusts() {
        if (!this.trustFile.exists()) {
            try {
                this.trustFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not create trusted_players.yml!");
                e.printStackTrace();
            }
        }
        this.trustConfig = YamlConfiguration.loadConfiguration((File)this.trustFile);
        for (String uuidStr : this.trustConfig.getKeys(false)) {
            UUID ownerUUID = UUID.fromString(uuidStr);
            HashSet<UUID> trusted = new HashSet<UUID>();
            if (this.trustConfig.getConfigurationSection(uuidStr) != null) {
                for (String trustedStr : this.trustConfig.getConfigurationSection(uuidStr).getKeys(false)) {
                    UUID trustedUUID = UUID.fromString(trustedStr);
                    trusted.add(trustedUUID);
                }
            }
            this.trustedPlayers.put(ownerUUID, trusted);
        }
    }

    public void saveTrusts() {
        for (String string : this.trustConfig.getKeys(false)) {
            this.trustConfig.set(string, null);
        }
        for (Map.Entry entry : this.trustedPlayers.entrySet()) {
            String uuidStr = ((UUID)entry.getKey()).toString();
            ArrayList<String> trustedUUIDs = new ArrayList<String>();
            for (UUID trustedUUID : (Set)entry.getValue()) {
                trustedUUIDs.add(trustedUUID.toString());
            }
            this.trustConfig.set(uuidStr, trustedUUIDs);
        }
        try {
            this.trustConfig.save(this.trustFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save trusted_players.yml!");
            e.printStackTrace();
        }
    }

    private void sendMessage(CommandSender sender, String message, String ... replacements) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
                message = PlaceholderAPI.setPlaceholders((Player)player, (String)message);
            } else {
                for (int i = 0; i < replacements.length; i += 2) {
                    message = message.replace(replacements[i], replacements[i + 1]);
                }
            }
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
        } else {
            for (int i = 0; i < replacements.length; i += 2) {
                message = message.replace(replacements[i], replacements[i + 1]);
            }
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
        }
    }

    public void trustPlayer(UUID player, UUID trusted, CommandSender sender) {
        Set trustList = this.trustedPlayers.computeIfAbsent(player, k -> new HashSet());
        if (trustList.contains(trusted)) {
            this.sendMessage(sender, "&ePlayer is already trusted.", new String[0]);
            return;
        }
        trustList.add(trusted);
        Player trustedPlayer = this.plugin.getServer().getPlayer(trusted);
        String trustedName = trustedPlayer != null ? trustedPlayer.getName() : trusted.toString().substring(0, 8);
        this.sendMessage(sender, "&aYou have trusted " + trustedName + ".", "%player%", trustedName);
    }

    public void untrustPlayer(UUID player, UUID trusted, CommandSender sender) {
        Player untrustedPlayer;
        Set<UUID> trustList = this.trustedPlayers.get(player);
        if (trustList == null || !trustList.contains(trusted)) {
            this.sendMessage(sender, "&ePlayer is not currently trusted.", new String[0]);
            return;
        }
        trustList.remove(trusted);
        if (trustList.isEmpty()) {
            this.trustedPlayers.remove(player);
        }
        String untrustedName = (untrustedPlayer = this.plugin.getServer().getPlayer(trusted)) != null ? untrustedPlayer.getName() : trusted.toString().substring(0, 8);
        this.sendMessage(sender, "&cYou have untrusted " + untrustedName + ".", "%player%", untrustedName);
    }

    public boolean isTrusted(UUID owner, UUID other) {
        return this.trustedPlayers.getOrDefault(owner, Collections.emptySet()).contains(other);
    }

    public Set<UUID> getTrusted(UUID player) {
        return this.trustedPlayers.getOrDefault(player, Collections.emptySet());
    }

    public void showTrustList(UUID player, CommandSender sender) {
        Set trustedList = this.trustedPlayers.getOrDefault(player, Collections.emptySet());
        if (trustedList.isEmpty()) {
            this.sendMessage(sender, "&7You have no currently trusted players.", new String[0]);
            return;
        }
        this.sendMessage(sender, "&eYour trusted players:", new String[0]);
        for (UUID trustedUUID : trustedList) {
            Player trustedPlayer = this.plugin.getServer().getPlayer(trustedUUID);
            String trustedName = trustedPlayer != null ? trustedPlayer.getName() : trustedUUID.toString().substring(0, 8);
            this.sendMessage(sender, "&a- " + trustedName, "%player%", trustedName);
        }
    }
}

