/*
 * Decompiled with CFR 0.152.
 */
package MCplugin.powerTrims.Logic;

import MCplugin.powerTrims.Logic.ArmourChecking;
import MCplugin.powerTrims.Logic.DataManager;
import MCplugin.powerTrims.PowerTrimss;
import MCplugin.powerTrims.ultimates.silenceult.SilenceUlt;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TrimCooldownManager {
    private final JavaPlugin plugin;
    private final DataManager dataManager;
    private DisplayMode displayMode;
    private boolean placeholderApiEnabled;
    private final PowerTrimss powerTrimsPlugin;

    public TrimCooldownManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.powerTrimsPlugin = (PowerTrimss)plugin;
        this.dataManager = this.powerTrimsPlugin.getDataManager();
        this.placeholderApiEnabled = Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI");
        this.loadConfig();
        new BukkitRunnable(){

            public void run() {
                TrimCooldownManager.this.updateDisplays();
            }
        }.runTaskTimer((Plugin)plugin, 0L, 20L);
    }

    public void reload() {
        this.loadConfig();
    }

    private void loadConfig() {
        FileConfiguration config = this.plugin.getConfig();
        String mode = config.getString("cooldown-display", "ACTION_BAR").toUpperCase();
        try {
            if (mode.equals("SCOREBOARD")) {
                this.displayMode = DisplayMode.ACTION_BAR;
                this.plugin.getLogger().warning("Scoreboard display mode is no longer supported. Using ACTION_BAR instead.");
            } else {
                this.displayMode = DisplayMode.valueOf(mode);
            }
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid cooldown-display mode in config.yml: " + mode + ". Using ACTION_BAR.");
            this.displayMode = DisplayMode.ACTION_BAR;
        }
    }

    private void updateDisplays() {
        if (this.displayMode == DisplayMode.NONE) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (this.displayMode != DisplayMode.ACTION_BAR) continue;
            this.showActionBar(player);
        }
    }

    private void showActionBar(Player player) {
        SilenceUlt silenceUlt;
        TrimPattern trim = ArmourChecking.getEquippedTrim(player);
        Object finalMessage = "";
        Object trimCooldownString = "";
        if (trim != null) {
            long cooldown = this.getRemainingCooldown(player, trim) / 1000L;
            String cooldownText = cooldown > 0L ? String.valueOf(ChatColor.RED) + "\u23f3 " + cooldown + "s" : String.valueOf(ChatColor.GREEN) + "\u2705 Ready!";
            trimCooldownString = String.valueOf(ChatColor.GRAY) + "Trim: " + String.valueOf(ChatColor.GOLD) + this.getTrimDisplayName(trim) + " - " + cooldownText;
        }
        String ultimateString = "";
        if (trim == TrimPattern.SILENCE && (silenceUlt = this.powerTrimsPlugin.getSilenceUlt()) != null) {
            ultimateString = silenceUlt.getUltimateActionbarString(player);
        }
        finalMessage = trimCooldownString;
        if (!ultimateString.isEmpty()) {
            if (!((String)finalMessage).isEmpty()) {
                finalMessage = (String)finalMessage + String.valueOf(ChatColor.DARK_GRAY) + " | ";
            }
            finalMessage = (String)finalMessage + ultimateString;
        }
        if (!((String)finalMessage).isEmpty()) {
            player.sendActionBar((Component)Component.text((String)finalMessage));
        }
    }

    public void setCooldown(Player player, TrimPattern trim, long cooldownMillis) {
        long expiry = System.currentTimeMillis() + cooldownMillis;
        this.dataManager.setCooldown(player, trim, expiry);
    }

    public boolean isOnCooldown(Player player, TrimPattern trim) {
        long cooldownExpiry = this.dataManager.getCooldown(player, trim);
        return System.currentTimeMillis() < cooldownExpiry;
    }

    public long getRemainingCooldown(Player player, TrimPattern trim) {
        long cooldownExpiry = this.dataManager.getCooldown(player, trim);
        long remaining = cooldownExpiry - System.currentTimeMillis();
        return Math.max(0L, remaining);
    }

    public void resetAllCooldowns(Player player) {
        this.dataManager.setCooldown(player, TrimPattern.SILENCE, 0L);
        this.dataManager.setCooldown(player, TrimPattern.SPIRE, 0L);
        this.dataManager.setCooldown(player, TrimPattern.WAYFINDER, 0L);
        this.dataManager.setCooldown(player, TrimPattern.RAISER, 0L);
        this.dataManager.setCooldown(player, TrimPattern.DUNE, 0L);
        this.dataManager.setCooldown(player, TrimPattern.HOST, 0L);
        this.dataManager.setCooldown(player, TrimPattern.COAST, 0L);
        this.dataManager.setCooldown(player, TrimPattern.FLOW, 0L);
        this.dataManager.setCooldown(player, TrimPattern.RIB, 0L);
        this.dataManager.setCooldown(player, TrimPattern.SENTRY, 0L);
        this.dataManager.setCooldown(player, TrimPattern.WILD, 0L);
        this.dataManager.setCooldown(player, TrimPattern.WARD, 0L);
        this.dataManager.setCooldown(player, TrimPattern.EYE, 0L);
        this.dataManager.setCooldown(player, TrimPattern.TIDE, 0L);
        this.dataManager.setCooldown(player, TrimPattern.SNOUT, 0L);
        this.dataManager.setCooldown(player, TrimPattern.VEX, 0L);
    }

    public String getTrimDisplayName(TrimPattern pattern) {
        if (pattern == null) {
            return "";
        }
        if (pattern == TrimPattern.SILENCE) {
            return "Silence";
        }
        if (pattern == TrimPattern.SPIRE) {
            return "Spire";
        }
        if (pattern == TrimPattern.WAYFINDER) {
            return "Wayfinder";
        }
        if (pattern == TrimPattern.RAISER) {
            return "Raiser";
        }
        if (pattern == TrimPattern.HOST) {
            return "Host";
        }
        if (pattern == TrimPattern.DUNE) {
            return "Dune";
        }
        if (pattern == TrimPattern.COAST) {
            return "Coast";
        }
        if (pattern == TrimPattern.FLOW) {
            return "Flow";
        }
        if (pattern == TrimPattern.RIB) {
            return "Rib";
        }
        if (pattern == TrimPattern.SENTRY) {
            return "Sentry";
        }
        if (pattern == TrimPattern.WILD) {
            return "Wild";
        }
        if (pattern == TrimPattern.WARD) {
            return "Ward";
        }
        if (pattern == TrimPattern.EYE) {
            return "Eye";
        }
        if (pattern == TrimPattern.TIDE) {
            return "Tide";
        }
        if (pattern == TrimPattern.BOLT) {
            return "Bolt";
        }
        if (pattern == TrimPattern.SNOUT) {
            return "Snout";
        }
        if (pattern == TrimPattern.VEX) {
            return "Vex";
        }
        if (pattern == TrimPattern.SHAPER) {
            return "Shaper";
        }
        return pattern.toString().replace("_", " ");
    }

    public static enum DisplayMode {
        ACTION_BAR,
        NONE;

    }
}

