/*
 * Decompiled with CFR 0.152.
 */
package MCplugin.powerTrims.Logic;

import MCplugin.powerTrims.Logic.ArmourChecking;
import MCplugin.powerTrims.config.ConfigManager;
import MCplugin.powerTrims.shaded.armorequipevent.ArmorEquipEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Registry;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class TrimEffectManager
implements Listener {
    private final JavaPlugin plugin;
    private final ConfigManager configManager;
    private final Map<TrimPattern, List<PotionEffect>> passiveEffects = new HashMap<TrimPattern, List<PotionEffect>>();

    public TrimEffectManager(JavaPlugin plugin, ConfigManager configManager) {
        this.plugin = plugin;
        this.configManager = configManager;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.registerPassiveEffects();
    }

    private void registerPassiveEffects() {
        ConfigurationSection passiveEffectsSection = this.configManager.getConfig().getConfigurationSection("passive_effects");
        if (passiveEffectsSection == null) {
            return;
        }
        for (String trimName : passiveEffectsSection.getKeys(false)) {
            TrimPattern pattern = this.getTrimPatternFromString(trimName);
            if (pattern == null) {
                this.plugin.getLogger().warning("Invalid trim pattern in passive_effects: " + trimName);
                continue;
            }
            ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
            List effectStrings = passiveEffectsSection.getStringList(trimName);
            if (effectStrings.isEmpty() || effectStrings.size() == 1 && ((String)effectStrings.get(0)).equalsIgnoreCase("none")) {
                this.passiveEffects.put(pattern, new ArrayList());
                continue;
            }
            for (String effectString : effectStrings) {
                try {
                    String[] parts = effectString.split(":");
                    if (parts.length != 2) {
                        this.plugin.getLogger().warning("Invalid effect format in passive_effects for trim '" + trimName + "': " + effectString);
                        continue;
                    }
                    PotionEffectType effectType = PotionEffectType.getByName((String)parts[0].toUpperCase());
                    int amplifier = Integer.parseInt(parts[1]);
                    if (effectType == null) {
                        this.plugin.getLogger().warning("Invalid potion effect type '" + parts[0] + "' for trim '" + trimName + "'.");
                        continue;
                    }
                    effects.add(new PotionEffect(effectType, -1, amplifier, true, false, true));
                }
                catch (NumberFormatException e) {
                    this.plugin.getLogger().warning("Invalid amplifier in passive_effects for trim '" + trimName + "': " + effectString);
                }
            }
            this.passiveEffects.put(pattern, effects);
        }
    }

    private TrimPattern getTrimPatternFromString(String patternName) {
        for (TrimPattern pattern : Registry.TRIM_PATTERN) {
            if (!pattern.getKey().getKey().equalsIgnoreCase(patternName)) continue;
            return pattern;
        }
        return null;
    }

    private void removeOwnedEffects(Player player) {
        for (List<PotionEffect> effects : this.passiveEffects.values()) {
            for (PotionEffect effect : effects) {
                String metadataKey = "powertrims-effect-" + effect.getType().getName();
                if (!player.hasMetadata(metadataKey)) continue;
                player.removePotionEffect(effect.getType());
                player.removeMetadata(metadataKey, (Plugin)this.plugin);
            }
        }
    }

    public void applyTrimEffects(Player player) {
        String trimName;
        this.removeOwnedEffects(player);
        TrimPattern equipped = ArmourChecking.getEquippedTrim(player);
        if (equipped != null && this.passiveEffects.containsKey(equipped) && this.configManager.isTrimEnabled(trimName = equipped.getKey().getKey())) {
            for (PotionEffect effect : this.passiveEffects.get(equipped)) {
                player.addPotionEffect(effect);
                String metadataKey = "powertrims-effect-" + effect.getType().getName();
                player.setMetadata(metadataKey, (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)true));
            }
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.applyTrimEffects(event.getPlayer()), 1L);
    }

    @EventHandler
    public void onMilkDrink(PlayerItemConsumeEvent event) {
        if (event.getItem().getType() == Material.MILK_BUCKET) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.applyTrimEffects(event.getPlayer()), 1L);
        }
    }

    @EventHandler
    public void onRespawn(PlayerRespawnEvent event) {
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.applyTrimEffects(event.getPlayer()), 40L);
    }

    @EventHandler
    public void onArmorEquip(ArmorEquipEvent event) {
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.applyTrimEffects(event.getPlayer()), 1L);
    }
}

