/*
 * Decompiled with CFR 0.152.
 */
package MCplugin.powerTrims;

import MCplugin.powerTrims.Logic.AbilityManager;
import MCplugin.powerTrims.Logic.DataManager;
import MCplugin.powerTrims.Logic.LoreChanger;
import MCplugin.powerTrims.Logic.PersistentTrustManager;
import MCplugin.powerTrims.Logic.TrimCooldownManager;
import MCplugin.powerTrims.Logic.TrimEffectManager;
import MCplugin.powerTrims.Trims.BoltTrim;
import MCplugin.powerTrims.Trims.CoastTrim;
import MCplugin.powerTrims.Trims.DuneTrim;
import MCplugin.powerTrims.Trims.EyeTrim;
import MCplugin.powerTrims.Trims.FlowTrim;
import MCplugin.powerTrims.Trims.HostTrim;
import MCplugin.powerTrims.Trims.RaiserTrim;
import MCplugin.powerTrims.Trims.RibTrim;
import MCplugin.powerTrims.Trims.SentryTrim;
import MCplugin.powerTrims.Trims.SilenceTrim;
import MCplugin.powerTrims.Trims.SnoutTrim;
import MCplugin.powerTrims.Trims.SpireTrim;
import MCplugin.powerTrims.Trims.TideTrim;
import MCplugin.powerTrims.Trims.VexTrim;
import MCplugin.powerTrims.Trims.WardTrim;
import MCplugin.powerTrims.Trims.WayfinderTrim;
import MCplugin.powerTrims.Trims.WildTrim;
import MCplugin.powerTrims.UltimateUpgrader.RitualManager;
import MCplugin.powerTrims.UltimateUpgrader.UltimateUpgraderManager;
import MCplugin.powerTrims.commands.PowerTrimsCommand;
import MCplugin.powerTrims.commands.TrustCommand;
import MCplugin.powerTrims.commands.TrustListCommand;
import MCplugin.powerTrims.commands.UntrustCommand;
import MCplugin.powerTrims.config.ConfigManager;
import MCplugin.powerTrims.integrations.PlaceholderIntegration;
import MCplugin.powerTrims.integrations.WorldGuardIntegration;
import MCplugin.powerTrims.integrations.geyser.DoubleSneakManager;
import MCplugin.powerTrims.shaded.armorequipevent.ArmorEquipEvent;
import MCplugin.powerTrims.ultimates.silenceult.SilenceTransformAnimations;
import MCplugin.powerTrims.ultimates.silenceult.SilenceUlt;
import MCplugin.powerTrims.ultimates.silenceult.SilenceUltData;
import java.util.Arrays;
import java.util.Objects;
import me.libraryaddict.disguise.DisguiseAPI;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class PowerTrimss
extends JavaPlugin
implements Listener {
    private TrimCooldownManager cooldownManager;
    private DataManager dataManager;
    private PersistentTrustManager trustManager;
    private ConfigManager configManager;
    private TrimEffectManager trimEffectManager;
    private AbilityManager abilityManager;
    private RitualManager ritualManager;
    private UltimateUpgraderManager ultimateUpgraderManager;
    private NamespacedKey upgradeKey;
    private SilenceUlt silenceUlt;
    private SilenceUltData silenceUltData;
    private EyeTrim eyeTrim;
    private RibTrim ribTrim;
    private VexTrim vexTrim;
    private BoltTrim boltTrim;
    private PlaceholderIntegration placeholderIntegration;
    private CoastTrim coastTrim;
    private DuneTrim duneTrim;
    private FlowTrim flowTrim;

    public void onLoad() {
        if (this.getServer().getPluginManager().getPlugin("WorldGuard") != null) {
            this.getLogger().info("WorldGuard detected. Registering custom PowerTrims flags...");
            WorldGuardIntegration.registerFlags();
        }
    }

    public void onEnable() {
        this.saveDefaultConfig();
        this.setConfigDefaults();
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        this.configManager = new ConfigManager(this);
        this.trustManager = new PersistentTrustManager(this);
        this.dataManager = new DataManager(this);
        this.cooldownManager = new TrimCooldownManager(this);
        this.abilityManager = new AbilityManager();
        new DoubleSneakManager(this, this.abilityManager);
        this.upgradeKey = new NamespacedKey((Plugin)this, "silence_ultimate_upgraded");
        this.ritualManager = new RitualManager(this, this.upgradeKey);
        this.ultimateUpgraderManager = new UltimateUpgraderManager(this, this.ritualManager, this.upgradeKey, this.configManager);
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            this.placeholderIntegration = new PlaceholderIntegration(this);
            this.placeholderIntegration.register();
        }
        this.registerTrimAbilities();
        ArmorEquipEvent.registerListener(this);
        this.trimEffectManager = new TrimEffectManager(this, this.configManager);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new LoreChanger(), (Plugin)this);
        Objects.requireNonNull(this.getCommand("powertrims")).setExecutor((CommandExecutor)new PowerTrimsCommand(this, this.configManager, this.cooldownManager, this.trustManager));
        Objects.requireNonNull(this.getCommand("trust")).setExecutor((CommandExecutor)new TrustCommand(this.trustManager));
        Objects.requireNonNull(this.getCommand("untrust")).setExecutor((CommandExecutor)new UntrustCommand(this.trustManager));
        Objects.requireNonNull(this.getCommand("trustlist")).setExecutor((CommandExecutor)new TrustListCommand(this.trustManager));
        if (this.silenceUlt != null) {
            this.silenceUltData.loadOriginalBlocks();
            SilenceTransformAnimations.revertSculkBlocks();
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!DisguiseAPI.isDisguised((Entity)player)) continue;
                this.silenceUlt.revertFromWarden(player, false);
            }
        }
        this.getLogger().info(String.valueOf(ChatColor.GREEN) + "--------------------------------------");
        this.getLogger().info(String.valueOf(ChatColor.GOLD) + "   Thanks for using PowerTrims!");
        this.getLogger().info(String.valueOf(ChatColor.AQUA) + "   Made by " + String.valueOf(ChatColor.BOLD) + "div");
        this.getLogger().info(String.valueOf(ChatColor.GREEN) + "--------------------------------------");
    }

    public void reloadPlugin() {
        HandlerList.unregisterAll((Plugin)this);
        this.configManager.reloadConfig();
        this.ritualManager.reload();
        this.registerTrimAbilities();
        ArmorEquipEvent.registerListener(this);
        this.trimEffectManager = new TrimEffectManager(this, this.configManager);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new LoreChanger(), (Plugin)this);
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.trimEffectManager.applyTrimEffects(player);
        }
    }

    private void registerTrimAbilities() {
        if (Bukkit.getPluginManager().getPlugin("LibsDisguises") != null) {
            this.silenceUltData = new SilenceUltData(this);
            this.silenceUlt = new SilenceUlt(this, this.upgradeKey, this.silenceUltData);
            this.getServer().getPluginManager().registerEvents((Listener)this.silenceUlt, (Plugin)this);
        } else {
            this.getLogger().warning("LibsDisguises not found, Silence Ultimate will be disabled.");
        }
        this.getServer().getPluginManager().registerEvents((Listener)new SilenceTrim(this, this.cooldownManager, this.trustManager, this.configManager, this.abilityManager), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new WildTrim(this, this.cooldownManager, this.trustManager, this.configManager, this.abilityManager), (Plugin)this);
        this.vexTrim = new VexTrim(this, this.cooldownManager, this.trustManager, this.configManager, this.abilityManager);
        this.getServer().getPluginManager().registerEvents((Listener)this.vexTrim, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new TideTrim(this, this.cooldownManager, this.trustManager, this.configManager, this.abilityManager), (Plugin)this);
        this.eyeTrim = new EyeTrim(this, this.cooldownManager, this.trustManager, this.configManager, this.abilityManager);
        this.getServer().getPluginManager().registerEvents((Listener)this.eyeTrim, (Plugin)this);
        this.ribTrim = new RibTrim(this, this.cooldownManager, this.trustManager, this.configManager, this.abilityManager);
        this.getServer().getPluginManager().registerEvents((Listener)this.ribTrim, (Plugin)this);
        this.flowTrim = new FlowTrim(this, this.cooldownManager, this.configManager, this.abilityManager);
        this.getServer().getPluginManager().registerEvents((Listener)this.flowTrim, (Plugin)this);
        this.coastTrim = new CoastTrim(this, this.cooldownManager, this.trustManager, this.configManager, this.abilityManager);
        this.getServer().getPluginManager().registerEvents((Listener)this.coastTrim, (Plugin)this);
        this.duneTrim = new DuneTrim(this, this.cooldownManager, this.trustManager, this.configManager, this.abilityManager);
        this.getServer().getPluginManager().registerEvents((Listener)this.duneTrim, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new SentryTrim(this, this.cooldownManager, this.trustManager, this.configManager, this.abilityManager), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new WayfinderTrim(this, this.cooldownManager, this.configManager, this.abilityManager), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new RaiserTrim(this, this.cooldownManager, this.trustManager, this.configManager, this.abilityManager), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new WardTrim(this, this.cooldownManager, this.configManager, this.abilityManager), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new SpireTrim(this, this.cooldownManager, this.trustManager, this.configManager, this.abilityManager), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new HostTrim(this, this.cooldownManager, this.trustManager, this.configManager, this.abilityManager), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new SnoutTrim(this, this.cooldownManager, this.trustManager, this.configManager, this.abilityManager), (Plugin)this);
        this.boltTrim = new BoltTrim(this, this.cooldownManager, this.trustManager, this.configManager);
        this.getServer().getPluginManager().registerEvents((Listener)this.boltTrim, (Plugin)this);
    }

    private void setConfigDefaults() {
        FileConfiguration config = this.getConfig();
        config.addDefault("web-address", (Object)"0.0.0.0");
        config.addDefault("web-port", (Object)8080);
        config.addDefault("upgrades.max_level", (Object)5);
        config.addDefault("passive_effects.silence", Arrays.asList("STRENGTH:1"));
        config.addDefault("passive_effects.vex", Arrays.asList("SPEED:1"));
        config.addDefault("passive_effects.snout", Arrays.asList("STRENGTH:0"));
        config.addDefault("passive_effects.coast", Arrays.asList("DOLPHINS_GRACE:0"));
        config.addDefault("passive_effects.wild", Arrays.asList("REGENERATION:0"));
        config.addDefault("passive_effects.tide", Arrays.asList("DOLPHINS_GRACE:2"));
        config.addDefault("passive_effects.dune", Arrays.asList("HASTE:0", "FIRE_RESISTANCE:0"));
        config.addDefault("passive_effects.eye", Arrays.asList("NIGHT_VISION:0"));
        config.addDefault("passive_effects.ward", Arrays.asList("RESISTANCE:0"));
        config.addDefault("passive_effects.sentry", Arrays.asList("RESISTANCE:0"));
        config.addDefault("passive_effects.spire", Arrays.asList("SPEED:1"));
        config.addDefault("passive_effects.rib", Arrays.asList("RESISTANCE:0"));
        config.addDefault("passive_effects.bolt", Arrays.asList("SPEED:2"));
        config.addDefault("passive_effects.flow", Arrays.asList("SPEED:1"));
        config.addDefault("silence.passive.cooldown", (Object)120000L);
        config.addDefault("silence.primary.radius", (Object)15.0);
        config.addDefault("silence.primary.potion_duration_ticks", (Object)400);
        config.addDefault("silence.primary.pearl_cooldown_ticks", (Object)200);
        config.addDefault("silence.passive.echo_radius", (Object)6.0);
        config.addDefault("silence.passive.effect_duration_ticks", (Object)300);
        config.addDefault("silence.primary.max_affected_entities", (Object)30);
        config.addDefault("silence.primary.cooldown", (Object)90000L);
        config.addDefault("wild.passive.trigger_health", (Object)8);
        config.addDefault("wild.passive.cooldown_seconds", (Object)20);
        config.addDefault("wild.primary.cooldown", (Object)20000L);
        config.addDefault("wild.primary.grapple_range", (Object)60.0);
        config.addDefault("wild.primary.poison_duration_ticks", (Object)200);
        config.addDefault("wild.primary.grapple_speed", (Object)1.8);
        config.addDefault("wild.passive.root_trap_radius_xz", (Object)5);
        config.addDefault("wild.passive.root_trap_radius_y", (Object)3);
        config.addDefault("wild.passive.root_trap_duration_ticks", (Object)200);
        config.addDefault("vex.primary.cooldown", (Object)120000L);
        config.addDefault("vex.primary.radius", (Object)30.0);
        config.addDefault("vex.primary.damage", (Object)8.0);
        config.addDefault("vex.primary.debuff_duration_ticks", (Object)400);
        config.addDefault("vex.primary.blindness_duration_ticks", (Object)100);
        config.addDefault("vex.passive.cooldown", (Object)120000L);
        config.addDefault("vex.passive.hide_duration_ticks", (Object)200L);
        config.addDefault("vex.passive.health_threshold", (Object)8.0);
        config.addDefault("tide.primary.cooldown", (Object)120000L);
        config.addDefault("tide.primary.wave_width", (Object)3.0);
        config.addDefault("tide.primary.effect_duration_ticks", (Object)300);
        config.addDefault("tide.primary.knockback_strength", (Object)1.8);
        config.addDefault("tide.primary.wall_height", (Object)6);
        config.addDefault("tide.primary.move_delay_ticks", (Object)2);
        config.addDefault("tide.primary.max_moves", (Object)20);
        config.addDefault("eye.primary.true_sight_radius", (Object)80.0);
        config.addDefault("eye.primary.true_sight_duration_ticks", (Object)600);
        config.addDefault("trim.eye.primary.cooldown", (Object)120000L);
        config.addDefault("eye.primary.task_interval_ticks", (Object)20L);
        config.addDefault("eye.primary.true_sight_vertical_radius", (Object)50.0);
        config.addDefault("rib.primary.cooldown", (Object)60000L);
        config.addDefault("rib.primary.minion_lifespan_ticks", (Object)1200L);
        config.addDefault("flow.primary.heart_cost_interval", (Object)20);
        config.addDefault("flow.primary.heart_cost_amount", (Object)2.0);
        config.addDefault("flow.primary.cooldown", (Object)60000L);
        config.addDefault("flow.primary.duration", (Object)400);
        config.addDefault("coast.primary.water-burst-radius", (Object)30);
        config.addDefault("coast.primary.water-burst-damage", (Object)10);
        config.addDefault("coast.primary.water-burst-cooldown", (Object)60000L);
        config.addDefault("coast.primary.pull-duration-ticks", (Object)60);
        config.addDefault("coast.primary.debuff-duration-ticks", (Object)80);
        config.addDefault("coast.primary.buff-duration-ticks", (Object)100);
        config.addDefault("coast.primary.weakness-amplifier", (Object)1);
        config.addDefault("coast.primary.slowness-amplifier", (Object)1);
        config.addDefault("coast.primary.speed-amplifier", (Object)1);
        config.addDefault("coast.primary.resistance-amplifier", (Object)0);
        config.addDefault("dune.primary.sandstorm_radius", (Object)12);
        config.addDefault("dune.primary.sandstorm_damage", (Object)10);
        config.addDefault("dune.primary.cooldown", (Object)60000L);
        config.addDefault("sentry.primary.arrow_count", (Object)3);
        config.addDefault("sentry.primary.spread", (Object)0.15);
        config.addDefault("sentry.primary.cooldown", (Object)90000L);
        config.addDefault("sentry.primary.true_damage", (Object)0.5);
        config.addDefault("wayfinder.primary.cooldown", (Object)120000L);
        config.addDefault("wayfinder.primary.enabled", (Object)true);
        config.addDefault("raiser.primary.cooldown", (Object)120000L);
        config.addDefault("raiser.primary.entity_pull_radius", (Object)15.0);
        config.addDefault("raiser.primary.player_upward_boost", (Object)1.5);
        config.addDefault("raiser.primary.pearl_cooldown_ticks", (Object)200);
        config.addDefault("ward.primary.barrier_duration", (Object)200);
        config.addDefault("ward.primary.absorption_level", (Object)4);
        config.addDefault("ward.primary.resistance_boost_level", (Object)2);
        config.addDefault("ward.primary.cooldown", (Object)120000L);
        config.addDefault("spire.primary.dash_distance", (Object)8);
        config.addDefault("spire.primary.dash_speed", (Object)2.0);
        config.addDefault("spire.primary.knockback_strength", (Object)1.5);
        config.addDefault("spire.primary.slow_duration", (Object)60);
        config.addDefault("spire.primary.vulnerable_duration", (Object)100);
        config.addDefault("spire.primary.damage_amplification", (Object)0.6);
        config.addDefault("spire.primary.cooldown", (Object)30000L);
        config.addDefault("host.primary.cooldown", (Object)120000L);
        config.addDefault("host.primary.effect_steal_radius", (Object)10.0);
        config.addDefault("host.primary.health_steal_amount", (Object)4.0);
        config.addDefault("host.primary.particle_density", (Object)4.0);
        config.addDefault("snout.primary.cooldown", (Object)120000L);
        config.addDefault("snout.primary.minion_lifespan_ticks", (Object)1800L);
        config.addDefault("bolt.primary.cooldown", (Object)20000L);
        config.addDefault("bolt.primary.chain_range", (Object)10);
        config.addDefault("bolt.primary.max_chains", (Object)3);
        config.addDefault("bolt.primary.initial_damage", (Object)6.0);
        config.addDefault("bolt.primary.subsequent_damage", (Object)4.0);
        config.addDefault("bolt.primary.target_range", (Object)20);
        config.addDefault("bolt.primary.weakness_duration", (Object)100);
        config.addDefault("bolt.primary.weakness_amplifier", (Object)0);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        event.getPlayer().sendMessage(String.valueOf(ChatColor.DARK_AQUA) + "\u00a7l\u2605 \u00a7eThank you for using " + String.valueOf(ChatColor.GOLD) + "PowerTrims! " + String.valueOf(ChatColor.DARK_AQUA) + "\u00a7l\u2605");
        event.getPlayer().sendMessage(String.valueOf(ChatColor.YELLOW) + "\u00a7lMade by " + String.valueOf(ChatColor.RED) + "div" + String.valueOf(ChatColor.YELLOW) + " \u00a7l\u2665");
    }

    public void onDisable() {
        if (this.trustManager != null) {
            this.trustManager.saveTrusts();
        }
        if (this.silenceUltData != null) {
            this.silenceUltData.saveOriginalBlocks();
        }
        if (this.eyeTrim != null) {
            this.eyeTrim.cleanup();
        }
        if (this.ribTrim != null) {
            this.ribTrim.cleanup();
        }
        if (this.vexTrim != null) {
            this.vexTrim.cleanup();
        }
        if (this.boltTrim != null) {
            this.boltTrim.cleanup();
        }
        if (this.placeholderIntegration != null) {
            this.placeholderIntegration.cleanup();
        }
        if (this.coastTrim != null) {
            this.coastTrim.cleanup();
        }
        if (this.duneTrim != null) {
            this.duneTrim.cleanup();
        }
        if (this.flowTrim != null) {
            this.flowTrim.cleanup();
        }
        this.getLogger().info(String.valueOf(ChatColor.RED) + "--------------------------------------");
        this.getLogger().info(String.valueOf(ChatColor.GOLD) + "   PowerTrims plugin has been disabled.");
        this.getLogger().info(String.valueOf(ChatColor.RED) + "--------------------------------------");
        if (this.dataManager != null) {
            this.dataManager.saveData();
        }
    }

    public DataManager getDataManager() {
        return this.dataManager;
    }

    public TrimCooldownManager getCooldownManager() {
        return this.cooldownManager;
    }

    public SilenceUlt getSilenceUlt() {
        return this.silenceUlt;
    }

    public NamespacedKey getUpgradeKey() {
        return this.upgradeKey;
    }
}

