/*
 * Decompiled with CFR 0.152.
 */
package MCplugin.powerTrims.Trims;

import MCplugin.powerTrims.Logic.ArmourChecking;
import MCplugin.powerTrims.Logic.PersistentTrustManager;
import MCplugin.powerTrims.Logic.TrimCooldownManager;
import MCplugin.powerTrims.config.ConfigManager;
import MCplugin.powerTrims.integrations.WorldGuardIntegration;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Transformation;
import org.bukkit.util.Vector;

public class BoltTrim
implements Listener {
    private final JavaPlugin plugin;
    private final TrimCooldownManager cooldownManager;
    private final PersistentTrustManager trustManager;
    private final ConfigManager configManager;
    private final List<BlockDisplay> activeLightningParts = new ArrayList<BlockDisplay>();

    public BoltTrim(JavaPlugin plugin, TrimCooldownManager cooldownManager, PersistentTrustManager trustManager, ConfigManager configManager) {
        this.plugin = plugin;
        this.cooldownManager = cooldownManager;
        this.trustManager = trustManager;
        this.configManager = configManager;
    }

    @EventHandler
    public void onOffhandPress(PlayerSwapHandItemsEvent event) {
        if (event.getPlayer().isSneaking()) {
            event.setCancelled(true);
            this.activateBoltPrimary(event.getPlayer());
        }
    }

    public void activateBoltPrimary(Player player) {
        LivingEntity nextTarget;
        if (!this.configManager.isTrimEnabled("bolt")) {
            return;
        }
        if (!ArmourChecking.hasFullTrimmedArmor(player, TrimPattern.BOLT)) {
            return;
        }
        if (this.cooldownManager.isOnCooldown(player, TrimPattern.BOLT)) {
            return;
        }
        if (Bukkit.getPluginManager().getPlugin("WorldGuard") != null && !WorldGuardIntegration.canUseAbilities(player)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You cannot use this ability in the current region.");
            return;
        }
        long cooldown = this.configManager.getLong("bolt.primary.cooldown");
        int chainRange = this.configManager.getInt("bolt.primary.chain_range");
        int maxChains = this.configManager.getInt("bolt.primary.max_chains");
        double initialDamage = this.configManager.getDouble("bolt.primary.initial_damage");
        double subsequentDamage = this.configManager.getDouble("bolt.primary.subsequent_damage");
        int targetRange = this.configManager.getInt("bolt.primary.target_range");
        int weaknessDuration = this.configManager.getInt("bolt.primary.weakness_duration");
        int weaknessAmplifier = this.configManager.getInt("bolt.primary.weakness_amplifier");
        LivingEntity target = this.getTarget(player, targetRange);
        if (target == null) {
            player.sendMessage(String.valueOf(ChatColor.GRAY) + "No target in sight.");
            return;
        }
        this.playLightningAnimation(target.getLocation());
        target.damage(initialDamage, (Entity)player);
        target.addPotionEffect(new PotionEffect(PotionEffectType.WEAKNESS, weaknessDuration, weaknessAmplifier));
        ArrayList<LivingEntity> struckEntities = new ArrayList<LivingEntity>();
        struckEntities.add(target);
        LivingEntity currentTarget = target;
        for (int i = 0; i < maxChains && (nextTarget = this.findNextTarget(currentTarget, chainRange, struckEntities, player)) != null; ++i) {
            this.playLightningArcAnimation(currentTarget.getEyeLocation(), nextTarget.getEyeLocation());
            nextTarget.getWorld().playSound(nextTarget.getLocation(), Sound.ENTITY_LIGHTNING_BOLT_IMPACT, 1.0f, 1.5f);
            nextTarget.damage(subsequentDamage, (Entity)player);
            nextTarget.addPotionEffect(new PotionEffect(PotionEffectType.WEAKNESS, weaknessDuration, weaknessAmplifier));
            struckEntities.add(nextTarget);
            currentTarget = nextTarget;
        }
        this.cooldownManager.setCooldown(player, TrimPattern.BOLT, cooldown);
        this.sendActivationMessage(player);
    }

    private void playLightningAnimation(Location targetLocation) {
        World world = targetLocation.getWorld();
        if (world == null) {
            return;
        }
        Material lightningMaterial = Material.CYAN_WOOL;
        int lifeTicks = 10;
        Location startPoint = targetLocation.clone().add(0.0, 15.0, 0.0);
        if (startPoint.getY() > (double)world.getMaxHeight()) {
            startPoint.setY((double)world.getMaxHeight());
        }
        Vector travel = targetLocation.toVector().subtract(startPoint.toVector());
        int segments = 25;
        Vector step = travel.clone().multiply(1.0 / (double)segments);
        Location current = startPoint.clone();
        for (int i = 0; i < segments; ++i) {
            current.add(step);
            Location jittered = current.clone().add(new Vector(Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5).multiply(1.5));
            BlockDisplay part = (BlockDisplay)world.spawn(jittered, BlockDisplay.class, bd -> {
                bd.setBlock(lightningMaterial.createBlockData());
                Transformation t = bd.getTransformation();
                t.getScale().set(0.3f);
                bd.setTransformation(t);
                bd.setBrightness(new Display.Brightness(15, 15));
            });
            this.activeLightningParts.add(part);
        }
        new BukkitRunnable(){

            public void run() {
                for (BlockDisplay part : BoltTrim.this.activeLightningParts) {
                    part.remove();
                }
                BoltTrim.this.activeLightningParts.clear();
            }
        }.runTaskLater((Plugin)this.plugin, 10L);
        world.playSound(targetLocation, Sound.ENTITY_LIGHTNING_BOLT_THUNDER, 2.0f, 1.0f);
        world.playSound(targetLocation, Sound.ENTITY_LIGHTNING_BOLT_IMPACT, 2.0f, 1.0f);
    }

    private void playLightningArcAnimation(Location start, Location end) {
        World world = start.getWorld();
        if (world == null) {
            return;
        }
        Material lightningMaterial = Material.CYAN_WOOL;
        int lifeTicks = 8;
        Vector travel = end.toVector().subtract(start.toVector());
        int segments = (int)(travel.length() * 2.0);
        if (segments == 0) {
            return;
        }
        Vector step = travel.clone().multiply(1.0 / (double)segments);
        Location current = start.clone();
        for (int i = 0; i < segments; ++i) {
            current.add(step);
            Location jittered = current.clone().add(new Vector(Math.random() - 0.5, Math.random() - 0.5, Math.random() - 0.5).multiply(0.7));
            BlockDisplay part = (BlockDisplay)world.spawn(jittered, BlockDisplay.class, bd -> {
                bd.setBlock(lightningMaterial.createBlockData());
                Transformation t = bd.getTransformation();
                t.getScale().set(0.25f);
                bd.setTransformation(t);
                bd.setBrightness(new Display.Brightness(15, 15));
            });
            this.activeLightningParts.add(part);
        }
        new BukkitRunnable(){

            public void run() {
                for (BlockDisplay part : BoltTrim.this.activeLightningParts) {
                    part.remove();
                }
                BoltTrim.this.activeLightningParts.clear();
            }
        }.runTaskLater((Plugin)this.plugin, 8L);
    }

    private LivingEntity getTarget(Player player, int range) {
        List nearbyEntities = player.getNearbyEntities((double)range, (double)range, (double)range);
        LivingEntity target = null;
        double minAngle = Double.MAX_VALUE;
        for (Entity entity : nearbyEntities) {
            double angle;
            if (!(entity instanceof LivingEntity) || !player.hasLineOfSight(entity)) continue;
            if (entity instanceof Player) {
                Player targetPlayer = (Player)entity;
                if (this.trustManager.isTrusted(player.getUniqueId(), targetPlayer.getUniqueId())) continue;
            }
            if (!((angle = (double)player.getLocation().getDirection().angle(entity.getLocation().toVector().subtract(player.getLocation().toVector()))) < minAngle)) continue;
            minAngle = angle;
            target = (LivingEntity)entity;
        }
        if (target != null && minAngle < 0.2) {
            return target;
        }
        return null;
    }

    private LivingEntity findNextTarget(LivingEntity from, int range, List<LivingEntity> excluded, Player caster) {
        LivingEntity closest = null;
        double closestDistSq = Double.MAX_VALUE;
        for (Entity entity : from.getNearbyEntities((double)range, (double)range, (double)range)) {
            double distSq;
            if (!(entity instanceof LivingEntity) || excluded.contains(entity) || entity.equals((Object)caster)) continue;
            if (entity instanceof Player) {
                Player targetPlayer = (Player)entity;
                if (this.trustManager.isTrusted(caster.getUniqueId(), targetPlayer.getUniqueId())) continue;
            }
            if (!((distSq = entity.getLocation().distanceSquared(from.getLocation())) < closestDistSq)) continue;
            closest = (LivingEntity)entity;
            closestDistSq = distSq;
        }
        return closest;
    }

    private void sendActivationMessage(Player player) {
        Component message = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"[", (TextColor)NamedTextColor.DARK_GRAY).append((Component)Component.text((String)"Bolt", (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)"] ", (TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.text((String)"You have activated ", (TextColor)NamedTextColor.GRAY))).append((Component)Component.text((String)"Chain Lightning", (TextColor)NamedTextColor.YELLOW))).append((Component)Component.text((String)"!", (TextColor)NamedTextColor.GRAY));
        player.sendMessage(message);
    }

    public void cleanup() {
        for (BlockDisplay part : this.activeLightningParts) {
            part.remove();
        }
        this.activeLightningParts.clear();
    }
}

