/*
 * Decompiled with CFR 0.152.
 */
package MCplugin.powerTrims.Trims;

import MCplugin.powerTrims.Logic.AbilityManager;
import MCplugin.powerTrims.Logic.ArmourChecking;
import MCplugin.powerTrims.Logic.Messaging;
import MCplugin.powerTrims.Logic.PersistentTrustManager;
import MCplugin.powerTrims.Logic.TrimCooldownManager;
import MCplugin.powerTrims.config.ConfigManager;
import MCplugin.powerTrims.integrations.WorldGuardIntegration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Transformation;
import org.bukkit.util.Vector;

public class DuneTrim
implements Listener {
    private final JavaPlugin plugin;
    private final TrimCooldownManager cooldownManager;
    private final PersistentTrustManager trustManager;
    private final ConfigManager configManager;
    private final AbilityManager abilityManager;
    private final long TORNADO_COOLDOWN;
    private final int TORNADO_DURATION;
    private final double TORNADO_HEIGHT;
    private final double PULL_STRENGTH;
    private final double LIFT_STRENGTH;
    private final double DAMAGE_PER_SECOND;
    private static final List<Material> SAND_MATERIALS = List.of(Material.SAND, Material.SANDSTONE, Material.RED_SAND, Material.SMOOTH_SANDSTONE, Material.CUT_SANDSTONE);
    private final List<BukkitTask> activeTornadoTasks = new ArrayList<BukkitTask>();

    public DuneTrim(JavaPlugin plugin, TrimCooldownManager cooldownManager, PersistentTrustManager trustManager, ConfigManager configManager, AbilityManager abilityManager) {
        this.plugin = plugin;
        this.cooldownManager = cooldownManager;
        this.trustManager = trustManager;
        this.configManager = configManager;
        this.abilityManager = abilityManager;
        this.TORNADO_COOLDOWN = configManager.getLong("dune.primary.cooldown");
        this.TORNADO_DURATION = configManager.getInt("dune.primary.duration");
        this.TORNADO_HEIGHT = configManager.getDouble("dune.primary.height");
        this.PULL_STRENGTH = configManager.getDouble("dune.primary.pull_strength");
        this.LIFT_STRENGTH = configManager.getDouble("dune.primary.lift_strength");
        this.DAMAGE_PER_SECOND = configManager.getDouble("dune.primary.damage_per_second");
        abilityManager.registerPrimaryAbility(TrimPattern.DUNE, this::dunePrimary);
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void dunePrimary(Player player) {
        if (!this.configManager.isTrimEnabled("dune")) {
            return;
        }
        if (!ArmourChecking.hasFullTrimmedArmor(player, TrimPattern.DUNE)) {
            return;
        }
        if (this.cooldownManager.isOnCooldown(player, TrimPattern.DUNE)) {
            return;
        }
        if (Bukkit.getPluginManager().isPluginEnabled("WorldGuard") && !WorldGuardIntegration.canUseAbilities(player)) {
            Messaging.sendError((CommandSender)player, "You must be looking at the ground to summon the tornado.");
            return;
        }
        Block targetBlock = player.getTargetBlockExact(30, FluidCollisionMode.NEVER);
        if (targetBlock == null) {
            Messaging.sendError((CommandSender)player, "You must be looking at the ground to summon the tornado.");
            return;
        }
        this.cooldownManager.setCooldown(player, TrimPattern.DUNE, this.TORNADO_COOLDOWN);
        Messaging.sendTrimMessage(player, "Dune", ChatColor.GOLD, "You have used dune ability!");
        this.startTornadoTask(player, targetBlock.getLocation().add(0.5, 1.0, 0.5));
    }

    private void startTornadoTask(final Player owner, final Location initialLocation) {
        final World world = initialLocation.getWorld();
        if (world == null) {
            return;
        }
        final ArrayList<TornadoParticle> particles = new ArrayList<TornadoParticle>();
        int particleCount = 150;
        for (int i = 0; i < 150; ++i) {
            ThreadLocalRandom r = ThreadLocalRandom.current();
            BlockDisplay display = (BlockDisplay)world.spawn(initialLocation, BlockDisplay.class, bd -> {
                bd.setBlock(SAND_MATERIALS.get(r.nextInt(SAND_MATERIALS.size())).createBlockData());
                bd.setInterpolationDuration(5);
                bd.setInterpolationDelay(-1);
            });
            double height = r.nextDouble(this.TORNADO_HEIGHT);
            double radius = height * 0.4 + 1.5;
            if (radius > 5.0) {
                radius = 5.0;
            }
            particles.add(new TornadoParticle(display, height, radius, r.nextDouble(20.0, 40.0) * (double)(r.nextBoolean() ? 1 : -1), r.nextDouble(360.0)));
        }
        BukkitRunnable tornadoTask = new BukkitRunnable(this){
            private int ticksElapsed = 0;
            private final Location tornadoLocation = initialLocation.clone();
            private final Vector moveDirection = owner.getEyeLocation().getDirection().setY(0).normalize().multiply(0.5);
            final /* synthetic */ DuneTrim this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (this.ticksElapsed >= this.this$0.TORNADO_DURATION || !owner.isValid()) {
                    this.cancel();
                    return;
                }
                ThreadLocalRandom r = ThreadLocalRandom.current();
                Vector wobble = new Vector(r.nextDouble() - 0.5, 0.0, r.nextDouble() - 0.5).multiply(0.4);
                this.tornadoLocation.add(this.moveDirection.clone().add(wobble));
                this.tornadoLocation.setY((double)world.getHighestBlockYAt(this.tornadoLocation) + 1.0);
                for (Entity entity : world.getNearbyEntities(this.tornadoLocation, 8.0, this.this$0.TORNADO_HEIGHT, 8.0)) {
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity target = (LivingEntity)entity;
                    if (entity.equals((Object)owner)) continue;
                    if (entity instanceof Player) {
                        Player p = (Player)entity;
                        if (this.this$0.trustManager.isTrusted(owner.getUniqueId(), p.getUniqueId())) continue;
                    }
                    Vector pull = this.tornadoLocation.toVector().subtract(target.getLocation().toVector()).normalize().multiply(this.this$0.PULL_STRENGTH);
                    Vector lift = new Vector(0.0, this.this$0.LIFT_STRENGTH, 0.0);
                    target.setVelocity(pull.add(lift));
                    if (this.ticksElapsed % 20 != 0) continue;
                    target.damage(this.this$0.DAMAGE_PER_SECOND, (Entity)owner);
                }
                for (TornadoParticle particle : particles) {
                    if (!particle.display.isValid()) continue;
                    double angle = Math.toRadians(particle.startAngle + (double)this.ticksElapsed * particle.speed);
                    Location particleLoc = this.tornadoLocation.clone().add(Math.cos(angle) * particle.radius, particle.height, Math.sin(angle) * particle.radius);
                    Transformation t = particle.display.getTransformation();
                    t.getScale().set(r.nextFloat() * 0.8f + 0.2f);
                    particle.display.teleport(particleLoc);
                    particle.display.setTransformation(t);
                }
                world.playSound(this.tornadoLocation, Sound.ENTITY_BREEZE_IDLE_AIR, 0.8f, (float)(1.5 + r.nextDouble() * 0.2));
                this.ticksElapsed += 4;
            }

            public synchronized void cancel() throws IllegalStateException {
                super.cancel();
                world.playSound(this.tornadoLocation, Sound.ENTITY_WARDEN_SONIC_BOOM, 1.5f, 1.0f);
                for (TornadoParticle particle : particles) {
                    if (!particle.display.isValid()) continue;
                    particle.display.remove();
                }
                this.this$0.activeTornadoTasks.remove((Object)this);
            }
        };
        this.activeTornadoTasks.add(tornadoTask.runTaskTimer((Plugin)this.plugin, 0L, 4L));
    }

    @EventHandler
    public void onOffhandPress(PlayerSwapHandItemsEvent event) {
        if (event.getPlayer().isSneaking()) {
            event.setCancelled(true);
            this.abilityManager.activatePrimaryAbility(event.getPlayer());
        }
    }

    public void cleanup() {
        for (BukkitTask task : this.activeTornadoTasks) {
            task.cancel();
        }
        this.activeTornadoTasks.clear();
    }

    private record TornadoParticle(BlockDisplay display, double height, double radius, double speed, double startAngle) {
    }
}

