/*
 * Decompiled with CFR 0.152.
 */
package MCplugin.powerTrims.Trims;

import MCplugin.powerTrims.Logic.AbilityManager;
import MCplugin.powerTrims.Logic.ArmourChecking;
import MCplugin.powerTrims.Logic.Messaging;
import MCplugin.powerTrims.Logic.PersistentTrustManager;
import MCplugin.powerTrims.Logic.TrimCooldownManager;
import MCplugin.powerTrims.config.ConfigManager;
import MCplugin.powerTrims.integrations.WorldGuardIntegration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Transformation;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class EyeTrim
implements Listener {
    private final JavaPlugin plugin;
    private final TrimCooldownManager cooldownManager;
    private final PersistentTrustManager trustManager;
    private final ConfigManager configManager;
    private final AbilityManager abilityManager;
    private final double TRUE_SIGHT_RADIUS;
    private final int TRUE_SIGHT_DURATION_TICKS;
    private final long TRUE_SIGHT_COOLDOWN;
    private final long TASK_INTERVAL_TICKS;
    private final double TRUE_SIGHT_VERTICAL_RADIUS;
    private final Map<UUID, BukkitRunnable> activeTrueSightTasks = new HashMap<UUID, BukkitRunnable>();
    private final Map<UUID, BukkitRunnable> activeAnimationTasks = new HashMap<UUID, BukkitRunnable>();
    private final Map<UUID, List<Entity>> activeEyeEffects = new HashMap<UUID, List<Entity>>();

    public EyeTrim(JavaPlugin plugin, TrimCooldownManager cooldownManager, PersistentTrustManager trustManager, ConfigManager configManager, AbilityManager abilityManager) {
        this.plugin = plugin;
        this.cooldownManager = cooldownManager;
        this.trustManager = trustManager;
        this.configManager = configManager;
        this.abilityManager = abilityManager;
        this.TRUE_SIGHT_RADIUS = configManager.getDouble("eye.primary.true_sight_radius");
        this.TRUE_SIGHT_DURATION_TICKS = configManager.getInt("eye.primary.true_sight_duration_ticks");
        this.TRUE_SIGHT_COOLDOWN = configManager.getLong("trim.eye.primary.cooldown");
        this.TASK_INTERVAL_TICKS = configManager.getLong("eye.primary.task_interval_ticks");
        this.TRUE_SIGHT_VERTICAL_RADIUS = configManager.getDouble("eye.primary.true_sight_vertical_radius");
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        abilityManager.registerPrimaryAbility(TrimPattern.EYE, this::activateEyePrimary);
    }

    @EventHandler
    public void onOffhandPress(PlayerSwapHandItemsEvent event) {
        if (event.getPlayer().isSneaking()) {
            event.setCancelled(true);
            this.abilityManager.activatePrimaryAbility(event.getPlayer());
        }
    }

    public void activateEyePrimary(Player player) {
        if (!this.configManager.isTrimEnabled("eye")) {
            return;
        }
        if (!ArmourChecking.hasFullTrimmedArmor(player, TrimPattern.EYE)) {
            return;
        }
        if (this.cooldownManager.isOnCooldown(player, TrimPattern.EYE)) {
            return;
        }
        if (Bukkit.getPluginManager().getPlugin("WorldGuard") != null && !WorldGuardIntegration.canUseAbilities(player)) {
            Messaging.sendError((CommandSender)player, "You cannot use this ability in the current region.");
            return;
        }
        this.activeTrueSightTasks.computeIfPresent(player.getUniqueId(), (uuid, task) -> {
            task.cancel();
            return null;
        });
        this.startEyeEffect(player);
        BukkitRunnable trueSightTask = this.getBukkitRunnable(player);
        this.activeTrueSightTasks.put(player.getUniqueId(), trueSightTask);
        trueSightTask.runTaskTimer((Plugin)this.plugin, 0L, this.TASK_INTERVAL_TICKS);
        this.cooldownManager.setCooldown(player, TrimPattern.EYE, this.TRUE_SIGHT_COOLDOWN);
        Messaging.sendTrimMessage(player, "Eye", ChatColor.AQUA, "you used eye ability!");
    }

    @NotNull
    private BukkitRunnable getBukkitRunnable(final Player player) {
        final HashSet affectedEntities = new HashSet();
        return new BukkitRunnable(this){
            private int ticksRun = 0;
            final /* synthetic */ EyeTrim this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (this.ticksRun >= this.this$0.TRUE_SIGHT_DURATION_TICKS || !player.isOnline()) {
                    this.cancel();
                    return;
                }
                for (Entity entity : player.getNearbyEntities(this.this$0.TRUE_SIGHT_RADIUS, this.this$0.TRUE_SIGHT_VERTICAL_RADIUS, this.this$0.TRUE_SIGHT_RADIUS)) {
                    LivingEntity target;
                    if (!(entity instanceof LivingEntity) || (target = (LivingEntity)entity).equals((Object)player)) continue;
                    if (target instanceof Player) {
                        Player targetPlayer = (Player)target;
                        if (this.this$0.trustManager.isTrusted(player.getUniqueId(), targetPlayer.getUniqueId())) continue;
                    }
                    if (!affectedEntities.add(target.getUniqueId())) continue;
                    this.this$0.applyDebuffs(target);
                }
                if ((long)this.ticksRun % (this.this$0.TASK_INTERVAL_TICKS * 5L) == 0L) {
                    this.this$0.startEyeEffect(player);
                }
                this.ticksRun += (int)this.this$0.TASK_INTERVAL_TICKS;
            }

            public synchronized void cancel() throws IllegalStateException {
                super.cancel();
                this.this$0.activeTrueSightTasks.remove(player.getUniqueId());
            }
        };
    }

    private void applyDebuffs(LivingEntity target) {
        target.removePotionEffect(PotionEffectType.INVISIBILITY);
        target.addPotionEffect(new PotionEffect(PotionEffectType.GLOWING, 1200, 0, false, false));
        target.addPotionEffect(new PotionEffect(PotionEffectType.WEAKNESS, 600, 0, false, false));
        target.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 600, 1, false, false));
    }

    private void startEyeEffect(final Player player) {
        this.stopEyeEffect(player);
        final World world = player.getWorld();
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_ELDER_GUARDIAN_CURSE, 1.0f, 2.0f);
        player.getWorld().playSound(player.getLocation(), Sound.BLOCK_BEACON_ACTIVATE, 1.0f, 1.5f);
        new BukkitRunnable(this){
            private int ticks = 0;
            private final int duration = 20;
            final /* synthetic */ EyeTrim this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (this.ticks++ >= 20 || !player.isOnline()) {
                    this.cancel();
                    return;
                }
                double progress = (double)this.ticks / 20.0;
                double currentRadius = this.this$0.TRUE_SIGHT_RADIUS * progress;
                Location center = player.getLocation();
                for (int i = 0; i < 360; i += 10) {
                    double angle = Math.toRadians(i);
                    double x = Math.cos(angle) * currentRadius;
                    double z = Math.sin(angle) * currentRadius;
                    Location particleLoc = center.clone().add(x, 0.1, z);
                    world.spawnParticle(Particle.WITCH, particleLoc, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
        ArrayList<ItemDisplay> effectEntities = new ArrayList<ItemDisplay>();
        int INTERPOLATION_DURATION = 5;
        final ItemDisplay eye = (ItemDisplay)world.spawn(player.getEyeLocation(), ItemDisplay.class, eyeDisplay -> {
            eyeDisplay.setItemStack(new ItemStack(Material.ENDER_EYE));
            eyeDisplay.setBillboard(Display.Billboard.CENTER);
            eyeDisplay.setInterpolationDelay(-1);
            eyeDisplay.setInterpolationDuration(5);
            Transformation t = eyeDisplay.getTransformation();
            t.getScale().set(0.0f);
            eyeDisplay.setTransformation(t);
        });
        effectEntities.add(eye);
        this.activeEyeEffects.put(player.getUniqueId(), effectEntities);
        BukkitRunnable animationTask = new BukkitRunnable(this){
            private int ticks = 0;
            private final int vanishTick = 60;
            final /* synthetic */ EyeTrim this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (!player.isOnline() || !this.this$0.activeEyeEffects.containsKey(player.getUniqueId())) {
                    this.cancel();
                    return;
                }
                if (this.ticks >= 60) {
                    this.this$0.stopEyeEffect(player);
                    this.cancel();
                    return;
                }
                Location eyeTargetPos = player.getEyeLocation();
                Vector direction = eyeTargetPos.getDirection().setY(0).normalize();
                eyeTargetPos.add(direction.multiply(-0.7)).add(0.0, 0.4, 0.0);
                if (this.ticks == 0) {
                    eye.teleport(eyeTargetPos);
                    Transformation t = eye.getTransformation();
                    t.getScale().set(0.6f);
                    eye.setTransformation(t);
                } else {
                    eye.teleport(eyeTargetPos);
                }
                ++this.ticks;
            }
        };
        animationTask.runTaskTimer((Plugin)this.plugin, 0L, 1L);
        this.activeAnimationTasks.put(player.getUniqueId(), animationTask);
    }

    private void stopEyeEffect(Player player) {
        ItemDisplay eye;
        Entity eyeEntity;
        List<Entity> entities;
        UUID id = player.getUniqueId();
        if (this.activeAnimationTasks.containsKey(id)) {
            this.activeAnimationTasks.get(id).cancel();
            this.activeAnimationTasks.remove(id);
        }
        if (this.activeEyeEffects.containsKey(id) && (entities = this.activeEyeEffects.remove(id)) != null && !entities.isEmpty() && (eyeEntity = entities.get(0)) instanceof ItemDisplay && (eye = (ItemDisplay)eyeEntity).isValid()) {
            Transformation t = eye.getTransformation();
            t.getScale().set(0.0f);
            eye.setTransformation(t);
            new BukkitRunnable(this){

                public void run() {
                    if (eye.isValid()) {
                        eye.remove();
                    }
                }
            }.runTaskLater((Plugin)this.plugin, (long)(eye.getInterpolationDuration() + 1));
        }
    }

    public void cleanup() {
        for (BukkitRunnable bukkitRunnable : this.activeTrueSightTasks.values()) {
            bukkitRunnable.cancel();
        }
        this.activeTrueSightTasks.clear();
        for (BukkitRunnable bukkitRunnable : this.activeAnimationTasks.values()) {
            bukkitRunnable.cancel();
        }
        this.activeAnimationTasks.clear();
        for (List list : this.activeEyeEffects.values()) {
            for (Entity entity : list) {
                entity.remove();
            }
        }
        this.activeEyeEffects.clear();
    }
}

