/*
 * Decompiled with CFR 0.152.
 */
package MCplugin.powerTrims.Trims;

import MCplugin.powerTrims.Logic.AbilityManager;
import MCplugin.powerTrims.Logic.ArmourChecking;
import MCplugin.powerTrims.Logic.Messaging;
import MCplugin.powerTrims.Logic.TrimCooldownManager;
import MCplugin.powerTrims.config.ConfigManager;
import MCplugin.powerTrims.integrations.WorldGuardIntegration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Transformation;
import org.bukkit.util.Vector;

public class FlowTrim
implements Listener {
    private final JavaPlugin plugin;
    private final TrimCooldownManager cooldownManager;
    private final ConfigManager configManager;
    private final AbilityManager abilityManager;
    private final NamespacedKey dashEndFallImmunityKey;
    private final int HEART_COST_INTERVAL;
    private final double HEART_COST_AMOUNT;
    private final long DASH_COOLDOWN;
    private final int DASH_DURATION;
    private final Map<UUID, BukkitRunnable> dashTasks = new HashMap<UUID, BukkitRunnable>();
    private final Map<UUID, Boolean> isDashing = new HashMap<UUID, Boolean>();
    private final Set<UUID> activationDebounce = new HashSet<UUID>();

    public FlowTrim(JavaPlugin plugin, TrimCooldownManager cooldownManager, ConfigManager configManager, AbilityManager abilityManager) {
        this.plugin = plugin;
        this.cooldownManager = cooldownManager;
        this.configManager = configManager;
        this.abilityManager = abilityManager;
        this.dashEndFallImmunityKey = new NamespacedKey((Plugin)plugin, "flow_trim_dash_end_immune");
        this.HEART_COST_INTERVAL = configManager.getInt("flow.primary.heart_cost_interval");
        this.HEART_COST_AMOUNT = configManager.getDouble("flow.primary.heart_cost_amount");
        this.DASH_COOLDOWN = configManager.getLong("flow.primary.cooldown");
        this.DASH_DURATION = configManager.getInt("flow.primary.duration");
        abilityManager.registerPrimaryAbility(TrimPattern.FLOW, this::flowPrimary);
    }

    public void flowPrimary(final Player player) {
        final UUID id = player.getUniqueId();
        if (this.activationDebounce.contains(id)) {
            return;
        }
        this.activationDebounce.add(id);
        new BukkitRunnable(this){
            final /* synthetic */ FlowTrim this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                this.this$0.activationDebounce.remove(id);
            }
        }.runTaskLater((Plugin)this.plugin, 10L);
        if (!this.configManager.isTrimEnabled("flow")) {
            return;
        }
        if (!ArmourChecking.hasFullTrimmedArmor(player, TrimPattern.FLOW)) {
            return;
        }
        if (this.isDashing.getOrDefault(id, false).booleanValue()) {
            this.deactivateDash(player, "You have deactivated Dash.");
            return;
        }
        if (this.cooldownManager.isOnCooldown(player, TrimPattern.FLOW)) {
            Messaging.sendTrimMessage(player, "Flow", ChatColor.AQUA, "Ability on cooldown!");
            return;
        }
        if (Bukkit.getPluginManager().getPlugin("WorldGuard") != null && !WorldGuardIntegration.canUseAbilities(player)) {
            Messaging.sendError((CommandSender)player, "You cannot use this ability in the current region.");
            return;
        }
        player.setAllowFlight(true);
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_BLAZE_SHOOT, 1.0f, 1.5f);
        this.createGaleDashAnimation(player);
        BukkitRunnable task = new BukkitRunnable(this){
            int tickCount = 0;
            final /* synthetic */ FlowTrim this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (!player.isOnline() || !this.this$0.isDashing.getOrDefault(id, false).booleanValue()) {
                    this.cancel();
                    return;
                }
                if (this.tickCount >= this.this$0.DASH_DURATION) {
                    this.this$0.deactivateDash(player, "Dash has expired.");
                    this.cancel();
                    return;
                }
                if (this.tickCount % this.this$0.HEART_COST_INTERVAL == 0) {
                    double hp = player.getHealth();
                    if (hp > this.this$0.HEART_COST_AMOUNT) {
                        player.setHealth(hp - this.this$0.HEART_COST_AMOUNT);
                    } else {
                        this.this$0.deactivateDash(player, "Dash ended due to low health.");
                        this.cancel();
                        return;
                    }
                }
                Vector dir = player.getLocation().getDirection().normalize();
                player.setVelocity(dir.multiply(1.2));
                if (this.tickCount % 3 == 0) {
                    this.this$0.createGaleDashAnimation(player);
                }
                ++this.tickCount;
            }
        };
        this.isDashing.put(id, true);
        this.dashTasks.put(id, task);
        task.runTaskTimer((Plugin)this.plugin, 0L, 1L);
        Messaging.sendTrimMessage(player, "Flow", ChatColor.AQUA, "Activated dash! \u00a77(uses " + this.HEART_COST_AMOUNT / 2.0 + " \u2764/sec)");
    }

    private void deactivateDash(Player player, String message) {
        UUID id = player.getUniqueId();
        if (this.dashTasks.containsKey(id)) {
            this.dashTasks.get(id).cancel();
            this.dashTasks.remove(id);
        }
        this.isDashing.put(id, false);
        if (player.getGameMode() != GameMode.CREATIVE) {
            player.setAllowFlight(false);
        }
        this.cooldownManager.setCooldown(player, TrimPattern.FLOW, this.DASH_COOLDOWN);
        player.getPersistentDataContainer().set(this.dashEndFallImmunityKey, PersistentDataType.BYTE, (Object)1);
        Messaging.sendTrimMessage(player, "Flow", ChatColor.AQUA, message);
    }

    private void createGaleDashAnimation(Player player) {
        Location center = player.getLocation().add(0.0, 1.2, 0.0);
        World world = player.getWorld();
        List<Material> cloudMaterials = List.of(Material.WHITE_WOOL, Material.LIGHT_GRAY_WOOL, Material.WHITE_CONCRETE_POWDER);
        int blocksPerPuff = 6;
        int animationTicks = 40;
        for (int i = 0; i < 6; ++i) {
            ThreadLocalRandom r = ThreadLocalRandom.current();
            final BlockDisplay block = (BlockDisplay)world.spawn(center, BlockDisplay.class, bd -> {
                bd.setBlock(((Material)cloudMaterials.get(r.nextInt(cloudMaterials.size()))).createBlockData());
                bd.setBrightness(new Display.Brightness(10, 10));
                bd.setInterpolationDelay(-1);
                bd.setInterpolationDuration(40);
                Transformation initialTransform = bd.getTransformation();
                initialTransform.getScale().set(r.nextFloat() * 0.4f + 0.2f);
                bd.setTransformation(initialTransform);
            });
            Vector randomOffset = new Vector((r.nextDouble() - 0.5) * 2.5, (r.nextDouble() - 0.5) * 1.5, (r.nextDouble() - 0.5) * 2.5);
            Location finalLocation = center.clone().add(randomOffset).subtract(player.getVelocity().multiply(2.0));
            final Transformation finalTransform = block.getTransformation();
            finalTransform.getScale().set(r.nextFloat() * 1.5f + 0.8f);
            block.teleport(finalLocation);
            new BukkitRunnable(this){
                final /* synthetic */ FlowTrim this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    if (!block.isValid()) {
                        return;
                    }
                    block.setInterpolationDuration(10);
                    finalTransform.getScale().set(0.0f);
                    block.setTransformation(finalTransform);
                    new BukkitRunnable(this){

                        public void run() {
                            block.remove();
                        }
                    }.runTaskLater((Plugin)this.this$0.plugin, 11L);
                }
            }.runTaskLater((Plugin)this.plugin, 30L);
        }
        world.spawnParticle(Particle.CLOUD, center, 20, 0.8, 0.5, 0.8, 0.01);
    }

    @EventHandler
    public void onOffhandPress(PlayerSwapHandItemsEvent event) {
        if (!this.configManager.isTrimEnabled("flow")) {
            return;
        }
        if (event.getPlayer().isSneaking()) {
            event.setCancelled(true);
            this.abilityManager.activatePrimaryAbility(event.getPlayer());
        }
    }

    @EventHandler
    public void onEntityFallDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (event.getCause() == EntityDamageEvent.DamageCause.FALL && this.isDashing.getOrDefault(player.getUniqueId(), false).booleanValue()) {
                event.setCancelled(true);
            } else if (event.getCause() == EntityDamageEvent.DamageCause.FALL && player.getPersistentDataContainer().has(this.dashEndFallImmunityKey, PersistentDataType.BYTE)) {
                event.setCancelled(true);
                player.getPersistentDataContainer().remove(this.dashEndFallImmunityKey);
            }
        }
    }

    public void cleanup() {
        for (UUID playerUUID : this.dashTasks.keySet()) {
            Player player = Bukkit.getPlayer((UUID)playerUUID);
            if (player == null) continue;
            this.deactivateDash(player, "Dash deactivated due to plugin reload.");
        }
        this.dashTasks.clear();
        this.isDashing.clear();
    }
}

