/*
 * Decompiled with CFR 0.152.
 */
package MCplugin.powerTrims.Trims;

import MCplugin.powerTrims.Logic.AbilityManager;
import MCplugin.powerTrims.Logic.ArmourChecking;
import MCplugin.powerTrims.Logic.Messaging;
import MCplugin.powerTrims.Logic.PersistentTrustManager;
import MCplugin.powerTrims.Logic.TrimCooldownManager;
import MCplugin.powerTrims.config.ConfigManager;
import MCplugin.powerTrims.integrations.WorldGuardIntegration;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Transformation;

public class HostTrim
implements Listener {
    private final JavaPlugin plugin;
    private final TrimCooldownManager cooldownManager;
    private final PersistentTrustManager trustManager;
    private final ConfigManager configManager;
    private final AbilityManager abilityManager;
    private final Random random = new Random();
    private final Map<UUID, Set<PotionEffectType>> amplifiedEffectsTracker = new ConcurrentHashMap<UUID, Set<PotionEffectType>>();
    private final long ESSENCE_REAPER_COOLDOWN;
    private final double EFFECT_STEAL_RADIUS;
    private final double HEALTH_STEAL_AMOUNT;
    private static final List<Material> SOUL_MATERIALS = List.of(Material.SOUL_SOIL, Material.SOUL_SAND, Material.SCULK, Material.AMETHYST_BLOCK);
    private static final int MAX_STEALABLE_DURATION = 36000;
    private static final Set<EntityType> BOSS_MOBS = EnumSet.of(EntityType.WARDEN, EntityType.ENDER_DRAGON, EntityType.WITHER);
    private static final Set<PotionEffectType> POSITIVE_EFFECTS = Set.of(PotionEffectType.SPEED, PotionEffectType.REGENERATION, PotionEffectType.STRENGTH, PotionEffectType.FIRE_RESISTANCE, PotionEffectType.RESISTANCE, PotionEffectType.ABSORPTION);

    public HostTrim(JavaPlugin plugin, TrimCooldownManager cooldownManager, PersistentTrustManager trustManager, ConfigManager configManager, AbilityManager abilityManager) {
        this.plugin = plugin;
        this.cooldownManager = cooldownManager;
        this.trustManager = trustManager;
        this.configManager = configManager;
        this.abilityManager = abilityManager;
        this.ESSENCE_REAPER_COOLDOWN = configManager.getLong("host.primary.cooldown");
        this.EFFECT_STEAL_RADIUS = configManager.getDouble("host.primary.effect_steal_radius");
        this.HEALTH_STEAL_AMOUNT = configManager.getDouble("host.primary.health_steal_amount");
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        abilityManager.registerPrimaryAbility(TrimPattern.HOST, this::activateHostPrimary);
    }

    @EventHandler
    public void onPotionEffectEnd(EntityPotionEffectEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (event.getAction() == EntityPotionEffectEvent.Action.REMOVED || event.getAction() == EntityPotionEffectEvent.Action.CLEARED) {
            PotionEffectType type = event.getModifiedType();
            Set<PotionEffectType> trackedEffects = this.amplifiedEffectsTracker.get(player.getUniqueId());
            if (trackedEffects != null && trackedEffects.remove(type) && trackedEffects.isEmpty()) {
                this.amplifiedEffectsTracker.remove(player.getUniqueId());
            }
        }
    }

    @EventHandler
    public void onEntityTarget(EntityTargetLivingEntityEvent event) {
        Player targetPlayer;
        LivingEntity livingEntity;
        block6: {
            block5: {
                livingEntity = event.getTarget();
                if (!(livingEntity instanceof Player)) break block5;
                targetPlayer = (Player)livingEntity;
                livingEntity = event.getEntity();
                if (livingEntity instanceof Mob) break block6;
            }
            return;
        }
        Mob mob = (Mob)livingEntity;
        if (BOSS_MOBS.contains(mob.getType())) {
            return;
        }
        if (ArmourChecking.hasFullTrimmedArmor(targetPlayer, TrimPattern.HOST)) {
            event.setCancelled(true);
            mob.setTarget(null);
        }
    }

    @EventHandler
    public void onOffhandPress(PlayerSwapHandItemsEvent event) {
        if (event.getPlayer().isSneaking()) {
            event.setCancelled(true);
            this.abilityManager.activatePrimaryAbility(event.getPlayer());
        }
    }

    public void activateHostPrimary(Player player) {
        if (!this.configManager.isTrimEnabled("host")) {
            return;
        }
        if (this.cooldownManager.isOnCooldown(player, TrimPattern.HOST) || !ArmourChecking.hasFullTrimmedArmor(player, TrimPattern.HOST)) {
            return;
        }
        if (Bukkit.getPluginManager().isPluginEnabled("WorldGuard") && !WorldGuardIntegration.canUseAbilities(player)) {
            Messaging.sendError((CommandSender)player, "You cannot use this ability in the current region.");
            return;
        }
        Location playerLoc = player.getLocation();
        World world = player.getWorld();
        HashSet<PotionEffectType> stolenThisActivation = new HashSet<PotionEffectType>();
        world.playSound(playerLoc, Sound.ENTITY_VEX_CHARGE, 1.2f, 0.8f);
        world.playSound(playerLoc, Sound.BLOCK_SCULK_SHRIEKER_SHRIEK, 0.8f, 2.0f);
        this.playActivationVortex(player);
        for (Player targetPlayer : world.getNearbyPlayers(playerLoc, this.EFFECT_STEAL_RADIUS)) {
            if (targetPlayer.equals((Object)player) || this.trustManager.isTrusted(player.getUniqueId(), targetPlayer.getUniqueId())) continue;
            for (PotionEffect effect : new ArrayList(targetPlayer.getActivePotionEffects())) {
                PotionEffectType type = effect.getType();
                if (!POSITIVE_EFFECTS.contains(type) || effect.getDuration() >= 36000 || !stolenThisActivation.add(type)) continue;
                targetPlayer.removePotionEffect(type);
                player.addPotionEffect(new PotionEffect(type, effect.getDuration(), effect.getAmplifier() + 1, true, true));
                this.amplifiedEffectsTracker.computeIfAbsent(player.getUniqueId(), k -> ConcurrentHashMap.newKeySet()).add(type);
                this.playSiphonAnimation(targetPlayer.getEyeLocation(), player.getEyeLocation(), 15, Material.AMETHYST_BLOCK);
            }
            double healthToSteal = Math.min(targetPlayer.getHealth() - 1.0, this.HEALTH_STEAL_AMOUNT);
            if (!(healthToSteal > 0.0)) continue;
            targetPlayer.setHealth(targetPlayer.getHealth() - healthToSteal);
            player.setHealth(Math.min(player.getMaxHealth(), player.getHealth() + healthToSteal));
            this.playSiphonAnimation(targetPlayer.getEyeLocation(), player.getEyeLocation(), 10, Material.REDSTONE_BLOCK);
        }
        this.cooldownManager.setCooldown(player, TrimPattern.HOST, this.ESSENCE_REAPER_COOLDOWN);
        Messaging.sendTrimMessage(player, "Host", ChatColor.DARK_PURPLE, "Essence Reaper activated!");
    }

    private void playActivationVortex(Player player) {
        Location center = player.getLocation();
        int particleCount = 40;
        double radius = 3.0;
        for (int i = 0; i < particleCount; ++i) {
            ThreadLocalRandom r = ThreadLocalRandom.current();
            double angle = r.nextDouble(Math.PI * 2);
            Location startLoc = center.clone().add(Math.cos(angle) * radius, r.nextDouble(2.5), Math.sin(angle) * radius);
            Material material = SOUL_MATERIALS.get(r.nextInt(SOUL_MATERIALS.size()));
            final BlockDisplay particle = (BlockDisplay)center.getWorld().spawn(startLoc, BlockDisplay.class, bd -> {
                bd.setBlock(material.createBlockData());
                bd.setInterpolationDuration(25);
                bd.setInterpolationDelay(-1);
                Transformation t = bd.getTransformation();
                t.getScale().set(r.nextFloat() * 0.4f + 0.2f);
                bd.setTransformation(t);
            });
            Location endLoc = player.getEyeLocation().add(r.nextGaussian() * 0.2, r.nextGaussian() * 0.2, r.nextGaussian() * 0.2);
            Transformation endTransform = particle.getTransformation();
            endTransform.getScale().set(0.0f);
            endTransform.getLeftRotation().rotateY((float)Math.PI * 3);
            particle.teleport(endLoc);
            particle.setTransformation(endTransform);
            new BukkitRunnable(this){

                public void run() {
                    particle.remove();
                }
            }.runTaskLater((Plugin)this.plugin, 26L);
        }
    }

    private void playSiphonAnimation(Location start, Location end, int particleCount, Material material) {
        World world = start.getWorld();
        if (world == null) {
            return;
        }
        int travelTicks = 20;
        for (int i = 0; i < particleCount; ++i) {
            final BlockDisplay particle = (BlockDisplay)world.spawn(start, BlockDisplay.class, bd -> {
                bd.setBlock(material.createBlockData());
                bd.setInterpolationDuration(travelTicks);
                bd.setInterpolationDelay(-1);
                Transformation t = bd.getTransformation();
                t.getScale().set(ThreadLocalRandom.current().nextFloat() * 0.2f + 0.1f);
                bd.setTransformation(t);
            });
            Location finalLocation = end.clone().add(ThreadLocalRandom.current().nextGaussian() * 0.5, ThreadLocalRandom.current().nextGaussian() * 0.5, ThreadLocalRandom.current().nextGaussian() * 0.5);
            particle.teleport(finalLocation);
            Transformation finalTransform = particle.getTransformation();
            finalTransform.getScale().set(0.0f);
            particle.setTransformation(finalTransform);
            new BukkitRunnable(this){

                public void run() {
                    particle.remove();
                }
            }.runTaskLater((Plugin)this.plugin, (long)(travelTicks + 1));
        }
    }

    private boolean isEffectAmplifiedByHost(UUID playerUUID, PotionEffectType type) {
        Set<PotionEffectType> trackedEffects = this.amplifiedEffectsTracker.get(playerUUID);
        return trackedEffects != null && trackedEffects.contains(type);
    }
}

