/*
 * Decompiled with CFR 0.152.
 */
package MCplugin.powerTrims.Trims;

import MCplugin.powerTrims.Logic.AbilityManager;
import MCplugin.powerTrims.Logic.ArmourChecking;
import MCplugin.powerTrims.Logic.PersistentTrustManager;
import MCplugin.powerTrims.Logic.TrimCooldownManager;
import MCplugin.powerTrims.config.ConfigManager;
import MCplugin.powerTrims.integrations.WorldGuardIntegration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Bogged;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Transformation;

public class RibTrim
implements Listener {
    private final JavaPlugin plugin;
    private final TrimCooldownManager cooldownManager;
    private final PersistentTrustManager trustManager;
    private final ConfigManager configManager;
    private final AbilityManager abilityManager;
    private final long RIB_COOLDOWN;
    private final long MINION_LIFESPAN_TICKS;
    private static final NamespacedKey OWNER_KEY = new NamespacedKey("powertrims", "owner_uuid");
    private final Map<UUID, LivingEntity> playerTargetMap = new HashMap<UUID, LivingEntity>();
    private final Map<UUID, List<Mob>> playerMinionMap = new HashMap<UUID, List<Mob>>();

    public RibTrim(JavaPlugin plugin, TrimCooldownManager cooldownManager, PersistentTrustManager trustManager, ConfigManager configManager, AbilityManager abilityManager) {
        this.plugin = plugin;
        this.cooldownManager = cooldownManager;
        this.trustManager = trustManager;
        this.configManager = configManager;
        this.abilityManager = abilityManager;
        this.RIB_COOLDOWN = configManager.getLong("rib.primary.cooldown");
        this.MINION_LIFESPAN_TICKS = configManager.getLong("rib.primary.minion_lifespan_ticks");
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        abilityManager.registerPrimaryAbility(TrimPattern.RIB, this::activateRibPrimary);
    }

    public void activateRibPrimary(Player player) {
        if (!this.configManager.isTrimEnabled("rib")) {
            return;
        }
        if (!ArmourChecking.hasFullTrimmedArmor(player, TrimPattern.RIB) || this.cooldownManager.isOnCooldown(player, TrimPattern.RIB)) {
            return;
        }
        if (Bukkit.getPluginManager().isPluginEnabled("WorldGuard") && !WorldGuardIntegration.canUseAbilities(player)) {
            return;
        }
        this.playerMinionMap.putIfAbsent(player.getUniqueId(), new ArrayList());
        int spawnCount = 3;
        for (int i = 0; i < spawnCount; ++i) {
            double angle = Math.toRadians(360.0 / (double)spawnCount * (double)i);
            Location spawnLoc = player.getLocation().clone().add(Math.cos(angle) * 3.0, 0.0, Math.sin(angle) * 3.0);
            this.playSummonAnimation(spawnLoc, finalLocation -> {
                Bogged bogged = this.spawnMinion(player, (Location)finalLocation);
                this.playerMinionMap.get(player.getUniqueId()).add((Mob)bogged);
                LivingEntity currentTarget = this.playerTargetMap.get(player.getUniqueId());
                if (this.isValidTarget((Entity)currentTarget, player)) {
                    bogged.setTarget(currentTarget);
                }
                this.scheduleMinionRemoval((Mob)bogged, this.MINION_LIFESPAN_TICKS);
            });
        }
        this.cooldownManager.setCooldown(player, TrimPattern.RIB, this.RIB_COOLDOWN);
    }

    private void playSummonAnimation(final Location location, final Consumer<Location> onSummonCallback) {
        int pillarHeight = 3;
        int eruptionTicks = 10;
        int staggerDelay = 3;
        final int lingerTicks = 15;
        final ArrayList<BlockDisplay> pillarBlocks = new ArrayList<BlockDisplay>();
        final long totalEruptionTime = (long)(pillarHeight - 1) * (long)staggerDelay + (long)eruptionTicks;
        location.getWorld().playSound(location, Sound.BLOCK_BONE_BLOCK_PLACE, 1.5f, 0.7f);
        new BukkitRunnable(this){
            int ticks = 0;

            public void run() {
                if ((long)this.ticks++ > totalEruptionTime + (long)lingerTicks) {
                    this.cancel();
                    return;
                }
                location.getWorld().spawnParticle(Particle.SOUL, location, 3, 0.5, 0.1, 0.5, 0.01);
                location.getWorld().spawnParticle(Particle.LARGE_SMOKE, location, 1, 0.5, 0.1, 0.5, 0.0);
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 2L);
        for (int i = 0; i < pillarHeight; ++i) {
            final int finalYOffset = i;
            Location startPos = location.clone().add(0.0, (double)(i - pillarHeight), 0.0);
            final BlockDisplay block = (BlockDisplay)location.getWorld().spawn(startPos, BlockDisplay.class, bd -> {
                bd.setBlock(Material.BONE_BLOCK.createBlockData());
                bd.setInterpolationDuration(eruptionTicks);
                bd.setInterpolationDelay(-1);
                Transformation t = bd.getTransformation();
                t.getScale().set(1.0f);
                bd.setTransformation(t);
            });
            pillarBlocks.add(block);
            new BukkitRunnable(this){

                public void run() {
                    if (block.isValid()) {
                        block.teleport(location.clone().add(0.0, (double)finalYOffset, 0.0));
                    }
                }
            }.runTaskLater((Plugin)this.plugin, (long)(i * staggerDelay));
        }
        new BukkitRunnable(this){

            public void run() {
                location.getWorld().playSound(location, Sound.ENTITY_WITHER_SKELETON_HURT, 1.2f, 0.5f);
                location.getWorld().spawnParticle(Particle.SOUL_FIRE_FLAME, location.clone().add(0.0, 1.0, 0.0), 25, 0.5, 0.5, 0.5, 0.05);
                for (BlockDisplay block : pillarBlocks) {
                    if (!block.isValid()) continue;
                    block.getWorld().spawnParticle(Particle.BLOCK, block.getLocation().add(0.0, 0.5, 0.0), 40, 0.5, 0.5, 0.5, (Object)Material.BONE_BLOCK.createBlockData());
                    block.remove();
                }
                onSummonCallback.accept(location);
            }
        }.runTaskLater((Plugin)this.plugin, totalEruptionTime + (long)lingerTicks);
    }

    private void playMinionDespawnAnimation(final Location location) {
        location.getWorld().playSound(location, Sound.BLOCK_BONE_BLOCK_BREAK, 1.0f, 0.8f);
        location.getWorld().spawnParticle(Particle.SOUL, location, 15, 0.3, 0.5, 0.3, 0.05);
        int particleCount = 20;
        int animationTicks = 25;
        for (int i = 0; i < particleCount; ++i) {
            ThreadLocalRandom r = ThreadLocalRandom.current();
            Location startPos = location.clone().add(r.nextGaussian() * 0.5, r.nextGaussian() * 0.8, r.nextGaussian() * 0.5);
            final BlockDisplay particle = (BlockDisplay)location.getWorld().spawn(startPos, BlockDisplay.class, bd -> {
                bd.setBlock(Material.BONE_BLOCK.createBlockData());
                bd.setInterpolationDuration(animationTicks);
                bd.setInterpolationDelay(-1);
                Transformation t = bd.getTransformation();
                t.getScale().set(r.nextFloat() * 0.4f + 0.2f);
                bd.setTransformation(t);
            });
            particle.teleport(location.clone().subtract(0.0, 1.0, 0.0));
            Transformation finalTransform = particle.getTransformation();
            finalTransform.getScale().set(0.0f);
            particle.setTransformation(finalTransform);
            new BukkitRunnable(this){

                public void run() {
                    if (particle.isValid()) {
                        particle.remove();
                    }
                }
            }.runTaskLater((Plugin)this.plugin, (long)(animationTicks + 1));
        }
        new BukkitRunnable(this){

            public void run() {
                location.getWorld().spawnParticle(Particle.SMOKE, location, 10, 0.5, 0.2, 0.5, 0.0);
            }
        }.runTaskLater((Plugin)this.plugin, (long)animationTicks);
    }

    private Bogged spawnMinion(Player owner, Location location) {
        return (Bogged)owner.getWorld().spawn(location, Bogged.class, bogged -> {
            bogged.getPersistentDataContainer().set(OWNER_KEY, PersistentDataType.STRING, (Object)owner.getUniqueId().toString());
            bogged.setCustomName(String.valueOf(ChatColor.WHITE) + "Bone Warrior");
            bogged.setCustomNameVisible(true);
            ItemStack bow = new ItemStack(Material.BOW);
            bow.addUnsafeEnchantment(Enchantment.POWER, 5);
            Optional.of(bogged.getEquipment()).ifPresent(eq -> {
                eq.setItemInMainHand(bow);
                eq.setItemInMainHandDropChance(0.0f);
                eq.setHelmet(new ItemStack(Material.LEATHER_HELMET));
                eq.setHelmetDropChance(0.0f);
            });
            this.applyBuffs((Mob)bogged);
        });
    }

    private void scheduleMinionRemoval(final Mob minion, long ticks) {
        new BukkitRunnable(this){
            final /* synthetic */ RibTrim this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (minion.isValid()) {
                    this.this$0.playMinionDespawnAnimation(minion.getEyeLocation());
                    minion.remove();
                }
            }
        }.runTaskLater((Plugin)this.plugin, ticks);
    }

    @EventHandler
    public void onOwnerAttack(EntityDamageByEntityEvent event) {
        Player owner;
        Entity entity;
        block7: {
            block6: {
                entity = event.getDamager();
                if (!(entity instanceof Player)) break block6;
                owner = (Player)entity;
                entity = event.getEntity();
                if (entity instanceof LivingEntity) break block7;
            }
            return;
        }
        LivingEntity target = (LivingEntity)entity;
        List<Mob> minions = this.playerMinionMap.get(owner.getUniqueId());
        if (minions == null || minions.isEmpty()) {
            return;
        }
        if (!this.isValidTarget((Entity)target, owner)) {
            this.playerTargetMap.remove(owner.getUniqueId());
            return;
        }
        this.playerTargetMap.put(owner.getUniqueId(), target);
        for (Mob minion : minions) {
            if (!minion.isValid()) continue;
            minion.setTarget(target);
        }
    }

    @EventHandler
    public void onOffhandPress(PlayerSwapHandItemsEvent event) {
        if (!this.configManager.isTrimEnabled("rib")) {
            return;
        }
        if (event.getPlayer().isSneaking()) {
            event.setCancelled(true);
            this.abilityManager.activatePrimaryAbility(event.getPlayer());
        }
    }

    @EventHandler
    public void onOwnerDamaged(EntityDamageByEntityEvent event) {
        Player owner;
        Entity entity;
        block7: {
            block6: {
                entity = event.getEntity();
                if (!(entity instanceof Player)) break block6;
                owner = (Player)entity;
                entity = event.getDamager();
                if (entity instanceof LivingEntity) break block7;
            }
            return;
        }
        LivingEntity attacker = (LivingEntity)entity;
        List<Mob> minions = this.playerMinionMap.get(owner.getUniqueId());
        if (minions == null || minions.isEmpty()) {
            return;
        }
        if (this.isValidTarget((Entity)attacker, owner)) {
            this.playerTargetMap.put(owner.getUniqueId(), attacker);
            for (Mob minion : minions) {
                if (!minion.isValid()) continue;
                minion.setTarget(attacker);
            }
        }
    }

    @EventHandler
    public void onMinionTarget(EntityTargetEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob minion = (Mob)entity;
        String ownerUUIDString = (String)minion.getPersistentDataContainer().get(OWNER_KEY, PersistentDataType.STRING);
        if (ownerUUIDString == null) {
            return;
        }
        Player owner = Bukkit.getPlayer((UUID)UUID.fromString(ownerUUIDString));
        if (owner == null) {
            return;
        }
        if (!this.isValidTarget(event.getTarget(), owner)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) {
        LivingEntity deadEntity = event.getEntity();
        String ownerUUIDString = (String)deadEntity.getPersistentDataContainer().get(OWNER_KEY, PersistentDataType.STRING);
        if (ownerUUIDString == null) {
            return;
        }
        UUID ownerUUID = UUID.fromString(ownerUUIDString);
        List<Mob> minions = this.playerMinionMap.get(ownerUUID);
        if (minions != null) {
            minions.remove(deadEntity);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        UUID ownerUUID = event.getPlayer().getUniqueId();
        List<Mob> minions = this.playerMinionMap.remove(ownerUUID);
        if (minions != null) {
            for (Mob minion : minions) {
                if (!minion.isValid()) continue;
                minion.remove();
            }
        }
        this.playerTargetMap.remove(ownerUUID);
    }

    private boolean isValidTarget(Entity target, Player owner) {
        String targetOwnerUUID;
        if (target == null || !target.isValid() || target.equals((Object)owner)) {
            return false;
        }
        if (target instanceof Player) {
            Player targetPlayer = (Player)target;
            if (this.trustManager.isTrusted(owner.getUniqueId(), targetPlayer.getUniqueId())) {
                return false;
            }
        }
        return (targetOwnerUUID = (String)target.getPersistentDataContainer().get(OWNER_KEY, PersistentDataType.STRING)) == null || !targetOwnerUUID.equals(owner.getUniqueId().toString());
    }

    private void applyBuffs(Mob mob) {
        AttributeInstance dmgAttr;
        AttributeInstance healthAttr = mob.getAttribute(Attribute.MAX_HEALTH);
        if (healthAttr != null) {
            healthAttr.setBaseValue(40.0);
            mob.setHealth(40.0);
        }
        if ((dmgAttr = mob.getAttribute(Attribute.ATTACK_DAMAGE)) != null) {
            dmgAttr.setBaseValue(10.0);
        }
    }

    public void cleanup() {
        for (List<Mob> minions : this.playerMinionMap.values()) {
            for (Mob minion : minions) {
                if (!minion.isValid()) continue;
                minion.remove();
            }
        }
        this.playerMinionMap.clear();
        this.playerTargetMap.clear();
    }
}

