/*
 * Decompiled with CFR 0.152.
 */
package MCplugin.powerTrims.Trims;

import MCplugin.powerTrims.Logic.AbilityManager;
import MCplugin.powerTrims.Logic.ArmourChecking;
import MCplugin.powerTrims.Logic.Messaging;
import MCplugin.powerTrims.Logic.PersistentTrustManager;
import MCplugin.powerTrims.Logic.TrimCooldownManager;
import MCplugin.powerTrims.config.ConfigManager;
import MCplugin.powerTrims.integrations.WorldGuardIntegration;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;

public class SentryTrim
implements Listener {
    private final JavaPlugin plugin;
    private final TrimCooldownManager cooldownManager;
    private final PersistentTrustManager trustManager;
    private final ConfigManager configManager;
    private final AbilityManager abilityManager;
    private final NamespacedKey effectKey;
    private final Set<UUID> activeGuards;
    private final int ARROW_COUNT;
    private final double SPREAD;
    private final long COOLDOWN;
    private final double TRUE_DAMAGE;

    public SentryTrim(JavaPlugin plugin, TrimCooldownManager cooldownManager, PersistentTrustManager trustManager, ConfigManager configManager, AbilityManager abilityManager) {
        this.plugin = plugin;
        this.cooldownManager = cooldownManager;
        this.trustManager = trustManager;
        this.configManager = configManager;
        this.abilityManager = abilityManager;
        this.effectKey = new NamespacedKey((Plugin)plugin, "sentry_trim_effect");
        this.activeGuards = new HashSet<UUID>();
        this.ARROW_COUNT = configManager.getInt("sentry.primary.arrow_count");
        this.SPREAD = configManager.getDouble("sentry.primary.spread");
        this.COOLDOWN = configManager.getLong("sentry.primary.cooldown");
        this.TRUE_DAMAGE = configManager.getDouble("sentry.primary.true_damage");
        abilityManager.registerPrimaryAbility(TrimPattern.SENTRY, this::SentryPrimary);
    }

    public void SentryPrimary(Player player) {
        Vector baseDirection;
        if (!this.configManager.isTrimEnabled("sentry")) {
            return;
        }
        if (!ArmourChecking.hasFullTrimmedArmor(player, TrimPattern.SENTRY) || this.cooldownManager.isOnCooldown(player, TrimPattern.SENTRY)) {
            return;
        }
        if (Bukkit.getPluginManager().getPlugin("WorldGuard") != null && !WorldGuardIntegration.canUseAbilities(player)) {
            Messaging.sendError((CommandSender)player, "You cannot use this ability in the current region.");
            return;
        }
        Location eyeLoc = player.getEyeLocation();
        World world = player.getWorld();
        Player sentryUser = player;
        double radius = 15.0;
        LivingEntity nearestTarget = null;
        double nearestDistance = Double.MAX_VALUE;
        for (Entity entity : world.getNearbyEntities(eyeLoc, radius, radius, radius)) {
            double distance;
            if (!(entity instanceof LivingEntity) || entity.equals((Object)sentryUser)) continue;
            if (entity instanceof Player) {
                Player targetPlayer = (Player)entity;
                if (this.trustManager.isTrusted(sentryUser.getUniqueId(), targetPlayer.getUniqueId())) continue;
            }
            if (!((distance = entity.getLocation().distance(eyeLoc)) < nearestDistance)) continue;
            nearestDistance = distance;
            nearestTarget = (LivingEntity)entity;
        }
        if (nearestTarget != null) {
            Location targetLoc = nearestTarget.getLocation().clone().add(0.0, nearestTarget.getHeight() / 2.0, 0.0);
            baseDirection = targetLoc.toVector().subtract(eyeLoc.toVector()).normalize();
        } else {
            baseDirection = eyeLoc.getDirection().clone().normalize();
        }
        for (int i = 0; i < this.ARROW_COUNT; ++i) {
            Vector direction = baseDirection.clone();
            direction.add(new Vector((Math.random() - 0.5) * this.SPREAD, (Math.random() - 0.5) * this.SPREAD, (Math.random() - 0.5) * this.SPREAD));
            direction.normalize().multiply(3);
            SpectralArrow arrow = (SpectralArrow)player.launchProjectile(SpectralArrow.class, direction);
            arrow.setKnockbackStrength(1);
            arrow.setPickupStatus(AbstractArrow.PickupStatus.DISALLOWED);
            arrow.setGlowing(true);
            arrow.getPersistentDataContainer().set(new NamespacedKey((Plugin)this.plugin, "true_damage_arrow"), PersistentDataType.STRING, (Object)player.getUniqueId().toString());
            world.spawnParticle(Particle.CRIT, arrow.getLocation(), 5, 0.1, 0.1, 0.1, 0.05);
            world.playSound(arrow.getLocation(), Sound.ENTITY_ARROW_SHOOT, 1.0f, 1.2f);
        }
        this.createBarrageEffect(player);
        Messaging.sendTrimMessage(player, "Sentry", ChatColor.YELLOW, "Barrage launched!");
        world.playSound(player.getLocation(), Sound.ENTITY_ILLUSIONER_CAST_SPELL, 1.0f, 1.0f);
        this.cooldownManager.setCooldown(player, TrimPattern.SENTRY, this.COOLDOWN);
    }

    @EventHandler
    public void onArrowHit(ProjectileHitEvent event) {
        Projectile projectile = event.getEntity();
        if (!(projectile instanceof SpectralArrow)) {
            return;
        }
        SpectralArrow arrow = (SpectralArrow)projectile;
        Entity entity = event.getHitEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = (LivingEntity)entity;
        String shooterUUID = (String)arrow.getPersistentDataContainer().get(new NamespacedKey((Plugin)this.plugin, "true_damage_arrow"), PersistentDataType.STRING);
        if (shooterUUID == null) {
            return;
        }
        Player shooter = Bukkit.getPlayer((UUID)UUID.fromString(shooterUUID));
        if (shooter == null) {
            return;
        }
        if (target instanceof Player) {
            Player targetPlayer = (Player)target;
            if (this.trustManager.isTrusted(shooter.getUniqueId(), targetPlayer.getUniqueId())) {
                return;
            }
        }
        event.setCancelled(true);
        double newHealth = Math.max(0.0, target.getHealth() - this.TRUE_DAMAGE);
        target.setHealth(newHealth);
        target.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 200, 1, false, true, true));
        target.addPotionEffect(new PotionEffect(PotionEffectType.HUNGER, 600, 1, false, true, true));
        target.getWorld().spawnParticle(Particle.CRIT, target.getLocation().add(0.0, 1.0, 0.0), 10, 0.2, 0.2, 0.2, 0.1);
        target.getWorld().playSound(target.getLocation(), Sound.ENTITY_PLAYER_HURT, 1.0f, 1.0f);
    }

    private void createBarrageEffect(Player player) {
        Location loc = player.getLocation().add(0.0, 1.0, 0.0);
        World world = player.getWorld();
        world.spawnParticle(Particle.EXPLOSION, loc, 1, 0.0, 0.0, 0.0, 0.1);
        int particleCount = 30;
        double radius = 2.0;
        for (int i = 0; i < particleCount; ++i) {
            double angle = Math.PI * 2 / (double)particleCount * (double)i;
            double offsetX = radius * Math.cos(angle);
            double offsetZ = radius * Math.sin(angle);
            Location ringLoc = loc.clone().add(offsetX, 0.0, offsetZ);
            world.spawnParticle(Particle.WITCH, ringLoc, 5, 0.2, 0.2, 0.2, 0.05);
        }
        world.spawnParticle(Particle.CRIT, loc, 20, 0.5, 0.5, 0.5, 0.1);
    }

    @EventHandler
    public void onOffhandPress(PlayerSwapHandItemsEvent event) {
        if (!this.configManager.isTrimEnabled("sentry")) {
            return;
        }
        if (event.getPlayer().isSneaking()) {
            event.setCancelled(true);
            this.abilityManager.activatePrimaryAbility(event.getPlayer());
        }
    }
}

