/*
 * Decompiled with CFR 0.152.
 */
package MCplugin.powerTrims.Trims;

import MCplugin.powerTrims.Logic.AbilityManager;
import MCplugin.powerTrims.Logic.ArmourChecking;
import MCplugin.powerTrims.Logic.Messaging;
import MCplugin.powerTrims.Logic.PersistentTrustManager;
import MCplugin.powerTrims.Logic.TrimCooldownManager;
import MCplugin.powerTrims.config.ConfigManager;
import MCplugin.powerTrims.integrations.WorldGuardIntegration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Transformation;
import org.bukkit.util.Vector;
import org.joml.AxisAngle4f;

public class SilenceTrim
implements Listener {
    private final JavaPlugin plugin;
    private final TrimCooldownManager cooldownManager;
    private final PersistentTrustManager trustManager;
    private final ConfigManager configManager;
    private final AbilityManager abilityManager;
    private final Map<UUID, Long> wardensEchoCooldowns = new HashMap<UUID, Long>();
    private final long WARDENS_ECHO_COOLDOWN_MS;
    private final double PRIMARY_RADIUS;
    private final int POTION_DURATION_TICKS;
    private final int PEARL_COOLDOWN_TICKS;
    private final double ECHO_RADIUS;
    private final int ECHO_EFFECT_DURATION_TICKS;
    private final int MAX_AFFECTED_ENTITIES;
    private final long PRIMARY_COOLDOWN;
    private static final List<Material> SCULK_MATERIALS = List.of(Material.SCULK, Material.SCULK_VEIN, Material.SCULK_CATALYST, Material.DEEPSLATE);

    public SilenceTrim(JavaPlugin plugin, TrimCooldownManager cooldownManager, PersistentTrustManager trustManager, ConfigManager configManager, AbilityManager abilityManager) {
        this.plugin = plugin;
        this.cooldownManager = cooldownManager;
        this.trustManager = trustManager;
        this.configManager = configManager;
        this.abilityManager = abilityManager;
        this.WARDENS_ECHO_COOLDOWN_MS = configManager.getLong("silence.passive.cooldown");
        this.PRIMARY_RADIUS = configManager.getDouble("silence.primary.radius");
        this.POTION_DURATION_TICKS = configManager.getInt("silence.primary.potion_duration_ticks");
        this.PEARL_COOLDOWN_TICKS = configManager.getInt("silence.primary.pearl_cooldown_ticks");
        this.ECHO_RADIUS = configManager.getDouble("silence.passive.echo_radius");
        this.ECHO_EFFECT_DURATION_TICKS = configManager.getInt("silence.passive.effect_duration_ticks");
        this.MAX_AFFECTED_ENTITIES = configManager.getInt("silence.primary.max_affected_entities");
        this.PRIMARY_COOLDOWN = configManager.getLong("silence.primary.cooldown");
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        abilityManager.registerPrimaryAbility(TrimPattern.SILENCE, this::activateSilencePrimary);
    }

    @EventHandler
    public void onOffhandPress(PlayerSwapHandItemsEvent event) {
        if (event.getPlayer().isSneaking()) {
            event.setCancelled(true);
            this.abilityManager.activatePrimaryAbility(event.getPlayer());
        }
    }

    public void activateSilencePrimary(Player player) {
        if (!this.configManager.isTrimEnabled("silence")) {
            return;
        }
        if (!ArmourChecking.hasFullTrimmedArmor(player, TrimPattern.SILENCE) || this.cooldownManager.isOnCooldown(player, TrimPattern.SILENCE)) {
            return;
        }
        if (Bukkit.getPluginManager().isPluginEnabled("WorldGuard") && !WorldGuardIntegration.canUseAbilities(player)) {
            Messaging.sendError((CommandSender)player, "You cannot use this ability in the current region.");
            return;
        }
        this.cooldownManager.setCooldown(player, TrimPattern.SILENCE, this.PRIMARY_COOLDOWN);
        Messaging.sendTrimMessage(player, "Silence", ChatColor.RED, "You have unleashed the Warden's Grasp!");
        ArrayList<LivingEntity> targets = new ArrayList<LivingEntity>();
        int affectedCount = 0;
        for (LivingEntity target : player.getWorld().getNearbyLivingEntities(player.getLocation(), this.PRIMARY_RADIUS)) {
            if (affectedCount >= this.MAX_AFFECTED_ENTITIES) break;
            if (target.equals((Object)player)) continue;
            if (target instanceof Player) {
                Player p = (Player)target;
                if (this.trustManager.isTrusted(player.getUniqueId(), p.getUniqueId())) continue;
            }
            targets.add(target);
            ++affectedCount;
        }
        this.playBackTentaclesAnimation(player);
        if (!targets.isEmpty()) {
            this.playSculkTentacleAnimation(player, targets);
        } else {
            player.getWorld().playSound(player.getLocation(), Sound.ENTITY_WARDEN_ANGRY, 1.5f, 1.8f);
        }
    }

    private void playBackTentaclesAnimation(final Player player) {
        int TENTACLE_COUNT = 5;
        int SEGMENTS_PER_TENTACLE = 8;
        double SEGMENT_LENGTH = 0.25;
        int DURATION_TICKS = 60;
        final ArrayList allTentacles = new ArrayList();
        int INTERPOLATION_TICKS = 3;
        for (int i = 0; i < 5; ++i) {
            ArrayList<BlockDisplay> currentTentacle = new ArrayList<BlockDisplay>();
            int j = 0;
            while (j < 8) {
                int finalJ = j++;
                BlockDisplay segment = (BlockDisplay)player.getWorld().spawn(player.getLocation(), BlockDisplay.class, bd -> {
                    bd.setBlock(Material.SCULK.createBlockData());
                    bd.setInterpolationDuration(3);
                    bd.setInterpolationDelay(-1);
                    Transformation t = bd.getTransformation();
                    t.getScale().set(0.2f - (float)finalJ * 0.01f);
                    bd.setTransformation(t);
                });
                currentTentacle.add(segment);
            }
            allTentacles.add(currentTentacle);
        }
        new BukkitRunnable(this){
            private int ticks = 0;

            public void run() {
                if (this.ticks * 2 > 60 || !player.isValid()) {
                    this.cancel();
                    allTentacles.forEach(tentacle -> tentacle.forEach(Entity::remove));
                    return;
                }
                ++this.ticks;
                Vector backDir = player.getLocation().getDirection().clone().multiply(-1);
                Vector sideDir = backDir.clone().crossProduct(new Vector(0, 1, 0)).normalize();
                Location anchor = player.getLocation().add(backDir.multiply(0.4)).add(0.0, 1.2, 0.0);
                for (int i = 0; i < allTentacles.size(); ++i) {
                    double horizontalOffset = ((double)i - 2.0) * 0.3;
                    Location currentAnchor = anchor.clone().add(sideDir.clone().multiply(horizontalOffset));
                    Vector previousSegmentPos = currentAnchor.toVector();
                    List currentTentacle = (List)allTentacles.get(i);
                    for (int j = 0; j < currentTentacle.size(); ++j) {
                        BlockDisplay segment = (BlockDisplay)currentTentacle.get(j);
                        if (!segment.isValid()) continue;
                        Vector dir = player.getLocation().getDirection().clone().multiply(-1);
                        double wave = Math.sin((double)(this.ticks * 2) * 0.3 + (double)i * 1.5 + (double)j * 0.5) * 0.6;
                        dir.add(sideDir.clone().multiply(wave * 0.5));
                        dir.setY(dir.getY() + Math.cos((double)(this.ticks * 2) * 0.2 + (double)i) * 0.4 - (double)j * 0.05);
                        Vector newPos = previousSegmentPos.clone().add(dir.normalize().multiply(0.25));
                        segment.teleport(newPos.toLocation(player.getWorld()));
                        previousSegmentPos = newPos;
                    }
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 2L);
    }

    private void playSculkTentacleAnimation(final Player player, final List<LivingEntity> targets) {
        int extendTicks = 20;
        int graspTicks = 20;
        final HashMap tendrils = new HashMap();
        final HashMap<LivingEntity, BlockDisplay> chargeSpheres = new HashMap<LivingEntity, BlockDisplay>();
        int INTERPOLATION_TICKS = 4;
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_WARDEN_TENDRIL_CLICKS, 2.0f, 1.2f);
        for (LivingEntity target : targets) {
            BlockDisplay charge = (BlockDisplay)player.getWorld().spawn(player.getEyeLocation(), BlockDisplay.class, bd -> {
                bd.setBlock(Material.SCULK_SHRIEKER.createBlockData());
                bd.setBrightness(new Display.Brightness(15, 15));
                bd.setInterpolationDuration(4);
                bd.setInterpolationDelay(-1);
                Transformation t = bd.getTransformation();
                t.getScale().set(0.4f);
                bd.setTransformation(t);
            });
            chargeSpheres.put(target, charge);
            double distance = player.getLocation().distance(target.getLocation());
            int tendrilLinks = (int)(distance * 2.5);
            ArrayList<BlockDisplay> links = new ArrayList<BlockDisplay>();
            for (int i = 0; i < tendrilLinks; ++i) {
                BlockDisplay link = (BlockDisplay)player.getWorld().spawn(player.getEyeLocation(), BlockDisplay.class, bd -> {
                    bd.setBlock(Material.SCULK.createBlockData());
                    bd.setInterpolationDuration(4);
                    bd.setInterpolationDelay(-1);
                    Transformation t = bd.getTransformation();
                    t.getScale().set(0.25f);
                    bd.setTransformation(t);
                });
                links.add(link);
            }
            tendrils.put(target, links);
        }
        new BukkitRunnable(this){
            private int ticks = 0;
            final /* synthetic */ SilenceTrim this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (this.ticks * 2 >= 40 || !player.isValid()) {
                    this.cancel();
                    return;
                }
                ++this.ticks;
                Location playerAnchor = player.getEyeLocation().add(0.0, -0.5, 0.0);
                for (Map.Entry entry : tendrils.entrySet()) {
                    LivingEntity target = (LivingEntity)entry.getKey();
                    if (!target.isValid()) continue;
                    double extendProgress = Math.min(1.0, (double)(this.ticks * 2) / 20.0);
                    Location targetAnchor = target.getLocation().add(0.0, target.getHeight() / 2.0, 0.0);
                    Vector toTarget = targetAnchor.toVector().subtract(playerAnchor.toVector());
                    List links = (List)entry.getValue();
                    for (int i = 0; i < links.size(); ++i) {
                        BlockDisplay link = (BlockDisplay)links.get(i);
                        if (!link.isValid()) continue;
                        double progress = (double)i / (double)(links.size() - 1);
                        Location linkPos = playerAnchor.clone().add(toTarget.clone().multiply(progress * extendProgress));
                        linkPos.add(0.0, Math.sin((double)(this.ticks * 2) * 0.5 + (double)i * 0.5) * 0.2, 0.0);
                        link.teleport(linkPos);
                    }
                    BlockDisplay charge = (BlockDisplay)chargeSpheres.get(target);
                    if (charge == null || !charge.isValid()) continue;
                    double chargeProgress = (double)(this.ticks * 2) / 40.0;
                    Location chargePos = playerAnchor.clone().add(toTarget.clone().multiply(chargeProgress));
                    charge.teleport(chargePos);
                }
            }

            public synchronized void cancel() throws IllegalStateException {
                super.cancel();
                for (LivingEntity target : targets) {
                    if (!target.isValid()) continue;
                    this.this$0.playSculkExplosion(target.getLocation().add(0.0, target.getHeight() / 2.0, 0.0));
                    this.this$0.applyPrimaryEffects(target);
                    if (!(target instanceof Player)) continue;
                    Player p = (Player)target;
                    p.setCooldown(Material.ENDER_PEARL, this.this$0.PEARL_COOLDOWN_TICKS);
                    this.this$0.sendMessages(p);
                }
                tendrils.values().forEach(list -> list.forEach(Entity::remove));
                chargeSpheres.values().forEach(Entity::remove);
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 2L);
    }

    private void playSculkExplosion(Location location) {
        location.getWorld().playSound(location, Sound.ENTITY_WARDEN_SONIC_BOOM, 1.5f, 1.2f);
        int particleCount = 40;
        int animationTicks = 20;
        final ArrayList<BlockDisplay> shards = new ArrayList<BlockDisplay>(particleCount);
        for (int i = 0; i < particleCount; ++i) {
            ThreadLocalRandom r = ThreadLocalRandom.current();
            BlockDisplay shard = (BlockDisplay)location.getWorld().spawn(location, BlockDisplay.class, bd -> {
                bd.setBlock(SCULK_MATERIALS.get(r.nextInt(SCULK_MATERIALS.size())).createBlockData());
                bd.setInterpolationDuration(animationTicks);
                bd.setInterpolationDelay(-1);
                Transformation t = bd.getTransformation();
                t.getScale().set(r.nextFloat() * 0.7f + 0.4f);
                t.getLeftRotation().set(new AxisAngle4f(r.nextFloat() * 360.0f, r.nextFloat(), r.nextFloat(), r.nextFloat()));
                bd.setTransformation(t);
            });
            shards.add(shard);
            Vector randomVec = new Vector(r.nextDouble() - 0.5, r.nextDouble() - 0.5, r.nextDouble() - 0.5);
            Location finalPos = location.clone().add(randomVec.normalize().multiply(3.0));
            shard.teleport(finalPos);
            Transformation finalTransform = shard.getTransformation();
            finalTransform.getScale().set(0.0f);
            shard.setTransformation(finalTransform);
        }
        new BukkitRunnable(this){

            public void run() {
                for (BlockDisplay shard : shards) {
                    if (!shard.isValid()) continue;
                    shard.remove();
                }
            }
        }.runTaskLater((Plugin)this.plugin, (long)(animationTicks + 5));
    }

    private void playEchoingVengeanceAnimation(Player player) {
        Location center = player.getLocation();
        int particleCount = 70;
        int animationTicks = 30;
        final ArrayList<BlockDisplay> shards = new ArrayList<BlockDisplay>(particleCount);
        for (int i = 0; i < particleCount; ++i) {
            ThreadLocalRandom r = ThreadLocalRandom.current();
            BlockDisplay shard = (BlockDisplay)player.getWorld().spawn(center, BlockDisplay.class, bd -> {
                bd.setBlock(SCULK_MATERIALS.get(r.nextInt(SCULK_MATERIALS.size())).createBlockData());
                bd.setInterpolationDuration(animationTicks);
                bd.setInterpolationDelay(-1);
                Transformation t = bd.getTransformation();
                t.getScale().set(r.nextFloat() * 0.8f + 0.4f);
                t.getLeftRotation().set(new AxisAngle4f(r.nextFloat() * 360.0f, r.nextFloat(), r.nextFloat(), r.nextFloat()));
                bd.setTransformation(t);
            });
            shards.add(shard);
            Location finalPos = center.clone().add(Vector.getRandom().subtract(new Vector(0.5, 0.5, 0.5)).normalize().multiply(this.ECHO_RADIUS));
            shard.teleport(finalPos);
            Transformation finalTransform = shard.getTransformation();
            finalTransform.getScale().set(0.0f);
            shard.setTransformation(finalTransform);
        }
        new BukkitRunnable(this){

            public void run() {
                for (BlockDisplay shard : shards) {
                    if (!shard.isValid()) continue;
                    shard.remove();
                }
            }
        }.runTaskLater((Plugin)this.plugin, (long)(animationTicks + 5));
        Location heartPos = player.getEyeLocation().add(0.0, 1.5, 0.0);
        final BlockDisplay shrieker = (BlockDisplay)player.getWorld().spawn(heartPos, BlockDisplay.class, bd -> {
            bd.setBlock(Material.SCULK_SHRIEKER.createBlockData());
            bd.setInterpolationDuration(10);
            bd.setInterpolationDelay(-1);
            Transformation t = bd.getTransformation();
            t.getScale().set(0.0f);
            bd.setTransformation(t);
        });
        new BukkitRunnable(this){

            public void run() {
                Transformation t = shrieker.getTransformation();
                t.getScale().set(0.8f);
                shrieker.setTransformation(t);
            }
        }.runTaskLater((Plugin)this.plugin, 1L);
        new BukkitRunnable(this){
            final /* synthetic */ SilenceTrim this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (!shrieker.isValid()) {
                    return;
                }
                Transformation t = shrieker.getTransformation();
                t.getScale().set(0.0f);
                shrieker.setTransformation(t);
                new BukkitRunnable(this){

                    public void run() {
                        shrieker.remove();
                    }
                }.runTaskLater((Plugin)this.this$0.plugin, 11L);
            }
        }.runTaskLater((Plugin)this.plugin, (long)this.ECHO_EFFECT_DURATION_TICKS);
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        double healthAfterDamage = player.getHealth() - event.getFinalDamage();
        if (healthAfterDamage > 8.0) {
            return;
        }
        if (!ArmourChecking.hasFullTrimmedArmor(player, TrimPattern.SILENCE)) {
            return;
        }
        if (this.wardensEchoCooldowns.getOrDefault(player.getUniqueId(), 0L) > System.currentTimeMillis()) {
            return;
        }
        this.activateWardensEcho(player);
    }

    private void activateWardensEcho(Player player) {
        Location playerLocation = player.getLocation();
        player.getWorld().playSound(playerLocation, Sound.ENTITY_WARDEN_SONIC_BOOM, 1.5f, 0.6f);
        this.playEchoingVengeanceAnimation(player);
        for (LivingEntity target : player.getWorld().getNearbyLivingEntities(playerLocation, this.ECHO_RADIUS)) {
            if (target.equals((Object)player)) continue;
            if (target instanceof Player) {
                Player targetPlayer = (Player)target;
                if (this.trustManager.isTrusted(player.getUniqueId(), targetPlayer.getUniqueId())) continue;
            }
            this.applyEchoEffects(player, target);
        }
        player.addPotionEffect(new PotionEffect(PotionEffectType.RESISTANCE, this.ECHO_EFFECT_DURATION_TICKS, 1));
        player.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, this.ECHO_EFFECT_DURATION_TICKS, 1));
        Messaging.sendTrimMessage(player, "Silence", ChatColor.RED, "Your armor has unleashed " + String.valueOf(ChatColor.BOLD) + "Warden's Echo!");
        this.wardensEchoCooldowns.put(player.getUniqueId(), System.currentTimeMillis() + this.WARDENS_ECHO_COOLDOWN_MS);
    }

    private void applyPrimaryEffects(LivingEntity target) {
        target.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, this.POTION_DURATION_TICKS, 0));
        target.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, this.POTION_DURATION_TICKS, 1));
        target.addPotionEffect(new PotionEffect(PotionEffectType.HUNGER, 600, 1));
        target.addPotionEffect(new PotionEffect(PotionEffectType.GLOWING, this.POTION_DURATION_TICKS, 1));
    }

    private void applyEchoEffects(Player player, LivingEntity target) {
        Vector knockback = target.getLocation().toVector().subtract(player.getLocation().toVector()).normalize().multiply(1.2);
        knockback.setY(0.5);
        target.setVelocity(knockback);
        target.addPotionEffect(new PotionEffect(PotionEffectType.WEAKNESS, this.ECHO_EFFECT_DURATION_TICKS, 1));
        target.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, this.ECHO_EFFECT_DURATION_TICKS, 1));
        if (target instanceof Player) {
            Player playerTarget = (Player)target;
            Messaging.sendTrimMessage(playerTarget, "Silence", ChatColor.RED, "You were hit by " + String.valueOf(ChatColor.BOLD) + "Warden's Echo!");
        }
    }

    private void sendMessages(Player targetPlayer) {
        Messaging.sendTrimMessage(targetPlayer, "Silence", ChatColor.RED, "You have been hit with the " + String.valueOf(ChatColor.BOLD) + "Warden's Roar!");
        Messaging.sendTrimMessage(targetPlayer, "Silence", ChatColor.RED, "Your Ender Pearl is on cooldown!");
    }
}

