/*
 * Decompiled with CFR 0.152.
 */
package MCplugin.powerTrims.Trims;

import MCplugin.powerTrims.Logic.AbilityManager;
import MCplugin.powerTrims.Logic.ArmourChecking;
import MCplugin.powerTrims.Logic.Messaging;
import MCplugin.powerTrims.Logic.PersistentTrustManager;
import MCplugin.powerTrims.Logic.TrimCooldownManager;
import MCplugin.powerTrims.config.ConfigManager;
import MCplugin.powerTrims.integrations.WorldGuardIntegration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.WitherSkeleton;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Transformation;

public class SnoutTrim
implements Listener {
    private final JavaPlugin plugin;
    private final TrimCooldownManager cooldownManager;
    private final PersistentTrustManager trustManager;
    private final ConfigManager configManager;
    private final AbilityManager abilityManager;
    private final long ROAR_COOLDOWN;
    private final long MINION_LIFESPAN_TICKS;
    private static final NamespacedKey SUMMONER_KEY = new NamespacedKey("powertrims", "snout_summoner_uuid");
    private final Map<UUID, List<WitherSkeleton>> playerMinions = new HashMap<UUID, List<WitherSkeleton>>();

    public SnoutTrim(JavaPlugin plugin, TrimCooldownManager cooldownManager, PersistentTrustManager trustManager, ConfigManager configManager, AbilityManager abilityManager) {
        this.plugin = plugin;
        this.cooldownManager = cooldownManager;
        this.trustManager = trustManager;
        this.configManager = configManager;
        this.abilityManager = abilityManager;
        this.ROAR_COOLDOWN = configManager.getLong("snout.primary.cooldown");
        this.MINION_LIFESPAN_TICKS = configManager.getLong("snout.primary.minion_lifespan_ticks");
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        abilityManager.registerPrimaryAbility(TrimPattern.SNOUT, this::activateSnoutPrimary);
    }

    @EventHandler
    public void onOffhandPress(PlayerSwapHandItemsEvent event) {
        if (event.getPlayer().isSneaking()) {
            event.setCancelled(true);
            this.abilityManager.activatePrimaryAbility(event.getPlayer());
        }
    }

    public void activateSnoutPrimary(final Player player) {
        if (!this.configManager.isTrimEnabled("snout")) {
            return;
        }
        if (!ArmourChecking.hasFullTrimmedArmor(player, TrimPattern.SNOUT) || this.cooldownManager.isOnCooldown(player, TrimPattern.SNOUT)) {
            return;
        }
        if (Bukkit.getPluginManager().isPluginEnabled("WorldGuard") && !WorldGuardIntegration.canUseAbilities(player)) {
            Messaging.sendError((CommandSender)player, "You cannot use this ability in the current region.");
            return;
        }
        this.cooldownManager.setCooldown(player, TrimPattern.SNOUT, this.ROAR_COOLDOWN);
        Messaging.sendTrimMessage(player, "Snout", ChatColor.DARK_RED, "You have summoned your Minions!");
        this.playerMinions.putIfAbsent(player.getUniqueId(), new ArrayList());
        new BukkitRunnable(this){
            private int spawnedCount = 0;
            final /* synthetic */ SnoutTrim this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                int minionsToSpawn = 5;
                if (this.spawnedCount >= minionsToSpawn) {
                    this.cancel();
                    return;
                }
                double angle = Math.toRadians(360.0 / (double)minionsToSpawn * (double)this.spawnedCount);
                Location spawnLoc = player.getLocation().clone().add(Math.cos(angle) * 3.5, 0.0, Math.sin(angle) * 3.5);
                this.this$0.playBlackstonePillarAnimation(spawnLoc, finalLocation -> {
                    WitherSkeleton skeleton = this.this$0.spawnMinion(player, (Location)finalLocation);
                    this.this$0.playerMinions.get(player.getUniqueId()).add(skeleton);
                    this.this$0.scheduleMinionRemoval(skeleton, this.this$0.MINION_LIFESPAN_TICKS);
                });
                ++this.spawnedCount;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 25L);
    }

    private void playBlackstonePillarAnimation(final Location location, final Consumer<Location> onSummonCallback) {
        int pillarHeight = 3;
        int eruptionTicks = 8;
        int staggerDelay = 2;
        final int lingerTicks = 10;
        final ArrayList<BlockDisplay> pillarBlocks = new ArrayList<BlockDisplay>();
        final long totalEruptionTime = (long)(pillarHeight - 1) * (long)staggerDelay + (long)eruptionTicks;
        location.getWorld().playSound(location, Sound.BLOCK_BASALT_BREAK, 1.5f, 0.7f);
        new BukkitRunnable(this){
            int ticks = 0;

            public void run() {
                if ((long)this.ticks++ > totalEruptionTime + (long)lingerTicks) {
                    this.cancel();
                    return;
                }
                location.getWorld().spawnParticle(Particle.FLAME, location, 2, 0.5, 0.1, 0.5, 0.01);
                location.getWorld().spawnParticle(Particle.LARGE_SMOKE, location, 1, 0.5, 0.1, 0.5, 0.0);
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 2L);
        for (int i = 0; i < pillarHeight; ++i) {
            final int finalYOffset = i;
            Location startPos = location.clone().add(0.0, (double)(i - pillarHeight), 0.0);
            final BlockDisplay block = (BlockDisplay)location.getWorld().spawn(startPos, BlockDisplay.class, bd -> {
                bd.setBlock(Material.BLACKSTONE.createBlockData());
                bd.setInterpolationDuration(eruptionTicks);
                bd.setInterpolationDelay(-1);
                Transformation t = bd.getTransformation();
                t.getScale().set(1.0f);
                bd.setTransformation(t);
            });
            pillarBlocks.add(block);
            new BukkitRunnable(this){

                public void run() {
                    if (block.isValid()) {
                        block.teleport(location.clone().add(0.0, (double)finalYOffset, 0.0));
                    }
                }
            }.runTaskLater((Plugin)this.plugin, (long)(i * staggerDelay));
        }
        new BukkitRunnable(this){

            public void run() {
                location.getWorld().playSound(location, Sound.ENTITY_WITHER_SKELETON_HURT, 1.2f, 0.8f);
                location.getWorld().spawnParticle(Particle.LAVA, location, 10, 0.3, 0.1, 0.3, 0.0);
                for (BlockDisplay block : pillarBlocks) {
                    if (!block.isValid()) continue;
                    block.getWorld().spawnParticle(Particle.BLOCK, block.getLocation().add(0.0, 0.5, 0.0), 40, 0.5, 0.5, 0.5, (Object)Material.BLACKSTONE.createBlockData());
                    block.remove();
                }
                onSummonCallback.accept(location);
            }
        }.runTaskLater((Plugin)this.plugin, totalEruptionTime + (long)lingerTicks);
    }

    private void playMinionDespawnAnimation(final Location location) {
        location.getWorld().playSound(location, Sound.BLOCK_NETHERRACK_BREAK, 1.0f, 0.8f);
        location.getWorld().spawnParticle(Particle.SOUL, location, 15, 0.3, 0.5, 0.3, 0.05);
        int particleCount = 20;
        int animationTicks = 25;
        for (int i = 0; i < particleCount; ++i) {
            ThreadLocalRandom r = ThreadLocalRandom.current();
            Location startPos = location.clone().add(r.nextGaussian() * 0.5, r.nextGaussian() * 0.8, r.nextGaussian() * 0.5);
            final BlockDisplay particle = (BlockDisplay)location.getWorld().spawn(startPos, BlockDisplay.class, bd -> {
                bd.setBlock(Material.BLACKSTONE.createBlockData());
                bd.setInterpolationDuration(animationTicks);
                bd.setInterpolationDelay(-1);
                Transformation t = bd.getTransformation();
                t.getScale().set(r.nextFloat() * 0.4f + 0.2f);
                bd.setTransformation(t);
            });
            particle.teleport(location.clone().subtract(0.0, 1.0, 0.0));
            Transformation finalTransform = particle.getTransformation();
            finalTransform.getScale().set(0.0f);
            particle.setTransformation(finalTransform);
            new BukkitRunnable(this){

                public void run() {
                    if (particle.isValid()) {
                        particle.remove();
                    }
                }
            }.runTaskLater((Plugin)this.plugin, (long)(animationTicks + 1));
        }
        new BukkitRunnable(this){

            public void run() {
                location.getWorld().spawnParticle(Particle.SMOKE, location, 10, 0.5, 0.2, 0.5, 0.0);
            }
        }.runTaskLater((Plugin)this.plugin, (long)animationTicks);
    }

    private WitherSkeleton spawnMinion(Player owner, Location location) {
        return (WitherSkeleton)owner.getWorld().spawn(location, WitherSkeleton.class, skel -> {
            skel.getPersistentDataContainer().set(SUMMONER_KEY, PersistentDataType.STRING, (Object)owner.getUniqueId().toString());
            skel.setCustomName(String.valueOf(ChatColor.DARK_GRAY) + "Necromancer's Minion");
            skel.setCustomNameVisible(true);
            skel.setCollidable(false);
            skel.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, Integer.MAX_VALUE, 1));
            skel.addPotionEffect(new PotionEffect(PotionEffectType.FIRE_RESISTANCE, Integer.MAX_VALUE, 0));
            skel.addPotionEffect(new PotionEffect(PotionEffectType.RESISTANCE, Integer.MAX_VALUE, 1));
            Optional.of(skel.getEquipment()).ifPresent(eq -> {
                eq.setItemInMainHand(new ItemStack(Material.STONE_SWORD));
                eq.setItemInMainHandDropChance(0.0f);
            });
        });
    }

    @EventHandler
    public void onEntityDamage(EntityDamageByEntityEvent event) {
        List<WitherSkeleton> minions;
        if (!(event.getEntity() instanceof LivingEntity)) {
            return;
        }
        Player owner = null;
        LivingEntity target = null;
        if (event.getDamager() instanceof Player) {
            owner = (Player)event.getDamager();
            target = (LivingEntity)event.getEntity();
        } else if (event.getEntity() instanceof Player && event.getDamager() instanceof LivingEntity) {
            owner = (Player)event.getEntity();
            target = (LivingEntity)event.getDamager();
        }
        if (owner != null && (minions = this.playerMinions.get(owner.getUniqueId())) != null && !minions.isEmpty() && this.isValidTarget((Entity)target, owner)) {
            for (WitherSkeleton minion : minions) {
                if (!minion.isValid()) continue;
                minion.setTarget(target);
            }
        }
    }

    @EventHandler
    public void onMinionInitialTarget(EntityTargetLivingEntityEvent event) {
        WitherSkeleton minion;
        block6: {
            block5: {
                Entity entity = event.getEntity();
                if (!(entity instanceof WitherSkeleton)) break block5;
                minion = (WitherSkeleton)entity;
                if (event.getTarget() != null) break block6;
            }
            return;
        }
        String ownerUUIDString = (String)minion.getPersistentDataContainer().get(SUMMONER_KEY, PersistentDataType.STRING);
        if (ownerUUIDString == null) {
            return;
        }
        Player owner = Bukkit.getPlayer((UUID)UUID.fromString(ownerUUIDString));
        if (owner != null && !this.isValidTarget((Entity)event.getTarget(), owner)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onMinionDeath(EntityDeathEvent event) {
        UUID ownerUUID;
        List<WitherSkeleton> minions;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof WitherSkeleton)) {
            return;
        }
        WitherSkeleton minion = (WitherSkeleton)livingEntity;
        String ownerUUIDString = (String)minion.getPersistentDataContainer().get(SUMMONER_KEY, PersistentDataType.STRING);
        if (ownerUUIDString != null && (minions = this.playerMinions.get(ownerUUID = UUID.fromString(ownerUUIDString))) != null) {
            minions.remove(minion);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        UUID playerUUID = event.getPlayer().getUniqueId();
        List<WitherSkeleton> minions = this.playerMinions.remove(playerUUID);
        if (minions != null) {
            for (WitherSkeleton minion : minions) {
                if (!minion.isValid()) continue;
                minion.remove();
            }
        }
    }

    private void scheduleMinionRemoval(final WitherSkeleton minion, long ticks) {
        new BukkitRunnable(this){
            final /* synthetic */ SnoutTrim this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (minion.isValid()) {
                    this.this$0.playMinionDespawnAnimation(minion.getLocation());
                    minion.remove();
                }
            }
        }.runTaskLater((Plugin)this.plugin, ticks);
    }

    private boolean isValidTarget(Entity target, Player owner) {
        if (target == null || !target.isValid() || target.equals((Object)owner)) {
            return false;
        }
        if (target instanceof Player && this.trustManager.isTrusted(owner.getUniqueId(), target.getUniqueId())) {
            return false;
        }
        String targetOwnerUUID = (String)target.getPersistentDataContainer().get(SUMMONER_KEY, PersistentDataType.STRING);
        return targetOwnerUUID == null || !targetOwnerUUID.equals(owner.getUniqueId().toString());
    }
}

