/*
 * Decompiled with CFR 0.152.
 */
package MCplugin.powerTrims.Trims;

import MCplugin.powerTrims.Logic.AbilityManager;
import MCplugin.powerTrims.Logic.ArmourChecking;
import MCplugin.powerTrims.Logic.Messaging;
import MCplugin.powerTrims.Logic.PersistentTrustManager;
import MCplugin.powerTrims.Logic.TrimCooldownManager;
import MCplugin.powerTrims.config.ConfigManager;
import MCplugin.powerTrims.integrations.WorldGuardIntegration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Transformation;
import org.bukkit.util.Vector;
import org.joml.AxisAngle4f;

public class SpireTrim
implements Listener {
    private final JavaPlugin plugin;
    private final TrimCooldownManager cooldownManager;
    private final PersistentTrustManager trustManager;
    private final AbilityManager abilityManager;
    private final Set<UUID> markedTargets;
    private final Set<UUID> dashingPlayers;
    private final ConfigManager configManager;
    private final double DASH_DISTANCE;
    private final double DASH_SPEED;
    private final double KNOCKBACK_STRENGTH;
    private final int SLOW_DURATION;
    private final int VULNERABLE_DURATION;
    private final double DAMAGE_AMPLIFICATION;
    private final long ABILITY_COOLDOWN;
    private static final List<Material> TRAIL_MATERIALS = List.of(Material.ICE, Material.PACKED_ICE, Material.PRISMARINE_BRICKS);
    private static final List<Material> SHATTER_MATERIALS = List.of(Material.GLASS, Material.LIGHT_BLUE_STAINED_GLASS, Material.CYAN_STAINED_GLASS);

    public SpireTrim(JavaPlugin plugin, TrimCooldownManager cooldownManager, PersistentTrustManager trustManager, ConfigManager configManager, AbilityManager abilityManager) {
        this.plugin = plugin;
        this.cooldownManager = cooldownManager;
        this.trustManager = trustManager;
        this.configManager = configManager;
        this.abilityManager = abilityManager;
        this.markedTargets = new HashSet<UUID>();
        this.dashingPlayers = new HashSet<UUID>();
        this.DASH_DISTANCE = configManager.getDouble("spire.primary.dash_distance");
        this.DASH_SPEED = configManager.getDouble("spire.primary.dash_speed");
        this.KNOCKBACK_STRENGTH = configManager.getDouble("spire.primary.knockback_strength");
        this.SLOW_DURATION = configManager.getInt("spire.primary.slow_duration");
        this.VULNERABLE_DURATION = configManager.getInt("spire.primary.vulnerable_duration");
        this.DAMAGE_AMPLIFICATION = configManager.getDouble("spire.primary.damage_amplification");
        this.ABILITY_COOLDOWN = configManager.getLong("spire.primary.cooldown");
        abilityManager.registerPrimaryAbility(TrimPattern.SPIRE, this::spirePrimary);
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    public void spirePrimary(final Player player) {
        if (!this.configManager.isTrimEnabled("spire")) {
            return;
        }
        if (this.dashingPlayers.contains(player.getUniqueId())) {
            return;
        }
        if (Bukkit.getPluginManager().isPluginEnabled("WorldGuard") && !WorldGuardIntegration.canUseAbilities(player)) {
            Messaging.sendError((CommandSender)player, "You cannot use this ability in the current region.");
            return;
        }
        if (!ArmourChecking.hasFullTrimmedArmor(player, TrimPattern.SPIRE) || this.cooldownManager.isOnCooldown(player, TrimPattern.SPIRE)) {
            return;
        }
        final Location startLoc = player.getLocation();
        final Vector direction = player.getLocation().getDirection().normalize();
        player.getWorld().playSound(startLoc, Sound.ITEM_TRIDENT_RIPTIDE_3, 1.0f, 1.8f);
        final UUID playerId = player.getUniqueId();
        this.dashingPlayers.add(playerId);
        player.setInvulnerable(true);
        player.setVelocity(direction.multiply(this.DASH_SPEED));
        final ArrayList<BlockDisplay> vortexBlocks = new ArrayList<BlockDisplay>();
        int VORTEX_ARMS = 3;
        int BLOCKS_PER_ARM = 4;
        double VORTEX_RADIUS = 1.2;
        ThreadLocalRandom r = ThreadLocalRandom.current();
        for (int i = 0; i < 12; ++i) {
            BlockDisplay vortexBlock = (BlockDisplay)player.getWorld().spawn(player.getLocation(), BlockDisplay.class, bd -> {
                bd.setBlock(TRAIL_MATERIALS.get(r.nextInt(TRAIL_MATERIALS.size())).createBlockData());
                Transformation t = bd.getTransformation();
                t.getScale().set(0.4f);
                bd.setTransformation(t);
            });
            vortexBlocks.add(vortexBlock);
        }
        new BukkitRunnable(this){
            private double distanceTraveled = 0.0;
            private int animationTick = 0;
            private Location lastLoc = startLoc.clone();
            private final Set<Entity> hitEntities = new HashSet<Entity>();
            final /* synthetic */ SpireTrim this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (!player.isOnline() || this.distanceTraveled >= this.this$0.DASH_DISTANCE) {
                    this.endDash();
                    return;
                }
                Location currentLoc = player.getLocation();
                this.distanceTraveled += this.lastLoc.distance(currentLoc);
                Location center = player.getLocation().add(0.0, 1.0, 0.0);
                double rotation = Math.toRadians(this.animationTick * 25);
                for (int i = 0; i < vortexBlocks.size(); ++i) {
                    BlockDisplay block = (BlockDisplay)vortexBlocks.get(i);
                    if (!block.isValid()) continue;
                    double armOffset = (double)(i % 3) / 3.0 * (Math.PI * 2);
                    double yOffset = ((double)(i / 3) / 4.0 - 0.5) * 2.0;
                    double currentAngle = rotation + armOffset + this.distanceTraveled * 2.0;
                    double x = Math.cos(currentAngle) * 1.2;
                    double z = Math.sin(currentAngle) * 1.2;
                    block.teleport(center.clone().add(x, yOffset, z));
                }
                ++this.animationTick;
                for (Entity entity : currentLoc.getWorld().getNearbyEntities(currentLoc, 1.5, 1.5, 1.5)) {
                    if (!(entity instanceof LivingEntity) || entity.equals((Object)player) || !this.hitEntities.add(entity)) continue;
                    this.this$0.handleEntityCollision((LivingEntity)entity, direction, player);
                }
                this.lastLoc = currentLoc;
            }

            private void endDash() {
                this.this$0.dashingPlayers.remove(playerId);
                player.setInvulnerable(false);
                player.setVelocity(player.getVelocity().multiply(0.1));
                this.this$0.cooldownManager.setCooldown(player, TrimPattern.SPIRE, this.this$0.ABILITY_COOLDOWN);
                vortexBlocks.forEach(Entity::remove);
                this.cancel();
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    private void handleEntityCollision(final LivingEntity target, Vector dashDirection, Player damager) {
        if (target instanceof Player) {
            Player p = (Player)target;
            if (this.trustManager.isTrusted(damager.getUniqueId(), p.getUniqueId())) {
                return;
            }
        }
        Vector knockbackVec = dashDirection.clone().multiply(this.KNOCKBACK_STRENGTH).setY(0.4);
        target.setVelocity(knockbackVec);
        target.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, this.SLOW_DURATION, 1));
        target.setGlowing(true);
        this.playShatterNovaAnimation(target.getLocation().add(0.0, target.getHeight() / 2.0, 0.0));
        final UUID targetId = target.getUniqueId();
        this.markedTargets.add(targetId);
        new BukkitRunnable(this){
            final /* synthetic */ SpireTrim this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                this.this$0.markedTargets.remove(targetId);
                if (target.isValid()) {
                    target.setGlowing(false);
                }
            }
        }.runTaskLater((Plugin)this.plugin, (long)this.VULNERABLE_DURATION);
    }

    private void playShatterNovaAnimation(Location location) {
        location.getWorld().playSound(location, Sound.BLOCK_GLASS_BREAK, 1.5f, 1.2f);
        int particleCount = 25;
        int animationTicks = 18;
        for (int i = 0; i < particleCount; ++i) {
            ThreadLocalRandom r = ThreadLocalRandom.current();
            final BlockDisplay shard = (BlockDisplay)location.getWorld().spawn(location, BlockDisplay.class, bd -> {
                bd.setBlock(SHATTER_MATERIALS.get(r.nextInt(SHATTER_MATERIALS.size())).createBlockData());
                bd.setInterpolationDuration(animationTicks);
                bd.setInterpolationDelay(-1);
                Transformation t = bd.getTransformation();
                t.getScale().set(r.nextFloat() * 0.6f + 0.3f);
                t.getLeftRotation().set(new AxisAngle4f(r.nextFloat() * 360.0f, r.nextFloat(), r.nextFloat(), r.nextFloat()));
                bd.setTransformation(t);
            });
            Location endPos = location.clone().add(Vector.getRandom().subtract(new Vector(0.5, 0.5, 0.5)).normalize().multiply(3));
            shard.teleport(endPos);
            Transformation finalTransform = shard.getTransformation();
            finalTransform.getScale().set(0.0f);
            shard.setTransformation(finalTransform);
            new BukkitRunnable(this){

                public void run() {
                    if (shard.isValid()) {
                        shard.remove();
                    }
                }
            }.runTaskLater((Plugin)this.plugin, (long)(animationTicks + 1));
        }
    }

    private void playResonanceImplosionAnimation(Location location) {
        location.getWorld().playSound(location, Sound.BLOCK_AMETHYST_BLOCK_CHIME, 2.0f, 1.5f);
        int particleCount = 12;
        int animationTicks = 10;
        double radius = 1.5;
        for (int i = 0; i < particleCount; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)particleCount;
            Location startPos = location.clone().add(Math.cos(angle) * radius, 0.0, Math.sin(angle) * radius);
            final BlockDisplay crystal = (BlockDisplay)location.getWorld().spawn(startPos, BlockDisplay.class, bd -> {
                bd.setBlock(Material.AMETHYST_BLOCK.createBlockData());
                bd.setInterpolationDuration(animationTicks);
                bd.setInterpolationDelay(-1);
                Transformation t = bd.getTransformation();
                t.getScale().set(0.5f);
                bd.setTransformation(t);
            });
            crystal.teleport(location);
            Transformation finalTransform = crystal.getTransformation();
            finalTransform.getScale().set(0.0f);
            crystal.setTransformation(finalTransform);
            new BukkitRunnable(this){

                public void run() {
                    if (crystal.isValid()) {
                        crystal.remove();
                    }
                }
            }.runTaskLater((Plugin)this.plugin, (long)(animationTicks + 1));
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageByEntityEvent event) {
        Player player;
        Entity entity;
        block8: {
            block7: {
                entity = event.getDamager();
                if (!(entity instanceof Player)) break block7;
                player = (Player)entity;
                entity = event.getEntity();
                if (entity instanceof LivingEntity) break block8;
            }
            return;
        }
        LivingEntity target = (LivingEntity)entity;
        if (this.markedTargets.remove(target.getUniqueId())) {
            if (target instanceof Player) {
                Player p = (Player)target;
                if (this.trustManager.isTrusted(player.getUniqueId(), p.getUniqueId())) {
                    return;
                }
            }
            event.setDamage(event.getDamage() * (1.0 + this.DAMAGE_AMPLIFICATION));
            if (target.isValid()) {
                target.setGlowing(false);
            }
            this.playResonanceImplosionAnimation(target.getLocation().add(0.0, target.getHeight() / 2.0, 0.0));
        }
    }

    @EventHandler
    public void onEntityFallDamage(EntityDamageEvent event) {
        Player player;
        Entity entity = event.getEntity();
        if (entity instanceof Player && this.dashingPlayers.contains((player = (Player)entity).getUniqueId()) && event.getCause() == EntityDamageEvent.DamageCause.FALL) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onOffhandPress(PlayerSwapHandItemsEvent event) {
        if (!this.configManager.isTrimEnabled("spire")) {
            return;
        }
        if (event.getPlayer().isSneaking()) {
            event.setCancelled(true);
            this.abilityManager.activatePrimaryAbility(event.getPlayer());
        }
    }
}

