/*
 * Decompiled with CFR 0.152.
 */
package MCplugin.powerTrims.Trims;

import MCplugin.powerTrims.Logic.AbilityManager;
import MCplugin.powerTrims.Logic.ArmourChecking;
import MCplugin.powerTrims.Logic.Messaging;
import MCplugin.powerTrims.Logic.PersistentTrustManager;
import MCplugin.powerTrims.Logic.TrimCooldownManager;
import MCplugin.powerTrims.config.ConfigManager;
import MCplugin.powerTrims.integrations.WorldGuardIntegration;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class TideTrim
implements Listener {
    private final JavaPlugin plugin;
    private final TrimCooldownManager cooldownManager;
    private final PersistentTrustManager trustManager;
    private final ConfigManager configManager;
    private final AbilityManager abilityManager;
    private final long TIDE_COOLDOWN;
    private final double WAVE_WIDTH;
    private final int EFFECT_DURATION_TICKS;
    private final double KNOCKBACK_STRENGTH;
    private final int WALL_HEIGHT;
    private final int MOVE_DELAY_TICKS;
    private final int MAX_MOVES;

    public TideTrim(JavaPlugin plugin, TrimCooldownManager cooldownManager, PersistentTrustManager trustManager, ConfigManager configManager, AbilityManager abilityManager) {
        this.plugin = plugin;
        this.cooldownManager = cooldownManager;
        this.trustManager = trustManager;
        this.configManager = configManager;
        this.abilityManager = abilityManager;
        this.TIDE_COOLDOWN = configManager.getLong("tide.primary.cooldown");
        this.WAVE_WIDTH = configManager.getDouble("tide.primary.wave_width");
        this.EFFECT_DURATION_TICKS = configManager.getInt("tide.primary.effect_duration_ticks");
        this.KNOCKBACK_STRENGTH = configManager.getDouble("tide.primary.knockback_strength");
        this.WALL_HEIGHT = configManager.getInt("tide.primary.wall_height");
        this.MOVE_DELAY_TICKS = configManager.getInt("tide.primary.move_delay_ticks");
        this.MAX_MOVES = configManager.getInt("tide.primary.max_moves");
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        abilityManager.registerPrimaryAbility(TrimPattern.TIDE, this::activateTidePrimary);
    }

    @EventHandler
    public void onOffhandPress(PlayerSwapHandItemsEvent event) {
        if (event.getPlayer().isSneaking()) {
            event.setCancelled(true);
            this.abilityManager.activatePrimaryAbility(event.getPlayer());
        }
    }

    public void activateTidePrimary(final Player player) {
        if (!this.configManager.isTrimEnabled("tide")) {
            return;
        }
        if (Bukkit.getPluginManager().getPlugin("WorldGuard") != null && !WorldGuardIntegration.canUseAbilities(player)) {
            Messaging.sendError((CommandSender)player, "You cannot use this ability in the current region.");
            return;
        }
        if (!ArmourChecking.hasFullTrimmedArmor(player, TrimPattern.TIDE) || this.cooldownManager.isOnCooldown(player, TrimPattern.TIDE)) {
            return;
        }
        final Location startLoc = player.getLocation();
        final Vector direction = startLoc.getDirection().setY(0).normalize();
        final World world = player.getWorld();
        world.playSound(startLoc, Sound.ENTITY_GENERIC_SPLASH, 2.0f, 0.5f);
        world.playSound(startLoc, Sound.BLOCK_WATER_AMBIENT, 2.0f, 1.0f);
        final Vector perpendicular = new Vector(-direction.getZ(), 0.0, direction.getX());
        new BukkitRunnable(this){
            private int moves = 0;
            private final Location currentLoc = startLoc.clone();
            private final Set<Block> previousWaterBlocks = new HashSet<Block>();
            private final Set<Block> currentWaterBlocks = new HashSet<Block>();
            final /* synthetic */ TideTrim this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                this.this$0.clearWaterBlocks(this.previousWaterBlocks, world);
                this.previousWaterBlocks.clear();
                this.previousWaterBlocks.addAll(this.currentWaterBlocks);
                this.currentWaterBlocks.clear();
                if (this.moves >= this.this$0.MAX_MOVES) {
                    this.this$0.clearWaterBlocks(this.previousWaterBlocks, world);
                    world.playSound(this.currentLoc, Sound.WEATHER_RAIN, 1.5f, 1.0f);
                    this.cancel();
                    return;
                }
                this.currentLoc.add(direction);
                block0: for (double w = -this.this$0.WAVE_WIDTH; w <= this.this$0.WAVE_WIDTH; w += 0.8) {
                    Location wallBaseLoc = this.currentLoc.clone().add(perpendicular.clone().multiply(w));
                    for (int h = 0; h < this.this$0.WALL_HEIGHT; ++h) {
                        Block block = wallBaseLoc.clone().add(0.0, (double)h, 0.0).getBlock();
                        if (block.getType().isAir()) {
                            block.setType(Material.WATER, false);
                            this.currentWaterBlocks.add(block);
                            continue;
                        }
                        if (block.getType().isSolid()) continue block0;
                        block.setType(Material.WATER, false);
                        this.currentWaterBlocks.add(block);
                    }
                }
                for (LivingEntity target : world.getNearbyLivingEntities(this.currentLoc, this.this$0.WAVE_WIDTH + 1.5, (double)this.this$0.WALL_HEIGHT, this.this$0.WAVE_WIDTH + 1.5)) {
                    if (target.equals((Object)player)) continue;
                    if (target instanceof Player) {
                        Player targetPlayer = (Player)target;
                        if (this.this$0.trustManager.isTrusted(player.getUniqueId(), targetPlayer.getUniqueId())) continue;
                    }
                    Vector knockback = direction.clone().multiply(this.this$0.KNOCKBACK_STRENGTH);
                    knockback.setY(0.4);
                    target.setVelocity(knockback);
                    target.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, this.this$0.EFFECT_DURATION_TICKS, 1));
                    world.spawnParticle(Particle.SPLASH, target.getLocation(), 15, 0.4, 1.0, 0.4, 0.2);
                    world.playSound(target.getLocation(), Sound.ENTITY_PLAYER_SPLASH, 1.0f, 1.2f);
                }
                world.playSound(this.currentLoc, Sound.BLOCK_WATER_AMBIENT, 0.8f, 1.2f);
                ++this.moves;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, (long)this.MOVE_DELAY_TICKS);
        Messaging.sendTrimMessage(player, "Tide", ChatColor.AQUA, "You have summoned a massive tidal wall!");
        this.cooldownManager.setCooldown(player, TrimPattern.TIDE, this.TIDE_COOLDOWN);
    }

    private void clearWaterBlocks(Set<Block> blocks, World world) {
        for (Block block : blocks) {
            if (block.getType() != Material.WATER) continue;
            block.setType(Material.AIR);
            world.spawnParticle(Particle.SPLASH, block.getLocation().add(0.5, 0.5, 0.5), 5, 0.3, 0.3, 0.3, 0.01);
        }
    }
}

