/*
 * Decompiled with CFR 0.152.
 */
package MCplugin.powerTrims.Trims;

import MCplugin.powerTrims.Logic.AbilityManager;
import MCplugin.powerTrims.Logic.ArmourChecking;
import MCplugin.powerTrims.Logic.Messaging;
import MCplugin.powerTrims.Logic.PersistentTrustManager;
import MCplugin.powerTrims.Logic.TrimCooldownManager;
import MCplugin.powerTrims.config.ConfigManager;
import MCplugin.powerTrims.integrations.WorldGuardIntegration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class VexTrim
implements Listener {
    private final JavaPlugin plugin;
    private final TrimCooldownManager cooldownManager;
    private final PersistentTrustManager trustManager;
    private final ConfigManager configManager;
    private final AbilityManager abilityManager;
    private final Map<UUID, Long> passiveCooldowns = new HashMap<UUID, Long>();
    private final Set<UUID> hiddenPlayers = new HashSet<UUID>();
    private final long PRIMARY_COOLDOWN;
    private final double PRIMARY_RADIUS;
    private final double PRIMARY_DAMAGE;
    private final int PRIMARY_DEBUFF_DURATION;
    private final int PRIMARY_BLINDNESS_DURATION;
    private final long PASSIVE_COOLDOWN;
    private final long PASSIVE_HIDE_DURATION_TICKS;
    private final double PASSIVE_HEALTH_THRESHOLD;

    public VexTrim(JavaPlugin plugin, TrimCooldownManager cooldownManager, PersistentTrustManager trustManager, ConfigManager configManager, AbilityManager abilityManager) {
        this.plugin = plugin;
        this.cooldownManager = cooldownManager;
        this.trustManager = trustManager;
        this.configManager = configManager;
        this.abilityManager = abilityManager;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.PRIMARY_COOLDOWN = configManager.getLong("vex.primary.cooldown");
        this.PRIMARY_RADIUS = configManager.getDouble("vex.primary.radius");
        this.PRIMARY_DAMAGE = configManager.getDouble("vex.primary.damage");
        this.PRIMARY_DEBUFF_DURATION = configManager.getInt("vex.primary.debuff_duration_ticks");
        this.PRIMARY_BLINDNESS_DURATION = configManager.getInt("vex.primary.blindness_duration_ticks");
        this.PASSIVE_COOLDOWN = configManager.getLong("vex.passive.cooldown");
        this.PASSIVE_HIDE_DURATION_TICKS = configManager.getLong("vex.passive.hide_duration_ticks");
        this.PASSIVE_HEALTH_THRESHOLD = configManager.getDouble("vex.passive.health_threshold");
        abilityManager.registerPrimaryAbility(TrimPattern.VEX, this::VexPrimary);
    }

    @EventHandler
    public void onOffhandPress(PlayerSwapHandItemsEvent event) {
        if (event.getPlayer().isSneaking()) {
            event.setCancelled(true);
            this.abilityManager.activatePrimaryAbility(event.getPlayer());
        }
    }

    public void VexPrimary(final Player player) {
        if (!this.configManager.isTrimEnabled("vex")) {
            return;
        }
        if (Bukkit.getPluginManager().getPlugin("WorldGuard") != null && !WorldGuardIntegration.canUseAbilities(player)) {
            Messaging.sendError((CommandSender)player, "You cannot use this ability in the current region.");
            return;
        }
        if (!ArmourChecking.hasFullTrimmedArmor(player, TrimPattern.VEX)) {
            return;
        }
        if (this.cooldownManager.isOnCooldown(player, TrimPattern.VEX)) {
            return;
        }
        final double radius = this.PRIMARY_RADIUS;
        int steps = 30;
        long interval = 2L;
        int points = 72;
        final Location center = player.getLocation().clone().add(0.0, 0.1, 0.0);
        player.getWorld().playSound(center, Sound.ENTITY_VEX_CHARGE, 1.0f, 1.0f);
        new BukkitRunnable(this){
            int i = 1;
            final /* synthetic */ VexTrim this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                double r = radius / 30.0 * (double)this.i;
                double y = center.getY();
                for (int j = 0; j < 360; j += 5) {
                    double rad = Math.toRadians(j);
                    double x = center.getX() + r * Math.cos(rad);
                    double z = center.getZ() + r * Math.sin(rad);
                    center.getWorld().spawnParticle(Particle.WITCH, x, y, z, 3, 0.1, 0.1, 0.1, 0.0, null);
                }
                if (++this.i > 30) {
                    this.cancel();
                    for (LivingEntity target : center.getWorld().getNearbyLivingEntities(center, radius, radius, radius)) {
                        if (target.equals((Object)player)) continue;
                        if (target instanceof Player) {
                            Player targetPlayer = (Player)target;
                            if (this.this$0.trustManager.isTrusted(player.getUniqueId(), targetPlayer.getUniqueId())) continue;
                        }
                        target.damage(this.this$0.PRIMARY_DAMAGE, (Entity)player);
                        target.addPotionEffect(new PotionEffect(PotionEffectType.WEAKNESS, this.this$0.PRIMARY_DEBUFF_DURATION, 1));
                        target.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, this.this$0.PRIMARY_DEBUFF_DURATION, 1));
                        target.addPotionEffect(new PotionEffect(PotionEffectType.GLOWING, this.this$0.PRIMARY_DEBUFF_DURATION, 0));
                        target.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, this.this$0.PRIMARY_BLINDNESS_DURATION, 0));
                    }
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 2L);
        this.cooldownManager.setCooldown(player, TrimPattern.VEX, this.PRIMARY_COOLDOWN);
    }

    @EventHandler
    public void onDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (ArmourChecking.hasFullTrimmedArmor(player, TrimPattern.VEX)) {
            double newHealth = player.getHealth() - event.getFinalDamage();
            if (newHealth <= 0.0) {
                return;
            }
            if (newHealth >= this.PASSIVE_HEALTH_THRESHOLD) {
                return;
            }
            if (this.isPassiveOnCooldown(player)) {
                return;
            }
            this.activatePassiveAbility(player);
        }
    }

    private void activatePassiveAbility(final Player player) {
        this.passiveCooldowns.put(player.getUniqueId(), System.currentTimeMillis() + this.PASSIVE_COOLDOWN);
        this.hiddenPlayers.add(player.getUniqueId());
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            if (onlinePlayer.equals((Object)player)) continue;
            onlinePlayer.hidePlayer((Plugin)this.plugin, player);
        }
        Messaging.sendTrimMessage(player, "Vex", ChatColor.DARK_GRAY, "You have become invisible for " + this.PASSIVE_HIDE_DURATION_TICKS / 20L + " seconds!");
        new BukkitRunnable(this){
            final /* synthetic */ VexTrim this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                this.this$0.hiddenPlayers.remove(player.getUniqueId());
                for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                    onlinePlayer.showPlayer((Plugin)this.this$0.plugin, player);
                }
                Messaging.sendTrimMessage(player, "Vex", ChatColor.GREEN, "You are now visible again!");
            }
        }.runTaskLater((Plugin)this.plugin, this.PASSIVE_HIDE_DURATION_TICKS);
    }

    private boolean isPassiveOnCooldown(Player player) {
        return this.passiveCooldowns.containsKey(player.getUniqueId()) && this.passiveCooldowns.get(player.getUniqueId()) > System.currentTimeMillis();
    }

    public void cleanup() {
        for (UUID playerUUID : this.hiddenPlayers) {
            Player player = Bukkit.getPlayer((UUID)playerUUID);
            if (player == null) continue;
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                onlinePlayer.showPlayer((Plugin)this.plugin, player);
            }
        }
        this.hiddenPlayers.clear();
    }
}

