/*
 * Decompiled with CFR 0.152.
 */
package MCplugin.powerTrims.Trims;

import MCplugin.powerTrims.Logic.AbilityManager;
import MCplugin.powerTrims.Logic.ArmourChecking;
import MCplugin.powerTrims.Logic.Messaging;
import MCplugin.powerTrims.Logic.TrimCooldownManager;
import MCplugin.powerTrims.config.ConfigManager;
import MCplugin.powerTrims.integrations.WorldGuardIntegration;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class WardTrim
implements Listener {
    private final JavaPlugin plugin;
    private final TrimCooldownManager cooldownManager;
    private final ConfigManager configManager;
    private final AbilityManager abilityManager;
    private final int BARRIER_DURATION;
    private final int ABSORPTION_LEVEL;
    private final int RESISTANCE_BOOST_LEVEL;
    private final long WARD_COOLDOWN;
    private final Set<UUID> activeBarriers = new HashSet<UUID>();

    public WardTrim(JavaPlugin plugin, TrimCooldownManager cooldownManager, ConfigManager configManager, AbilityManager abilityManager) {
        this.plugin = plugin;
        this.cooldownManager = cooldownManager;
        this.configManager = configManager;
        this.abilityManager = abilityManager;
        this.BARRIER_DURATION = configManager.getInt("ward.primary.barrier_duration");
        this.ABSORPTION_LEVEL = configManager.getInt("ward.primary.absorption_level");
        this.RESISTANCE_BOOST_LEVEL = configManager.getInt("ward.primary.resistance_boost_level");
        this.WARD_COOLDOWN = configManager.getLong("ward.primary.cooldown");
        abilityManager.registerPrimaryAbility(TrimPattern.WARD, this::WardPrimary);
    }

    public void WardPrimary(final Player player) {
        if (!this.configManager.isTrimEnabled("ward")) {
            return;
        }
        if (Bukkit.getPluginManager().getPlugin("WorldGuard") != null && !WorldGuardIntegration.canUseAbilities(player)) {
            Messaging.sendError((CommandSender)player, "You cannot use this ability in the current region.");
            return;
        }
        if (!ArmourChecking.hasFullTrimmedArmor(player, TrimPattern.WARD) || this.cooldownManager.isOnCooldown(player, TrimPattern.WARD)) {
            return;
        }
        Location playerLoc = player.getLocation();
        player.getWorld().playSound(playerLoc, Sound.BLOCK_BEACON_ACTIVATE, 1.0f, 1.2f);
        player.getWorld().playSound(playerLoc, Sound.BLOCK_ENCHANTMENT_TABLE_USE, 1.0f, 0.8f);
        player.getWorld().playSound(playerLoc, Sound.BLOCK_ANVIL_USE, 0.7f, 1.5f);
        player.addPotionEffect(new PotionEffect(PotionEffectType.ABSORPTION, this.BARRIER_DURATION, this.ABSORPTION_LEVEL, true, true, true));
        player.addPotionEffect(new PotionEffect(PotionEffectType.RESISTANCE, this.BARRIER_DURATION, this.RESISTANCE_BOOST_LEVEL, true, true, true));
        player.addPotionEffect(new PotionEffect(PotionEffectType.FIRE_RESISTANCE, this.BARRIER_DURATION, 0, true, true, true));
        this.createBarrierEffect(player);
        this.activeBarriers.add(player.getUniqueId());
        new BukkitRunnable(this){
            final /* synthetic */ WardTrim this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                this.this$0.activeBarriers.remove(player.getUniqueId());
            }
        }.runTaskLater((Plugin)this.plugin, (long)this.BARRIER_DURATION);
        Messaging.sendTrimMessage(player, "Ward", ChatColor.YELLOW, "You have activated your personal Protective Barrier!");
        this.cooldownManager.setCooldown(player, TrimPattern.WARD, this.WARD_COOLDOWN);
        new BukkitRunnable(this){
            int remainingTicks;
            final /* synthetic */ WardTrim this$0;
            {
                this.this$0 = this$0;
                this.remainingTicks = this.this$0.BARRIER_DURATION;
            }

            public void run() {
                if (this.remainingTicks <= 0 || !this.this$0.activeBarriers.contains(player.getUniqueId())) {
                    this.cancel();
                    return;
                }
                Location loc = player.getLocation();
                World world = player.getWorld();
                double y = 0.0;
                for (double i = 0.0; i < Math.PI * 2; i += 0.39269908169872414) {
                    double x = Math.cos(i + (double)this.remainingTicks * 0.1) * 1.2;
                    double z = Math.sin(i + (double)this.remainingTicks * 0.1) * 1.2;
                    Location particleLoc = loc.clone().add(x, y, z);
                    world.spawnParticle(Particle.WITCH, particleLoc, 1, 0.0, 0.0, 0.0, 0.0);
                    y += 0.2;
                    if (!(y > 2.0)) continue;
                    y = 0.0;
                }
                --this.remainingTicks;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    private void createBarrierEffect(Player player) {
        final Location center = player.getLocation();
        final World world = player.getWorld();
        new BukkitRunnable(this){
            double phi = 0.0;

            public void run() {
                this.phi += 0.39269908169872414;
                if (this.phi >= Math.PI) {
                    this.cancel();
                    return;
                }
                for (double theta = 0.0; theta < Math.PI * 2; theta += 0.39269908169872414) {
                    double x = 1.5 * Math.sin(this.phi) * Math.cos(theta);
                    double y = 1.5 * Math.cos(this.phi) + 1.0;
                    double z = 1.5 * Math.sin(this.phi) * Math.sin(theta);
                    Location particleLoc = center.clone().add(x, y, z);
                    world.spawnParticle(Particle.END_ROD, particleLoc, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    @EventHandler
    public void onOffhandPress(PlayerSwapHandItemsEvent event) {
        if (!this.configManager.isTrimEnabled("ward")) {
            return;
        }
        if (event.getPlayer().isSneaking()) {
            event.setCancelled(true);
            this.abilityManager.activatePrimaryAbility(event.getPlayer());
        }
    }
}

