/*
 * Decompiled with CFR 0.152.
 */
package MCplugin.powerTrims.Trims;

import MCplugin.powerTrims.Logic.AbilityManager;
import MCplugin.powerTrims.Logic.ArmourChecking;
import MCplugin.powerTrims.Logic.Messaging;
import MCplugin.powerTrims.Logic.TrimCooldownManager;
import MCplugin.powerTrims.config.ConfigManager;
import MCplugin.powerTrims.integrations.WorldGuardIntegration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Transformation;
import org.bukkit.util.Vector;

public class WayfinderTrim
implements Listener {
    private final JavaPlugin plugin;
    private final TrimCooldownManager cooldownManager;
    private final ConfigManager configManager;
    private final AbilityManager abilityManager;
    private final NamespacedKey effectKey;
    private final long TELEPORT_COOLDOWN;
    private final Map<UUID, Location> markedLocations = new HashMap<UUID, Location>();

    public WayfinderTrim(JavaPlugin plugin, TrimCooldownManager cooldownManager, ConfigManager configManager, AbilityManager abilityManager) {
        this.plugin = plugin;
        this.cooldownManager = cooldownManager;
        this.configManager = configManager;
        this.abilityManager = abilityManager;
        this.effectKey = new NamespacedKey((Plugin)plugin, "wayfinder_trim_effect");
        this.TELEPORT_COOLDOWN = configManager.getLong("wayfinder.primary.cooldown");
        abilityManager.registerPrimaryAbility(TrimPattern.WAYFINDER, this::WayfinderPrimary);
    }

    public void WayfinderPrimary(Player player) {
        if (!this.configManager.isTrimEnabled("wayfinder")) {
            return;
        }
        if (Bukkit.getPluginManager().getPlugin("WorldGuard") != null && !WorldGuardIntegration.canUseAbilities(player)) {
            Messaging.sendError((CommandSender)player, "You cannot use this ability in the current region.");
            return;
        }
        if (!ArmourChecking.hasFullTrimmedArmor(player, TrimPattern.WAYFINDER)) {
            return;
        }
        if (this.cooldownManager.isOnCooldown(player, TrimPattern.WAYFINDER)) {
            return;
        }
        UUID uuid = player.getUniqueId();
        World world = player.getWorld();
        if (this.markedLocations.containsKey(uuid)) {
            Location mark = this.markedLocations.remove(uuid);
            this.playTeleportAnimation(player.getLocation(), mark);
            player.teleport(mark);
            Messaging.sendTrimMessage(player, "Wayfinder", ChatColor.AQUA, "You have returned to your marked location!");
            player.playSound(mark, Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
            this.cooldownManager.setCooldown(player, TrimPattern.WAYFINDER, this.TELEPORT_COOLDOWN);
        } else {
            Location mark = player.getLocation();
            this.markedLocations.put(uuid, mark);
            this.playMarkAnimation(mark);
            Messaging.sendTrimMessage(player, "Wayfinder", ChatColor.DARK_AQUA, "You have marked this location!");
            player.playSound(mark, Sound.BLOCK_BEACON_ACTIVATE, 1.0f, 1.0f);
        }
    }

    private void playMarkAnimation(Location location) {
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        final ArrayList<BlockDisplay> blocks = new ArrayList<BlockDisplay>();
        Material markMaterial = Material.EMERALD_BLOCK;
        int durationTicks = 30;
        final BlockDisplay centerBlock = (BlockDisplay)world.spawn(location.clone().add(0.0, 0.5, 0.0), BlockDisplay.class, bd -> {
            bd.setBlock(markMaterial.createBlockData());
            Transformation t = bd.getTransformation();
            t.getScale().set(0.01f);
            bd.setTransformation(t);
            bd.setBrightness(new Display.Brightness(15, 15));
        });
        blocks.add(centerBlock);
        new BukkitRunnable(this){
            int ticks = 0;

            public void run() {
                if (this.ticks++ > 30) {
                    blocks.forEach(Entity::remove);
                    this.cancel();
                    return;
                }
                float progress = (float)this.ticks / 30.0f;
                float scale = (float)(Math.sin((double)progress * Math.PI) * (double)0.6f);
                Transformation t = centerBlock.getTransformation();
                t.getScale().set(scale);
                centerBlock.setTransformation(t);
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    private void playTeleportAnimation(Location from, Location to) {
        this.playVortexAnimation(from, Material.PURPUR_BLOCK);
        this.playVortexAnimation(to, Material.EMERALD_BLOCK);
    }

    private void playVortexAnimation(final Location location, final Material material) {
        final World world = location.getWorld();
        if (world == null) {
            return;
        }
        final ArrayList blocks = new ArrayList();
        int durationTicks = 25;
        int blockCount = 30;
        new BukkitRunnable(this){
            int ticks = 0;

            public void run() {
                if (this.ticks++ > 25) {
                    blocks.forEach(Entity::remove);
                    this.cancel();
                    return;
                }
                for (int i = 0; i < 2; ++i) {
                    double angle = Math.random() * 2.0 * Math.PI;
                    double radius = Math.random() * 2.0;
                    Location spawnLoc = location.clone().add(Math.cos(angle) * radius, Math.random() * 2.5, Math.sin(angle) * radius);
                    BlockDisplay block2 = (BlockDisplay)world.spawn(spawnLoc, BlockDisplay.class, bd -> {
                        bd.setBlock(material.createBlockData());
                        Transformation t = bd.getTransformation();
                        t.getScale().set(0.3f);
                        bd.setTransformation(t);
                    });
                    blocks.add(block2);
                }
                blocks.removeIf(block -> {
                    if (!block.isValid()) {
                        return true;
                    }
                    Vector toCenter = location.toVector().subtract(block.getLocation().toVector()).normalize().multiply(0.25);
                    block.teleport(block.getLocation().add(toCenter));
                    if (block.getLocation().distanceSquared(location) < 1.0) {
                        block.remove();
                        return true;
                    }
                    return false;
                });
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    @EventHandler
    public void onOffhandPress(PlayerSwapHandItemsEvent event) {
        if (!this.configManager.isTrimEnabled("wayfinder")) {
            return;
        }
        if (event.getPlayer().isSneaking()) {
            event.setCancelled(true);
            this.abilityManager.activatePrimaryAbility(event.getPlayer());
        }
    }
}

