/*
 * Decompiled with CFR 0.152.
 */
package MCplugin.powerTrims.Trims;

import MCplugin.powerTrims.Logic.AbilityManager;
import MCplugin.powerTrims.Logic.ArmourChecking;
import MCplugin.powerTrims.Logic.Messaging;
import MCplugin.powerTrims.Logic.PersistentTrustManager;
import MCplugin.powerTrims.Logic.TrimCooldownManager;
import MCplugin.powerTrims.config.ConfigManager;
import MCplugin.powerTrims.integrations.WorldGuardIntegration;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Transformation;
import org.bukkit.util.Vector;

public class WildTrim
implements Listener {
    private final JavaPlugin plugin;
    private final TrimCooldownManager cooldownManager;
    private final PersistentTrustManager trustManager;
    private final ConfigManager configManager;
    private final AbilityManager abilityManager;
    private final Random random = new Random();
    private final int PASSIVE_TRIGGER_HEALTH;
    private final int PASSIVE_COOLDOWN_SECONDS;
    private final long PRIMARY_COOLDOWN;
    private final double GRAPPLE_RANGE;
    private final int POISON_DURATION_TICKS;
    private final double GRAPPLE_SPEED;
    private final double ROOT_TRAP_RADIUS_XZ;
    private final double ROOT_TRAP_RADIUS_Y;
    private final int ROOT_TRAP_DURATION_TICKS;
    private final Map<UUID, Long> passiveCooldowns = new HashMap<UUID, Long>();
    private final Set<UUID> frozenEntities = new HashSet<UUID>();

    public WildTrim(JavaPlugin plugin, TrimCooldownManager cooldownManager, PersistentTrustManager trustManager, ConfigManager configManager, AbilityManager abilityManager) {
        this.plugin = plugin;
        this.cooldownManager = cooldownManager;
        this.trustManager = trustManager;
        this.configManager = configManager;
        this.abilityManager = abilityManager;
        this.PASSIVE_TRIGGER_HEALTH = configManager.getInt("wild.passive.trigger_health");
        this.PASSIVE_COOLDOWN_SECONDS = configManager.getInt("wild.passive.cooldown_seconds");
        this.PRIMARY_COOLDOWN = configManager.getLong("wild.primary.cooldown");
        this.GRAPPLE_RANGE = configManager.getDouble("wild.primary.grapple_range");
        this.POISON_DURATION_TICKS = configManager.getInt("wild.primary.poison_duration_ticks");
        this.GRAPPLE_SPEED = configManager.getDouble("wild.primary.grapple_speed");
        this.ROOT_TRAP_RADIUS_XZ = configManager.getDouble("wild.passive.root_trap_radius_xz");
        this.ROOT_TRAP_RADIUS_Y = configManager.getDouble("wild.passive.root_trap_radius_y");
        this.ROOT_TRAP_DURATION_TICKS = configManager.getInt("wild.passive.root_trap_duration_ticks");
        abilityManager.registerPrimaryAbility(TrimPattern.WILD, this::WildPrimary);
    }

    /*
     * Unable to fully structure code
     */
    public void WildPrimary(Player player) {
        block11: {
            block10: {
                if (!this.configManager.isTrimEnabled("wild")) {
                    return;
                }
                if (Bukkit.getPluginManager().getPlugin("WorldGuard") != null && !WorldGuardIntegration.canUseAbilities(player)) {
                    Messaging.sendError((CommandSender)player, "You cannot use this ability in the current region.");
                    return;
                }
                if (!ArmourChecking.hasFullTrimmedArmor(player, TrimPattern.WILD)) {
                    return;
                }
                if (this.cooldownManager.isOnCooldown(player, TrimPattern.WILD)) {
                    return;
                }
                start = player.getEyeLocation();
                direction = player.getLocation().getDirection().normalize();
                range = this.GRAPPLE_RANGE;
                wildUser = player;
                player.playSound(player.getLocation(), Sound.ENTITY_FISHING_BOBBER_THROW, 1.0f, 1.0f);
                abilityUsed = false;
                entityHit = player.getWorld().rayTraceEntities(start, direction, range, (Predicate<Entity>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$WildPrimary$0(org.bukkit.entity.Player org.bukkit.entity.Entity ), (Lorg/bukkit/entity/Entity;)Z)((Player)wildUser));
                if (entityHit == null || !((var10_8 = entityHit.getHitEntity()) instanceof LivingEntity)) break block10;
                targetEntity = (LivingEntity)var10_8;
                if (!(targetEntity instanceof Player)) ** GOTO lbl-1000
                targetPlayer = (Player)targetEntity;
                if (this.trustManager.isTrusted(wildUser.getUniqueId(), targetPlayer.getUniqueId())) {
                    Messaging.sendTrimMessage(player, "Wild", ChatColor.GREEN, "Grappling to trusted player!");
                    this.visualizeGrapple(player, targetEntity.getLocation().add(0.0, 1.0, 0.0));
                    this.smoothlyPullPlayer(player, targetEntity.getLocation().add(0.0, 1.0, 0.0));
                } else lbl-1000:
                // 2 sources

                {
                    Messaging.sendTrimMessage(player, "Wild", ChatColor.GREEN, "Grappling to entity!");
                    this.visualizeGrapple(player, targetEntity.getLocation().add(0.0, 1.0, 0.0));
                    this.smoothlyPullPlayer(player, targetEntity.getLocation().add(0.0, 1.0, 0.0));
                    targetEntity.addPotionEffect(new PotionEffect(PotionEffectType.POISON, this.POISON_DURATION_TICKS, 1, true, false, true));
                    if (targetEntity instanceof Player) {
                        Messaging.sendTrimMessage((Player)targetEntity, "Wild", ChatColor.RED, "You have been Poisoned for " + this.POISON_DURATION_TICKS / 20 + " sec!");
                    }
                    abilityUsed = true;
                }
                break block11;
            }
            targetBlock = player.getTargetBlockExact((int)range);
            if (targetBlock != null && !targetBlock.getType().isAir()) {
                Messaging.sendTrimMessage(player, "Wild", ChatColor.GREEN, "Grappling to block!");
                this.visualizeGrapple(player, targetBlock.getLocation().add(0.5, 1.0, 0.5));
                this.smoothlyPullPlayer(player, targetBlock.getLocation().add(0.5, 1.0, 0.5));
                abilityUsed = true;
            } else {
                Messaging.sendTrimMessage(player, "Wild", ChatColor.RED, "No valid target found!");
            }
        }
        if (abilityUsed) {
            this.cooldownManager.setCooldown(player, TrimPattern.WILD, this.PRIMARY_COOLDOWN);
        }
    }

    private void visualizeGrapple(Player player, Location target) {
        final Location start = player.getEyeLocation();
        final World world = player.getWorld();
        if (world == null) {
            return;
        }
        final ArrayList vineParts = new ArrayList();
        final Material vineMaterial = Material.VINE;
        Vector travel = target.toVector().subtract(start.toVector());
        final int segments = (int)(travel.length() * 2.0);
        if (segments == 0) {
            return;
        }
        final Vector step = travel.clone().multiply(1.0 / (double)segments);
        new BukkitRunnable(this){
            int currentSegment = 0;
            final /* synthetic */ WildTrim this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (this.currentSegment >= segments) {
                    new BukkitRunnable(this){

                        public void run() {
                            vineParts.forEach(Entity::remove);
                        }
                    }.runTaskLater((Plugin)this.this$0.plugin, 20L);
                    this.cancel();
                    return;
                }
                Location currentPos = start.clone().add(step.clone().multiply(this.currentSegment));
                BlockDisplay part = (BlockDisplay)world.spawn(currentPos, BlockDisplay.class, bd -> {
                    bd.setBlock(vineMaterial.createBlockData());
                    Transformation t = bd.getTransformation();
                    t.getScale().set(0.2f);
                    bd.setTransformation(t);
                });
                vineParts.add(part);
                ++this.currentSegment;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    private void smoothlyPullPlayer(final Player player, final Location target) {
        player.setGravity(false);
        player.setFallDistance(0.0f);
        new BukkitRunnable(this){
            int ticks = 0;
            final double maxSpeed;
            boolean reachedTarget;
            final /* synthetic */ WildTrim this$0;
            {
                this.this$0 = this$0;
                this.maxSpeed = this.this$0.GRAPPLE_SPEED;
                this.reachedTarget = false;
            }

            public void run() {
                if (!player.isOnline() || player.isDead()) {
                    this.finishGrapple();
                    return;
                }
                double distanceSquared = player.getLocation().distanceSquared(target);
                if (distanceSquared < 1.5) {
                    this.reachedTarget = true;
                    this.finishGrapple();
                    return;
                }
                if (this.ticks++ > 30) {
                    this.finishGrapple();
                    return;
                }
                Vector pullVector = target.toVector().subtract(player.getLocation().toVector());
                double length = pullVector.length();
                double speed = Math.min(this.maxSpeed, length * 0.28);
                player.setVelocity(pullVector.normalize().multiply(speed));
                this.this$0.playWindEffect(player);
                if (this.ticks % 5 == 0) {
                    player.playSound(player.getLocation(), Sound.ENTITY_ENDER_DRAGON_FLAP, 0.5f, 1.2f);
                }
            }

            private void finishGrapple() {
                player.setGravity(true);
                if (this.reachedTarget) {
                    player.setVelocity(new Vector(0.0, 0.3, 0.0));
                    player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_ATTACK_SWEEP, 1.0f, 1.0f);
                }
                this.cancel();
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    private void playWindEffect(Player player) {
        Location loc = player.getLocation();
        World world = player.getWorld();
        if (world == null) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            Location spawnLoc = loc.clone().add((this.random.nextDouble() - 0.5) * 1.5, (this.random.nextDouble() - 0.5) * 1.5 + 1.0, (this.random.nextDouble() - 0.5) * 1.5);
            final BlockDisplay block = (BlockDisplay)world.spawn(spawnLoc, BlockDisplay.class, bd -> {
                bd.setBlock(Material.LIGHT_GRAY_WOOL.createBlockData());
                Transformation t = bd.getTransformation();
                t.getScale().set((float)(0.1 + this.random.nextDouble() * 0.1));
                bd.setTransformation(t);
            });
            final Vector velocity = player.getVelocity().clone().multiply(-0.5).add(new Vector(this.random.nextDouble() - 0.5, this.random.nextDouble() - 0.5, this.random.nextDouble() - 0.5).multiply(0.2));
            new BukkitRunnable(this){
                int life = 0;

                public void run() {
                    if (this.life++ > 10 || !block.isValid()) {
                        block.remove();
                        this.cancel();
                        return;
                    }
                    block.teleport(block.getLocation().add(velocity));
                }
            }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
        }
    }

    @EventHandler
    public void onOffhandPress(PlayerSwapHandItemsEvent event) {
        if (!this.configManager.isTrimEnabled("wild")) {
            return;
        }
        if (event.getPlayer().isSneaking()) {
            event.setCancelled(true);
            this.abilityManager.activatePrimaryAbility(event.getPlayer());
        }
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (Bukkit.getPluginManager().getPlugin("WorldGuard") != null && !WorldGuardIntegration.canUseAbilities(player)) {
            Messaging.sendError((CommandSender)player, "You cannot use this ability in the current region.");
            return;
        }
        if (!ArmourChecking.hasFullTrimmedArmor(player, TrimPattern.WILD)) {
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (player.getHealth() > (double)this.PASSIVE_TRIGGER_HEALTH) {
                return;
            }
            if (this.isPassiveOnCooldown(player)) {
                Messaging.sendTrimMessage(player, "Wild", ChatColor.RED, "Root Trap is on cooldown!");
                return;
            }
            this.activateRootTrap(player);
            this.setPassiveCooldown(player);
        }, 1L);
    }

    public void activateRootTrap(Player player) {
        if (this.isPassiveOnCooldown(player)) {
            Messaging.sendTrimMessage(player, "Wild", ChatColor.RED, "Root Trap is on cooldown!");
            return;
        }
        this.setPassiveCooldown(player);
        Messaging.sendTrimMessage(player, "Wild", ChatColor.GREEN, "You activated Root Trap!");
        final ArrayList<LivingEntity> affectedEntities = new ArrayList<LivingEntity>();
        for (Entity entity : player.getNearbyEntities(this.ROOT_TRAP_RADIUS_XZ, this.ROOT_TRAP_RADIUS_Y, this.ROOT_TRAP_RADIUS_XZ)) {
            if (!(entity instanceof LivingEntity) || entity == player) continue;
            LivingEntity target = (LivingEntity)entity;
            if (target instanceof Player) {
                Player targetPlayer = (Player)target;
                if (this.trustManager.isTrusted(player.getUniqueId(), targetPlayer.getUniqueId())) continue;
            }
            affectedEntities.add(target);
            this.frozenEntities.add(target.getUniqueId());
            this.spawnVinesAnimation(target.getLocation());
        }
        new BukkitRunnable(this){
            final /* synthetic */ WildTrim this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                for (LivingEntity entity : affectedEntities) {
                    if (!this.this$0.frozenEntities.contains(entity.getUniqueId())) continue;
                    entity.setVelocity(new Vector(0, 0, 0));
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 5L);
        new BukkitRunnable(this){
            final /* synthetic */ WildTrim this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                for (LivingEntity entity : affectedEntities) {
                    this.this$0.frozenEntities.remove(entity.getUniqueId());
                }
            }
        }.runTaskLater((Plugin)this.plugin, (long)this.ROOT_TRAP_DURATION_TICKS);
    }

    private void spawnVinesAnimation(Location location) {
        World world = location.getWorld();
        if (world == null) {
            return;
        }
        final ArrayList<BlockDisplay> vines = new ArrayList<BlockDisplay>();
        Material vineMaterial = Material.OAK_LOG;
        final int duration = this.ROOT_TRAP_DURATION_TICKS;
        for (int i = 0; i < 8; ++i) {
            double angle = Math.PI * 2 * (double)i / 8.0;
            Location spawnLoc = location.clone().add(Math.cos(angle) * 1.2, 0.0, Math.sin(angle) * 1.2);
            BlockDisplay vine = (BlockDisplay)world.spawn(spawnLoc, BlockDisplay.class, bd -> {
                bd.setBlock(vineMaterial.createBlockData());
                Transformation t = bd.getTransformation();
                t.getScale().set(0.1f, 0.01f, 0.1f);
                bd.setTransformation(t);
            });
            vines.add(vine);
        }
        new BukkitRunnable(this){
            int ticks = 0;
            final /* synthetic */ WildTrim this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (this.ticks++ > duration) {
                    new BukkitRunnable(this){
                        int shrinkTicks = 0;

                        public void run() {
                            if (this.shrinkTicks++ > 20) {
                                vines.forEach(Entity::remove);
                                this.cancel();
                                return;
                            }
                            for (BlockDisplay vine : vines) {
                                if (!vine.isValid()) continue;
                                Transformation t = vine.getTransformation();
                                t.getScale().mul(0.8f);
                                vine.setTransformation(t);
                            }
                        }
                    }.runTaskTimer((Plugin)this.this$0.plugin, 0L, 1L);
                    this.cancel();
                    return;
                }
                for (BlockDisplay vine : vines) {
                    if (!vine.isValid()) continue;
                    Transformation t = vine.getTransformation();
                    if (!(t.getScale().y < 2.0f)) continue;
                    t.getScale().add(0.0f, 0.1f, 0.0f);
                    vine.setTransformation(t);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        if (this.frozenEntities.contains(event.getPlayer().getUniqueId())) {
            event.setCancelled(true);
        }
    }

    private boolean isPassiveOnCooldown(Player player) {
        return this.passiveCooldowns.containsKey(player.getUniqueId()) && System.currentTimeMillis() < this.passiveCooldowns.get(player.getUniqueId());
    }

    private void setPassiveCooldown(Player player) {
        this.passiveCooldowns.put(player.getUniqueId(), System.currentTimeMillis() + (long)this.PASSIVE_COOLDOWN_SECONDS * 1000L);
    }

    private static /* synthetic */ boolean lambda$WildPrimary$0(Player wildUser, Entity entity) {
        return entity instanceof LivingEntity && entity != wildUser;
    }
}

