/*
 * Decompiled with CFR 0.152.
 */
package MCplugin.powerTrims.UltimateUpgrader;

import MCplugin.powerTrims.UltimateUpgrader.RitualAnimation;
import MCplugin.powerTrims.UltimateUpgrader.RitualConfig;
import MCplugin.powerTrims.UltimateUpgrader.RitualManager;
import java.util.Arrays;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ArmorMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.trim.ArmorTrim;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Ritual {
    private final JavaPlugin plugin;
    private final Player player;
    private final Location location;
    private final ItemStack[] armorSet;
    private final RitualConfig config;
    private final RitualManager ritualManager;
    private final NamespacedKey upgradeKey;
    private final RitualAnimation animation;

    public Ritual(JavaPlugin plugin, Player player, Location location, ItemStack[] armorSet, RitualConfig config, RitualManager ritualManager, NamespacedKey upgradeKey) {
        this.plugin = plugin;
        this.player = player;
        this.location = location;
        this.armorSet = armorSet;
        this.config = config;
        this.ritualManager = ritualManager;
        this.upgradeKey = upgradeKey;
        this.animation = new RitualAnimation(plugin, location, armorSet, config.getMaterials());
    }

    public void start() {
        this.animation.start();
        this.location.getWorld().playSound(this.location, Sound.BLOCK_BEACON_ACTIVATE, 1.5f, 0.8f);
        String dimensionName = this.getDimensionName(this.location.getWorld());
        String coords = String.format("X: %d, Y: %d, Z: %d", this.location.getBlockX(), this.location.getBlockY(), this.location.getBlockZ());
        Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.DARK_PURPLE) + "\u00a7l[!] " + String.valueOf(ChatColor.LIGHT_PURPLE) + this.player.getName() + " has begun a powerful ritual in " + dimensionName + " at " + coords + "!"));
        new BukkitRunnable(){
            int countdown;
            {
                this.countdown = Ritual.this.config.getDuration();
            }

            public void run() {
                if (this.countdown <= 0) {
                    Ritual.this.complete();
                    this.cancel();
                    return;
                }
                Ritual.this.animation.updateHologram(this.countdown);
                Ritual.this.location.getWorld().playSound(Ritual.this.location, Sound.BLOCK_CONDUIT_AMBIENT_SHORT, 0.5f, 1.5f);
                --this.countdown;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    private String getDimensionName(World world) {
        return switch (world.getEnvironment()) {
            case World.Environment.NORMAL -> "the Overworld";
            case World.Environment.NETHER -> "the Nether";
            case World.Environment.THE_END -> "the End";
            default -> "an unknown dimension";
        };
    }

    private void complete() {
        this.animation.stop();
        this.location.getWorld().playSound(this.location, Sound.ENTITY_PLAYER_LEVELUP, 2.0f, 1.0f);
        this.location.getWorld().playSound(this.location, Sound.BLOCK_AMETHYST_BLOCK_CHIME, 2.0f, 1.0f);
        TrimPattern pattern = null;
        for (ItemStack item : this.armorSet) {
            ArmorTrim trim;
            ItemMeta meta = item.getItemMeta();
            if (meta == null) continue;
            if (pattern == null && meta instanceof ArmorMeta && (trim = ((ArmorMeta)meta).getTrim()) != null) {
                pattern = trim.getPattern();
            }
            meta.getPersistentDataContainer().set(this.upgradeKey, PersistentDataType.BYTE, (Object)1);
            List<String> newLore = Arrays.asList("\u00a77A relic of a forgotten age,", "\u00a77pulsating with untold power.", "", "\u00a7d\u00a7lMYTHIC ARMOR");
            meta.setLore(newLore);
            item.setItemMeta(meta);
            this.location.getWorld().dropItemNaturally(this.location, item);
        }
        if (pattern != null) {
            this.ritualManager.incrementUpgradeCount(pattern);
        }
        Bukkit.broadcastMessage((String)(String.valueOf(ChatColor.DARK_PURPLE) + "\u00a7l[!] " + String.valueOf(ChatColor.LIGHT_PURPLE) + "The ritual has been completed!"));
        this.ritualManager.endRitual(this.player.getUniqueId());
        this.player.sendMessage("\u00a7aThe ritual is complete! Your armor has been empowered.");
    }
}

