/*
 * Decompiled with CFR 0.152.
 */
package MCplugin.powerTrims.UltimateUpgrader;

import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Transformation;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class RitualAnimation {
    private final JavaPlugin plugin;
    private final Location center;
    private final ItemStack[] armorSet;
    private final List<ItemStack> materials;
    private BukkitTask animationTask;
    private final List<Entity> ritualEntities = new ArrayList<Entity>();
    private final List<Display> orbitingDisplays = new ArrayList<Display>();
    private final List<BlockDisplay> pillarCrystals = new ArrayList<BlockDisplay>();
    private ArmorStand hologram;

    public RitualAnimation(JavaPlugin plugin, Location center, ItemStack[] armorSet, List<ItemStack> materials) {
        this.plugin = plugin;
        this.center = center.clone().add(0.0, 0.2, 0.0);
        this.armorSet = armorSet;
        this.materials = materials;
    }

    public void start() {
        final World world = this.center.getWorld();
        this.hologram = (ArmorStand)world.spawn(this.center.clone().add(0.0, 5.5, 0.0), ArmorStand.class, as -> {
            as.setInvisible(true);
            as.setGravity(false);
            as.setInvulnerable(true);
            as.setCustomNameVisible(true);
        });
        this.ritualEntities.add((Entity)this.hologram);
        BlockDisplay centralPedestal = (BlockDisplay)world.spawn(this.center.clone(), BlockDisplay.class, bd -> {
            bd.setBlock(Material.CRYING_OBSIDIAN.createBlockData());
            bd.setBrightness(new Display.Brightness(15, 15));
            Transformation t = bd.getTransformation();
            t.getScale().set(0.8f, 0.3f, 0.8f);
            t.getLeftRotation().identity();
            bd.setTransformation(t);
        });
        this.ritualEntities.add((Entity)centralPedestal);
        double pillarDistance = 7.0;
        this.createPillar(this.center.clone().add(pillarDistance, 0.0, 0.0));
        this.createPillar(this.center.clone().add(-pillarDistance, 0.0, 0.0));
        this.createPillar(this.center.clone().add(0.0, 0.0, pillarDistance));
        this.createPillar(this.center.clone().add(0.0, 0.0, -pillarDistance));
        float[] armorYOffsets = new float[]{2.5f, 2.0f, 1.5f, 1.0f};
        for (int i = 0; i < this.armorSet.length; ++i) {
            int finalI = i;
            ItemDisplay armorPiece = (ItemDisplay)world.spawn(this.center.clone().add(0.0, (double)armorYOffsets[i], 0.0), ItemDisplay.class, id -> {
                id.setItemStack(this.armorSet[finalI]);
                id.setBrightness(new Display.Brightness(15, 15));
                Transformation t = id.getTransformation();
                t.getScale().set(1.2f);
                id.setTransformation(t);
            });
            this.ritualEntities.add((Entity)armorPiece);
        }
        this.setupOrbitingMaterials();
        world.playSound(this.center, Sound.BLOCK_PORTAL_TRIGGER, 2.0f, 0.5f);
        world.playSound(this.center, Sound.BLOCK_BEACON_ACTIVATE, 1.5f, 0.7f);
        this.animationTask = new BukkitRunnable(this){
            double angle = 0.0;
            final /* synthetic */ RitualAnimation this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                Transformation t;
                this.angle += 0.031415926535897934;
                this.this$0.drawRuneCircles(this.angle);
                this.this$0.animateOrbitingMaterials(this.angle);
                for (Entity e : this.this$0.ritualEntities) {
                    ItemDisplay id;
                    if (!(e instanceof ItemDisplay) || !this.this$0.isArmor((id = (ItemDisplay)e).getItemStack())) continue;
                    t = id.getTransformation();
                    t.getLeftRotation().set((Quaternionfc)new Quaternionf().rotateY((float)(-this.angle) * 0.5f));
                    id.setTransformation(t);
                }
                for (BlockDisplay crystal : this.this$0.pillarCrystals) {
                    float pulse = (float)(0.6 + Math.sin(this.angle * 4.0) * 0.2);
                    t = crystal.getTransformation();
                    t.getScale().set(pulse);
                    crystal.setTransformation(t);
                }
                if (this.getTaskId() % 100 == 0) {
                    world.playSound(this.this$0.center, Sound.BLOCK_PORTAL_AMBIENT, 0.5f, 0.8f);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    private void createPillar(Location location) {
        BlockDisplay pillarBase = (BlockDisplay)location.getWorld().spawn(location, BlockDisplay.class, bd -> {
            bd.setBlock(Material.OBSIDIAN.createBlockData());
            bd.setBrightness(new Display.Brightness(10, 10));
            Transformation t = bd.getTransformation();
            t.getScale().set(0.6f, 2.5f, 0.6f);
            t.getLeftRotation().identity();
            bd.setTransformation(t);
        });
        this.ritualEntities.add((Entity)pillarBase);
        BlockDisplay crystal = (BlockDisplay)location.getWorld().spawn(location.clone().add(0.0, 2.5, 0.0), BlockDisplay.class, bd -> {
            bd.setBlock(Material.AMETHYST_BLOCK.createBlockData());
            bd.setBrightness(new Display.Brightness(15, 15));
            bd.setGlowing(true);
            Transformation t = bd.getTransformation();
            t.getScale().set(0.6f);
            t.getLeftRotation().identity();
            bd.setTransformation(t);
        });
        this.pillarCrystals.add(crystal);
        this.ritualEntities.add((Entity)crystal);
    }

    private void drawRuneCircles(double currentAngle) {
        World world = this.center.getWorld();
        int points = 60;
        double radius1 = 5.5;
        for (int i = 0; i < points; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)points;
            double x = Math.cos(angle + currentAngle) * radius1;
            double z = Math.sin(angle + currentAngle) * radius1;
            world.spawnParticle(Particle.DUST, this.center.clone().add(x, 0.1, z), 1, 0.0, 0.0, 0.0, 0.0, (Object)new Particle.DustOptions(Color.RED, 1.0f));
        }
        double radius2 = 4.0;
        for (int i = 0; i < points; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)points;
            double x = Math.cos(angle - currentAngle * 1.2) * radius2;
            double z = Math.sin(angle - currentAngle * 1.2) * radius2;
            world.spawnParticle(Particle.SOUL_FIRE_FLAME, this.center.clone().add(x, 0.15, z), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private void setupOrbitingMaterials() {
        World world = this.center.getWorld();
        int materialsPerRing = (this.materials.size() + 1) / 2;
        for (int i = 0; i < this.materials.size(); ++i) {
            ItemStack materialStack = this.materials.get(i);
            boolean isOuterRing = i < materialsPerRing;
            double radius = isOuterRing ? 6.0 : 3.5;
            double yOffset = isOuterRing ? 2.2 : 1.7;
            Location spawnLoc = this.center.clone().add(radius, yOffset, 0.0);
            Display display = materialStack.getType().isBlock() ? (Display)world.spawn(spawnLoc, BlockDisplay.class, d -> {
                d.setBlock(materialStack.getType().createBlockData());
                Transformation t = d.getTransformation();
                t.getScale().set(0.4f);
                t.getLeftRotation().identity();
                d.setTransformation(t);
            }) : (Display)world.spawn(spawnLoc, ItemDisplay.class, d -> {
                d.setItemStack(materialStack);
                d.getTransformation().getScale().set(0.6f);
            });
            display.setBrightness(new Display.Brightness(15, 15));
            this.orbitingDisplays.add(display);
            this.ritualEntities.add((Entity)display);
        }
    }

    private void animateOrbitingMaterials(double currentAngle) {
        int materialsPerRing = (this.orbitingDisplays.size() + 1) / 2;
        for (int i = 0; i < this.orbitingDisplays.size(); ++i) {
            Display display = this.orbitingDisplays.get(i);
            boolean isOuterRing = i < materialsPerRing;
            double radius = isOuterRing ? 6.0 : 3.5;
            double yOffset = isOuterRing ? 2.2 : 1.7;
            double speed = isOuterRing ? 1.0 : -1.2;
            int ringIndex = isOuterRing ? i : i - materialsPerRing;
            int ringSize = isOuterRing ? materialsPerRing : this.orbitingDisplays.size() - materialsPerRing;
            double orbitAngle = Math.PI * 2 / (double)ringSize * (double)ringIndex + currentAngle * speed;
            double bob = Math.sin(currentAngle * 2.0 + (double)i) * 0.15;
            Location newLoc = this.center.clone().add(radius * Math.cos(orbitAngle), yOffset + bob, radius * Math.sin(orbitAngle));
            display.teleport(newLoc);
            Transformation t = display.getTransformation();
            t.getLeftRotation().set((Quaternionfc)new Quaternionf().rotateY((float)currentAngle * 2.0f));
            display.setTransformation(t);
        }
    }

    public void stop() {
        if (this.animationTask != null) {
            this.animationTask.cancel();
        }
        this.center.getWorld().playSound(this.center, Sound.ENTITY_GENERIC_EXPLODE, 1.5f, 0.8f);
        this.center.getWorld().spawnParticle(Particle.EXPLOSION, this.center.clone().add(0.0, 1.5, 0.0), 3, 0.5, 0.5, 0.5);
        this.ritualEntities.forEach(Entity::remove);
        this.ritualEntities.clear();
        this.orbitingDisplays.clear();
        this.pillarCrystals.clear();
    }

    public void updateHologram(int timeRemaining) {
        if (this.hologram != null && this.hologram.isValid()) {
            Component text = ((TextComponent)((TextComponent)((TextComponent)Component.text((String)"\u25c6 ", (TextColor)NamedTextColor.DARK_RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}).append((Component)Component.text((String)"RITUAL IN PROGRESS", (TextColor)NamedTextColor.RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.text((String)" \u25c6", (TextColor)NamedTextColor.DARK_RED, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}))).append((Component)Component.newline())).append((Component)Component.text((String)(timeRemaining + "s"), (TextColor)NamedTextColor.WHITE, (TextDecoration[])new TextDecoration[]{TextDecoration.BOLD}));
            this.hologram.customName(text);
        }
    }

    private boolean isArmor(ItemStack item) {
        if (item == null) {
            return false;
        }
        String typeName = item.getType().name();
        return typeName.endsWith("_HELMET") || typeName.endsWith("_CHESTPLATE") || typeName.endsWith("_LEGGINGS") || typeName.endsWith("_BOOTS");
    }
}

