/*
 * Decompiled with CFR 0.152.
 */
package MCplugin.powerTrims.UltimateUpgrader;

import MCplugin.powerTrims.UltimateUpgrader.Ritual;
import MCplugin.powerTrims.UltimateUpgrader.RitualConfig;
import MCplugin.powerTrims.UltimateUpgrader.UltimateUpgraderManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.plugin.java.JavaPlugin;

public class RitualManager {
    private final JavaPlugin plugin;
    private final NamespacedKey upgradeKey;
    private final Map<TrimPattern, RitualConfig> ritualConfigs = new HashMap<TrimPattern, RitualConfig>();
    private final Map<UUID, Ritual> activeRituals = new HashMap<UUID, Ritual>();
    private FileConfiguration upgradeCountsConfig;
    private File upgradeCountsFile;

    public RitualManager(JavaPlugin plugin, NamespacedKey upgradeKey) {
        this.plugin = plugin;
        this.upgradeKey = upgradeKey;
        this.loadRituals();
        this.loadUpgradeCounts();
    }

    public void reload() {
        this.ritualConfigs.clear();
        this.loadRituals();
        this.upgradeCountsConfig = null;
        this.loadUpgradeCounts();
        this.plugin.getLogger().info("Ritual configurations and upgrade counts have been reloaded.");
    }

    public void loadRituals() {
        YamlConfiguration config;
        ConfigurationSection ritualsSection;
        File ritualsFile = new File(this.plugin.getDataFolder(), "rituals.yml");
        if (!ritualsFile.exists()) {
            this.plugin.saveResource("rituals.yml", false);
        }
        if ((ritualsSection = (config = YamlConfiguration.loadConfiguration((File)ritualsFile)).getConfigurationSection("rituals")) == null) {
            return;
        }
        for (String key : ritualsSection.getKeys(false)) {
            try {
                NamespacedKey patternKey = NamespacedKey.minecraft((String)key.toLowerCase());
                TrimPattern pattern = (TrimPattern)Registry.TRIM_PATTERN.get(patternKey);
                if (pattern == null) {
                    this.plugin.getLogger().warning("Invalid trim pattern in rituals.yml: " + key);
                    continue;
                }
                int duration = ritualsSection.getInt(key + ".duration");
                int limit = ritualsSection.getInt(key + ".limit", 1);
                boolean enabled = ritualsSection.getBoolean(key + ".enabled", true);
                ArrayList<ItemStack> materials = new ArrayList<ItemStack>();
                for (String materialString : ritualsSection.getStringList(key + ".materials")) {
                    String[] parts = materialString.split(":");
                    Material material = Material.valueOf((String)parts[0].toUpperCase());
                    int amount = Integer.parseInt(parts[1]);
                    materials.add(new ItemStack(material, amount));
                }
                this.ritualConfigs.put(pattern, new RitualConfig(duration, materials, limit, enabled));
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid material in rituals.yml for trim '" + key + "': " + e.getMessage());
            }
        }
    }

    private void loadUpgradeCounts() {
        this.upgradeCountsFile = new File(this.plugin.getDataFolder(), "upgrade_counts.yml");
        if (!this.upgradeCountsFile.exists()) {
            try {
                this.upgradeCountsFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not create upgrade_counts.yml!");
            }
        }
        this.upgradeCountsConfig = YamlConfiguration.loadConfiguration((File)this.upgradeCountsFile);
    }

    public int getUpgradeCount(TrimPattern pattern) {
        return this.upgradeCountsConfig.getInt(pattern.getKey().getKey(), 0);
    }

    public void incrementUpgradeCount(TrimPattern pattern) {
        int currentCount = this.getUpgradeCount(pattern);
        this.upgradeCountsConfig.set(pattern.getKey().getKey(), (Object)(currentCount + 1));
        try {
            this.upgradeCountsConfig.save(this.upgradeCountsFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save upgrade_counts.yml!");
        }
    }

    public RitualConfig getRitualConfig(TrimPattern pattern) {
        return this.ritualConfigs.get(pattern);
    }

    public boolean isPlayerInRitual(UUID playerUUID) {
        return this.activeRituals.containsKey(playerUUID);
    }

    public void startRitual(Player player, ItemStack[] armorSet, RitualConfig config, Inventory gui) {
        this.consumeMaterials(player, config.getMaterials());
        for (int slot : UltimateUpgraderManager.ARMOR_SLOTS) {
            gui.setItem(slot, null);
        }
        Ritual ritual = new Ritual(this.plugin, player, player.getLocation(), armorSet, config, this, this.upgradeKey);
        this.activeRituals.put(player.getUniqueId(), ritual);
        ritual.start();
    }

    public void endRitual(UUID playerUUID) {
        this.activeRituals.remove(playerUUID);
    }

    private void consumeMaterials(Player player, List<ItemStack> materials) {
        for (ItemStack material : materials) {
            player.getInventory().removeItem(new ItemStack[]{material});
        }
    }
}

