/*
 * Decompiled with CFR 0.152.
 */
package MCplugin.powerTrims.UltimateUpgrader;

import MCplugin.powerTrims.UltimateUpgrader.RitualConfig;
import MCplugin.powerTrims.UltimateUpgrader.RitualManager;
import MCplugin.powerTrims.config.ConfigManager;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.PrepareSmithingEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.SmithingInventory;
import org.bukkit.inventory.meta.ArmorMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.trim.ArmorTrim;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class UltimateUpgraderManager
implements Listener,
CommandExecutor,
InventoryHolder {
    private final RitualManager ritualManager;
    private final String GUI_NAME = "\u00a75Ultimate Upgrader";
    private final NamespacedKey upgradeKey;
    public static final int HELMET_SLOT = 10;
    public static final int CHESTPLATE_SLOT = 12;
    public static final int LEGGINGS_SLOT = 14;
    public static final int BOOTS_SLOT = 16;
    private static final int UPGRADE_BUTTON_SLOT = 22;
    public static final Set<Integer> ARMOR_SLOTS = new HashSet<Integer>(Arrays.asList(10, 12, 14, 16));

    public UltimateUpgraderManager(JavaPlugin plugin, RitualManager ritualManager, NamespacedKey upgradeKey, ConfigManager configManager) {
        this.ritualManager = ritualManager;
        this.upgradeKey = upgradeKey;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        PluginCommand command = plugin.getCommand("upgrade");
        if (command != null) {
            command.setExecutor((CommandExecutor)this);
        }
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (this.ritualManager.isPlayerInRitual(player.getUniqueId())) {
                player.sendMessage("\u00a7cYou are already performing a ritual!");
                return true;
            }
            this.openUpgradeGUI(player);
        } else {
            sender.sendMessage("This command can only be used by players.");
        }
        return true;
    }

    private void openUpgradeGUI(Player player) {
        Inventory gui = Bukkit.createInventory((InventoryHolder)this, (int)27, (String)"\u00a75Ultimate Upgrader");
        ItemStack placeholder = this.createGuiItem(Material.GRAY_STAINED_GLASS_PANE, " ", new String[0]);
        for (int i = 0; i < gui.getSize(); ++i) {
            gui.setItem(i, placeholder);
        }
        gui.setItem(10, null);
        gui.setItem(12, null);
        gui.setItem(14, null);
        gui.setItem(16, null);
        gui.setItem(22, this.createGuiItem(Material.AMETHYST_SHARD, "\u00a7d\u00a7lInitiate Ritual", "\u00a77Place a full set of armor with a", "\u00a77valid trim to begin the ritual."));
        player.openInventory(gui);
    }

    @NotNull
    public Inventory getInventory() {
        return null;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getView().getTopInventory().getHolder() instanceof UltimateUpgraderManager)) {
            return;
        }
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        Inventory clickedInventory = event.getClickedInventory();
        int rawSlot = event.getRawSlot();
        if (event.getView().getTopInventory().equals((Object)clickedInventory)) {
            if (ARMOR_SLOTS.contains(rawSlot)) {
                return;
            }
            if (event.isShiftClick()) {
                event.setCancelled(true);
                return;
            }
            if (rawSlot == 22) {
                event.setCancelled(true);
                this.initiateRitual(player, event.getView().getTopInventory());
                return;
            }
            event.setCancelled(true);
        } else if (event.isShiftClick() && clickedInventory != null && clickedInventory.equals((Object)event.getView().getBottomInventory())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onSmithing(PrepareSmithingEvent event) {
        SmithingInventory inventory = event.getInventory();
        if (inventory == null) {
            return;
        }
        ItemStack armorPiece = inventory.getItem(1);
        if (armorPiece == null || armorPiece.getType() == Material.AIR) {
            return;
        }
        ItemMeta meta = armorPiece.getItemMeta();
        if (meta != null && meta.getPersistentDataContainer().has(this.upgradeKey, PersistentDataType.BYTE)) {
            event.setResult(null);
        }
    }

    private void initiateRitual(Player player, Inventory gui) {
        ItemStack[] armorSet = new ItemStack[]{gui.getItem(10), gui.getItem(12), gui.getItem(14), gui.getItem(16)};
        TrimPattern pattern = null;
        for (ItemStack item : armorSet) {
            ItemMeta itemMeta;
            if (item == null || !((itemMeta = item.getItemMeta()) instanceof ArmorMeta)) {
                player.sendMessage("\u00a7cPlease place a full, trimmed armor set in the slots.");
                return;
            }
            ArmorMeta armorMeta = (ArmorMeta)itemMeta;
            if (armorMeta.getPersistentDataContainer().has(this.upgradeKey, PersistentDataType.BYTE)) {
                player.sendMessage("\u00a7cThis armor piece has already been upgraded and cannot be modified further.");
                return;
            }
            ArmorTrim trim = armorMeta.getTrim();
            if (trim == null) {
                player.sendMessage("\u00a7cAn armor piece is missing a trim.");
                return;
            }
            if (pattern == null) {
                pattern = trim.getPattern();
                continue;
            }
            if (pattern.equals((Object)trim.getPattern())) continue;
            player.sendMessage("\u00a7cAll armor pieces must have the same trim pattern.");
            return;
        }
        RitualConfig config = this.ritualManager.getRitualConfig(pattern);
        if (config == null) {
            player.sendMessage("\u00a7cThere is no upgrade ritual for this trim pattern.");
            return;
        }
        if (!config.isEnabled()) {
            player.sendMessage("\u00a7cThe upgrade ritual for this trim pattern is currently disabled.");
            return;
        }
        if (config.getLimit() >= 0 && this.ritualManager.getUpgradeCount(pattern) >= config.getLimit()) {
            player.sendMessage("\u00a7cThe maximum number of upgrades for this armor set has been reached.");
            return;
        }
        if (!this.hasRequiredMaterials(player, config.getMaterials())) {
            player.sendMessage("\u00a7cYou lack the required materials for this ritual.");
            return;
        }
        this.ritualManager.startRitual(player, armorSet, config, gui);
        player.closeInventory();
        player.sendMessage("\u00a7aThe ritual has begun!");
    }

    private boolean hasRequiredMaterials(Player player, List<ItemStack> materials) {
        for (ItemStack material : materials) {
            int requiredAmount = material.getAmount();
            int foundAmount = 0;
            for (ItemStack item : player.getInventory().getContents()) {
                if (item == null || item.getType() != material.getType()) continue;
                foundAmount += item.getAmount();
            }
            if (foundAmount >= requiredAmount) continue;
            return false;
        }
        return true;
    }

    public void consumeMaterials(Player player, List<ItemStack> materials) {
        for (ItemStack material : materials) {
            player.getInventory().removeItem(new ItemStack[]{material});
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getInventory().getHolder() instanceof UltimateUpgraderManager && !this.ritualManager.isPlayerInRitual(event.getPlayer().getUniqueId())) {
            Inventory gui = event.getInventory();
            for (int slot : ARMOR_SLOTS) {
                ItemStack item = gui.getItem(slot);
                if (item == null || item.getType() == Material.AIR) continue;
                event.getPlayer().getInventory().addItem(new ItemStack[]{item});
            }
        }
    }

    private ItemStack createGuiItem(Material material, String name, String ... lore) {
        ItemStack item = new ItemStack(material, 1);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(name);
            meta.setLore(Arrays.asList(lore));
            item.setItemMeta(meta);
        }
        return item;
    }
}

