/*
 * Decompiled with CFR 0.152.
 */
package MCplugin.powerTrims.commands;

import MCplugin.powerTrims.Logic.PersistentTrustManager;
import MCplugin.powerTrims.Logic.TrimCooldownManager;
import MCplugin.powerTrims.PowerTrimss;
import MCplugin.powerTrims.config.ConfigManager;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PowerTrimsCommand
implements CommandExecutor {
    private final PowerTrimss plugin;
    private final ConfigManager configManager;
    private final TrimCooldownManager cooldownManager;
    private final PersistentTrustManager trustManager;

    public PowerTrimsCommand(PowerTrimss plugin, ConfigManager configManager, TrimCooldownManager cooldownManager, PersistentTrustManager trustManager) {
        this.plugin = plugin;
        this.configManager = configManager;
        this.cooldownManager = cooldownManager;
        this.trustManager = trustManager;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (args.length == 0) {
            this.sendHelpMessage(sender);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "reload": {
                this.handleReload(sender);
                break;
            }
            case "resetcooldowns": {
                this.handleResetCooldowns(sender);
                break;
            }
            default: {
                this.sendHelpMessage(sender);
            }
        }
        return true;
    }

    private void handleReload(CommandSender sender) {
        if (!sender.hasPermission("powertrims.reload")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to do that.");
            return;
        }
        this.plugin.reloadPlugin();
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "PowerTrims has been reloaded.");
    }

    private void handleResetCooldowns(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "This command can only be used by players.");
            return;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("powertrims.resetcooldowns")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to use this command.");
            return;
        }
        this.cooldownManager.resetAllCooldowns(player);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "All your trim cooldowns have been reset.");
    }

    private void sendHelpMessage(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.GOLD) + "--- PowerTrims Help ---");
        sender.sendMessage(String.valueOf(ChatColor.AQUA) + "/powertrims panel" + String.valueOf(ChatColor.GRAY) + " - Opens the web configuration panel.");
        sender.sendMessage(String.valueOf(ChatColor.AQUA) + "/powertrims reload" + String.valueOf(ChatColor.GRAY) + " - Reloads the config.");
        sender.sendMessage(String.valueOf(ChatColor.AQUA) + "/powertrims resetcooldowns" + String.valueOf(ChatColor.GRAY) + " - Resets all your cooldowns.");
        sender.sendMessage(String.valueOf(ChatColor.AQUA) + "/trust <player>" + String.valueOf(ChatColor.GRAY) + " - Trust a player.");
        sender.sendMessage(String.valueOf(ChatColor.AQUA) + "/untrust <player>" + String.valueOf(ChatColor.GRAY) + " - Untrust a player.");
        sender.sendMessage(String.valueOf(ChatColor.AQUA) + "/trustlist" + String.valueOf(ChatColor.GRAY) + " - View your trusted players.");
    }
}

