/*
 * Decompiled with CFR 0.152.
 */
package MCplugin.powerTrims.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigManager {
    private final JavaPlugin plugin;
    private FileConfiguration config;
    private final Map<String, Boolean> trimEnabledStatus = new HashMap<String, Boolean>();

    public ConfigManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfig();
        this.loadTrimStatus();
    }

    public void reloadConfig() {
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
        this.loadTrimStatus();
        this.plugin.getLogger().info("Configuration reloaded.");
    }

    private void loadTrimStatus() {
        this.trimEnabledStatus.clear();
        ConfigurationSection trimsSection = this.config.getConfigurationSection("trims");
        if (trimsSection != null) {
            Set trimNames = trimsSection.getKeys(false);
            for (String trimName : trimNames) {
                this.trimEnabledStatus.put(trimName.toLowerCase(), trimsSection.getBoolean(trimName));
            }
        }
    }

    public boolean isTrimEnabled(String trimName) {
        return this.trimEnabledStatus.getOrDefault(trimName.toLowerCase(), true);
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public int getInt(String path) {
        return this.config.getInt(path);
    }

    public double getDouble(String path) {
        return this.config.getDouble(path);
    }

    public long getLong(String path) {
        return this.config.getLong(path);
    }
}

