/*
 * Decompiled with CFR 0.152.
 */
package MCplugin.powerTrims.integrations;

import MCplugin.powerTrims.Logic.ArmourChecking;
import MCplugin.powerTrims.Logic.TrimCooldownManager;
import MCplugin.powerTrims.PowerTrimss;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.jetbrains.annotations.NotNull;

public class PlaceholderIntegration
extends PlaceholderExpansion {
    private final TrimCooldownManager cooldownManager;

    public PlaceholderIntegration(PowerTrimss plugin) {
        this.cooldownManager = plugin.getCooldownManager();
    }

    @NotNull
    public String getIdentifier() {
        return "powertrims";
    }

    @NotNull
    public String getAuthor() {
        return "div";
    }

    @NotNull
    public String getVersion() {
        return "1.0.0";
    }

    public boolean persist() {
        return true;
    }

    public String onPlaceholderRequest(Player player, @NotNull String identifier) {
        if (player == null) {
            return "";
        }
        TrimPattern trim = ArmourChecking.getEquippedTrim(player);
        switch (identifier) {
            case "equipped_trim": {
                return trim != null ? this.cooldownManager.getTrimDisplayName(trim) : "None";
            }
            case "cooldown_seconds": {
                if (trim == null) {
                    return "0";
                }
                long cooldown = this.cooldownManager.getRemainingCooldown(player, trim) / 1000L;
                return String.valueOf(cooldown);
            }
            case "cooldown_formatted": {
                if (trim == null) {
                    return "Not Available";
                }
                long remaining = this.cooldownManager.getRemainingCooldown(player, trim) / 1000L;
                return remaining > 0L ? remaining + "s" : "Ready";
            }
            case "status": {
                if (trim == null) {
                    return String.valueOf(ChatColor.GRAY) + "No Trim Equipped";
                }
                String trimName = this.cooldownManager.getTrimDisplayName(trim);
                long cooldownTime = this.cooldownManager.getRemainingCooldown(player, trim) / 1000L;
                String status = cooldownTime > 0L ? String.valueOf(ChatColor.RED) + "\u23f3 " + cooldownTime + "s" : String.valueOf(ChatColor.GREEN) + "\u2705 Ready";
                return String.valueOf(ChatColor.GOLD) + trimName + ": " + status;
            }
        }
        return null;
    }

    public void cleanup() {
        this.unregister();
    }
}

