/*
 * Decompiled with CFR 0.152.
 */
package MCplugin.powerTrims.ultimates.silenceult;

import MCplugin.powerTrims.ultimates.silenceult.SilenceUlt;
import MCplugin.powerTrims.ultimates.silenceult.SilenceUltData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.WeatherType;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Transformation;
import org.bukkit.util.Vector;

public class SilenceTransformAnimations {
    private final JavaPlugin plugin;
    private final SilenceUlt silenceUlt;
    private static SilenceUltData data;
    private final Random random = new Random();

    public SilenceTransformAnimations(JavaPlugin plugin, SilenceUlt silenceUlt, SilenceUltData data) {
        this.plugin = plugin;
        this.silenceUlt = silenceUlt;
        SilenceTransformAnimations.data = data;
    }

    public void startTransformationSequence(Player player) {
        UUID playerUUID = player.getUniqueId();
        SilenceTransformAnimations.data.transformingPlayers.add(playerUUID);
        SilenceTransformAnimations.data.originalBlocks.put(playerUUID, new HashMap());
        SilenceTransformAnimations.data.rage.put(playerUUID, 0.0);
        player.addPotionEffect(new PotionEffect(PotionEffectType.LEVITATION, 220, 0, false, false));
        player.getWorld().playSound(player.getLocation(), Sound.ENTITY_WARDEN_EMERGE, 2.0f, 0.5f);
        player.setPlayerWeather(WeatherType.DOWNFALL);
        this.startPreAnimation(player);
        this.startSculkInfestation(player);
    }

    private void startPreAnimation(final Player player) {
        int preAnimationDuration = 100;
        final World world = player.getWorld();
        new BukkitRunnable(this){
            int ticks = 0;
            final /* synthetic */ SilenceTransformAnimations this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (!player.isOnline() || !SilenceTransformAnimations.data.transformingPlayers.contains(player.getUniqueId()) || this.ticks >= 100) {
                    if (player.isOnline()) {
                        this.this$0.startMainAnimation(player);
                    }
                    this.cancel();
                    return;
                }
                if (this.ticks % 10 == 0) {
                    double offsetX = (this.this$0.random.nextDouble() - 0.5) * 8.0 * 4.0;
                    double offsetZ = (this.this$0.random.nextDouble() - 0.5) * 8.0 * 4.0;
                    world.strikeLightningEffect(player.getLocation().clone().add(offsetX, 0.0, offsetZ));
                }
                if (this.ticks % 4 == 0) {
                    this.this$0.lockNearbyPlayerEyesight(player);
                }
                ++this.ticks;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    public void startMainAnimation(final Player player) {
        UUID playerUUID = player.getUniqueId();
        int totalDurationTicks = 120;
        final ArrayList absorbingBlocks = new ArrayList();
        final ArrayList<BlockDisplay> shellBlocks = new ArrayList<BlockDisplay>();
        final List<Vector> shellOffsets = this.createPlayerShellOffsets();
        for (Vector offset : shellOffsets) {
            Location spawnLoc = player.getLocation().clone().add(offset.clone().multiply(3.0));
            BlockDisplay shellBlock = (BlockDisplay)player.getWorld().spawn(spawnLoc, BlockDisplay.class, bd -> {
                bd.setBlock(Material.SCULK.createBlockData());
                Transformation t = bd.getTransformation();
                t.getScale().set(0.01f);
                bd.setTransformation(t);
            });
            shellBlocks.add(shellBlock);
        }
        SilenceTransformAnimations.data.mainAnimationTasks.put(playerUUID, new BukkitRunnable(this){
            int ticks = 0;
            double angle = 0.0;
            final double maxRadius = 12.0;
            final /* synthetic */ SilenceTransformAnimations this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (!player.isOnline() || this.ticks >= 120) {
                    if (player.isOnline()) {
                        this.this$0.silenceUlt.completeWardenTransformation(player);
                    }
                    absorbingBlocks.forEach(Entity::remove);
                    shellBlocks.forEach(Entity::remove);
                    this.cancel();
                    return;
                }
                Location loc = player.getLocation();
                World world = loc.getWorld();
                double progress = (double)this.ticks / 120.0;
                if (this.ticks % 4 == 0) {
                    this.this$0.lockNearbyPlayerEyesight(player);
                }
                double shellGrowthFactor = Math.sin(progress * Math.PI / 2.0);
                for (int i = 0; i < shellBlocks.size(); ++i) {
                    BlockDisplay shellBlock = (BlockDisplay)shellBlocks.get(i);
                    if (!shellBlock.isValid()) continue;
                    Vector baseOffset = (Vector)shellOffsets.get(i);
                    Vector currentOffset = baseOffset.clone().multiply(shellGrowthFactor);
                    Location targetPos = player.getLocation().clone().add(currentOffset);
                    Vector toTarget = targetPos.toVector().subtract(shellBlock.getLocation().toVector()).multiply(0.15);
                    shellBlock.teleport(shellBlock.getLocation().add(toTarget));
                    Transformation t = shellBlock.getTransformation();
                    float finalScale = 0.4f;
                    t.getScale().set((float)(shellGrowthFactor * (double)finalScale));
                    shellBlock.setTransformation(t);
                }
                this.angle += 0.2617993877991494;
                double currentRadius = 12.0 * (1.0 - progress);
                if (this.ticks % 2 == 0 && this.ticks < 110) {
                    for (int i = 0; i < 10; ++i) {
                        double spawnAngle = 0.6283185307179586 * (double)i + this.angle + (this.this$0.random.nextDouble() - 0.5);
                        Location spawnLoc = loc.clone().add(Math.cos(spawnAngle) * currentRadius, (this.this$0.random.nextDouble() - 0.5) * 4.0, Math.sin(spawnAngle) * currentRadius);
                        BlockDisplay absorbingBlock = (BlockDisplay)world.spawn(spawnLoc, BlockDisplay.class, bd -> {
                            bd.setBlock(Material.SCULK_VEIN.createBlockData());
                            Transformation t = bd.getTransformation();
                            t.getScale().set(0.1f + (float)this.this$0.random.nextDouble() * 0.2f);
                            bd.setTransformation(t);
                        });
                        absorbingBlocks.add(absorbingBlock);
                    }
                }
                absorbingBlocks.removeIf(bd -> {
                    if (!bd.isValid()) {
                        return true;
                    }
                    Vector toPlayer = player.getEyeLocation().toVector().subtract(bd.getLocation().toVector()).normalize().multiply(0.4 + progress * 1.2);
                    bd.teleport(bd.getLocation().add(toPlayer));
                    if (bd.getLocation().distanceSquared(player.getEyeLocation()) < 1.5) {
                        world.spawnParticle(Particle.SCULK_SOUL, bd.getLocation(), 1, 0.0, 0.0, 0.0, 0.0);
                        bd.remove();
                        return true;
                    }
                    return false;
                });
                if (this.ticks % 12 == 0) {
                    world.playSound(loc, Sound.ENTITY_WARDEN_HEARTBEAT, 2.0f, 0.5f + (float)progress * 1.5f);
                }
                player.sendTitle("", String.valueOf(ChatColor.DARK_AQUA) + (int)(progress * 100.0) + "%", 0, 2, 0);
                ++this.ticks;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L));
    }

    private void lockNearbyPlayerEyesight(Player targetPlayer) {
        Location targetLocation = targetPlayer.getEyeLocation();
        for (Entity entity : targetPlayer.getWorld().getNearbyEntities(targetLocation, 30.0, 30.0, 30.0)) {
            Player nearbyPlayer;
            if (!(entity instanceof Player) || (nearbyPlayer = (Player)entity).equals((Object)targetPlayer) || nearbyPlayer.getGameMode() == GameMode.SPECTATOR) continue;
            Vector direction = targetLocation.toVector().subtract(nearbyPlayer.getEyeLocation().toVector()).normalize();
            Location newLookLocation = nearbyPlayer.getLocation().setDirection(direction);
            nearbyPlayer.teleport(newLookLocation);
            nearbyPlayer.addPotionEffect(new PotionEffect(PotionEffectType.DARKNESS, 40, 0, true, false));
        }
    }

    private List<Vector> createPlayerShellOffsets() {
        ArrayList<Vector> offsets = new ArrayList<Vector>();
        float playerHeight = 2.8f;
        float playerWidth = 1.0f;
        int density = 14;
        float headRadius = playerWidth / 2.0f + 0.2f;
        for (int i = 0; i < density; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)density;
            for (int j = 0; j < density / 2; ++j) {
                double pitch = Math.PI * (double)j / ((double)density / 2.0) - 1.5707963267948966;
                double y = Math.sin(pitch) * (double)headRadius;
                double xzRadius = Math.cos(pitch) * (double)headRadius;
                double x = Math.cos(angle) * xzRadius;
                double z = Math.sin(angle) * xzRadius;
                offsets.add(new Vector(x, (double)(playerHeight - headRadius) + y, z));
            }
        }
        float torsoRadius = playerWidth / 2.0f + 0.1f;
        for (float y = 0.2f; y < 1.4f; y += 0.3f) {
            for (int i = 0; i < density; ++i) {
                double angle = Math.PI * 2 * (double)i / (double)density;
                double x = Math.cos(angle) * (double)torsoRadius;
                double z = Math.sin(angle) * (double)torsoRadius;
                offsets.add(new Vector(x, (double)y, z));
            }
        }
        float armRadius = 0.25f;
        for (float y = 0.4f; y < 1.2f; y += 0.4f) {
            for (int i = 0; i < density / 2; ++i) {
                double angle = Math.PI * 2 * (double)i / ((double)density / 2.0);
                double x = (double)(torsoRadius + armRadius) + Math.cos(angle) * (double)armRadius;
                offsets.add(new Vector(x, (double)y, Math.sin(angle) * (double)armRadius));
                offsets.add(new Vector(-x, (double)y, Math.sin(angle) * (double)armRadius));
            }
        }
        return offsets;
    }

    public void startSculkInfestation(final Player player) {
        final UUID playerUUID = player.getUniqueId();
        SilenceTransformAnimations.data.sculkTasks.put(playerUUID, new BukkitRunnable(this){
            int radius = 0;
            final /* synthetic */ SilenceTransformAnimations this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                if (!SilenceTransformAnimations.data.transformingPlayers.contains(playerUUID) || !player.isOnline() || this.radius > 10) {
                    this.cancel();
                    return;
                }
                Location center = player.getLocation();
                for (int x = -this.radius; x <= this.radius; ++x) {
                    for (int z = -this.radius; z <= this.radius; ++z) {
                        Map<Location, BlockData> playerOriginals;
                        Material type;
                        if (Math.abs(x) < this.radius && Math.abs(z) < this.radius) continue;
                        Location blockLoc = center.clone().add((double)x, -1.0, (double)z);
                        if ((blockLoc = blockLoc.getWorld().getHighestBlockAt(blockLoc).getLocation()).distanceSquared(center) > 100.0 || (type = blockLoc.getBlock().getType()).isAir() || !type.isSolid() || type == Material.SCULK || (playerOriginals = SilenceTransformAnimations.data.originalBlocks.get(player.getUniqueId())) == null || playerOriginals.containsKey(blockLoc)) continue;
                        playerOriginals.put(blockLoc, blockLoc.getBlock().getBlockData());
                        blockLoc.getBlock().setType(Material.SCULK);
                        blockLoc.getWorld().playSound(blockLoc, Sound.BLOCK_SCULK_SPREAD, 1.0f, 1.0f);
                        if (!(this.this$0.random.nextDouble() < 0.15)) continue;
                        this.this$0.createVolcano(blockLoc.clone().add(0.0, 1.0, 0.0));
                    }
                }
                ++this.radius;
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 8L));
    }

    private void createVolcano(final Location location) {
        final Material originalType = location.getBlock().getType();
        location.getBlock().setType(Material.MAGMA_BLOCK);
        new BukkitRunnable(this){
            final int duration;
            int ticks;
            final /* synthetic */ SilenceTransformAnimations this$0;
            {
                this.this$0 = this$0;
                this.duration = 40 + this.this$0.random.nextInt(40);
                this.ticks = 0;
            }

            public void run() {
                if (this.ticks++ > this.duration) {
                    if (location.getBlock().getType() == Material.MAGMA_BLOCK) {
                        location.getBlock().setType(originalType);
                    }
                    this.cancel();
                    return;
                }
                if (this.ticks % 5 == 0) {
                    location.getWorld().spawnParticle(Particle.LAVA, location, 10, 0.5, 0.5, 0.5);
                    location.getWorld().spawnParticle(Particle.SMOKE, location, 5, 0.5, 0.5, 0.5, 0.05);
                    location.getWorld().playSound(location, Sound.BLOCK_LAVA_POP, 1.0f, 1.0f);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }

    public static void revertSculkBlocks() {
        for (Map<Location, BlockData> playerOriginals : SilenceTransformAnimations.data.originalBlocks.values()) {
            if (playerOriginals == null || playerOriginals.isEmpty()) continue;
            for (Map.Entry<Location, BlockData> entry : playerOriginals.entrySet()) {
                if (!entry.getKey().isWorldLoaded()) continue;
                entry.getKey().getBlock().setBlockData(entry.getValue());
            }
        }
        SilenceTransformAnimations.data.originalBlocks.clear();
    }
}

